// $Header: Socket.cc,v 1.2 92/06/17 15:53:39 vern Exp $

#include <stdio.h>
#include <osfcn.h>

#include "Socket.h"
#include "system.h"


Socket::Socket( int socket_fd )
	{
	if ( socket_fd < 0 )
		fd = get_tcp_socket();
	else
		fd = socket_fd;

	port = 0;
	}

Socket::~Socket()
	{
	close( fd );
	}

void Socket::Gripe( char* msg )
	{
	fprintf( stderr, "Socket error: %s\n", msg );
	perror( "perror value" );
	exit( 1 );
	}

AcceptSocket::AcceptSocket( int port_hint )
	{
	int result;

	do
		result = bind_socket( fd, port_hint );
	while ( result == 0 && ++port_hint < 65535 );

	if ( result < 0 )
		Gripe( "couldn't bind AcceptSocket to any port" );

	port = port_hint;
	}


Socket* AcceptSocket::Accept()
	{
	int new_connection = accept_connection( fd );
	if ( new_connection < 0 )
		Gripe( "problems with Accept()" );

	return new Socket( new_connection );
	}


RemoteSocket::RemoteSocket( char hostname[], int port )
	{
	if ( ! remote_connection( fd, hostname, port ) )
		Gripe( "couldn't make remote connection" );
	}
