package Twilio::Functions;
use Perlmazing;
require Exporter;
our @ISA = qw(Exporter);
our @EXPORT = qw();

push @EXPORT, 'camel_to_modern';
sub camel_to_modern {
	my $str = shift;
	$str =~ s/(?<!_)([A-Z0-9])(?![A-Z0-9])/_$1/g;
	$str =~ s/^_//;
	lc $str;
}

push @EXPORT, 'modern_to_camel';
sub modern_to_camel {
	my $str = shift;
	$str =~ s/_(\w)/uc($1)/eg;
	ucfirst $str;
}

push @EXPORT, 'normalize_request_params';
sub normalize_request_params (+) {
	my @call = caller(1);
	$_[0] = [] unless defined $_[0];
	unless (isa_hash $_[0] or isa_array $_[0]) {
		die("This method expects either none or a hashref (or an arrayref where odd elements are keys and even elements are values) as argument at $call[1] line $call[2]\n");
	}
	if (isa_hash $_[0]) {
		$_[0] = [ map { modern_to_camel($_) => $_[0]->{$_} } sort keys %{$_[0]} ];
	} else {
		for (my $i = 0; $i < @{$_[0]}; $i += 2) {
			$_[0]->[$i] = modern_to_camel $_[0]->[$i];
		}
		sort_by_key $_[0];
	}
}

1;
