package Twilio::UserAgent;
use Perlmazing;
use LWP::UserAgent;
use File::Spec;
use Cwd;
my $folder = 'ua_caches';
my $path = File::Spec->catfile(cwd, $folder, 'cache_');

sub new {
	my $class = shift;
	my $self = {
		agent	=> "Twilio-Perl/$Twilio::VERSION",
		ssl_opts	=> {
			SSL_version		=> 'SSLv3',
			SSL_verify_mode	=> 0,
			verify_hostname	=> 0,
		},
		testing	=> 0,
		call_order	=> 0,
		@_,
	};
	$self->{ua} = LWP::UserAgent->new (
		agent		=> $self->{agent},
		ssl_opts	=> $self->{ssl_opts},
	);
	return $self->{ua} unless $self->{testing};
	bless $self, $class;
}

sub credentials {
	my $self = shift;
	$self->{credentials} = ['AC'.md5('sid'), md5('token')];
	$self->{ua}->credentials(@_);
}

sub get {
	my $self = shift;
	$self->get_cache('get', @_);
}

sub post {
	my $self = shift;
	$self->get_cache('post', @_);
}

sub put {
	my $self = shift;
	$self->get_cache('put', @_);
}

sub delete {
	my $self = shift;
	$self->get_cache('get', @_);
}

sub get_cache {
	my $self = shift;
	$self->{call_order}++;
	my $file = md5 dumped $self->{call_order}, $self->{credentials}, @_;
	my $content;
	if ($self->{testing} == 2) {
		my $method = shift @_;
		$content = $self->{ua}->$method(@_);
		unless (-d $folder) {
			mkdir($folder) or die "Cannot create path $path: $!";
		}
		open my $out, '>', $path.$file or die "Cannot write to $path$file: $!";
		binmode $out;
		print $out dumped $content;
		close $out;
	} else {
		open my $in, '<', $path.$file or die "Cannot open $path$file: $!";
		binmode $in;
		$content = eval join '', <$in>;
		die "Error eval'ing cache content: $@" if $@;
		close $in;
	}
	$content;
}

1;
