#!perl
use warnings;
use File::Spec;
use Test::More;
use Test::Exception;
use English qw(-no_match_vars);

use lib '.';
use t::Elive;

use File::Spec;

if ( not $ENV{TEST_AUTHOR} ) {
    my $msg = 'Author test.  Set $ENV{TEST_AUTHOR} to a true value to run.';
    plan( skip_all => $msg );
}

eval "use Test::Script::Run 0.04";

if ( $EVAL_ERROR ) {
    my $msg = 'Test::Script::Run 0.04+ required to run scripts';
    plan( skip_all => $msg );
}

local ($ENV{TERM}) = 'dumb';

plan(tests => 24);

my $script_name = 'elive_query';

do {
    #
    # try running script with --help
    #

    my ( $result, $stdout, $stderr ) = run_script ($script_name, ['--help'] );

    is($stderr, '', "$script_name --help: no errors");
    ok($stdout =~ m{usage:}ix, "$script_name --help: stdout =~ 'usage:...''");
};

do {
    # 
    # try with invalid option
    #

    my ( $result, $stdout, $stderr ) = run_script($script_name, ['--invalid-opt']  );

    ok($stderr =~ m{unknown \s+ option}ix, "$script_name invalid option error");
    ok($stdout =~ m{usage:}ix, "$script_name invalid option usage");

};

do {
    #
    # invalid command
    #

    my ( $result, $stdout, $stderr ) = run_script($script_name, [-c => 'blah blah'] );

    ok($stderr =~ m{unrecognised \s command: \s blah}ixs, "$script_name -c '<invalid command>': error as expected");
    is($stdout, '', "$script_name -c '<invalid command>': no output");
};

do {
    #
    # describe one of the entities: user
    #

    my ($result, $stdout, $stderr) = run_script ($script_name, [-c => 'describe user']);

    is($stderr, '', "$script_name -c 'describe user': no errors");
    ok($stdout =~ m{user: \s+ Elive::Entity::User .* userId \s+ : \s+ pkey \s+ Str}ixs, "$script_name -c 'describe user': looks like dump of users entity");

};

do {
    #
    # describe unknown entity
    #

    my ( $result, $stdout, $stderr ) = run_script($script_name, [-c => 'describe crud'] );

    ok($stderr =~ m{unknown \s+ entity: \s+ crud}ix, "$script_name: describe <unknown> error");
    is($stdout, '', "$script_name: describe <unknown> error - no output");
};

SKIP: {

    my %result = t::Elive->test_connection(only => 'real');
    my $auth = $result{auth};

    skip ($result{reason} || 'skipping live tests', 14)
	unless $auth && @$auth >= 3;

    my ($url, $user, $pass) = @$auth;

    my $connection_class = $result{class};
    my $connection = $connection_class->connect(@$auth)
	or die "failed to connect?";

    foreach my $selection (qw(serverDetailsId * **), 'name,serverDetailsId') {
	#
	# simple query on server details
	#
	my ( $result, $stdout, $stderr ) = run_script(
	    $script_name,
	    [$url,
	     -user => $user,
	     -pass => $pass,
	     -c => "select $selection from serverDetails"]);
       
	ok($stdout =~ m{serverDetailsId .* \w+ }ixs, "$script_name 'select $selection from serverDetails expected output");
	
    };

    eval {require YAML};
    # YAML is a Elive prequesite
    die "unable to load YAML - can't continue: $@"
	if $@;

    do {
	#
	# simple query on server details - yaml dump of output
	#

	my ( $result, $stdout, $stderr ) = run_script(
	    $script_name,
	    [$url,
	     -user => $user,
	     -pass => $pass,
	     -dump => 'yaml',
	     -c => 'select serverDetailsId from serverDetails']);

       
	ok($stderr =~ m{^connecting}i, "$script_name -c 'connecting...' message");

	my $data;
	my @guff;

	lives_ok(sub {($data, @guff) = YAML::Load($stdout)}, 'output is parsable YAML');
	isa_ok($data, 'HASH', 'result');
	ok($data->{ServerDetails}{serverDetailsId}, 'hash structure contains ServerDetails.serverDetailsId');

	ok(!@guff, 'single result returned for singleton entity');

    };

    do {
	#
	# now create and verify a session
	#
	eval "use Elive::View::Session";
	die $@ if $@;

	my $session_start = time();
	my $session_end = $session_start + 900;

	$session_start .= '000';
	$session_end .= '000';

	my %insert_data = (
	    name => 'test, generated by t/script-elive_query.t',
	    password => '&&(*',
	    start =>  $session_start,
	    end => $session_end,
	    facilitatorId => $connection->login,
	    privateMeeting => 1,
	    costCenter => 'testing',
	    moderatorNotes => 'test moderator notes. Here are some entities: & > <',
	    userNotes => 'test user notes; some more entities: &gt;',
	    recordingStatus => 'remote',
	    raiseHandOnEnter => 0,
	    maxTalkers => 2,
	    inSessionInvitation => 1,
	    boundaryMinutes => 15,
	    fullPermissions => 1,
	    supervised => 1,
	    seats => 2,
	    );

	my $session = Elive::View::Session->insert(\%insert_data,
						   connection => $connection);
	my $session_id = $session->id;

	my %expected_content = map {$_ => scalar $session->$_} Elive::View::Session->properties;
	my $expected_data = {Session => \%expected_content};

	my ( $result, $stdout, $stderr ) = run_script(
	    $script_name,
	    [$url,
	     -user => $user,
	     -pass => $pass,
	     -dump => 'yaml',
	     -c => 'select * from session where id='.$session_id]);

       
	ok($stderr =~ m{^connecting}i, "$script_name -c 'connecting...' message");

	my $data;
	my @guff;

	lives_ok(sub {($data, @guff) = YAML::Load($stdout)}, 'session query output is parsable YAML');
	isa_ok($data, 'HASH', 'result');

	ok(!@guff, 'single result returned for single row query');

	is_deeply($data, $expected_data, 'yaml dump matches session contents');

	$session->delete;

	$connection->disconnect;

    };
}
