FAQ
===

1. What is VIC&trade; ?

VIC&trade; is a domain specific language to write code for Microchip&quot;s PIC&regd;
microcontrollers. It's aim is for users or developers to write code that looks
simple, logical and can hide complexities that are in-built into VIC&trade; as language
primitives. VIC&trade; also is the name of the compiler to compile that language.

2. Why should you use VIC&trade; ?

- If you like using PIC&regd; microcontrollers, do not like coding in PIC specific
C and/or assembly, would like to understand what your code does months or years
from now, then you should use VIC&trade;.
- If you want to port existing code seamlessly
to other microcontrollers in the same family without making any changes, you can
use VIC&trade;. 
- If you want to automatically simulate your code using supported PIC&regd;
  simulators, you should use VIC&trade;.
- If you like scripting languages you will like using VIC&trade;. It is designed in the
  same vein.

3. Why was the decision made to create VIC&trade; ?

While coding firmware for various microcontroller projects, we ended up using a
lot of common code between them. So we abstracted them into header files with
macros, but that wasn't enough so we went down the path of auto-generating these
macros and instead went a step further and created a domain specific language --
VIC&trade;. Our aim was to enable us to write code that looked really simple, was
verifiable using a PIC simulator and did not need detailed reading of the data
sheets every time we chose a particular MCU. We wanted to read the MCU data
sheet once, abstract it out and then start using it. The work for abstraction is
already done and now anyone can use it without having to read all the pages of a
PIC MCU's data sheet.

4. Will VIC&trade; support other MCUs like AVR, 8051, ARM-Cortex etc. ?

Currently, we are focused on supporting PIC microcontrollers. There are so many
of them ! If you like using AVR, maybe the Arduino library is a better bet. This
doesn't mean that in the future we will not support the Atmel or Maxim
microcontrollers.

5. What license is the VIC&trade; released under ?

VIC&trade; is dual licensed under the [Perl Artistic license](TODO) and the [GNU General Public
License](TODO). You can distribute the VIC&trade; compiler by following the requirements of
the afore mentioned licenses.

6. Can I create a proprietary compiler for VIC&trade; ?

Yes you may, but that would not be nice of you. VIC&trade; is designed to make
life easy for its users. They should *not* have to pay for a compiler.

You are free to make accessory applications like a debugger or a simulator for
it though.

7. Where can I download VIC&trade; ?

You can download the _official_ version of VIC&trade; from [Github](https://github.com/vikasnkumar/vic).

8. What are the operating systems that VIC&trade; supports ?

The VIC&trade; compiler works on Linux, Mac OS X, FreeBSD, OpenBSD and Windows.
So far, we have only tested the code generated by VIC&trade; with `gpasm` from
[gputils](TODO) and the simulator we have tested with [gpsim](TODO). You may
want to test with Microchip's PIC&regd; compiler and simulator on Windows and
Linux and let us know how it fares. We will be willing to see examples where it
fails to work as expected.

9. How do I help in development of VIC&trade; ?

VIC&trade; needs more testing on real chips, more interesting examples and bug
reports. If you are willing to do this, please feel free to fork VIC&trade; and
send us pull requests or submit patches on the [Github issue tracker](TODO).

10. What editor or IDE is needed for VIC&trade; ?

We use [Vim](TODO) as our editor of choice on all the systems we support,
but you could use any text editor of your choice. We provide a syntax
highlighting file for Vim as part of the distribution of VIC&trade;.

11. How does one compile VIC&trade; programs ?

Please refer to the [documentation](TODO) for more details.

12. How does one compile the PIC&regd; assembly code generated by VIC&trade; ?

You can use `gpasm` from the [gputils](TODO) toolkit on Linux, Mac OS X, FreeBSD
and OpenBSD. On Windows, if you have a Windows build of `gputils` you may use
that or you can use Microchip's compilers.

13. Which simulator is to be used with VIC&trade; ?

VIC&trade; supports [gpsim](TODO) as its default simulator but future support
for other simulators may be added as time permits.
