package Net::OAI::Record;

use strict;

=head1 NAME

Net::OAI::Record - An OAI-PMH record.

=head1 SYNOPSIS

=head1 DESCRIPTION

=head1 METHODS

=head2 new()

probably don't want to instantiate this yourself

=cut

sub new {
    my ( $class, %opts ) = @_;
    return bless {
	header	    => $opts{ header },
	@{[$opts{ metadata } ? (metadata => $opts{ metadata }) : ()]},
	@{[$opts{ recorddata } ? (recorddata => $opts{ recorddata }) : ()]},
    }, ref( $class ) || $class;
}

=head2 header()

Returns the C<Net::OAI::Header> object for the OAI header element that
accompanied the record.

=cut

sub header {
    my $self = shift;
    return( $self->{ header } );
}

=head2 metadata()
=head2 recorddata()

Returns the object (SAX Handler!) used or created by the C<metadataHandler> 
rsp. C<recordHandler> filter class at the moment the OAI::Record was created, 
namely right after seeing the closing OAI record tag. Or - in the case of
a C<Net::OAI::Record> provided by the C<next()> method of C<ListRecords>,
a clone created by means of L<Storable>.

Will be C<undef> when no corresponding option was provided.

Access to the actual data if desired has to be provided by the Handler class.
Note that in the case of deleted records the 

=cut 

sub metadata {
    my $self = shift;
#   return undef unless exists $self->{ metadata };
    return $self->{ metadata } || undef;
}


sub recorddata {
    my $self = shift;
#   return undef unless exists $self->{ recorddata };
    return $self->{ recorddata } || undef;
}

=head1 TODO

=head1 SEE ALSO

=head1 AUTHORS

Ed Summers <ehs@pobox.com>

=cut


1;
