use Test::More tests => 22;
#use File::Path;
#use IO::Dir;
use utf8;
use open IO => ':encoding(utf8)';
use strict;
use warnings;
$XML::SAX::ParserPackage = $XML::SAX::ParserPackage ||= $ENV{'NOH_ParserPackage'};
use_ok( 'Net::OAI::Harvester' );
use_ok( 'Net::OAI::Record::NamespaceFilter' );
BEGIN {
  eval 'use XML::SAX::Writer';
}
use constant XMLNS_OAIDC => "http://www.openarchives.org/OAI/2.0/oai_dc/";

# thanks http://www.effectiveperlprogramming.com/2011/07/fix-testbuilders-unicode-issue/
foreach my $method ( qw(output failure_output) ) {
    binmode Test::More->builder->$method(), ':encoding(UTF-8)'};

my $repo = 'http://memory.loc.gov/cgi-bin/oai2_0';

my $plug = new_ok('Net::OAI::Record::NamespaceFilter');

my $h = new_ok('Net::OAI::Harvester' => [
    baseURL => $repo,
]);

my $list = $h->listRecords(
    metadataPrefix => 'oai_dc',
    recordHandler => $plug,
);

SKIP: {
    my $HTE = HTE($list, $repo);
    skip $HTE, 5 if $HTE;

    ok( ! $list->errorCode(), 'errorCode()' );
    if  ( $list->errorCode() ) {
        diag "Received error: ".$list->errorString();
      };
    ok( ! $list->errorString(), 'errorString()' );

    my $rawresponse = $list->xml();
    my $nsubdocs = () = ($rawresponse =~ /<record>/g);
    note "no of records in raw response: $nsubdocs";
    my $count = 0;
    subtest 'Collect Whatever' => sub {
        while( my $r = $list->next() ) {
            $count++;
            isa_ok( $r, 'Net::OAI::Record' );

            my $header = $r->header();
            isa_ok( $header, 'Net::OAI::Record::Header' );
            ok( $header->identifier(), 
        	'header identifier defined: '.$header->identifier() );
            unless ( $header -> identifier() ) {
                diag explain $header;
                diag "----";
              };

            ok( ! defined $r->metadata(), 'custom handler does not deliver metadata' );

            my $record = $r->recorddata();
            isa_ok( $record, 'Net::OAI::Record::NamespaceFilter' );
#           diag explain $record;
#           diag "====";
          }
        note "collected $count records from $repo";
        done_testing();
      };
  is($count, $nsubdocs, 'no of records and records events coincides');

## resumption token

    my $r = $list->resumptionToken();
    subtest 'Resumption Token' => sub {
        plan tests => 5;
        isa_ok( $r, 'Net::OAI::ResumptionToken' );
        ok( $r->token(), 'token() '.$r->token() );

## these may not return stuff but we must be able to call the methods
        eval { $r->expirationDate() };
        ok( ! $@, 'expirationDate()' );

        eval { $r->completeListSize() };
        ok( ! $@, 'completeListSize()' );

        eval { $r->cursor() };
        ok( ! $@, 'cursor()' );
      };

  }


SKIP: {
  eval { require XML::SAX::Writer };
  if ( $@ ) {
      diag "XML::SAX::Writer not installed - skipping some tests";
      skip "XML::SAX::Writer not installed", 12;
    }
  
  my $xmlstring = "";          
  open my $fh, ">", \$xmlstring;
  binmode($fh, ":utf8");
  my $catcher = XML::SAX::Writer->new(Output => $fh);
# returns XML::FilteR::BufferText???
# isa_ok($catcher, 'XML::SAX::Writer');
  my $filter = Net::OAI::Record::NamespaceFilter->new(
       XMLNS_OAIDC() => $catcher
    );
  isa_ok($filter, 'Net::OAI::Record::NamespaceFilter');

  my $h = new_ok('Net::OAI::Harvester' => [
    baseURL => $repo,
    ]);

  my $id = 'oai:lcoa1.loc.gov:loc.gmd/g3764s.pm003250';
  $catcher->start_document({});
  my $single = $h->getRecord(
    metadataPrefix => 'oai_dc',
    metadataHandler => $filter,
    identifier => $id,
  );
  $catcher->end_document({});
  close($fh);
  isa_ok( $single, 'Net::OAI::GetRecord' );
  note "RAW: ".$single->xml();
  note "PARSED: $xmlstring";

  ok( ! $single->errorCode(), 'errorCode()' );
  ok( ! $single->errorString(), 'errorString()' );

  my $contents = $single->record();
  isa_ok( $contents, 'Net::OAI::Record' );
  my $object = $contents->metadata();
  isa_ok( $object, 'Net::OAI::Record::NamespaceFilter' );

  like($xmlstring, qr!<(\w+:)?identifier>http://hdl.loc.gov/loc\.gmd/g3764s\.pm003250</(\w+:)?identifier>!, 'string output contains expected identifier');

  my $resultref = $object->result();
  is(ref($resultref), "HASH", "result method w/o arguments is working");
  note explain $resultref;
  my $string = $object->result(XMLNS_OAIDC);
  ok(! defined $string, "result method is working for single ns");

########

  my $listfilter = Net::OAI::Record::NamespaceFilter->new(
       XMLNS_OAIDC() => sub {my $buffer = ''; return XML::SAX::Writer->new(Output => \$buffer)}
    );
  isa_ok($listfilter, 'Net::OAI::Record::NamespaceFilter');

  my $list = $h->listRecords(
    metadataPrefix => 'oai_dc',
    metadataHandler => $listfilter,
  );
  isa_ok( $list, 'Net::OAI::ListRecords' );
  close($fh);
  my $raw = $list->xml();
  note "RAW: ".$list->xml();
  my %rawids;
  while ( $raw =~ m!<dc:identifier>([^<]+)</dc:identifier>!g ) {
      $rawids{$1}++;
    };

  my $count = 0;
  my %ids;
  my $idcount = 0;
  subtest 'Get some records with custom filter' => sub {
      while( my $r = $list->next() ) {
          $count++;
          note "processing record $count";
          isa_ok( $r, 'Net::OAI::Record' );

          my $header = $r->header();
          isa_ok( $header, 'Net::OAI::Record::Header' );
          ok( $header->identifier(), 'header identifier defined: '.$header->identifier() );
          unless ( $header -> identifier() ) {
              diag explain $header;
              diag "----";
            };

          my $data = $r->metadata();
          ok( defined $data, 'custom handler does deliver metadata' );
          isa_ok( $data, 'Net::OAI::Record::NamespaceFilter' );

          my $xmlref = $data->result(XMLNS_OAIDC);
          ok(defined $xmlref, "ns handler has a result");
          is(ref($xmlref), "SCALAR", "ns handler provides a string reference");
          my $xml = $$xmlref;          
          ok(defined $xml, "handler result is a string");
          like($xml, qr!<((?:\w+:)?title)>[^<]+</(\1)>!, 'string output contains dc:title');
          while ( $xml =~ m!<(?:\w+:)?identifier>([^<]+)</(\w+:)?identifier>!g ) {
              $ids{$1}++;
              $idcount ++;
            };
          note "RAW: $xml";
          note "====";
        }
      my $distinctids = scalar keys %ids;
      note "collected $count records with $distinctids different ids from $repo";
      my $distinctrawids = scalar keys %rawids;
      is($distinctids, $distinctrawids, "collected records have expected number of differentd ids");
      done_testing();
    };
  note "collected $count records from $repo";
# is($count, $nsubdocs, 'no of records and record events coincides');
}

sub HTE {
    my ($r, $url) = @_;
    my $hte;
    if ( my $e = $r->HTTPError() ) {
        $hte = "HTTP Error ".$e->status_line;
	$hte .= " [Retry-After: ".$r->HTTPRetryAfter()."]" if $e->code() == 503;
	diag("LWP condition when accessing $url:\n$hte");
        note explain $e;
      }
   return $hte;
}

