package Date::Manip::TZ::amasun00;
# Copyright (c) 2008-2013 Sullivan Beck.  All rights reserved.
# This program is free software; you can redistribute it and/or modify it
# under the same terms as Perl itself.

# This file was automatically generated.  Any changes to this file will
# be lost the next time 'tzdata' is run.
#    Generated on: Fri Nov 30 12:40:03 EST 2012
#    Data version: tzdata2012j
#    Code version: tzcode2012j

# This module contains data from the zoneinfo time zone database.  The original
# data was obtained from the URL:
#    ftp://ftp.iana.org/tz

=pod

=head1 NAME

Date::Manip::TZ::amasun00 - Support for the America/Asuncion time zone

=head1 SYNPOSIS

This module contains data describing a time zone.  Most of the time zone
data comes from the Olsen database, but there are a few exceptions.

This module is not intended to be used directly.  Other Date::Manip modules
will load it as needed.

=cut

use strict;
use warnings;
require 5.010000;

our (%Dates,%LastRule);
END {
   undef %Dates;
   undef %LastRule;
}

our ($VERSION);
$VERSION='6.38';
END { undef $VERSION; }

%Dates         = (
   1    =>
     [
        [ [1,1,2,0,0,0],[1,1,1,20,9,20],'-03:50:40',[-3,-50,-40],
          'LMT',0,[1890,1,1,3,50,39],[1889,12,31,23,59,59],
          '0001010200:00:00','0001010120:09:20','1890010103:50:39','1889123123:59:59' ],
     ],
   1890 =>
     [
        [ [1890,1,1,3,50,40],[1890,1,1,0,0,0],'-03:50:40',[-3,-50,-40],
          'AMT',0,[1931,10,10,3,50,39],[1931,10,9,23,59,59],
          '1890010103:50:40','1890010100:00:00','1931101003:50:39','1931100923:59:59' ],
     ],
   1931 =>
     [
        [ [1931,10,10,3,50,40],[1931,10,9,23,50,40],'-04:00:00',[-4,0,0],
          'PYT',0,[1972,10,1,3,59,59],[1972,9,30,23,59,59],
          '1931101003:50:40','1931100923:50:40','1972100103:59:59','1972093023:59:59' ],
     ],
   1972 =>
     [
        [ [1972,10,1,4,0,0],[1972,10,1,1,0,0],'-03:00:00',[-3,0,0],
          'PYT',0,[1974,4,1,2,59,59],[1974,3,31,23,59,59],
          '1972100104:00:00','1972100101:00:00','1974040102:59:59','1974033123:59:59' ],
     ],
   1974 =>
     [
        [ [1974,4,1,3,0,0],[1974,3,31,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[1975,10,1,3,59,59],[1975,9,30,23,59,59],
          '1974040103:00:00','1974033123:00:00','1975100103:59:59','1975093023:59:59' ],
     ],
   1975 =>
     [
        [ [1975,10,1,4,0,0],[1975,10,1,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[1976,3,1,2,59,59],[1976,2,29,23,59,59],
          '1975100104:00:00','1975100101:00:00','1976030102:59:59','1976022923:59:59' ],
     ],
   1976 =>
     [
        [ [1976,3,1,3,0,0],[1976,2,29,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[1976,10,1,3,59,59],[1976,9,30,23,59,59],
          '1976030103:00:00','1976022923:00:00','1976100103:59:59','1976093023:59:59' ],
        [ [1976,10,1,4,0,0],[1976,10,1,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[1977,3,1,2,59,59],[1977,2,28,23,59,59],
          '1976100104:00:00','1976100101:00:00','1977030102:59:59','1977022823:59:59' ],
     ],
   1977 =>
     [
        [ [1977,3,1,3,0,0],[1977,2,28,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[1977,10,1,3,59,59],[1977,9,30,23,59,59],
          '1977030103:00:00','1977022823:00:00','1977100103:59:59','1977093023:59:59' ],
        [ [1977,10,1,4,0,0],[1977,10,1,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[1978,3,1,2,59,59],[1978,2,28,23,59,59],
          '1977100104:00:00','1977100101:00:00','1978030102:59:59','1978022823:59:59' ],
     ],
   1978 =>
     [
        [ [1978,3,1,3,0,0],[1978,2,28,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[1978,10,1,3,59,59],[1978,9,30,23,59,59],
          '1978030103:00:00','1978022823:00:00','1978100103:59:59','1978093023:59:59' ],
        [ [1978,10,1,4,0,0],[1978,10,1,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[1979,4,1,2,59,59],[1979,3,31,23,59,59],
          '1978100104:00:00','1978100101:00:00','1979040102:59:59','1979033123:59:59' ],
     ],
   1979 =>
     [
        [ [1979,4,1,3,0,0],[1979,3,31,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[1979,10,1,3,59,59],[1979,9,30,23,59,59],
          '1979040103:00:00','1979033123:00:00','1979100103:59:59','1979093023:59:59' ],
        [ [1979,10,1,4,0,0],[1979,10,1,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[1980,4,1,2,59,59],[1980,3,31,23,59,59],
          '1979100104:00:00','1979100101:00:00','1980040102:59:59','1980033123:59:59' ],
     ],
   1980 =>
     [
        [ [1980,4,1,3,0,0],[1980,3,31,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[1980,10,1,3,59,59],[1980,9,30,23,59,59],
          '1980040103:00:00','1980033123:00:00','1980100103:59:59','1980093023:59:59' ],
        [ [1980,10,1,4,0,0],[1980,10,1,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[1981,4,1,2,59,59],[1981,3,31,23,59,59],
          '1980100104:00:00','1980100101:00:00','1981040102:59:59','1981033123:59:59' ],
     ],
   1981 =>
     [
        [ [1981,4,1,3,0,0],[1981,3,31,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[1981,10,1,3,59,59],[1981,9,30,23,59,59],
          '1981040103:00:00','1981033123:00:00','1981100103:59:59','1981093023:59:59' ],
        [ [1981,10,1,4,0,0],[1981,10,1,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[1982,4,1,2,59,59],[1982,3,31,23,59,59],
          '1981100104:00:00','1981100101:00:00','1982040102:59:59','1982033123:59:59' ],
     ],
   1982 =>
     [
        [ [1982,4,1,3,0,0],[1982,3,31,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[1982,10,1,3,59,59],[1982,9,30,23,59,59],
          '1982040103:00:00','1982033123:00:00','1982100103:59:59','1982093023:59:59' ],
        [ [1982,10,1,4,0,0],[1982,10,1,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[1983,4,1,2,59,59],[1983,3,31,23,59,59],
          '1982100104:00:00','1982100101:00:00','1983040102:59:59','1983033123:59:59' ],
     ],
   1983 =>
     [
        [ [1983,4,1,3,0,0],[1983,3,31,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[1983,10,1,3,59,59],[1983,9,30,23,59,59],
          '1983040103:00:00','1983033123:00:00','1983100103:59:59','1983093023:59:59' ],
        [ [1983,10,1,4,0,0],[1983,10,1,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[1984,4,1,2,59,59],[1984,3,31,23,59,59],
          '1983100104:00:00','1983100101:00:00','1984040102:59:59','1984033123:59:59' ],
     ],
   1984 =>
     [
        [ [1984,4,1,3,0,0],[1984,3,31,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[1984,10,1,3,59,59],[1984,9,30,23,59,59],
          '1984040103:00:00','1984033123:00:00','1984100103:59:59','1984093023:59:59' ],
        [ [1984,10,1,4,0,0],[1984,10,1,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[1985,4,1,2,59,59],[1985,3,31,23,59,59],
          '1984100104:00:00','1984100101:00:00','1985040102:59:59','1985033123:59:59' ],
     ],
   1985 =>
     [
        [ [1985,4,1,3,0,0],[1985,3,31,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[1985,10,1,3,59,59],[1985,9,30,23,59,59],
          '1985040103:00:00','1985033123:00:00','1985100103:59:59','1985093023:59:59' ],
        [ [1985,10,1,4,0,0],[1985,10,1,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[1986,4,1,2,59,59],[1986,3,31,23,59,59],
          '1985100104:00:00','1985100101:00:00','1986040102:59:59','1986033123:59:59' ],
     ],
   1986 =>
     [
        [ [1986,4,1,3,0,0],[1986,3,31,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[1986,10,1,3,59,59],[1986,9,30,23,59,59],
          '1986040103:00:00','1986033123:00:00','1986100103:59:59','1986093023:59:59' ],
        [ [1986,10,1,4,0,0],[1986,10,1,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[1987,4,1,2,59,59],[1987,3,31,23,59,59],
          '1986100104:00:00','1986100101:00:00','1987040102:59:59','1987033123:59:59' ],
     ],
   1987 =>
     [
        [ [1987,4,1,3,0,0],[1987,3,31,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[1987,10,1,3,59,59],[1987,9,30,23,59,59],
          '1987040103:00:00','1987033123:00:00','1987100103:59:59','1987093023:59:59' ],
        [ [1987,10,1,4,0,0],[1987,10,1,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[1988,4,1,2,59,59],[1988,3,31,23,59,59],
          '1987100104:00:00','1987100101:00:00','1988040102:59:59','1988033123:59:59' ],
     ],
   1988 =>
     [
        [ [1988,4,1,3,0,0],[1988,3,31,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[1988,10,1,3,59,59],[1988,9,30,23,59,59],
          '1988040103:00:00','1988033123:00:00','1988100103:59:59','1988093023:59:59' ],
        [ [1988,10,1,4,0,0],[1988,10,1,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[1989,4,1,2,59,59],[1989,3,31,23,59,59],
          '1988100104:00:00','1988100101:00:00','1989040102:59:59','1989033123:59:59' ],
     ],
   1989 =>
     [
        [ [1989,4,1,3,0,0],[1989,3,31,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[1989,10,22,3,59,59],[1989,10,21,23,59,59],
          '1989040103:00:00','1989033123:00:00','1989102203:59:59','1989102123:59:59' ],
        [ [1989,10,22,4,0,0],[1989,10,22,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[1990,4,1,2,59,59],[1990,3,31,23,59,59],
          '1989102204:00:00','1989102201:00:00','1990040102:59:59','1990033123:59:59' ],
     ],
   1990 =>
     [
        [ [1990,4,1,3,0,0],[1990,3,31,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[1990,10,1,3,59,59],[1990,9,30,23,59,59],
          '1990040103:00:00','1990033123:00:00','1990100103:59:59','1990093023:59:59' ],
        [ [1990,10,1,4,0,0],[1990,10,1,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[1991,4,1,2,59,59],[1991,3,31,23,59,59],
          '1990100104:00:00','1990100101:00:00','1991040102:59:59','1991033123:59:59' ],
     ],
   1991 =>
     [
        [ [1991,4,1,3,0,0],[1991,3,31,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[1991,10,6,3,59,59],[1991,10,5,23,59,59],
          '1991040103:00:00','1991033123:00:00','1991100603:59:59','1991100523:59:59' ],
        [ [1991,10,6,4,0,0],[1991,10,6,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[1992,3,1,2,59,59],[1992,2,29,23,59,59],
          '1991100604:00:00','1991100601:00:00','1992030102:59:59','1992022923:59:59' ],
     ],
   1992 =>
     [
        [ [1992,3,1,3,0,0],[1992,2,29,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[1992,10,5,3,59,59],[1992,10,4,23,59,59],
          '1992030103:00:00','1992022923:00:00','1992100503:59:59','1992100423:59:59' ],
        [ [1992,10,5,4,0,0],[1992,10,5,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[1993,3,31,2,59,59],[1993,3,30,23,59,59],
          '1992100504:00:00','1992100501:00:00','1993033102:59:59','1993033023:59:59' ],
     ],
   1993 =>
     [
        [ [1993,3,31,3,0,0],[1993,3,30,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[1993,10,1,3,59,59],[1993,9,30,23,59,59],
          '1993033103:00:00','1993033023:00:00','1993100103:59:59','1993093023:59:59' ],
        [ [1993,10,1,4,0,0],[1993,10,1,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[1994,2,27,2,59,59],[1994,2,26,23,59,59],
          '1993100104:00:00','1993100101:00:00','1994022702:59:59','1994022623:59:59' ],
     ],
   1994 =>
     [
        [ [1994,2,27,3,0,0],[1994,2,26,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[1994,10,1,3,59,59],[1994,9,30,23,59,59],
          '1994022703:00:00','1994022623:00:00','1994100103:59:59','1994093023:59:59' ],
        [ [1994,10,1,4,0,0],[1994,10,1,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[1995,2,26,2,59,59],[1995,2,25,23,59,59],
          '1994100104:00:00','1994100101:00:00','1995022602:59:59','1995022523:59:59' ],
     ],
   1995 =>
     [
        [ [1995,2,26,3,0,0],[1995,2,25,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[1995,10,1,3,59,59],[1995,9,30,23,59,59],
          '1995022603:00:00','1995022523:00:00','1995100103:59:59','1995093023:59:59' ],
        [ [1995,10,1,4,0,0],[1995,10,1,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[1996,3,1,2,59,59],[1996,2,29,23,59,59],
          '1995100104:00:00','1995100101:00:00','1996030102:59:59','1996022923:59:59' ],
     ],
   1996 =>
     [
        [ [1996,3,1,3,0,0],[1996,2,29,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[1996,10,6,3,59,59],[1996,10,5,23,59,59],
          '1996030103:00:00','1996022923:00:00','1996100603:59:59','1996100523:59:59' ],
        [ [1996,10,6,4,0,0],[1996,10,6,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[1997,2,23,2,59,59],[1997,2,22,23,59,59],
          '1996100604:00:00','1996100601:00:00','1997022302:59:59','1997022223:59:59' ],
     ],
   1997 =>
     [
        [ [1997,2,23,3,0,0],[1997,2,22,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[1997,10,5,3,59,59],[1997,10,4,23,59,59],
          '1997022303:00:00','1997022223:00:00','1997100503:59:59','1997100423:59:59' ],
        [ [1997,10,5,4,0,0],[1997,10,5,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[1998,3,1,2,59,59],[1998,2,28,23,59,59],
          '1997100504:00:00','1997100501:00:00','1998030102:59:59','1998022823:59:59' ],
     ],
   1998 =>
     [
        [ [1998,3,1,3,0,0],[1998,2,28,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[1998,10,4,3,59,59],[1998,10,3,23,59,59],
          '1998030103:00:00','1998022823:00:00','1998100403:59:59','1998100323:59:59' ],
        [ [1998,10,4,4,0,0],[1998,10,4,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[1999,3,7,2,59,59],[1999,3,6,23,59,59],
          '1998100404:00:00','1998100401:00:00','1999030702:59:59','1999030623:59:59' ],
     ],
   1999 =>
     [
        [ [1999,3,7,3,0,0],[1999,3,6,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[1999,10,3,3,59,59],[1999,10,2,23,59,59],
          '1999030703:00:00','1999030623:00:00','1999100303:59:59','1999100223:59:59' ],
        [ [1999,10,3,4,0,0],[1999,10,3,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2000,3,5,2,59,59],[2000,3,4,23,59,59],
          '1999100304:00:00','1999100301:00:00','2000030502:59:59','2000030423:59:59' ],
     ],
   2000 =>
     [
        [ [2000,3,5,3,0,0],[2000,3,4,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2000,10,1,3,59,59],[2000,9,30,23,59,59],
          '2000030503:00:00','2000030423:00:00','2000100103:59:59','2000093023:59:59' ],
        [ [2000,10,1,4,0,0],[2000,10,1,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2001,3,4,2,59,59],[2001,3,3,23,59,59],
          '2000100104:00:00','2000100101:00:00','2001030402:59:59','2001030323:59:59' ],
     ],
   2001 =>
     [
        [ [2001,3,4,3,0,0],[2001,3,3,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2001,10,7,3,59,59],[2001,10,6,23,59,59],
          '2001030403:00:00','2001030323:00:00','2001100703:59:59','2001100623:59:59' ],
        [ [2001,10,7,4,0,0],[2001,10,7,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2002,4,7,2,59,59],[2002,4,6,23,59,59],
          '2001100704:00:00','2001100701:00:00','2002040702:59:59','2002040623:59:59' ],
     ],
   2002 =>
     [
        [ [2002,4,7,3,0,0],[2002,4,6,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2002,9,1,3,59,59],[2002,8,31,23,59,59],
          '2002040703:00:00','2002040623:00:00','2002090103:59:59','2002083123:59:59' ],
        [ [2002,9,1,4,0,0],[2002,9,1,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2003,4,6,2,59,59],[2003,4,5,23,59,59],
          '2002090104:00:00','2002090101:00:00','2003040602:59:59','2003040523:59:59' ],
     ],
   2003 =>
     [
        [ [2003,4,6,3,0,0],[2003,4,5,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2003,9,7,3,59,59],[2003,9,6,23,59,59],
          '2003040603:00:00','2003040523:00:00','2003090703:59:59','2003090623:59:59' ],
        [ [2003,9,7,4,0,0],[2003,9,7,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2004,4,4,2,59,59],[2004,4,3,23,59,59],
          '2003090704:00:00','2003090701:00:00','2004040402:59:59','2004040323:59:59' ],
     ],
   2004 =>
     [
        [ [2004,4,4,3,0,0],[2004,4,3,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2004,10,17,3,59,59],[2004,10,16,23,59,59],
          '2004040403:00:00','2004040323:00:00','2004101703:59:59','2004101623:59:59' ],
        [ [2004,10,17,4,0,0],[2004,10,17,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2005,3,13,2,59,59],[2005,3,12,23,59,59],
          '2004101704:00:00','2004101701:00:00','2005031302:59:59','2005031223:59:59' ],
     ],
   2005 =>
     [
        [ [2005,3,13,3,0,0],[2005,3,12,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2005,10,16,3,59,59],[2005,10,15,23,59,59],
          '2005031303:00:00','2005031223:00:00','2005101603:59:59','2005101523:59:59' ],
        [ [2005,10,16,4,0,0],[2005,10,16,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2006,3,12,2,59,59],[2006,3,11,23,59,59],
          '2005101604:00:00','2005101601:00:00','2006031202:59:59','2006031123:59:59' ],
     ],
   2006 =>
     [
        [ [2006,3,12,3,0,0],[2006,3,11,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2006,10,15,3,59,59],[2006,10,14,23,59,59],
          '2006031203:00:00','2006031123:00:00','2006101503:59:59','2006101423:59:59' ],
        [ [2006,10,15,4,0,0],[2006,10,15,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2007,3,11,2,59,59],[2007,3,10,23,59,59],
          '2006101504:00:00','2006101501:00:00','2007031102:59:59','2007031023:59:59' ],
     ],
   2007 =>
     [
        [ [2007,3,11,3,0,0],[2007,3,10,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2007,10,21,3,59,59],[2007,10,20,23,59,59],
          '2007031103:00:00','2007031023:00:00','2007102103:59:59','2007102023:59:59' ],
        [ [2007,10,21,4,0,0],[2007,10,21,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2008,3,9,2,59,59],[2008,3,8,23,59,59],
          '2007102104:00:00','2007102101:00:00','2008030902:59:59','2008030823:59:59' ],
     ],
   2008 =>
     [
        [ [2008,3,9,3,0,0],[2008,3,8,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2008,10,19,3,59,59],[2008,10,18,23,59,59],
          '2008030903:00:00','2008030823:00:00','2008101903:59:59','2008101823:59:59' ],
        [ [2008,10,19,4,0,0],[2008,10,19,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2009,3,8,2,59,59],[2009,3,7,23,59,59],
          '2008101904:00:00','2008101901:00:00','2009030802:59:59','2009030723:59:59' ],
     ],
   2009 =>
     [
        [ [2009,3,8,3,0,0],[2009,3,7,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2009,10,18,3,59,59],[2009,10,17,23,59,59],
          '2009030803:00:00','2009030723:00:00','2009101803:59:59','2009101723:59:59' ],
        [ [2009,10,18,4,0,0],[2009,10,18,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2010,4,11,2,59,59],[2010,4,10,23,59,59],
          '2009101804:00:00','2009101801:00:00','2010041102:59:59','2010041023:59:59' ],
     ],
   2010 =>
     [
        [ [2010,4,11,3,0,0],[2010,4,10,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2010,10,3,3,59,59],[2010,10,2,23,59,59],
          '2010041103:00:00','2010041023:00:00','2010100303:59:59','2010100223:59:59' ],
        [ [2010,10,3,4,0,0],[2010,10,3,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2011,4,10,2,59,59],[2011,4,9,23,59,59],
          '2010100304:00:00','2010100301:00:00','2011041002:59:59','2011040923:59:59' ],
     ],
   2011 =>
     [
        [ [2011,4,10,3,0,0],[2011,4,9,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2011,10,2,3,59,59],[2011,10,1,23,59,59],
          '2011041003:00:00','2011040923:00:00','2011100203:59:59','2011100123:59:59' ],
        [ [2011,10,2,4,0,0],[2011,10,2,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2012,4,8,2,59,59],[2012,4,7,23,59,59],
          '2011100204:00:00','2011100201:00:00','2012040802:59:59','2012040723:59:59' ],
     ],
   2012 =>
     [
        [ [2012,4,8,3,0,0],[2012,4,7,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2012,10,7,3,59,59],[2012,10,6,23,59,59],
          '2012040803:00:00','2012040723:00:00','2012100703:59:59','2012100623:59:59' ],
        [ [2012,10,7,4,0,0],[2012,10,7,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2013,4,14,2,59,59],[2013,4,13,23,59,59],
          '2012100704:00:00','2012100701:00:00','2013041402:59:59','2013041323:59:59' ],
     ],
   2013 =>
     [
        [ [2013,4,14,3,0,0],[2013,4,13,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2013,10,6,3,59,59],[2013,10,5,23,59,59],
          '2013041403:00:00','2013041323:00:00','2013100603:59:59','2013100523:59:59' ],
        [ [2013,10,6,4,0,0],[2013,10,6,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2014,4,13,2,59,59],[2014,4,12,23,59,59],
          '2013100604:00:00','2013100601:00:00','2014041302:59:59','2014041223:59:59' ],
     ],
   2014 =>
     [
        [ [2014,4,13,3,0,0],[2014,4,12,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2014,10,5,3,59,59],[2014,10,4,23,59,59],
          '2014041303:00:00','2014041223:00:00','2014100503:59:59','2014100423:59:59' ],
        [ [2014,10,5,4,0,0],[2014,10,5,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2015,4,12,2,59,59],[2015,4,11,23,59,59],
          '2014100504:00:00','2014100501:00:00','2015041202:59:59','2015041123:59:59' ],
     ],
   2015 =>
     [
        [ [2015,4,12,3,0,0],[2015,4,11,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2015,10,4,3,59,59],[2015,10,3,23,59,59],
          '2015041203:00:00','2015041123:00:00','2015100403:59:59','2015100323:59:59' ],
        [ [2015,10,4,4,0,0],[2015,10,4,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2016,4,10,2,59,59],[2016,4,9,23,59,59],
          '2015100404:00:00','2015100401:00:00','2016041002:59:59','2016040923:59:59' ],
     ],
   2016 =>
     [
        [ [2016,4,10,3,0,0],[2016,4,9,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2016,10,2,3,59,59],[2016,10,1,23,59,59],
          '2016041003:00:00','2016040923:00:00','2016100203:59:59','2016100123:59:59' ],
        [ [2016,10,2,4,0,0],[2016,10,2,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2017,4,9,2,59,59],[2017,4,8,23,59,59],
          '2016100204:00:00','2016100201:00:00','2017040902:59:59','2017040823:59:59' ],
     ],
   2017 =>
     [
        [ [2017,4,9,3,0,0],[2017,4,8,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2017,10,1,3,59,59],[2017,9,30,23,59,59],
          '2017040903:00:00','2017040823:00:00','2017100103:59:59','2017093023:59:59' ],
        [ [2017,10,1,4,0,0],[2017,10,1,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2018,4,8,2,59,59],[2018,4,7,23,59,59],
          '2017100104:00:00','2017100101:00:00','2018040802:59:59','2018040723:59:59' ],
     ],
   2018 =>
     [
        [ [2018,4,8,3,0,0],[2018,4,7,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2018,10,7,3,59,59],[2018,10,6,23,59,59],
          '2018040803:00:00','2018040723:00:00','2018100703:59:59','2018100623:59:59' ],
        [ [2018,10,7,4,0,0],[2018,10,7,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2019,4,14,2,59,59],[2019,4,13,23,59,59],
          '2018100704:00:00','2018100701:00:00','2019041402:59:59','2019041323:59:59' ],
     ],
   2019 =>
     [
        [ [2019,4,14,3,0,0],[2019,4,13,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2019,10,6,3,59,59],[2019,10,5,23,59,59],
          '2019041403:00:00','2019041323:00:00','2019100603:59:59','2019100523:59:59' ],
        [ [2019,10,6,4,0,0],[2019,10,6,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2020,4,12,2,59,59],[2020,4,11,23,59,59],
          '2019100604:00:00','2019100601:00:00','2020041202:59:59','2020041123:59:59' ],
     ],
   2020 =>
     [
        [ [2020,4,12,3,0,0],[2020,4,11,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2020,10,4,3,59,59],[2020,10,3,23,59,59],
          '2020041203:00:00','2020041123:00:00','2020100403:59:59','2020100323:59:59' ],
        [ [2020,10,4,4,0,0],[2020,10,4,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2021,4,11,2,59,59],[2021,4,10,23,59,59],
          '2020100404:00:00','2020100401:00:00','2021041102:59:59','2021041023:59:59' ],
     ],
   2021 =>
     [
        [ [2021,4,11,3,0,0],[2021,4,10,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2021,10,3,3,59,59],[2021,10,2,23,59,59],
          '2021041103:00:00','2021041023:00:00','2021100303:59:59','2021100223:59:59' ],
        [ [2021,10,3,4,0,0],[2021,10,3,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2022,4,10,2,59,59],[2022,4,9,23,59,59],
          '2021100304:00:00','2021100301:00:00','2022041002:59:59','2022040923:59:59' ],
     ],
   2022 =>
     [
        [ [2022,4,10,3,0,0],[2022,4,9,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2022,10,2,3,59,59],[2022,10,1,23,59,59],
          '2022041003:00:00','2022040923:00:00','2022100203:59:59','2022100123:59:59' ],
        [ [2022,10,2,4,0,0],[2022,10,2,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2023,4,9,2,59,59],[2023,4,8,23,59,59],
          '2022100204:00:00','2022100201:00:00','2023040902:59:59','2023040823:59:59' ],
     ],
   2023 =>
     [
        [ [2023,4,9,3,0,0],[2023,4,8,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2023,10,1,3,59,59],[2023,9,30,23,59,59],
          '2023040903:00:00','2023040823:00:00','2023100103:59:59','2023093023:59:59' ],
        [ [2023,10,1,4,0,0],[2023,10,1,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2024,4,14,2,59,59],[2024,4,13,23,59,59],
          '2023100104:00:00','2023100101:00:00','2024041402:59:59','2024041323:59:59' ],
     ],
   2024 =>
     [
        [ [2024,4,14,3,0,0],[2024,4,13,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2024,10,6,3,59,59],[2024,10,5,23,59,59],
          '2024041403:00:00','2024041323:00:00','2024100603:59:59','2024100523:59:59' ],
        [ [2024,10,6,4,0,0],[2024,10,6,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2025,4,13,2,59,59],[2025,4,12,23,59,59],
          '2024100604:00:00','2024100601:00:00','2025041302:59:59','2025041223:59:59' ],
     ],
   2025 =>
     [
        [ [2025,4,13,3,0,0],[2025,4,12,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2025,10,5,3,59,59],[2025,10,4,23,59,59],
          '2025041303:00:00','2025041223:00:00','2025100503:59:59','2025100423:59:59' ],
        [ [2025,10,5,4,0,0],[2025,10,5,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2026,4,12,2,59,59],[2026,4,11,23,59,59],
          '2025100504:00:00','2025100501:00:00','2026041202:59:59','2026041123:59:59' ],
     ],
   2026 =>
     [
        [ [2026,4,12,3,0,0],[2026,4,11,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2026,10,4,3,59,59],[2026,10,3,23,59,59],
          '2026041203:00:00','2026041123:00:00','2026100403:59:59','2026100323:59:59' ],
        [ [2026,10,4,4,0,0],[2026,10,4,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2027,4,11,2,59,59],[2027,4,10,23,59,59],
          '2026100404:00:00','2026100401:00:00','2027041102:59:59','2027041023:59:59' ],
     ],
   2027 =>
     [
        [ [2027,4,11,3,0,0],[2027,4,10,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2027,10,3,3,59,59],[2027,10,2,23,59,59],
          '2027041103:00:00','2027041023:00:00','2027100303:59:59','2027100223:59:59' ],
        [ [2027,10,3,4,0,0],[2027,10,3,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2028,4,9,2,59,59],[2028,4,8,23,59,59],
          '2027100304:00:00','2027100301:00:00','2028040902:59:59','2028040823:59:59' ],
     ],
   2028 =>
     [
        [ [2028,4,9,3,0,0],[2028,4,8,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2028,10,1,3,59,59],[2028,9,30,23,59,59],
          '2028040903:00:00','2028040823:00:00','2028100103:59:59','2028093023:59:59' ],
        [ [2028,10,1,4,0,0],[2028,10,1,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2029,4,8,2,59,59],[2029,4,7,23,59,59],
          '2028100104:00:00','2028100101:00:00','2029040802:59:59','2029040723:59:59' ],
     ],
   2029 =>
     [
        [ [2029,4,8,3,0,0],[2029,4,7,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2029,10,7,3,59,59],[2029,10,6,23,59,59],
          '2029040803:00:00','2029040723:00:00','2029100703:59:59','2029100623:59:59' ],
        [ [2029,10,7,4,0,0],[2029,10,7,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2030,4,14,2,59,59],[2030,4,13,23,59,59],
          '2029100704:00:00','2029100701:00:00','2030041402:59:59','2030041323:59:59' ],
     ],
   2030 =>
     [
        [ [2030,4,14,3,0,0],[2030,4,13,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2030,10,6,3,59,59],[2030,10,5,23,59,59],
          '2030041403:00:00','2030041323:00:00','2030100603:59:59','2030100523:59:59' ],
        [ [2030,10,6,4,0,0],[2030,10,6,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2031,4,13,2,59,59],[2031,4,12,23,59,59],
          '2030100604:00:00','2030100601:00:00','2031041302:59:59','2031041223:59:59' ],
     ],
   2031 =>
     [
        [ [2031,4,13,3,0,0],[2031,4,12,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2031,10,5,3,59,59],[2031,10,4,23,59,59],
          '2031041303:00:00','2031041223:00:00','2031100503:59:59','2031100423:59:59' ],
        [ [2031,10,5,4,0,0],[2031,10,5,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2032,4,11,2,59,59],[2032,4,10,23,59,59],
          '2031100504:00:00','2031100501:00:00','2032041102:59:59','2032041023:59:59' ],
     ],
   2032 =>
     [
        [ [2032,4,11,3,0,0],[2032,4,10,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2032,10,3,3,59,59],[2032,10,2,23,59,59],
          '2032041103:00:00','2032041023:00:00','2032100303:59:59','2032100223:59:59' ],
        [ [2032,10,3,4,0,0],[2032,10,3,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2033,4,10,2,59,59],[2033,4,9,23,59,59],
          '2032100304:00:00','2032100301:00:00','2033041002:59:59','2033040923:59:59' ],
     ],
   2033 =>
     [
        [ [2033,4,10,3,0,0],[2033,4,9,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2033,10,2,3,59,59],[2033,10,1,23,59,59],
          '2033041003:00:00','2033040923:00:00','2033100203:59:59','2033100123:59:59' ],
        [ [2033,10,2,4,0,0],[2033,10,2,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2034,4,9,2,59,59],[2034,4,8,23,59,59],
          '2033100204:00:00','2033100201:00:00','2034040902:59:59','2034040823:59:59' ],
     ],
   2034 =>
     [
        [ [2034,4,9,3,0,0],[2034,4,8,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2034,10,1,3,59,59],[2034,9,30,23,59,59],
          '2034040903:00:00','2034040823:00:00','2034100103:59:59','2034093023:59:59' ],
        [ [2034,10,1,4,0,0],[2034,10,1,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2035,4,8,2,59,59],[2035,4,7,23,59,59],
          '2034100104:00:00','2034100101:00:00','2035040802:59:59','2035040723:59:59' ],
     ],
   2035 =>
     [
        [ [2035,4,8,3,0,0],[2035,4,7,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2035,10,7,3,59,59],[2035,10,6,23,59,59],
          '2035040803:00:00','2035040723:00:00','2035100703:59:59','2035100623:59:59' ],
        [ [2035,10,7,4,0,0],[2035,10,7,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2036,4,13,2,59,59],[2036,4,12,23,59,59],
          '2035100704:00:00','2035100701:00:00','2036041302:59:59','2036041223:59:59' ],
     ],
   2036 =>
     [
        [ [2036,4,13,3,0,0],[2036,4,12,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2036,10,5,3,59,59],[2036,10,4,23,59,59],
          '2036041303:00:00','2036041223:00:00','2036100503:59:59','2036100423:59:59' ],
        [ [2036,10,5,4,0,0],[2036,10,5,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2037,4,12,2,59,59],[2037,4,11,23,59,59],
          '2036100504:00:00','2036100501:00:00','2037041202:59:59','2037041123:59:59' ],
     ],
   2037 =>
     [
        [ [2037,4,12,3,0,0],[2037,4,11,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2037,10,4,3,59,59],[2037,10,3,23,59,59],
          '2037041203:00:00','2037041123:00:00','2037100403:59:59','2037100323:59:59' ],
        [ [2037,10,4,4,0,0],[2037,10,4,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2038,4,11,2,59,59],[2038,4,10,23,59,59],
          '2037100404:00:00','2037100401:00:00','2038041102:59:59','2038041023:59:59' ],
     ],
   2038 =>
     [
        [ [2038,4,11,3,0,0],[2038,4,10,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2038,10,3,3,59,59],[2038,10,2,23,59,59],
          '2038041103:00:00','2038041023:00:00','2038100303:59:59','2038100223:59:59' ],
        [ [2038,10,3,4,0,0],[2038,10,3,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2039,4,10,2,59,59],[2039,4,9,23,59,59],
          '2038100304:00:00','2038100301:00:00','2039041002:59:59','2039040923:59:59' ],
     ],
   2039 =>
     [
        [ [2039,4,10,3,0,0],[2039,4,9,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2039,10,2,3,59,59],[2039,10,1,23,59,59],
          '2039041003:00:00','2039040923:00:00','2039100203:59:59','2039100123:59:59' ],
        [ [2039,10,2,4,0,0],[2039,10,2,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2040,4,8,2,59,59],[2040,4,7,23,59,59],
          '2039100204:00:00','2039100201:00:00','2040040802:59:59','2040040723:59:59' ],
     ],
   2040 =>
     [
        [ [2040,4,8,3,0,0],[2040,4,7,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2040,10,7,3,59,59],[2040,10,6,23,59,59],
          '2040040803:00:00','2040040723:00:00','2040100703:59:59','2040100623:59:59' ],
        [ [2040,10,7,4,0,0],[2040,10,7,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2041,4,14,2,59,59],[2041,4,13,23,59,59],
          '2040100704:00:00','2040100701:00:00','2041041402:59:59','2041041323:59:59' ],
     ],
   2041 =>
     [
        [ [2041,4,14,3,0,0],[2041,4,13,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2041,10,6,3,59,59],[2041,10,5,23,59,59],
          '2041041403:00:00','2041041323:00:00','2041100603:59:59','2041100523:59:59' ],
        [ [2041,10,6,4,0,0],[2041,10,6,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2042,4,13,2,59,59],[2042,4,12,23,59,59],
          '2041100604:00:00','2041100601:00:00','2042041302:59:59','2042041223:59:59' ],
     ],
   2042 =>
     [
        [ [2042,4,13,3,0,0],[2042,4,12,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2042,10,5,3,59,59],[2042,10,4,23,59,59],
          '2042041303:00:00','2042041223:00:00','2042100503:59:59','2042100423:59:59' ],
        [ [2042,10,5,4,0,0],[2042,10,5,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2043,4,12,2,59,59],[2043,4,11,23,59,59],
          '2042100504:00:00','2042100501:00:00','2043041202:59:59','2043041123:59:59' ],
     ],
   2043 =>
     [
        [ [2043,4,12,3,0,0],[2043,4,11,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2043,10,4,3,59,59],[2043,10,3,23,59,59],
          '2043041203:00:00','2043041123:00:00','2043100403:59:59','2043100323:59:59' ],
        [ [2043,10,4,4,0,0],[2043,10,4,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2044,4,10,2,59,59],[2044,4,9,23,59,59],
          '2043100404:00:00','2043100401:00:00','2044041002:59:59','2044040923:59:59' ],
     ],
   2044 =>
     [
        [ [2044,4,10,3,0,0],[2044,4,9,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2044,10,2,3,59,59],[2044,10,1,23,59,59],
          '2044041003:00:00','2044040923:00:00','2044100203:59:59','2044100123:59:59' ],
        [ [2044,10,2,4,0,0],[2044,10,2,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2045,4,9,2,59,59],[2045,4,8,23,59,59],
          '2044100204:00:00','2044100201:00:00','2045040902:59:59','2045040823:59:59' ],
     ],
   2045 =>
     [
        [ [2045,4,9,3,0,0],[2045,4,8,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2045,10,1,3,59,59],[2045,9,30,23,59,59],
          '2045040903:00:00','2045040823:00:00','2045100103:59:59','2045093023:59:59' ],
        [ [2045,10,1,4,0,0],[2045,10,1,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2046,4,8,2,59,59],[2046,4,7,23,59,59],
          '2045100104:00:00','2045100101:00:00','2046040802:59:59','2046040723:59:59' ],
     ],
   2046 =>
     [
        [ [2046,4,8,3,0,0],[2046,4,7,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2046,10,7,3,59,59],[2046,10,6,23,59,59],
          '2046040803:00:00','2046040723:00:00','2046100703:59:59','2046100623:59:59' ],
        [ [2046,10,7,4,0,0],[2046,10,7,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2047,4,14,2,59,59],[2047,4,13,23,59,59],
          '2046100704:00:00','2046100701:00:00','2047041402:59:59','2047041323:59:59' ],
     ],
   2047 =>
     [
        [ [2047,4,14,3,0,0],[2047,4,13,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2047,10,6,3,59,59],[2047,10,5,23,59,59],
          '2047041403:00:00','2047041323:00:00','2047100603:59:59','2047100523:59:59' ],
        [ [2047,10,6,4,0,0],[2047,10,6,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2048,4,12,2,59,59],[2048,4,11,23,59,59],
          '2047100604:00:00','2047100601:00:00','2048041202:59:59','2048041123:59:59' ],
     ],
   2048 =>
     [
        [ [2048,4,12,3,0,0],[2048,4,11,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2048,10,4,3,59,59],[2048,10,3,23,59,59],
          '2048041203:00:00','2048041123:00:00','2048100403:59:59','2048100323:59:59' ],
        [ [2048,10,4,4,0,0],[2048,10,4,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2049,4,11,2,59,59],[2049,4,10,23,59,59],
          '2048100404:00:00','2048100401:00:00','2049041102:59:59','2049041023:59:59' ],
     ],
   2049 =>
     [
        [ [2049,4,11,3,0,0],[2049,4,10,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2049,10,3,3,59,59],[2049,10,2,23,59,59],
          '2049041103:00:00','2049041023:00:00','2049100303:59:59','2049100223:59:59' ],
        [ [2049,10,3,4,0,0],[2049,10,3,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2050,4,10,2,59,59],[2050,4,9,23,59,59],
          '2049100304:00:00','2049100301:00:00','2050041002:59:59','2050040923:59:59' ],
     ],
   2050 =>
     [
        [ [2050,4,10,3,0,0],[2050,4,9,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2050,10,2,3,59,59],[2050,10,1,23,59,59],
          '2050041003:00:00','2050040923:00:00','2050100203:59:59','2050100123:59:59' ],
        [ [2050,10,2,4,0,0],[2050,10,2,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2051,4,9,2,59,59],[2051,4,8,23,59,59],
          '2050100204:00:00','2050100201:00:00','2051040902:59:59','2051040823:59:59' ],
     ],
   2051 =>
     [
        [ [2051,4,9,3,0,0],[2051,4,8,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2051,10,1,3,59,59],[2051,9,30,23,59,59],
          '2051040903:00:00','2051040823:00:00','2051100103:59:59','2051093023:59:59' ],
        [ [2051,10,1,4,0,0],[2051,10,1,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2052,4,14,2,59,59],[2052,4,13,23,59,59],
          '2051100104:00:00','2051100101:00:00','2052041402:59:59','2052041323:59:59' ],
     ],
   2052 =>
     [
        [ [2052,4,14,3,0,0],[2052,4,13,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2052,10,6,3,59,59],[2052,10,5,23,59,59],
          '2052041403:00:00','2052041323:00:00','2052100603:59:59','2052100523:59:59' ],
        [ [2052,10,6,4,0,0],[2052,10,6,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2053,4,13,2,59,59],[2053,4,12,23,59,59],
          '2052100604:00:00','2052100601:00:00','2053041302:59:59','2053041223:59:59' ],
     ],
   2053 =>
     [
        [ [2053,4,13,3,0,0],[2053,4,12,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2053,10,5,3,59,59],[2053,10,4,23,59,59],
          '2053041303:00:00','2053041223:00:00','2053100503:59:59','2053100423:59:59' ],
        [ [2053,10,5,4,0,0],[2053,10,5,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2054,4,12,2,59,59],[2054,4,11,23,59,59],
          '2053100504:00:00','2053100501:00:00','2054041202:59:59','2054041123:59:59' ],
     ],
   2054 =>
     [
        [ [2054,4,12,3,0,0],[2054,4,11,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2054,10,4,3,59,59],[2054,10,3,23,59,59],
          '2054041203:00:00','2054041123:00:00','2054100403:59:59','2054100323:59:59' ],
        [ [2054,10,4,4,0,0],[2054,10,4,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2055,4,11,2,59,59],[2055,4,10,23,59,59],
          '2054100404:00:00','2054100401:00:00','2055041102:59:59','2055041023:59:59' ],
     ],
   2055 =>
     [
        [ [2055,4,11,3,0,0],[2055,4,10,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2055,10,3,3,59,59],[2055,10,2,23,59,59],
          '2055041103:00:00','2055041023:00:00','2055100303:59:59','2055100223:59:59' ],
        [ [2055,10,3,4,0,0],[2055,10,3,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2056,4,9,2,59,59],[2056,4,8,23,59,59],
          '2055100304:00:00','2055100301:00:00','2056040902:59:59','2056040823:59:59' ],
     ],
   2056 =>
     [
        [ [2056,4,9,3,0,0],[2056,4,8,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2056,10,1,3,59,59],[2056,9,30,23,59,59],
          '2056040903:00:00','2056040823:00:00','2056100103:59:59','2056093023:59:59' ],
        [ [2056,10,1,4,0,0],[2056,10,1,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2057,4,8,2,59,59],[2057,4,7,23,59,59],
          '2056100104:00:00','2056100101:00:00','2057040802:59:59','2057040723:59:59' ],
     ],
   2057 =>
     [
        [ [2057,4,8,3,0,0],[2057,4,7,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2057,10,7,3,59,59],[2057,10,6,23,59,59],
          '2057040803:00:00','2057040723:00:00','2057100703:59:59','2057100623:59:59' ],
        [ [2057,10,7,4,0,0],[2057,10,7,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2058,4,14,2,59,59],[2058,4,13,23,59,59],
          '2057100704:00:00','2057100701:00:00','2058041402:59:59','2058041323:59:59' ],
     ],
   2058 =>
     [
        [ [2058,4,14,3,0,0],[2058,4,13,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2058,10,6,3,59,59],[2058,10,5,23,59,59],
          '2058041403:00:00','2058041323:00:00','2058100603:59:59','2058100523:59:59' ],
        [ [2058,10,6,4,0,0],[2058,10,6,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2059,4,13,2,59,59],[2059,4,12,23,59,59],
          '2058100604:00:00','2058100601:00:00','2059041302:59:59','2059041223:59:59' ],
     ],
   2059 =>
     [
        [ [2059,4,13,3,0,0],[2059,4,12,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2059,10,5,3,59,59],[2059,10,4,23,59,59],
          '2059041303:00:00','2059041223:00:00','2059100503:59:59','2059100423:59:59' ],
        [ [2059,10,5,4,0,0],[2059,10,5,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2060,4,11,2,59,59],[2060,4,10,23,59,59],
          '2059100504:00:00','2059100501:00:00','2060041102:59:59','2060041023:59:59' ],
     ],
   2060 =>
     [
        [ [2060,4,11,3,0,0],[2060,4,10,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2060,10,3,3,59,59],[2060,10,2,23,59,59],
          '2060041103:00:00','2060041023:00:00','2060100303:59:59','2060100223:59:59' ],
        [ [2060,10,3,4,0,0],[2060,10,3,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2061,4,10,2,59,59],[2061,4,9,23,59,59],
          '2060100304:00:00','2060100301:00:00','2061041002:59:59','2061040923:59:59' ],
     ],
   2061 =>
     [
        [ [2061,4,10,3,0,0],[2061,4,9,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2061,10,2,3,59,59],[2061,10,1,23,59,59],
          '2061041003:00:00','2061040923:00:00','2061100203:59:59','2061100123:59:59' ],
        [ [2061,10,2,4,0,0],[2061,10,2,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2062,4,9,2,59,59],[2062,4,8,23,59,59],
          '2061100204:00:00','2061100201:00:00','2062040902:59:59','2062040823:59:59' ],
     ],
   2062 =>
     [
        [ [2062,4,9,3,0,0],[2062,4,8,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2062,10,1,3,59,59],[2062,9,30,23,59,59],
          '2062040903:00:00','2062040823:00:00','2062100103:59:59','2062093023:59:59' ],
        [ [2062,10,1,4,0,0],[2062,10,1,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2063,4,8,2,59,59],[2063,4,7,23,59,59],
          '2062100104:00:00','2062100101:00:00','2063040802:59:59','2063040723:59:59' ],
     ],
   2063 =>
     [
        [ [2063,4,8,3,0,0],[2063,4,7,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2063,10,7,3,59,59],[2063,10,6,23,59,59],
          '2063040803:00:00','2063040723:00:00','2063100703:59:59','2063100623:59:59' ],
        [ [2063,10,7,4,0,0],[2063,10,7,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2064,4,13,2,59,59],[2064,4,12,23,59,59],
          '2063100704:00:00','2063100701:00:00','2064041302:59:59','2064041223:59:59' ],
     ],
   2064 =>
     [
        [ [2064,4,13,3,0,0],[2064,4,12,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2064,10,5,3,59,59],[2064,10,4,23,59,59],
          '2064041303:00:00','2064041223:00:00','2064100503:59:59','2064100423:59:59' ],
        [ [2064,10,5,4,0,0],[2064,10,5,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2065,4,12,2,59,59],[2065,4,11,23,59,59],
          '2064100504:00:00','2064100501:00:00','2065041202:59:59','2065041123:59:59' ],
     ],
   2065 =>
     [
        [ [2065,4,12,3,0,0],[2065,4,11,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2065,10,4,3,59,59],[2065,10,3,23,59,59],
          '2065041203:00:00','2065041123:00:00','2065100403:59:59','2065100323:59:59' ],
        [ [2065,10,4,4,0,0],[2065,10,4,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2066,4,11,2,59,59],[2066,4,10,23,59,59],
          '2065100404:00:00','2065100401:00:00','2066041102:59:59','2066041023:59:59' ],
     ],
   2066 =>
     [
        [ [2066,4,11,3,0,0],[2066,4,10,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2066,10,3,3,59,59],[2066,10,2,23,59,59],
          '2066041103:00:00','2066041023:00:00','2066100303:59:59','2066100223:59:59' ],
        [ [2066,10,3,4,0,0],[2066,10,3,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2067,4,10,2,59,59],[2067,4,9,23,59,59],
          '2066100304:00:00','2066100301:00:00','2067041002:59:59','2067040923:59:59' ],
     ],
   2067 =>
     [
        [ [2067,4,10,3,0,0],[2067,4,9,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2067,10,2,3,59,59],[2067,10,1,23,59,59],
          '2067041003:00:00','2067040923:00:00','2067100203:59:59','2067100123:59:59' ],
        [ [2067,10,2,4,0,0],[2067,10,2,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2068,4,8,2,59,59],[2068,4,7,23,59,59],
          '2067100204:00:00','2067100201:00:00','2068040802:59:59','2068040723:59:59' ],
     ],
   2068 =>
     [
        [ [2068,4,8,3,0,0],[2068,4,7,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2068,10,7,3,59,59],[2068,10,6,23,59,59],
          '2068040803:00:00','2068040723:00:00','2068100703:59:59','2068100623:59:59' ],
        [ [2068,10,7,4,0,0],[2068,10,7,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2069,4,14,2,59,59],[2069,4,13,23,59,59],
          '2068100704:00:00','2068100701:00:00','2069041402:59:59','2069041323:59:59' ],
     ],
   2069 =>
     [
        [ [2069,4,14,3,0,0],[2069,4,13,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2069,10,6,3,59,59],[2069,10,5,23,59,59],
          '2069041403:00:00','2069041323:00:00','2069100603:59:59','2069100523:59:59' ],
        [ [2069,10,6,4,0,0],[2069,10,6,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2070,4,13,2,59,59],[2070,4,12,23,59,59],
          '2069100604:00:00','2069100601:00:00','2070041302:59:59','2070041223:59:59' ],
     ],
   2070 =>
     [
        [ [2070,4,13,3,0,0],[2070,4,12,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2070,10,5,3,59,59],[2070,10,4,23,59,59],
          '2070041303:00:00','2070041223:00:00','2070100503:59:59','2070100423:59:59' ],
        [ [2070,10,5,4,0,0],[2070,10,5,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2071,4,12,2,59,59],[2071,4,11,23,59,59],
          '2070100504:00:00','2070100501:00:00','2071041202:59:59','2071041123:59:59' ],
     ],
   2071 =>
     [
        [ [2071,4,12,3,0,0],[2071,4,11,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2071,10,4,3,59,59],[2071,10,3,23,59,59],
          '2071041203:00:00','2071041123:00:00','2071100403:59:59','2071100323:59:59' ],
        [ [2071,10,4,4,0,0],[2071,10,4,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2072,4,10,2,59,59],[2072,4,9,23,59,59],
          '2071100404:00:00','2071100401:00:00','2072041002:59:59','2072040923:59:59' ],
     ],
   2072 =>
     [
        [ [2072,4,10,3,0,0],[2072,4,9,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2072,10,2,3,59,59],[2072,10,1,23,59,59],
          '2072041003:00:00','2072040923:00:00','2072100203:59:59','2072100123:59:59' ],
        [ [2072,10,2,4,0,0],[2072,10,2,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2073,4,9,2,59,59],[2073,4,8,23,59,59],
          '2072100204:00:00','2072100201:00:00','2073040902:59:59','2073040823:59:59' ],
     ],
   2073 =>
     [
        [ [2073,4,9,3,0,0],[2073,4,8,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2073,10,1,3,59,59],[2073,9,30,23,59,59],
          '2073040903:00:00','2073040823:00:00','2073100103:59:59','2073093023:59:59' ],
        [ [2073,10,1,4,0,0],[2073,10,1,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2074,4,8,2,59,59],[2074,4,7,23,59,59],
          '2073100104:00:00','2073100101:00:00','2074040802:59:59','2074040723:59:59' ],
     ],
   2074 =>
     [
        [ [2074,4,8,3,0,0],[2074,4,7,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2074,10,7,3,59,59],[2074,10,6,23,59,59],
          '2074040803:00:00','2074040723:00:00','2074100703:59:59','2074100623:59:59' ],
        [ [2074,10,7,4,0,0],[2074,10,7,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2075,4,14,2,59,59],[2075,4,13,23,59,59],
          '2074100704:00:00','2074100701:00:00','2075041402:59:59','2075041323:59:59' ],
     ],
   2075 =>
     [
        [ [2075,4,14,3,0,0],[2075,4,13,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2075,10,6,3,59,59],[2075,10,5,23,59,59],
          '2075041403:00:00','2075041323:00:00','2075100603:59:59','2075100523:59:59' ],
        [ [2075,10,6,4,0,0],[2075,10,6,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2076,4,12,2,59,59],[2076,4,11,23,59,59],
          '2075100604:00:00','2075100601:00:00','2076041202:59:59','2076041123:59:59' ],
     ],
   2076 =>
     [
        [ [2076,4,12,3,0,0],[2076,4,11,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2076,10,4,3,59,59],[2076,10,3,23,59,59],
          '2076041203:00:00','2076041123:00:00','2076100403:59:59','2076100323:59:59' ],
        [ [2076,10,4,4,0,0],[2076,10,4,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2077,4,11,2,59,59],[2077,4,10,23,59,59],
          '2076100404:00:00','2076100401:00:00','2077041102:59:59','2077041023:59:59' ],
     ],
   2077 =>
     [
        [ [2077,4,11,3,0,0],[2077,4,10,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2077,10,3,3,59,59],[2077,10,2,23,59,59],
          '2077041103:00:00','2077041023:00:00','2077100303:59:59','2077100223:59:59' ],
        [ [2077,10,3,4,0,0],[2077,10,3,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2078,4,10,2,59,59],[2078,4,9,23,59,59],
          '2077100304:00:00','2077100301:00:00','2078041002:59:59','2078040923:59:59' ],
     ],
   2078 =>
     [
        [ [2078,4,10,3,0,0],[2078,4,9,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2078,10,2,3,59,59],[2078,10,1,23,59,59],
          '2078041003:00:00','2078040923:00:00','2078100203:59:59','2078100123:59:59' ],
        [ [2078,10,2,4,0,0],[2078,10,2,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2079,4,9,2,59,59],[2079,4,8,23,59,59],
          '2078100204:00:00','2078100201:00:00','2079040902:59:59','2079040823:59:59' ],
     ],
   2079 =>
     [
        [ [2079,4,9,3,0,0],[2079,4,8,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2079,10,1,3,59,59],[2079,9,30,23,59,59],
          '2079040903:00:00','2079040823:00:00','2079100103:59:59','2079093023:59:59' ],
        [ [2079,10,1,4,0,0],[2079,10,1,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2080,4,14,2,59,59],[2080,4,13,23,59,59],
          '2079100104:00:00','2079100101:00:00','2080041402:59:59','2080041323:59:59' ],
     ],
   2080 =>
     [
        [ [2080,4,14,3,0,0],[2080,4,13,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2080,10,6,3,59,59],[2080,10,5,23,59,59],
          '2080041403:00:00','2080041323:00:00','2080100603:59:59','2080100523:59:59' ],
        [ [2080,10,6,4,0,0],[2080,10,6,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2081,4,13,2,59,59],[2081,4,12,23,59,59],
          '2080100604:00:00','2080100601:00:00','2081041302:59:59','2081041223:59:59' ],
     ],
   2081 =>
     [
        [ [2081,4,13,3,0,0],[2081,4,12,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2081,10,5,3,59,59],[2081,10,4,23,59,59],
          '2081041303:00:00','2081041223:00:00','2081100503:59:59','2081100423:59:59' ],
        [ [2081,10,5,4,0,0],[2081,10,5,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2082,4,12,2,59,59],[2082,4,11,23,59,59],
          '2081100504:00:00','2081100501:00:00','2082041202:59:59','2082041123:59:59' ],
     ],
   2082 =>
     [
        [ [2082,4,12,3,0,0],[2082,4,11,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2082,10,4,3,59,59],[2082,10,3,23,59,59],
          '2082041203:00:00','2082041123:00:00','2082100403:59:59','2082100323:59:59' ],
        [ [2082,10,4,4,0,0],[2082,10,4,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2083,4,11,2,59,59],[2083,4,10,23,59,59],
          '2082100404:00:00','2082100401:00:00','2083041102:59:59','2083041023:59:59' ],
     ],
   2083 =>
     [
        [ [2083,4,11,3,0,0],[2083,4,10,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2083,10,3,3,59,59],[2083,10,2,23,59,59],
          '2083041103:00:00','2083041023:00:00','2083100303:59:59','2083100223:59:59' ],
        [ [2083,10,3,4,0,0],[2083,10,3,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2084,4,9,2,59,59],[2084,4,8,23,59,59],
          '2083100304:00:00','2083100301:00:00','2084040902:59:59','2084040823:59:59' ],
     ],
   2084 =>
     [
        [ [2084,4,9,3,0,0],[2084,4,8,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2084,10,1,3,59,59],[2084,9,30,23,59,59],
          '2084040903:00:00','2084040823:00:00','2084100103:59:59','2084093023:59:59' ],
        [ [2084,10,1,4,0,0],[2084,10,1,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2085,4,8,2,59,59],[2085,4,7,23,59,59],
          '2084100104:00:00','2084100101:00:00','2085040802:59:59','2085040723:59:59' ],
     ],
   2085 =>
     [
        [ [2085,4,8,3,0,0],[2085,4,7,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2085,10,7,3,59,59],[2085,10,6,23,59,59],
          '2085040803:00:00','2085040723:00:00','2085100703:59:59','2085100623:59:59' ],
        [ [2085,10,7,4,0,0],[2085,10,7,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2086,4,14,2,59,59],[2086,4,13,23,59,59],
          '2085100704:00:00','2085100701:00:00','2086041402:59:59','2086041323:59:59' ],
     ],
   2086 =>
     [
        [ [2086,4,14,3,0,0],[2086,4,13,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2086,10,6,3,59,59],[2086,10,5,23,59,59],
          '2086041403:00:00','2086041323:00:00','2086100603:59:59','2086100523:59:59' ],
        [ [2086,10,6,4,0,0],[2086,10,6,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2087,4,13,2,59,59],[2087,4,12,23,59,59],
          '2086100604:00:00','2086100601:00:00','2087041302:59:59','2087041223:59:59' ],
     ],
   2087 =>
     [
        [ [2087,4,13,3,0,0],[2087,4,12,23,0,0],'-04:00:00',[-4,0,0],
          'PYT',0,[2087,10,5,3,59,59],[2087,10,4,23,59,59],
          '2087041303:00:00','2087041223:00:00','2087100503:59:59','2087100423:59:59' ],
        [ [2087,10,5,4,0,0],[2087,10,5,1,0,0],'-03:00:00',[-3,0,0],
          'PYST',1,[2088,4,11,2,59,59],[2088,4,10,23,59,59],
          '2087100504:00:00','2087100501:00:00','2088041102:59:59','2088041023:59:59' ],
     ],
);

%LastRule      = (
   'zone'   => {
                'dstoff' => '-03:00:00',
                'stdoff' => '-04:00:00',
               },
   'rules'  => {
                '04' => {
                         'flag'    => 'ge',
                         'dow'     => '7',
                         'num'     => '8',
                         'type'    => 'w',
                         'time'    => '00:00:00',
                         'isdst'   => '0',
                         'abb'     => 'PYT',
                        },
                '10' => {
                         'flag'    => 'ge',
                         'dow'     => '7',
                         'num'     => '1',
                         'type'    => 'w',
                         'time'    => '00:00:00',
                         'isdst'   => '1',
                         'abb'     => 'PYST',
                        },
               },
);

1;
