package RT::CustomField;

use strict;
use RTx::Shredder::Constants;
use RTx::Shredder::Exceptions;
use RTx::Shredder::Dependencies;

#TODO: Queues if we wish export tool

sub __DependsOn
{
	my $self = shift;
	my %args = (
			Shredder => undef,
			Dependencies => undef,
			@_,
		   );
	my $deps = $args{'Dependencies'};
	my $list = [];

# Custom field values
	push( @$list, $self->Values );

# Ticket custom field values
	my $objs = RT::TicketCustomFieldValues->new( $self->CurrentUser );
	$objs->LimitToCustomField( $self->Id );
	push( @$list, $objs );

	$deps->_PushDependencies(
			BaseObj => $self,
			Flags => DEPENDS_ON,
			TargetObjs => $list,
			Shredder => $args{'Shredder'}
		);
	return $self->SUPER::__DependsOn( %args );
}

sub __Relates
{
	my $self = shift;
	my %args = (
			Shredder => undef,
			Dependencies => undef,
			@_,
		   );
	my $deps = $args{'Dependencies'};
	my $list = [];

	my $obj = $self->Object;

# Queue
# Skip if it's global CF
	if( $self->Queue ) {
		if( $self->QueueObj && $self->QueueObj->Id ) {
			push( @$list, $obj );
		} else {
			my $rec = $args{'Shredder'}->GetRecord( Object => $self );
			$self = $rec->{'Object'};
			$rec->{'State'} |= INVALID;
			$rec->{'Description'} = "Have no related queue #". $self->Queue ." object";
		}
	}
	
	$deps->_PushDependencies(
			BaseObj => $self,
			Flags => RELATES,
			TargetObjs => $list,
			Shredder => $args{'Shredder'}
		);
	return $self->SUPER::__Relates( %args );
}

1;

