use ExtUtils::MakeMaker;

# ----------------

# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.

my(%params) =
(
	($] ge '5.005') ?
	(
		AUTHOR   => 'Ron Savage (ron@savage.net.au)',
		ABSTRACT => 'English names of nationalities',
		) : (),
	clean =>
	{
		FILES => 'blib/* Makefile MANIFEST Locale-Nationality-en-*'
	},
	dist =>
	{
		COMPRESS => 'gzip',
		SUFFIX   => 'gz'
	},
	DISTNAME  => 'Locale-Nationality-en',
	NAME      => 'Locale::Nationality::en',
	LICENSE   => 'artistic_2',
	PL_FILES  => {},
	PREREQ_PM =>
	{
		'Test::Stream' => 1.302026,
		'Test::Pod' => 1.48,
	},
	VERSION_FROM => 'lib/Locale/Nationality/en.pm',
);

if ( ($ExtUtils::MakeMaker::VERSION =~ /^\d\.\d\d$/) && ($ExtUtils::MakeMaker::VERSION > 6.30) )
{
	$params{LICENSE} = 'artistic_2';
}

if ($ExtUtils::MakeMaker::VERSION ge '6.46')
{
	$params{META_MERGE} =
	{
		'meta-spec' =>
		{
			version => 2,
		},
		resources =>
		{
			bugtracker	=> 'https://rt.cpan.org/Public/Dist/Display.html?Name=Locale-Nationality-en',
			license		=> 'http://opensource.org/licenses/Artistic-2.0',
			repository	=>
			{
				type => 'git',
				url  => 'https://github.com/ronsavage/Locale-Nationality-en.git',
				web  => 'https://github.com/ronsavage/Locale-Nationality-en',
			},
		},
	};
}

WriteMakefile(%params);
