#!/usr/bin/perl -I/home/phil/z/perl/cpan/DataTableText/lib
#-------------------------------------------------------------------------------
# Flop a switch in your script to zero after a clean run with the switch set to one
# Philip R Brenan at gmail dot com, Appa Apps Ltd Inc, 2016-2017
#-------------------------------------------------------------------------------

package Flip::Flop;
our $VERSION = 20170821;
use v5.16.0;
use warnings FATAL => qw(all);
use strict;
use Carp;
use Data::Table::Text qw(:all);

my @flipflops;

sub AUTOLOAD
 {my $program =
  push @flipflops, [$0, $Flip::Flop::AUTOLOAD];
  return $_[0];
 }

END
 {unless($?)
   {for(@flipflops)
     {my ($file, $program) = @$_;
      my $s = readFile($file);
      my $F = "$program\\(\\d+\\)";
      my $f = "$program(0)";
      $s =~ s($F)($f)gs;
      writeFile($0, $s);
     }
   }
 }

# podDocumentation

=pod

=encoding utf-8

=head1 Name

Flip::Flop - Flop a switch in your script to zero after a clean run with the
switch set to one.

=head1 Synopsis

Some where at the top of your program you might have some variables that select
the actions the code is to perform on the next run from your IDE:

 my $doUpload = Flip::Flop::uploadToCloud(1);

 ...

 if ($doUpload)
  {....
   exit(1) unless ... upload succeeded.
  }

If the upload succeeds, your program source code will be modified to read:

  my $doUpload = Flip::Flop::uploadToCloud(0);

so that the next time you run your program this selected operation will not be
performed unless you explicitly re-request it.

If the run does not succeed the switch will be left unchanged.

=head1 Installation

This module is written in 100% Pure Perl and, thus, it is easy to read, use,
modify and install.

Standard Module::Build process for building and installing modules:

  perl Build.PL
  ./Build
  ./Build test
  ./Build install

=head1 Author

L<philiprbrenan\@gmail.com|mailto:philiprbrenan\@gmail.com>

L<http://www.appaapps.com|http://www.appaapps.com>

=head1 Copyright

Copyright (c) 2016-2017 Philip R Brenan.

This module is free software. It may be used, redistributed and/or modified
under the same terms as Perl itself.

END

=cut

1;
# podDocumentation
__DATA__
use warnings FATAL=>qw(all);
use strict;
use Test::More tests=>1;

ok 1
1
