#ifndef __FUTURE_ASYNCAWAIT_H__
#define __FUTURE_ASYNCAWAIT_H__

#include "perl.h"

/*
 * The API contained in this file is even more experimental than the rest of
 * Future::AsyncAwait. It is primarily designed to allow suspend-aware dynamic
 * variables in Syntax::Keyword::Dynamically, but may be useful for other
 * tasks.
 *
 * There are no unit tests for these hooks inside this distribution, as testing
 * it would require more XS code. It is tested as a side-effect of the
 * integration with Syntax::Keyword::Dynamically.
 */

/*
 * This enum provides values for the `phase` hook parameter.
 */
enum {
  /* PRESUSPEND = 0x10, */
  FAA_PHASE_POSTSUSPEND = 0x20,
  FAA_PHASE_PRERESUME   = 0x30,
  /* POSTRESUME = 0x40, */
  FAA_PHASE_FREE = 0xFF,
};

/*
 * The type of suspend hook functions.
 *
 *   `phase` indicates the point in the suspend/resume lifecycle, as one of
 *     the values of the enum above.
 *   `cv` points to the CV being suspended or resumed. This will be after it
 *     has been cloned, if necessary.
 *   `modhookdata` points to an HV associated with the CV state, and may be
 *     used by modules as a scratchpad to store extra data relating to this
 *     function. Callers should prefix keys with their own module name to
 *     avoid collisions.
 */
typedef void SuspendHookFunc(pTHX_ U8 phase, CV *cv, HV *modhookdata);

/*
 * Callers should use this function-like macro to set the value of the hook
 * function variable, by passing in the address of a new function and
 * capturing the previous value.
 *
 *   oldhook = future_asyncawait_set_suspendhook(&my_hook_func);
 *
 * The hook function itself should remember to chain to the oldhook function
 * if the previous value was not NULL.
 *
 *   void my_hook_func(aTHX_ U8 phase, CV *cv, HV *modhookdata)
 *   {
 *     ...
 *     if(oldhook)
 *       (*oldhook)(phase, cv, modhookdata);
 *   }
 */
#define future_asyncawait_set_suspendhook(newfunc) S_future_asyncawait_set_suspendhook(aTHX_ newfunc)
static SuspendHookFunc *S_future_asyncawait_set_suspendhook(pTHX_ SuspendHookFunc *newfunc)
{
  SuspendHookFunc *ret = NULL;

  SV **hookp = hv_fetchs(PL_modglobal, "Future::AsyncAwait/suspendhook", TRUE);
  if(hookp && SvOK(*hookp))
    ret = INT2PTR(SuspendHookFunc *, SvUV(*hookp));

  sv_setuv(*hookp, PTR2UV(newfunc));

  return ret;
}

#endif
