package PERLANCAR::Exporter::Lite;

our $DATE = '2016-03-12'; # DATE
our $VERSION = '0.01'; # VERSION

# Be lean.
#use strict;
#use warnings;

sub import {
    my $pkg0 = shift;
    if (@_ && $_[0] eq 'import') {
        my $caller0 = caller;
        *{"$caller0\::import"} = sub {
            my $pkg = shift;
            my $caller = caller;
            my @imp = @_ ? @_ : @{__PACKAGE__.'::EXPORT'};
            for my $imp (@imp) {
                if (grep {$_ eq $imp} (@{__PACKAGE__.'::EXPORT'},
                                       @{__PACKAGE__.'::EXPORT_OK'})) {
                    *{"$caller\::$imp"} = \&{$imp};
                } else {
                    die "$imp is not exported by ".__PACKAGE__;
                }
            }
        };
    }
}

1;
# ABSTRACT: A stripped down Exporter

__END__

=pod

=encoding UTF-8

=head1 NAME

PERLANCAR::Exporter::Lite - A stripped down Exporter

=head1 VERSION

This document describes version 0.01 of PERLANCAR::Exporter::Lite (from Perl distribution PERLANCAR-Exporter-Lite), released on 2016-03-12.

=head1 SYNOPSIS

In F<lib/YourModule.pm>:

 package YourModule;
 use PERLANCAR::Exporter::Lite qw(import);
 our @EXPORT = qw(...);
 our @EXPORT_OK = qw(...);

=head1 DESCRIPTION

This is a stripped down exporter module, to achieve the smallest startup
overhead (see L<Bencher::Scenario::Exporters::Startup> for benchmark). This is
what I think L<Exporter::Lite> should be.

This module offers only some features of L<Exporter>: default exports via
C<@EXPORT> and optional exports via C<@EXPORT_OK>. You can only use this
exporter by importing its C<import> and not by subclassing. There is no support
for export tags, C<export_to_level>, etc.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/PERLANCAR-Exporter-Lite>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-PERLANCAR-Exporter-Lite>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=PERLANCAR-Exporter-Lite>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<Exporter>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
