package Dist::Zilla::Plugin::EnsureDepakable;

our $DATE = '2016-05-18'; # DATE
our $VERSION = '0.001'; # VERSION

use 5.010001;
use strict;
use warnings;

use Moose;
with 'Dist::Zilla::Role::InstallTool';

use Module::Depakable;
use namespace::autoclean;

sub setup_installer {
    my ($self) = @_;

    my $prereqs_hash = $self->zilla->prereqs->as_string_hash;
    my $rr_prereqs = $prereqs_hash->{runtime}{requires} // {};

    return unless keys %$rr_prereqs;

    my $res = Module::Depakable::prereq_depakable(
        prereqs => [grep { $_ ne 'perl' } keys %$rr_prereqs]);
    if ($res->[0] != 200) {
        $self->log_fatal(["Distribution not depakable: %s", $res->[1]]);
    }
}

__PACKAGE__->meta->make_immutable;
1;
# ABSTRACT: Make sure that distribution is depakable

__END__

=pod

=encoding UTF-8

=head1 NAME

Dist::Zilla::Plugin::EnsureDepakable - Make sure that distribution is depakable

=head1 VERSION

This document describes version 0.001 of Dist::Zilla::Plugin::EnsureDepakable (from Perl distribution Dist-Zilla-Plugin-EnsureDepakable), released on 2016-05-18.

=head1 SYNOPSIS

In F<dist.ini>:

 [EnsureDepakable]

=head1 DESCRIPTION

This plugin will check that the distribution is "depakable", i.e. all the
modules in the distribution can be packed in a script using fatpack or datapack
technique. To do this, the plugin will feed all the distribution's
RuntimeRequires prerequisites to L<Module::Depakable>. The build will be aborted
if distribution is not depakable.

=for Pod::Coverage .+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Dist-Zilla-Plugin-EnsureDepakable>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Dist-Zilla-Plugin-EnsureDepakable>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Dist-Zilla-Plugin-EnsureDepakable>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<App::depak>

L<Module::Depakable>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
