package Devel::Confess::Tiny;

our $DATE = '2015-06-18'; # DATE
our $VERSION = '0.01'; # VERSION

#BEGIN IFBUILT
use strict;
use warnings;
#END IFUNBUILT

# BEGIN_BLOCK: stacktrace_printer
sub _longmess {
    my $mess = $_[0];
    my $i = 2;
    {
        package DB;
        while (my @caller = caller($i)) {
            $mess .= "\t";
            if ($i > 1 && $caller[3]) { # subroutine
                $mess .= "$caller[3](";
                if ($caller[4]) { # has_args
                    my $j = 0;
                    for my $arg0 (@DB::args) {
                        my $arg = $arg0; # copy
                        if ($j++) { $mess .= ", " }
                        if (!defined($arg)) { $arg = "undef" }
                        elsif (ref($arg)) { }
                        else { $arg =~ s/([\\'])/\\$1/g; $arg = "'$arg'" }
                        $mess .= $arg;
                    }
                }
                $mess .= ") called ";
            }
            $mess .= "at $caller[1] line $caller[2]\n";
            $i++;
        }
    }
    $mess;
}

my %OLD_SIG;
BEGIN {
    @OLD_SIG{qw/__DIE__ __WARN__/} = @SIG{qw/__DIE__ __WARN__/};
    $SIG{__DIE__}  = sub { die @_ if ref($_[0]); die &_longmess };
    $SIG{__WARN__} = sub { warn &_longmess };
}

END {
    @SIG{qw/__DIE__ __WARN__/} = @OLD_SIG{qw/__DIE__ __WARN__/};
}
# END_BLOCK: stacktrace_printer

1;
# ABSTRACT: Include stack traces on all warnings and errors (with as little code as possible)

__END__

=pod

=encoding UTF-8

=head1 NAME

Devel::Confess::Tiny - Include stack traces on all warnings and errors (with as little code as possible)

=head1 VERSION

This document describes version 0.01 of Devel::Confess::Tiny (from Perl distribution Devel-Confess-Tiny), released on 2015-06-18.

=head1 SYNOPSIS

 use Devel::Confess::Tiny;

=head1 DESCRIPTION

Provides a very simple and lightweight stacktrace printer. Does not require
I<any> module and code is suitable for embedding/copy-pasting. Does not support
fancy stuffs that other stacktrace printer might provide, e.g. dumping of
complex function arguments, colors, handling level trickery (like in L<Carp>),
etc. It just shows each level's filename/line number/function name with argument
list.

=head1 SEE ALSO

L<Devel::Confess>

L<Carp::Always> (also: L<Carp::Always::Color>, L<Carp::Source::Always>, etc)

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Devel-Confess-Tiny>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Devel-Confess-Tiny>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Devel-Confess-Tiny>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
