package Bencher::Scenario::IPManipulation::ValidateIPv4;

our $DATE = '2016-08-13'; # DATE
our $VERSION = '0.001'; # VERSION

our $scenario = {
    summary => 'Benchmark validation of IPv4 address string',
    participants => [
        {
            module => 'NetAddr::IP',
            code_template => 'NetAddr::IP->new(<str>) ? 1:0',
        },
        {
            module => 'NetObj::IPv4Address',
            code_template => 'NetObj::IPv4Address::is_valid(<str>)',
        },
        {
            module => 'Net::CIDR',
            code_template => 'Net::CIDR::cidrvalidate(<str>) ? 1:0',
        },
    ],
    datasets => [
        {args=>{str=>'x'}},
        {args=>{str=>'300.0.0.0'}},
        {args=>{str=>'127.0.0.2'}},
    ],
};

1;
# ABSTRACT: Benchmark validation of IPv4 address string

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::IPManipulation::ValidateIPv4 - Benchmark validation of IPv4 address string

=head1 VERSION

This document describes version 0.001 of Bencher::Scenario::IPManipulation::ValidateIPv4 (from Perl distribution Bencher-Scenarios-IPManipulation), released on 2016-08-13.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m IPManipulation::ValidateIPv4

To run module startup overhead benchmark:

 % bencher --module-startup -m IPManipulation::ValidateIPv4

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<NetAddr::IP>  4.079

L<NetObj::IPv4Address> 1.0

L<Net::CIDR> 0.18

=head1 BENCHMARK PARTICIPANTS

=over

=item * NetAddr::IP (perl_code)

Code template:

 NetAddr::IP->new(<str>) ? 1:0



=item * NetObj::IPv4Address (perl_code)

Code template:

 NetObj::IPv4Address::is_valid(<str>)



=item * Net::CIDR (perl_code)

Code template:

 Net::CIDR::cidrvalidate(<str>) ? 1:0



=back

=head1 BENCHMARK DATASETS

=over

=item * x

=item * 300.0.0.0

=item * 127.0.0.2

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.2 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m IPManipulation::ValidateIPv4 >>):

 #table1#
 {dataset=>"127.0.0.2"}
 +---------------------+-----------+-----------+------------+---------+---------+
 | participant         | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +---------------------+-----------+-----------+------------+---------+---------+
 | Net::CIDR           |     20000 |     50    |        1   | 5.3e-08 |      32 |
 | NetAddr::IP         |     68000 |     15    |        3.4 | 2.6e-08 |      21 |
 | NetObj::IPv4Address |    404000 |      2.48 |       20   | 8.3e-10 |      20 |
 +---------------------+-----------+-----------+------------+---------+---------+

 #table2#
 {dataset=>"300.0.0.0"}
 +---------------------+-----------+-----------+------------+---------+---------+
 | participant         | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +---------------------+-----------+-----------+------------+---------+---------+
 | NetAddr::IP         |    225000 |    4.44   |     1      | 1.6e-09 |      21 |
 | Net::CIDR           |    650000 |    1.5    |     2.9    |   3e-09 |      24 |
 | NetObj::IPv4Address |    654950 |    1.5268 |     2.9062 | 9.8e-12 |      24 |
 +---------------------+-----------+-----------+------------+---------+---------+

 #table3#
 {dataset=>"x"}
 +---------------------+-----------+-----------+------------+---------+---------+
 | participant         | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +---------------------+-----------+-----------+------------+---------+---------+
 | NetAddr::IP         |     45000 |  22       |      1     | 4.7e-08 |      20 |
 | NetObj::IPv4Address |   1061300 |   0.94226 |     23.523 | 9.4e-12 |      22 |
 | Net::CIDR           |   2200000 |   0.46    |     49     | 8.1e-10 |      21 |
 +---------------------+-----------+-----------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-IPManipulation>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-IPManipulation>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-IPManipulation>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
