package Bencher::Scenario::Accessors::Set;

our $DATE = '2016-11-25'; # DATE
our $VERSION = '0.12'; # VERSION

use Bencher::ScenarioUtil::Accessors;

my $classes = \%Bencher::ScenarioUtil::Accessors::classes;

our $scenario = {
    summary => 'Benchmark attribute write/set',
    modules => {
        # include the generator modules here so we can show their versions in
        # sample benchmark results produced by PWP:Bencher::Scenario
        (map { $_=>0 } grep {defined} map { $classes->{$_}{generator} }
             keys %$classes),
    },
    participants => [
        (map {
            my $spec = $classes->{$_};
            +{
                name => $spec->{generator} || $spec->{name},
                module => $_,
                code_template => "state \$o = do { my \$o = ${_}->new; \$o }; \$o->attr1(42)",
            };
        } grep { !$classes->{$_}{immutable} && ($classes->{$_}{supports_setters} // 1) } keys %$classes),

        # also compare with raw hash & array access
        {
            name => 'raw hash access',
            module => 'Perl::Examples::Accessors::Hash',
            code_template => "state \$o = do { my \$o = Perl::Examples::Accessors::Hash->new; \$o }; \$o->{attr1} = 42",
        },
        {
            name => 'raw array access',
            module => 'Perl::Examples::Accessors::Array',
            code_template => "state \$o = do { my \$o = Perl::Examples::Accessors::Array->new; \$o }; \$o->[0] = 42",
        },
    ],
};

1;
# ABSTRACT: Benchmark attribute write/set

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::Accessors::Set - Benchmark attribute write/set

=head1 VERSION

This document describes version 0.12 of Bencher::Scenario::Accessors::Set (from Perl distribution Bencher-Scenarios-Accessors), released on 2016-11-25.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m Accessors::Set

To run module startup overhead benchmark:

 % bencher --module-startup -m Accessors::Set

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Class::Accessor> 0.34

L<Class::Accessor::Array> 0.02

L<Class::InsideOut> 1.13

L<Class::Struct> 0.65

L<Class::Tiny> 1.004

L<Class::XSAccessor> 1.19

L<Class::XSAccessor::Array> 1.19

L<Evo::Class>

L<Mo> 0.40

L<Mojo::Base>

L<Mojo::Base::XS> 0.07

L<Moo> 2.002004

L<Moops> 0.034

L<Moos> 0.30

L<Moose> 2.1805

L<Mouse> v2.4.5

L<Object::Simple> 3.17

L<Object::Tiny> 1.08

L<Object::Tiny::RW> 1.07

L<Object::Tiny::RW::XS> 0.03

L<Object::Tiny::XS> 1.01

L<Perl::Examples::Accessors::Array> 0.09

L<Perl::Examples::Accessors::ClassAccessor> 0.09

L<Perl::Examples::Accessors::ClassAccessorArray> 0.09

L<Perl::Examples::Accessors::ClassInsideOut> 0.09

L<Perl::Examples::Accessors::ClassStruct> 0.09

L<Perl::Examples::Accessors::ClassTiny> 0.09

L<Perl::Examples::Accessors::ClassXSAccessor> 0.09

L<Perl::Examples::Accessors::ClassXSAccessorArray> 0.09

L<Perl::Examples::Accessors::EvoClass> 0.09

L<Perl::Examples::Accessors::Hash> 0.09

L<Perl::Examples::Accessors::Mo> 0.09

L<Perl::Examples::Accessors::MojoBase> 0.09

L<Perl::Examples::Accessors::MojoBaseXS> 0.09

L<Perl::Examples::Accessors::Moo> 0.09

L<Perl::Examples::Accessors::Moops> 0.09

L<Perl::Examples::Accessors::Moos> 0.09

L<Perl::Examples::Accessors::Moose> 0.09

L<Perl::Examples::Accessors::Mouse> 0.09

L<Perl::Examples::Accessors::ObjectSimple> 0.09

L<Perl::Examples::Accessors::ObjectTinyRW> 0.09

L<Perl::Examples::Accessors::ObjectTinyRWXS> 0.09

L<Perl::Examples::Accessors::SimpleAccessor> 0.09

L<Simple::Accessor> 1.02

=head1 BENCHMARK PARTICIPANTS

=over

=item * Class::Struct (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassStruct->new; $o }; $o->attr1(42)



=item * Moo (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Moo->new; $o }; $o->attr1(42)



=item * Object::Tiny::RW::XS (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ObjectTinyRWXS->new; $o }; $o->attr1(42)



=item * Class::InsideOut (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassInsideOut->new; $o }; $o->attr1(42)



=item * Mouse (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Mouse->new; $o }; $o->attr1(42)



=item * Moose (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Moose->new; $o }; $o->attr1(42)



=item * Mojo::Base (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::MojoBase->new; $o }; $o->attr1(42)



=item * Evo::Class (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::EvoClass->new; $o }; $o->attr1(42)



=item * Class::Accessor (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassAccessor->new; $o }; $o->attr1(42)



=item * Mo (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Mo->new; $o }; $o->attr1(42)



=item * Simple::Accessor (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::SimpleAccessor->new; $o }; $o->attr1(42)



=item * Mojo::Base::XS (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::MojoBaseXS->new; $o }; $o->attr1(42)



=item * Object::Simple (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ObjectSimple->new; $o }; $o->attr1(42)



=item * Moos (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Moos->new; $o }; $o->attr1(42)



=item * Class::XSAccessor (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassXSAccessor->new; $o }; $o->attr1(42)



=item * Class::Tiny (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassTiny->new; $o }; $o->attr1(42)



=item * Moops (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Moops->new; $o }; $o->attr1(42)



=item * Class::Accessor::Array (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassAccessorArray->new; $o }; $o->attr1(42)



=item * no generator (array-based) (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Array->new; $o }; $o->attr1(42)



=item * Class::XSAccessor::Array (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassXSAccessorArray->new; $o }; $o->attr1(42)



=item * Object::Tiny::RW (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ObjectTinyRW->new; $o }; $o->attr1(42)



=item * no generator (hash-based) (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Hash->new; $o }; $o->attr1(42)



=item * raw hash access (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Hash->new; $o }; $o->{attr1} = 42



=item * raw array access (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Array->new; $o }; $o->[0] = 42



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.24.0 >>, CPU: I<< Intel(R) Core(TM) M-5Y71 CPU @ 1.20GHz (2 cores) >>, OS: I<< GNU/Linux LinuxMint version 17.3 >>, OS kernel: I<< Linux version 3.19.0-32-generic >>.

Benchmark with default options (C<< bencher -m Accessors::Set >>):

 #table1#
 +----------------------------+-----------+-----------+------------+---------+---------+
 | participant                | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +----------------------------+-----------+-----------+------------+---------+---------+
 | Simple::Accessor           |    259000 | 3.86      |    1       | 1.4e-09 |      28 |
 | Class::Accessor            |   1918800 | 0.52116   |    7.40018 |   0     |      22 |
 | Class::InsideOut           |   2499980 | 0.400003  |    9.64161 |   0     |      20 |
 | Evo::Class                 |   4500000 | 0.22      |   17       | 4.2e-10 |      20 |
 | Class::Struct              |   4500000 | 0.22      |   17       | 4.2e-10 |      20 |
 | Class::Tiny                |   4600000 | 0.22      |   18       | 4.2e-10 |      20 |
 | Object::Tiny::RW           |   4600000 | 0.22      |   18       | 3.1e-10 |      20 |
 | Mojo::Base                 |   4650000 | 0.215     |   18       | 9.1e-11 |      26 |
 | Moose                      |   4700000 | 0.21      |   18       | 4.1e-10 |      21 |
 | Mo                         |   4800000 | 0.21      |   18       | 4.2e-10 |      20 |
 | Class::Accessor::Array     |   4922840 | 0.203135  |   18.9858  |   0     |      20 |
 | Object::Simple             |   5285030 | 0.189214  |   20.3826  |   0     |      21 |
 | no generator (hash-based)  |   5420000 | 0.185     |   20.9     |   1e-10 |      20 |
 | no generator (array-based) |   6113640 | 0.163569  |   23.5783  |   0     |      23 |
 | Mouse                      |   9500000 | 0.1       |   37       | 2.1e-10 |      20 |
 | Class::XSAccessor          |  10297200 | 0.0971137 |   39.713   |   0     |      20 |
 | Moos                       |  10000000 | 0.096     |   40       | 2.6e-10 |      20 |
 | Object::Tiny::RW::XS       |  11000000 | 0.091     |   43       | 2.1e-10 |      20 |
 | Mojo::Base::XS             |  11000000 | 0.09      |   43       | 2.1e-10 |      20 |
 | Moops                      |  11500000 | 0.0868    |   44.4     | 4.4e-11 |      28 |
 | Moo                        |  11500000 | 0.0866    |   44.5     | 5.2e-11 |      20 |
 | Class::XSAccessor::Array   |  13172700 | 0.0759144 |   50.8029  |   0     |      20 |
 | raw hash access            |  20000000 | 0.05      |   77       | 2.1e-10 |      20 |
 | raw array access           |  22052400 | 0.0453465 |   85.0489  |   0     |      21 |
 +----------------------------+-----------+-----------+------------+---------+---------+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-Accessors>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-Accessors>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-Accessors>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
