package Bencher::Scenario::Accessors::Get;

our $DATE = '2016-09-09'; # DATE
our $VERSION = '0.09'; # VERSION

use Bencher::ScenarioUtil::Accessors;

my $classes = \%Bencher::ScenarioUtil::Accessors::classes;

our $scenario = {
    summary => 'Benchmark attribute read/get',
    modules => {
    },
    participants => [
        (map {
            my $spec = $classes->{$_};
            +{
                name => $spec->{generator} || $spec->{name},
                module => $_,
                code_template => "state \$o = do { my \$o = ${_}->new; \$o->attr1(42); \$o }; \$o->attr1",
            };
        } grep { !$classes->{$_}{immutable} } keys %$classes),

        # also compare with raw hash & array access
        {
            name => 'raw hash access',
            module => 'Perl::Examples::Accessors::Hash',
            code_template => "state \$o = do { my \$o = Perl::Examples::Accessors::Hash->new; \$o->attr1(42); \$o }; \$o->{attr1}",
        },
        {
            name => 'raw array access',
            module => 'Perl::Examples::Accessors::Array',
            code_template => "state \$o = do { my \$o = Perl::Examples::Accessors::Array->new; \$o->attr1(42); \$o }; \$o->[0]",
        },
    ],
};

1;
# ABSTRACT: Benchmark attribute read/get

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::Accessors::Get - Benchmark attribute read/get

=head1 VERSION

This document describes version 0.09 of Bencher::Scenario::Accessors::Get (from Perl distribution Bencher-Scenarios-Accessors), released on 2016-09-09.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m Accessors::Get

To run module startup overhead benchmark:

 % bencher --module-startup -m Accessors::Get

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Perl::Examples::Accessors::Array> 0.08

L<Perl::Examples::Accessors::ClassAccessor> 0.08

L<Perl::Examples::Accessors::ClassAccessorArray> 0.08

L<Perl::Examples::Accessors::ClassInsideOut> 0.08

L<Perl::Examples::Accessors::ClassTiny> 0.08

L<Perl::Examples::Accessors::ClassXSAccessor> 0.08

L<Perl::Examples::Accessors::ClassXSAccessorArray> 0.08

L<Perl::Examples::Accessors::Hash> 0.08

L<Perl::Examples::Accessors::Mo> 0.08

L<Perl::Examples::Accessors::MojoBase> 0.08

L<Perl::Examples::Accessors::Moo> 0.08

L<Perl::Examples::Accessors::Moose> 0.08

L<Perl::Examples::Accessors::Mouse> 0.08

L<Perl::Examples::Accessors::ObjectSimple> 0.08

L<Perl::Examples::Accessors::SimpleAccessor> 0.08

=head1 BENCHMARK PARTICIPANTS

=over

=item * Object::Simple (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ObjectSimple->new; $o->attr1(42); $o }; $o->attr1



=item * Moo (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Moo->new; $o->attr1(42); $o }; $o->attr1



=item * Mouse (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Mouse->new; $o->attr1(42); $o }; $o->attr1



=item * Mo (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Mo->new; $o->attr1(42); $o }; $o->attr1



=item * Mojo::Base (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::MojoBase->new; $o->attr1(42); $o }; $o->attr1



=item * Class::Accessor::Array (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassAccessorArray->new; $o->attr1(42); $o }; $o->attr1



=item * Moose (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Moose->new; $o->attr1(42); $o }; $o->attr1



=item * Class::Tiny (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassTiny->new; $o->attr1(42); $o }; $o->attr1



=item * Class::XSAccessor (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassXSAccessor->new; $o->attr1(42); $o }; $o->attr1



=item * no generator (hash-based) (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Hash->new; $o->attr1(42); $o }; $o->attr1



=item * Simple::Accessor (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::SimpleAccessor->new; $o->attr1(42); $o }; $o->attr1



=item * no generator (array-based) (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Array->new; $o->attr1(42); $o }; $o->attr1



=item * Class::Accessor (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassAccessor->new; $o->attr1(42); $o }; $o->attr1



=item * Class::XSAccessor::Array (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassXSAccessorArray->new; $o->attr1(42); $o }; $o->attr1



=item * Class::InsideOut (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassInsideOut->new; $o->attr1(42); $o }; $o->attr1



=item * raw hash access (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Hash->new; $o->attr1(42); $o }; $o->{attr1}



=item * raw array access (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Array->new; $o->attr1(42); $o }; $o->[0]



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.24.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m Accessors::Get >>):

 #table1#
 +----------------------------+-----------+-----------+------------+---------+---------+
 | participant                | rate (/s) | time (ns) | vs_slowest |  errors | samples |
 +----------------------------+-----------+-----------+------------+---------+---------+
 | Class::Accessor            |   2000000 |     510   |       1    | 8.5e-10 |      20 |
 | Class::InsideOut           |   2450000 |     408   |       1.25 | 2.5e-10 |      20 |
 | Simple::Accessor           |   2670000 |     375   |       1.36 | 9.2e-11 |      20 |
 | Mojo::Base                 |   4000000 |     250   |       2.1  | 4.2e-10 |      20 |
 | Mo                         |   4670000 |     214   |       2.38 | 4.6e-11 |      20 |
 | no generator (hash-based)  |   5200000 |     190   |       2.6  | 7.6e-10 |      24 |
 | Class::Tiny                |   5500000 |     180   |       2.8  | 5.1e-10 |      21 |
 | Object::Simple             |   5600000 |     180   |       2.8  | 2.1e-10 |      20 |
 | Moose                      |   5720000 |     175   |       2.91 | 4.6e-11 |      24 |
 | Class::Accessor::Array     |   5980000 |     167   |       3.04 | 5.8e-11 |      20 |
 | no generator (array-based) |   6180000 |     162   |       3.14 | 9.2e-11 |      20 |
 | Mouse                      |  10200000 |      98.5 |       5.16 | 6.1e-11 |      33 |
 | Class::XSAccessor          |  14000000 |      71.2 |       7.14 | 4.6e-11 |      20 |
 | Class::XSAccessor::Array   |  19000000 |      54   |       9.4  | 2.3e-10 |      20 |
 | Moo                        |  21000000 |      47   |      11    | 2.7e-10 |      20 |
 | raw hash access            |  23000000 |      44   |      12    | 4.7e-11 |      28 |
 | raw array access           |  36000000 |      28   |      18    |   7e-11 |      20 |
 +----------------------------+-----------+-----------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-Accessors>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-Accessors>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-Accessors>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
