package Bencher::Scenario::Accessors::Construction;

our $DATE = '2016-06-26'; # DATE
our $VERSION = '0.08'; # VERSION

use Bencher::ScenarioUtil::Accessors;

my $classes = \%Bencher::ScenarioUtil::Accessors::classes;

our $scenario = {
    summary => 'Benchmark object construction',
    modules => {
        'Perl::Examples::Accessors' => {version=>0.05},
    },
    participants => [
        map {
            my $spec = $classes->{$_};
            +{
                name => $spec->{generator} || $spec->{name},
                module => $_,
                code_template => "${_}->new",
            };
        } keys %$classes,
    ],
    include_result_size => 1,
};

1;
# ABSTRACT: Benchmark object construction

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::Accessors::Construction - Benchmark object construction

=head1 VERSION

This document describes version 0.08 of Bencher::Scenario::Accessors::Construction (from Perl distribution Bencher-Scenarios-Accessors), released on 2016-06-26.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m Accessors::Construction

To run module startup overhead benchmark:

 % bencher --module-startup -m Accessors::Construction

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Perl::Examples::Accessors> 0.06

L<Perl::Examples::Accessors::Array> 0.06

L<Perl::Examples::Accessors::ClassAccessor> 0.06

L<Perl::Examples::Accessors::ClassAccessorArray> 0.06

L<Perl::Examples::Accessors::ClassInsideOut> 0.06

L<Perl::Examples::Accessors::ClassXSAccessor> 0.06

L<Perl::Examples::Accessors::ClassXSAccessorArray> 0.06

L<Perl::Examples::Accessors::Hash> 0.06

L<Perl::Examples::Accessors::Mo> 0.06

L<Perl::Examples::Accessors::MojoBase> 0.06

L<Perl::Examples::Accessors::Moo> 0.06

L<Perl::Examples::Accessors::Moose> 0.06

L<Perl::Examples::Accessors::Mouse> 0.06

L<Perl::Examples::Accessors::ObjectSimple> 0.06

L<Perl::Examples::Accessors::Scalar> 0.06

L<Perl::Examples::Accessors::SimpleAccessor> 0.06

=head1 BENCHMARK PARTICIPANTS

=over

=item * Mo (perl_code)

Code template:

 Perl::Examples::Accessors::Mo->new



=item * no generator (scalar-based) (perl_code)

Code template:

 Perl::Examples::Accessors::Scalar->new



=item * Class::XSAccessor (perl_code)

Code template:

 Perl::Examples::Accessors::ClassXSAccessor->new



=item * Class::InsideOut (perl_code)

Code template:

 Perl::Examples::Accessors::ClassInsideOut->new



=item * Simple::Accessor (perl_code)

Code template:

 Perl::Examples::Accessors::SimpleAccessor->new



=item * Mouse (perl_code)

Code template:

 Perl::Examples::Accessors::Mouse->new



=item * Class::XSAccessor::Array (perl_code)

Code template:

 Perl::Examples::Accessors::ClassXSAccessorArray->new



=item * Moose (perl_code)

Code template:

 Perl::Examples::Accessors::Moose->new



=item * no generator (hash-based) (perl_code)

Code template:

 Perl::Examples::Accessors::Hash->new



=item * Class::Accessor (perl_code)

Code template:

 Perl::Examples::Accessors::ClassAccessor->new



=item * Mojo::Base (perl_code)

Code template:

 Perl::Examples::Accessors::MojoBase->new



=item * Class::Accessor::Array (perl_code)

Code template:

 Perl::Examples::Accessors::ClassAccessorArray->new



=item * Moo (perl_code)

Code template:

 Perl::Examples::Accessors::Moo->new



=item * no generator (array-based) (perl_code)

Code template:

 Perl::Examples::Accessors::Array->new



=item * Object::Simple (perl_code)

Code template:

 Perl::Examples::Accessors::ObjectSimple->new



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.2 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m Accessors::Construction >>):

 +-----------------------------+-----------+-----------+------------+-----------------+---------+---------+
 | participant                 | rate (/s) | time (μs) | vs_slowest | result_size (b) |  errors | samples |
 +-----------------------------+-----------+-----------+------------+-----------------+---------+---------+
 | Class::InsideOut            |    396000 |  2.52     |    1       |             144 | 2.5e-09 |      20 |
 | Simple::Accessor            |    582633 |  1.71635  |    1.47078 |             120 |   0     |      23 |
 | Moose                       |    940000 |  1.1      |    2.4     |             120 | 1.7e-09 |      20 |
 | Mo                          |   1252940 |  0.798125 |    3.16287 |             120 |   0     |      25 |
 | Moo                         |   1638420 |  0.610344 |    4.13597 |             120 |   0     |      21 |
 | Mouse                       |   1700000 |  0.59     |    4.3     |             120 | 6.2e-10 |      20 |
 | Class::Accessor             |   1780000 |  0.561    |    4.5     |             120 | 2.2e-10 |      20 |
 | no generator (array-based)  |   2470000 |  0.405    |    6.24    |              64 | 1.9e-10 |      27 |
 | Mojo::Base                  |   2937600 |  0.340414 |    7.41558 |             120 |   0     |      20 |
 | no generator (hash-based)   |   2960000 |  0.338    |    7.46    |             120 | 4.7e-11 |      20 |
 | Object::Simple              |   3000000 |  0.33     |    7.5     |             120 | 8.3e-10 |      20 |
 | no generator (scalar-based) |   3200000 |  0.313    |    8.07    |              72 |   1e-10 |      20 |
 | Class::Accessor::Array      |   3230000 |  0.31     |    8.15    |              64 | 8.5e-11 |      30 |
 | Class::XSAccessor           |   5100000 |  0.19     |   13       |             120 | 3.2e-10 |      20 |
 | Class::XSAccessor::Array    |   5305300 |  0.188491 |   13.3925  |              64 |   0     |      20 |
 +-----------------------------+-----------+-----------+------------+-----------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-Accessors>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-Accessors>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-Accessors>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
