package Bencher::Scenario::Accessors::Set;

our $DATE = '2016-03-31'; # DATE
our $VERSION = '0.04'; # VERSION

use Bencher::ScenarioUtil::Accessors;

my $classes = \%Bencher::ScenarioUtil::Accessors::classes;

our $scenario = {
    summary => 'Benchmark attribute write/set',
    modules => {
    },
    participants => [
        (map {
            my $spec = $classes->{$_};
            +{
                name => $spec->{generator} || $spec->{name},
                module => $_,
                code_template => "state \$o = do { my \$o = ${_}->new; \$o }; \$o->attr1(42)",
            };
        } grep { !$classes->{$_}{immutable} } keys %$classes),

        # also compare with raw hash & array access
        {
            name => 'raw hash access',
            module => 'Perl::Examples::Accessors::Hash',
            code_template => "state \$o = do { my \$o = Perl::Examples::Accessors::Hash->new; \$o }; \$o->{attr1} = 42",
        },
        {
            name => 'raw array access',
            module => 'Perl::Examples::Accessors::Array',
            code_template => "state \$o = do { my \$o = Perl::Examples::Accessors::Array->new; \$o }; \$o->[0] = 42",
        },
    ],
};

1;
# ABSTRACT: Benchmark attribute write/set

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::Accessors::Set - Benchmark attribute write/set

=head1 VERSION

This document describes version 0.04 of Bencher::Scenario::Accessors::Set (from Perl distribution Bencher-Scenarios-Accessors), released on 2016-03-31.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m Accessors::Set

To run module startup overhead benchmark:

 % bencher --module-startup -m Accessors::Set

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Perl::Examples::Accessors::Array> 0.03

L<Perl::Examples::Accessors::ClassAccessor> 0.03

L<Perl::Examples::Accessors::ClassAccessorArray> 0.03

L<Perl::Examples::Accessors::ClassXSAccessor> 0.03

L<Perl::Examples::Accessors::ClassXSAccessorArray> 0.03

L<Perl::Examples::Accessors::Hash> 0.03

L<Perl::Examples::Accessors::Mo> 0.03

L<Perl::Examples::Accessors::Moo> 0.03

L<Perl::Examples::Accessors::Moose> 0.03

L<Perl::Examples::Accessors::Mouse> 0.03

=head1 BENCHMARK PARTICIPANTS

=over

=item * Moo (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Moo->new; $o }; $o->attr1(42)



=item * Class::XSAccessor::Array (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassXSAccessorArray->new; $o }; $o->attr1(42)



=item * Mo (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Mo->new; $o }; $o->attr1(42)



=item * Mouse (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Mouse->new; $o }; $o->attr1(42)



=item * Moose (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Moose->new; $o }; $o->attr1(42)



=item * no generator (hash-based) (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Hash->new; $o }; $o->attr1(42)



=item * no generator (array-based) (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Array->new; $o }; $o->attr1(42)



=item * Class::XSAccessor (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassXSAccessor->new; $o }; $o->attr1(42)



=item * Class::Accessor::Array (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassAccessorArray->new; $o }; $o->attr1(42)



=item * Class::Accessor (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassAccessor->new; $o }; $o->attr1(42)



=item * raw hash access (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Hash->new; $o }; $o->{attr1} = 42



=item * raw array access (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Array->new; $o }; $o->[0] = 42



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m Accessors::Set >>):

 +----------------------------+-------------+-----------+------------+---------+---------+
 | participant                | rate (/s)   | time (ns) | vs_slowest | errors  | samples |
 +----------------------------+-------------+-----------+------------+---------+---------+
 | Class::Accessor            | 1e+06       | 9.9e+02   | 1          | 1.7e-09 | 20      |
 | no generator (hash-based)  | 2.6e+06     | 3.9e+02   | 2.5        | 1.5e-09 | 26      |
 | no generator (array-based) | 2.87e+06    | 348       | 2.83       | 9.4e-11 | 20      |
 | Moose                      | 2.9e+06     | 3.5e+02   | 2.8        | 2.1e-09 | 29      |
 | Class::Accessor::Array     | 3.09e+06    | 323       | 3.05       | 2.7e-10 | 27      |
 | Mo                         | 3.4e+06     | 2.9e+02   | 3.4        | 1.3e-09 | 23      |
 | Mouse                      | 8e+06       | 1.3e+02   | 7.9        | 4.3e-10 | 27      |
 | Moo                        | 9.31898e+06 | 107.308   | 9.19237    | 0       | 23      |
 | Class::XSAccessor          | 9.6304e+06  | 103.838   | 9.49956    | 0       | 20      |
 | Class::XSAccessor::Array   | 1.1e+07     | 89        | 11         | 1.2e-10 | 20      |
 | raw array access           | 1.6e+07     | 62        | 16         | 6.7e-11 | 22      |
 | raw hash access            | 1.7e+07     | 60        | 17         | 2.8e-10 | 23      |
 +----------------------------+-------------+-----------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-Accessors>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-Accessors>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-Accessors>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
