package Bencher::Scenario::Accessors::ClassStartup;

our $DATE = '2016-03-30'; # DATE
our $VERSION = '0.03'; # VERSION

use Bencher::ScenarioUtil::Accessors;

my $classes = \%Bencher::ScenarioUtil::Accessors::classes;

our $scenario = {
    summary => 'Benchmark startup of classes using various accessor generators',
    module_startup => 1,
    modules => {
    },
    participants => [
        map {
            #my $spec = $classes->{$_};
            +{ module=>$_ };
        } keys %$classes,
    ],
};

1;
# ABSTRACT: Benchmark startup of classes using various accessor generators

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::Accessors::ClassStartup - Benchmark startup of classes using various accessor generators

=head1 VERSION

This document describes version 0.03 of Bencher::Scenario::Accessors::ClassStartup (from Perl distribution Bencher-Scenarios-Accessors), released on 2016-03-30.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m Accessors::ClassStartup

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Perl::Examples::Accessors::Array> 0.03

L<Perl::Examples::Accessors::ClassAccessor> 0.03

L<Perl::Examples::Accessors::ClassAccessorArray> 0.03

L<Perl::Examples::Accessors::ClassXSAccessor> 0.03

L<Perl::Examples::Accessors::ClassXSAccessorArray> 0.03

L<Perl::Examples::Accessors::Hash> 0.03

L<Perl::Examples::Accessors::Mo> 0.03

L<Perl::Examples::Accessors::Moo> 0.03

L<Perl::Examples::Accessors::Moose> 0.03

L<Perl::Examples::Accessors::Mouse> 0.03

L<Perl::Examples::Accessors::Scalar> 0.03

=head1 BENCHMARK PARTICIPANTS

=over

=item * Perl::Examples::Accessors::Mo (perl_code)

L<Perl::Examples::Accessors::Mo>



=item * Perl::Examples::Accessors::Array (perl_code)

L<Perl::Examples::Accessors::Array>



=item * Perl::Examples::Accessors::Scalar (perl_code)

L<Perl::Examples::Accessors::Scalar>



=item * Perl::Examples::Accessors::Hash (perl_code)

L<Perl::Examples::Accessors::Hash>



=item * Perl::Examples::Accessors::Moose (perl_code)

L<Perl::Examples::Accessors::Moose>



=item * Perl::Examples::Accessors::ClassXSAccessor (perl_code)

L<Perl::Examples::Accessors::ClassXSAccessor>



=item * Perl::Examples::Accessors::ClassAccessor (perl_code)

L<Perl::Examples::Accessors::ClassAccessor>



=item * Perl::Examples::Accessors::Moo (perl_code)

L<Perl::Examples::Accessors::Moo>



=item * Perl::Examples::Accessors::ClassAccessorArray (perl_code)

L<Perl::Examples::Accessors::ClassAccessorArray>



=item * Perl::Examples::Accessors::Mouse (perl_code)

L<Perl::Examples::Accessors::Mouse>



=item * Perl::Examples::Accessors::ClassXSAccessorArray (perl_code)

L<Perl::Examples::Accessors::ClassXSAccessorArray>



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i5-2557M CPU @ 1.70GHz (2 cores) >>, OS: I<< GNU/Linux LinuxMint version 17 >>, OS kernel: I<< Linux version 3.13.0-32-generic >>.

Benchmark with default options (C<< bencher -m Accessors::ClassStartup >>):

 +-------------------------------------------------+-----------+------------------------+------------+---------+---------+
 | participant                                     | time (ms) | mod_overhead_time (ms) | vs_slowest | errors  | samples |
 +-------------------------------------------------+-----------+------------------------+------------+---------+---------+
 | Perl::Examples::Accessors::Moose                | 3e+02     | 290                    | 1          | 0.0031  | 20      |
 | Perl::Examples::Accessors::Moo                  | 9e+01     | 80                     | 4          | 0.0017  | 20      |
 | Perl::Examples::Accessors::Mouse                | 6e+01     | 50                     | 5          | 0.0023  | 20      |
 | Perl::Examples::Accessors::ClassAccessor        | 3e+01     | 20                     | 1e+01      | 0.001   | 21      |
 | Perl::Examples::Accessors::ClassXSAccessor      | 3e+01     | 20                     | 1e+01      | 0.0013  | 20      |
 | Perl::Examples::Accessors::ClassXSAccessorArray | 3e+01     | 20                     | 1e+01      | 0.00035 | 20      |
 | Perl::Examples::Accessors::ClassAccessorArray   | 2e+01     | 10                     | 1e+01      | 0.00057 | 20      |
 | Perl::Examples::Accessors::Mo                   | 2e+01     | 10                     | 2e+01      | 0.00047 | 20      |
 | Perl::Examples::Accessors::Array                | 1e+01     | 0                      | 2e+01      | 0.00026 | 20      |
 | perl -e1 (baseline)                             | 1e+01     | 0                      | 2e+01      | 0.00019 | 25      |
 | Perl::Examples::Accessors::Scalar               | 1e+01     | 0                      | 2e+01      | 0.00042 | 20      |
 | Perl::Examples::Accessors::Hash                 | 1e+01     | 0                      | 2e+01      | 0.00048 | 21      |
 +-------------------------------------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-Accessors>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-Accessors>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-Accessors>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
