/* ************************************************************************
   Copyright: 2009 OETIKER+PARTNER AG
   License:   GPLv3 or later
   Authors:   Tobi Oetiker <tobi@oetiker.ch>
   Utf8Check: äöü

************************************************************************ */

/**
 * initialize us an Rpc object with some extra thrills.
 */
qx.Class.define("callbackery.data.Server", {
    extend: qx.io.remote.Rpc,
    type: "singleton",

    construct: function () {
        this.base( arguments );
        this.set( {
            timeout: 60000,
            url: 'QX-JSON-RPC/',
            serviceName: 'default'
        });
    },

    properties: {
        sessionCookie: {
            init: null,
            nullable: true
        }
    },
    members: {
        /**
         * A asyncCall handler which tries to
         * login in the case of a permission exception.
         *
         * @param handler {Function} the callback function.
         * @param methodName {String} the name of the method to call.
         * @return {var} the method call reference.
         */
        callAsync: function(handler, methodName) {
            var origArguments = arguments;
            var origThis = this;
            var origHandler = handler;
            var that = this;
            var superHandler = function(ret, exc, id) {
                if (exc && exc.code == 6) {
                    var login = callbackery.ui.Login.getInstance();

                    login.addListenerOnce('login', function(e) {
                        var ret = e.getData();
                        that.setSessionCookie(ret.sessionCookie);
                        origArguments.callee.base.apply(origThis, origArguments);
                    });

                    login.open();
                    return;
                }

                origHandler(ret, exc, id);
            };

            if (methodName != 'login') {
                arguments[0] = superHandler;
            }

            arguments.callee.base.apply(this, arguments);
        },
        /**
         * A variant of the asyncCall method which pops up error messages
         * generated by the server automatically.
         *
         * Note that the handler method only gets a return value never an exception
         * It just does not get called when there is an exception.
         *
         * @param handler {Function} the callback function.
         * @param methodName {String} the name of the method to call.
         * @return {var} the method call reference.
         */
        callAsyncSmart: function(handler, methodName) {
            var origHandler = handler;

            var superHandler = function(ret, exc, id) {
                if (exc) {
                    callbackery.ui.MsgBox.getInstance().exc(exc);
                } else {
                    origHandler(ret);
                }
            };

            arguments[0] = superHandler;
            this.callAsync.apply(this, arguments);
        },
        callAsyncSmartBusy: function(handler, methodName) {
            var origHandler = handler;
            var busy = callbackery.ui.Busy.getInstance();
            var superHandler = function(ret, exc, id) {
                busy.hide();
                if (exc) {
                    callbackery.ui.MsgBox.getInstance().exc(exc);
                } else {
                    origHandler(ret);
                }
            };
            arguments[0] = superHandler;
            busy.show('Runnning ' + methodName);
            this.callAsync.apply(this, arguments);
        },
        /**
         * override the request creation, to add our 'cookie' header
         */
        createRequest: function() {
            var req = this.base(arguments);
            var cookie = this.getSessionCookie();
            if (cookie) {
                req.setRequestHeader('X-Session-Cookie', this.getSessionCookie());
            }
            return req;
        }
    }
});
