.so man.macros
.TH configure n "" Tk "Tk Generic Methods"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
configure, cget \- Change or inquire the attributes of an object.
.SH SYNOPSIS
\fI$var\fR = \fI$widget\fR->\fBcget\fR('\fIoption\fR');
.br
\fI$widget\fR->\fBconfigure\fR(\fIoption\fR => \fIvalue \fR?,\fIoption\fR => \fIvalue ...\fR?\fR);
.br
\fI@var\fR = \fI$widget\fR->\fBconfigure\fR('\fIoption\fR');
.br
\fI@var\fR = \fI$widget\fR->\fBconfigure\fR;
.BE
.SH DESCRIPTION
.TP 12
\fI$widget\fR->\fBcget\fR('\fIoption\fR')
Returns the current value of \fIoption\fP for \fI$widget\fR.
.LP
.TP 12
\fI$widget\fR->\fBconfigure\fR(\fIoption\fR => \fIvalue \fR?,\fIoption\fR => \fIvalue ...\fR?\fR);
Sets the values of \fIoption\fR to \fIvalue\fR for each \fIoption\fR => \fIvalue\fR 
pair. The internal \fBnew\fR method does an implicit \fBconfigure\fR in this 
form with options passed in at widget create time.
.LP
.TP 12
\fI$widget\fR->\fBconfigure\fR('\fIoption\fR')
Returns a list of five elements:
.RS
.TP 16
Configure Option
The value of \fIoption\fR.
.TP 16
Name
The option's name in the option database (e.g.
in .Xdefaults files).
.TP 16
Class
The option's class value in the option database.
.TP 16
Default
The default value for the option if not specified or in the option databse.
.TP 16
Value
The current value (as returned by \fBcget\fR).
.RE
.LP
.TP 12
\fI$widget\fR->\fBconfigure\fR
Returns a list of lists for all the options supported by \fI$widget\fR.
Each sub-list is in the form returned by \fBconfigure\fR('\fIoption\fR').
(This mechanism is used by the \fBTk::Derived\fP class to determine
the options available from base class.)
.SH "SEE ALSO"
configspec

.SH BUGS
\fBcget\fR('\fIoption\fR') is clumsy with the need for '' due to perl's
parsing rules. Something more subtle using \fBtie\fR might look better.
.SH KEYWORDS
configure, cget
