# This Makefile.PL for Crypt-SecretBuffer was generated by
# Dist::Zilla::Plugin::MakeMaker::Awesome 0.49.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use ExtUtils::MakeMaker;

our %PREREQ_PM;
BEGIN {
    %PREREQ_PM= (
        'ExtUtils::Depends' => '0.405',
        'Devel::CheckLib'   => '1.03',
    );

    # If the prereqs for this script are missing,
    # write out a Makefile that tells CPAN to install them
    my $use_prereqs_code= join('', map { "use $_ '$PREREQ_PM{$_}'; " } keys %PREREQ_PM).'1;';
    print $use_prereqs_code."\n";
    unless (eval $use_prereqs_code) {
       warn "$@\n";
       WriteMakefile(
             NAME         => 'Crypt::SecretBuffer',
             PREREQ_FATAL => 1,
             PREREQ_PM    => \%PREREQ_PM,
       );
       exit 1; # not reached
    }
}

my $dep= ExtUtils::Depends->new('Crypt::SecretBuffer');
my @incpath;
my @libpath;
my @have;

sub check_lib_fn {
   my ($macro, $fname, $header, $lib)= @_;
   if (check_lib(
      # Just take the address of it, to verify it gets linked
      function => qq{void (*fn)()= (void(*)()) $fname; return fn != NULL;},
      ($header? ( header => $header ) : ()),
      ($lib? ( lib => $lib ) : ()),
      incpath  => \@incpath,
      libpath  => \@libpath,
      debug => 1,
      analyze_binary => sub { warn "  $_\n" for @_; },
   )) {
      warn "Found $fname";
      push @have, $macro;
   } else {
      warn "Don't have $fname";
   }
}

if ($^O ne 'MSWin32') { # none available on windows, and check_lib giving false positives...
   check_lib_fn(LIBSSL => 'RAND_bytes', 'openssl/rand.h', 'ssl');
   check_lib_fn(GETRANDOM => 'getrandom', 'sys/random.h');
   check_lib_fn(EXPLICIT_BZERO => 'explicit_bzero', 'string.h');
   check_lib_fn(MINCORE => 'mincore', 'sys/mman.h');
   check_lib_fn(MEMMEM => 'memmem', 'string.h');
}

$dep->set_libs(join ' ', (map "-L$_", @libpath))
   if @libpath;
$dep->set_inc(join ' ', map "-I$_", @incpath)
   if @incpath;
$dep->install('SecretBuffer.h', 'SecretBufferManualLinkage.h');
$dep->add_xs('SecretBuffer.xs');
$dep->add_pm(map { my $n= $_; $n =~ s/^lib/\$(INST_LIB)/; $_ => $n } <lib/*/*.pm>, <lib/*/*/*.pm>);
$dep->add_typemaps('typemap');

sub MY::postamble {
   return <<LITERAL;

SecretBufferManualLinkage.h: SecretBuffer.h
\t\$(PERL) build-manual-linkage-header.pl < SecretBuffer.h > SecretBufferManualLinkage.h

SecretBuffer.c: SecretBufferManualLinkage.h

LITERAL
}

my %WriteMakefileArgs = (
  "ABSTRACT" => "Prevent accidentally copying a string of sensitive data",
  "AUTHOR" => "Michael Conrad <mike\@nrdvana.net>",
  "CONFIGURE_REQUIRES" => {
    "Devel::CheckLib" => "1.03",
    "ExtUtils::Depends" => "0.405",
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME" => "Crypt-SecretBuffer",
  "LICENSE" => "perl",
  "NAME" => "Crypt::SecretBuffer",
  "PREREQ_PM" => {
    "Carp" => 0,
    "DynaLoader" => 0,
    "Exporter" => 0,
    "Scalar::Util" => 0,
    "overload" => 0,
    "parent" => 0,
    "strict" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "File::Temp" => 0,
    "FindBin" => 0,
    "IO::Handle" => 0,
    "POSIX" => 0,
    "Test2::Suite" => "0.000139",
    "Test2::Tools::Subtest" => 0,
    "Test2::V0" => 0,
    "Time::HiRes" => 0,
    "lib" => 0
  },
  "VERSION" => "0.001",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

%WriteMakefileArgs = (
    %WriteMakefileArgs,
    $dep->get_makefile_vars, DEFINE => join(' ', map "-DHAVE_$_", @have),,
);

my %FallbackPrereqs = (
  "Carp" => 0,
  "DynaLoader" => 0,
  "Exporter" => 0,
  "File::Temp" => 0,
  "FindBin" => 0,
  "IO::Handle" => 0,
  "POSIX" => 0,
  "Scalar::Util" => 0,
  "Test2::Suite" => "0.000139",
  "Test2::Tools::Subtest" => 0,
  "Test2::V0" => 0,
  "Time::HiRes" => 0,
  "lib" => 0,
  "overload" => 0,
  "parent" => 0,
  "strict" => 0,
  "warnings" => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION('6.63_03') } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);
