## -*- Mode: CPerl -*-
##
## File: DTA::CAB::Analyzer::EqPho::JsonCDB.pm
## Author: Bryan Jurish <moocow@cpan.org>
## Description: dictionary-based equivalence-class expander, phonetic variant

package DTA::CAB::Analyzer::EqPho::JsonCDB;
use DTA::CAB::Analyzer ':child';
use DTA::CAB::Analyzer::Dict::JsonCDB;
use strict;

##==============================================================================
## Globals
##==============================================================================

our @ISA = qw(DTA::CAB::Analyzer::Dict::JsonCDB);

##==============================================================================
## Constructors etc.
##==============================================================================

## $obj = CLASS_OR_OBJ->new(%args)
##  + object structure: see DTA::CAB::Analyzer::Dict::JsonCDB
sub new {
  my $that = shift;
  return $that->SUPER::new(
			   ##-- options
			   label       => 'eqpho',
			   eqIdWeight  => 0,
			   #allowRegex  => '(?:^[[:alpha:]\-\x{ac}]*[[:alpha:]]+$)|(?:^[[:alpha:]]+[[:alpha:]\-\x{ac}]+$)',
			   allowRegex  => '(?:[[:alpha:]])',
			   ##
			   analyzeCode => join("\n",
					       'return if (defined($_->{$lab})); ##-- avoid re-analysis',
					       'if (!defined($val=$tied->FETCH('._am_lts.'))) {',
					       ' $_->{$lab} = ['._am_id_fst('$_','$dic->{eqIdWeight}').'];',
					       ' return;',
					       '}',
					       '$tmp  = undef; ##-- avoid bleed-over from _am_fst_uniq',
					       '$val  = $jxs->decode($val);',
					       '@$val = '._am_fst_usort((_am_id_fst('$_','$dic->{eqIdWeight}').',@$val'),'$tmp').';',
					       '$_->{$lab} = $val;',
					      ),

			   ##-- user args
			   @_
			  );
}

## $prefix = $dict->analyzePre()
sub analyzePre {
  my $dic = shift;
  return $dic->SUPER::analyzePre(@_)."\n".'my $tied=tied(%$dhash);'."\n".'my ($tmp);';
}

1; ##-- be happy

__END__
##========================================================================
## POD DOCUMENTATION, auto-generated by podextract.perl, edited

##========================================================================
## NAME
=pod

=head1 NAME

DTA::CAB::Analyzer::EqPho::JsonCDB - Json-valued CDB dictionary-based phonetic equivalence expander

=cut

##========================================================================
## SYNOPSIS
=pod

=head1 SYNOPSIS

 use DTA::CAB::Analyzer::EqPho::JsonCDB;
 
 ##========================================================================
 ## Constructors etc.
 
 $eqp = DTA::CAB::Analyzer::EqPho::JsonCDB->new(%args);
 

=cut

##========================================================================
## DESCRIPTION
=pod

=head1 DESCRIPTION

Json-valued CDB dictionary-based phonetic equivalence-class expander.
Composite analyzers should also include an 'lts' phonetic analyzer.

=cut

##----------------------------------------------------------------
## DESCRIPTION: DTA::CAB::Analyzer::Dict::JsonCDB: Globals
=pod

=head2 Globals

=over 4

=item Variable: @ISA

DTA::CAB::Analyzer::EqPho::JsonCDB inherits from
L<DTA::CAB::Analyzer::Dict::JsonCDB>.

=back

=cut

##----------------------------------------------------------------
## DESCRIPTION: DTA::CAB::Analyzer::Dict::JsonCDB: Constructors etc.
=pod

=head2 Constructors etc.

=over 4

=item new

 $eqc = CLASS_OR_OBJ->new(%args);

Constructor.  Sets the following default options:

 label       => 'eqpho',
 eqIdWeight  => 0,
 #allowRegex  => '(?:^[[:alpha:]\-\x{ac}]*[[:alpha:]]+$)|(?:^[[:alpha:]]+[[:alpha:]\-\x{ac}]+$)',
 allowRegex  => '(?:[[:alpha:]])',
 analyzeCode => ... ##-- see the source

=back

=cut


##========================================================================
## END POD DOCUMENTATION, auto-generated by podextract.perl

##======================================================================
## Footer
##======================================================================

=pod

=head1 AUTHOR

Bryan Jurish E<lt>moocow@cpan.orgE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2011-2019 by Bryan Jurish

This package is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.24.1 or,
at your option, any later version of Perl 5 you may have available.

=cut
