# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl new_pz.t'

use Test::More tests => 7990;

BEGIN { use_ok('Business::KontoCheck') };

$ok_cnt=$nok_cnt=0;
while(<DATA>){
   chomp;
   ($ret,$blz,$kto)=split(/ /);
   $retval=Business::KontoCheck::kto_check_pz($blz,$kto);
   $ret_txt=$kto_retval{$retval};
   if($retval==$ret){$ok_cnt++;}else{$nok_cnt++;}
   ok($retval eq $ret,"BLZ/KTO (neu) $blz $kto: $retval (Soll: $ret) => $ret_txt (ok: $ok_cnt, nok: $nok_cnt)");
}

__DATA__
1 00 5453362179
1 00 7148579464
1 00 3525213181
1 00 1695114700
1 00 6931087115
1 00 9354352636
1 00 3480616246
1 00 9730586790
1 00 8596712771
1 00 4696577081
1 01 1073022289
1 01 2055658182
1 01 1088687767
1 01 1392163874
1 01 9712108095
1 01 7474533443
1 01 1190283585
1 01 4728787773
1 01 2037535632
1 01 4314394192
1 02 6978686070
1 02 1014185332
1 02 3760033352
1 02 6417319214
1 02 2953901536
1 02 6751896658
1 02 9848375843
1 02 1292498312
1 02 3998041348
1 02 4904792504
1 03 3734784031
1 03 2983279629
1 03 2777867052
1 03 8324143738
1 03 5489373490
1 03 8179442707
1 03 1397952483
1 03 9261825372
1 03 1257124263
1 03 3086554512
1 04 5791188158
1 04 2156281495
1 04 3996333743
1 04 4747257820
1 04 6268345181
1 04 2037423346
1 04 5387312457
1 04 6427139555
1 04 8508518405
1 04 6477620157
1 05 1239713662
1 05 4397455076
1 05 3069113210
1 05 7046471793
1 05 8107049487
1 05 4952010199
1 05 6557505832
1 05 9605182900
1 05 6501766371
1 05 1319654861
1 06 6430302050
1 06 6512745022
1 06 8136590635
1 06 5511318582
1 06 3734536368
1 06 2956006409
1 06 9778486080
1 06 1004819116
1 06 5302547396
1 06 1055867573
1 07 9796950138
1 07 8578461320
1 07 9308616624
1 07 9570112670
1 07 8496823148
1 07 5656114481
1 07 4419587563
1 07 9307733740
1 07 2917847034
1 07 4749552461
1 08 7594337656
1 08 7258527576
1 08 3648207847
1 08 3075278592
1 08 1609046956
1 08 2287157206
1 08 1570145977
1 08 3500591551
1 08 5343790449
1 08 2469417469
2 09 6341909739
2 09 8921013520
2 09 9108969839
2 09 5666238429
2 09 2893687143
2 09 4594652204
2 09 8783033436
2 09 8009690427
2 09 2663745017
2 09 4943329947
1 10 1913172775
1 10 2757285726
1 10 8931543913
1 10 9396872059
1 10 6286352104
1 10 9386705958
1 10 8034618365
1 10 7533896670
1 10 2033948803
1 10 5084259927
1 11 4196194949
1 11 7054847660
1 11 7253462718
1 11 5851509449
1 11 3463432412
1 11 7785173486
1 11 8311190283
1 11 7341634057
1 11 1565597184
1 11 7843818979
1 13a 0286268895
1 13a 0406676709
1 13a 0523701107
1 13a 0301715922
1 13a 0292912336
1 13a 0764289569
1 13a 0178750636
1 13a 0762500727
1 13a 0112302514
1 13a 0286575635
1 13b 0088102758
1 13b 0038968828
1 13b 0084469870
1 13b 0061263797
1 13b 0013038734
1 13b 0088200172
1 13b 0057517048
1 13b 0091375898
1 13b 0074909768
1 13b 0061067990
1 14 7277268521
1 14 4572620502
1 14 5909535535
1 14 3193465071
1 14 9116908322
1 14 2960972681
1 14 9154060008
1 14 3874126815
1 14 7885267889
1 14 4237274092
1 15 3103565684
1 15 4639498540
1 15 1017604030
1 15 3229237265
1 15 3889223337
1 15 6711822144
1 15 4489479464
1 15 9497139306
1 15 6731959013
1 15 1348067849
1 16 2242764628
1 16 8601421802
1 16 8025956932
1 16 2371971028
1 16 1692675521
1 16 2501389792
1 16 2802291259
1 16 1861415593
1 16 5330351790
1 16 7955523843
1 17 8375700494
1 17 1017081338
1 17 7208400485
1 17 6187978660
1 17 2435592408
1 17 6776277017
1 17 3358452443
1 17 4621370947
1 17 6061969576
1 17 5609633680
1 18 2269158593
1 18 3348721154
1 18 9944933458
1 18 7735663289
1 18 2002821344
1 18 8863069815
1 18 1731857064
1 18 7823213646
1 18 5774089095
1 18 1963523537
1 19 4088027623
1 19 5297320047
1 19 9291986384
1 19 6287908717
1 19 9508559474
1 19 4111730674
1 19 6782814667
1 19 9558446584
1 19 6302876817
1 19 4528339679
1 20 8479346397
1 20 2170252064
1 20 8446640687
1 20 8056902792
1 20 3410971628
1 20 7761096508
1 20 5583953170
1 20 5287609177
1 20 9840456137
1 20 6845753359
1 21 6941338529
1 21 6075745954
1 21 3137081361
1 21 3313097066
1 21 3263808512
1 21 2178083707
1 21 1605852107
1 21 1245078708
1 21 7490616655
1 21 8294028492
1 22 8053431178
1 22 7705091456
1 22 3323296457
1 22 8081998681
1 22 7306732994
1 22 7594514227
1 22 9235701553
1 22 1709189263
1 22 3607868448
1 22 7173200886
1 23 3167763495
1 23 5899044353
1 23 7649681471
1 23 4528840464
1 23 5923247345
1 23 6863027667
1 23 9762620763
1 23 4500245582
1 23 7243707199
1 23 2510103182
1 24 1684440033
1 24 1024937205
1 24 1795801637
1 24 1042970678
1 24 1781803072
1 24 1978174126
1 24 1064539766
1 24 1043528740
1 24 1687322439
1 24 1118210040
1 24 2970962978
1 24 2164861254
1 24 2221016716
1 24 2460657462
1 24 2084241454
1 24 2508261451
1 24 2530267867
1 24 2197539038
1 24 2641795521
1 24 2217145527
1 24 7200790624
1 24 7442001738
1 24 7789635893
1 24 7222255334
1 24 7116590992
1 24 7193927984
1 24 7778579161
1 24 7295161231
1 24 7258389625
1 24 7008234536
1 24 8372515578
1 24 8415296884
1 24 8346373904
1 24 8480569786
1 24 8064201953
1 24 8352041731
1 24 8051524731
1 24 8647246384
1 24 8551943891
1 24 8813572795
1 24 3831169680
1 24 3071390890
1 24 3021472135
1 24 3841478116
1 24 3111243225
1 24 3671497791
1 24 3531161990
1 24 3981576211
1 24 3441957110
1 24 3691330430
1 24 4171080462
1 24 4861940786
1 24 4161009876
1 24 4931447065
1 24 4131056884
1 24 4061561482
1 24 4831155788
1 24 4181441439
1 24 4791781563
1 24 4561262862
1 24 5291921320
1 24 5821427854
1 24 5531877250
1 24 5691026305
1 24 5651812427
1 24 5571966254
1 24 5091408776
1 24 5351368032
1 24 5631932377
1 24 5221269467
1 24 6371063191
1 24 6191933516
1 24 6221682948
1 24 6731088069
1 24 6821683159
1 24 6001523602
1 24 6231266194
1 24 6571536887
1 24 6211633545
1 24 6631340377
1 24 3542792600
1 24 3262241789
1 24 3352526767
1 24 3042768766
1 24 3062804541
1 24 3132178762
1 24 3642455610
1 24 3042003350
1 24 3732835317
1 24 3982559410
1 24 4912903971
1 24 4762231428
1 24 4672654741
1 24 4962918612
1 24 4552477656
1 24 4202269377
1 24 4172068184
1 24 4172419360
1 24 4222831178
1 24 4452085748
1 24 5672000341
1 24 5912902967
1 24 5172779125
1 24 5962387503
1 24 5362774323
1 24 5522557583
1 24 5682906325
1 24 5632892737
1 24 5142651893
1 24 5132674588
1 24 6122465536
1 24 6142265300
1 24 6452980069
1 24 6962439234
1 24 6542273272
1 24 6092455722
1 24 6242856942
1 24 6192023567
1 24 6882110627
1 24 6762162068
1 24 3743462058
1 24 3093474461
1 24 3203953783
1 24 3823804410
1 24 3843723259
1 24 3043393095
1 24 3503784985
1 24 3903689539
1 24 3393721993
1 24 3193275655
1 24 4603092925
1 24 4453298211
1 24 4283750638
1 24 4183885067
1 24 4033680063
1 24 4823763847
1 24 4533852300
1 24 4363144716
1 24 4543498528
1 24 4623521031
1 24 5343051586
1 24 5873280912
1 24 5063137564
1 24 5633661601
1 24 5803633227
1 24 5073608958
1 24 5073888799
1 24 5103739331
1 24 5103478320
1 24 5423235940
1 24 6823795736
1 24 6413278638
1 24 6013929575
1 24 6183594242
1 24 6483868217
1 24 6583505998
1 24 6133696592
1 24 6543230624
1 24 6173891864
1 24 6763668428
1 24 3335237031
1 24 3945234649
1 24 3785933547
1 24 3295839789
1 24 3615767434
1 24 3445122545
1 24 3255543668
1 24 3815285059
1 24 3225343394
1 24 3835773924
1 24 4605464520
1 24 4015221746
1 24 4205829731
1 24 4835201729
1 24 4575688984
1 24 4015866194
1 24 4875561136
1 24 4325114097
1 24 4745793194
1 24 4745385764
1 24 5795430761
1 24 5305590786
1 24 5155805532
1 24 5265693569
1 24 5645005603
1 24 5925279265
1 24 5165408880
1 24 5765031473
1 24 5755293519
1 24 5225777469
1 24 6195694809
1 24 6295732171
1 24 6745105112
1 24 6255479848
1 24 6655908031
1 24 6435523788
1 24 6355375074
1 24 6605460390
1 24 6125878462
1 24 6235397018
1 24 3106700101
1 24 3466029295
1 24 3316109407
1 24 3576337069
1 24 3606610246
1 24 3636930084
1 24 3876122143
1 24 3516069460
1 24 3436539832
1 24 3206575865
1 24 4746685493
1 24 4666354002
1 24 4336989996
1 24 4846394060
1 24 4766844498
1 24 4466128547
1 24 4296349312
1 24 4396130237
1 24 4206105591
1 24 4686448007
1 24 5846627981
1 24 5156822352
1 24 5896271662
1 24 5816458336
1 24 5616263783
1 24 5986544554
1 24 5846470637
1 24 5166319840
1 24 5346771283
1 24 5796880161
1 24 6886305479
1 24 6266599420
1 24 6026276732
1 24 6416793162
1 24 6456694185
1 24 6436340825
1 24 6826225673
1 24 6616647379
1 24 6216276820
1 24 6956322647
1 24 3177647924
1 24 3417397173
1 24 3337486298
1 24 3127371691
1 24 3097193883
1 24 3137374616
1 24 3307638062
1 24 3717244685
1 24 3767552063
1 24 3567779751
1 24 4637415347
1 24 4587563982
1 24 4407675050
1 24 4357311725
1 24 4677657373
1 24 4807701925
1 24 4747832908
1 24 4657541625
1 24 4457572835
1 24 4927947849
1 24 5417141420
1 24 5717851712
1 24 5997571771
1 24 5447503793
1 24 5227120078
1 24 5577096396
1 24 5847779965
1 24 5347670356
1 24 5967252151
1 24 5077742320
1 24 6097273449
1 24 6167815644
1 24 6347276892
1 24 6297142224
1 24 6017805465
1 24 6857471621
1 24 6777673175
1 24 6387471657
1 24 6207395782
1 24 6487586012
1 24 3238618559
1 24 3608406457
1 24 3338984353
1 24 3878677992
1 24 3388444325
1 24 3488129889
1 24 3158524169
1 24 3948784730
1 24 3988199659
1 24 3908079244
1 24 4658465896
1 24 4598771848
1 24 4938872631
1 24 4058849533
1 24 4748358638
1 24 4068243537
1 24 4148366300
1 24 4878760966
1 24 4268181631
1 24 4838885095
1 24 5328527467
1 24 5658984716
1 24 5648190833
1 24 5908474434
1 24 5728575895
1 24 5088949208
1 24 5048030245
1 24 5248556717
1 24 5348693629
1 24 5498860361
1 24 6838207075
1 24 6708584282
1 24 6308822386
1 24 6778330980
1 24 6738676626
1 24 6058829130
1 24 6918911901
1 24 6748760667
1 24 6388526746
1 24 6908469485
1 24 3119440029
1 24 3669847329
1 24 3319732333
1 24 3419633966
1 24 3519658701
1 24 3829828513
1 24 3199064299
1 24 3249369009
1 24 3559377957
1 24 3049341259
1 24 4779030485
1 24 4829249171
1 24 4199350733
1 24 4379090027
1 24 4429074519
1 24 4579026009
1 24 4659606867
1 24 4699103014
1 24 4409236011
1 24 4969292649
1 24 5849924822
1 24 5169374589
1 24 5599731919
1 24 5269773126
1 24 5499086445
1 24 5809429948
1 24 5299421681
1 24 5989905789
1 24 5759181649
1 24 5179465039
1 24 6629357961
1 24 6929472614
1 24 6249707424
1 24 6809174569
1 24 6729218134
1 24 6659902149
1 24 6989079099
1 24 6709071700
1 24 6519963904
1 24 6939805209
1 24 9441950032
1 24 9591527355
1 24 9571211290
1 24 9011346896
1 24 9131590283
1 24 9601266026
1 24 9211984778
1 24 9821317832
1 24 9231395410
1 24 9901774873
1 24 9582636101
1 24 9242049061
1 24 9662075739
1 24 9012740755
1 24 9622885766
1 24 9032750287
1 24 9412329943
1 24 9962861869
1 24 9852807623
1 24 9482468767
1 24 9313811208
1 24 9923192751
1 24 9693057063
1 24 9813948364
1 24 9403491988
1 24 9333515438
1 24 9243662240
1 24 9303018972
1 24 9373851586
1 24 9403640856
1 24 9924177430
1 24 9824965634
1 24 9524775877
1 24 9814048472
1 24 9354191265
1 24 9084749771
1 24 9254206916
1 24 9214315465
1 24 9644144057
1 24 9964820227
1 24 9475633769
1 24 9435485400
1 24 9205446876
1 24 9625003887
1 24 9455735979
1 24 9265253905
1 24 9445344271
1 24 9655860832
1 24 9555160814
1 24 9725222845
1 24 9736524741
1 24 9746601334
1 24 9936504671
1 24 9276496125
1 24 9266919713
1 24 9506962252
1 24 9496780248
1 24 9716187081
1 24 9846903215
1 24 9336877321
1 24 9747896780
1 24 9087525593
1 24 9157473101
1 24 9097833708
1 24 9337578838
1 24 9967615653
1 24 9577385222
1 24 9627525784
1 24 9387848995
1 24 9267393174
1 24 9248576894
1 24 9108089952
1 24 9848148185
1 24 9548789531
1 24 9058571702
1 24 9818336683
1 24 9878005606
1 24 9378437849
1 24 9148670818
1 24 9848893468
1 24 9509169285
1 24 9239847017
1 24 9169020649
1 24 9979329104
1 24 9659801897
1 24 9489507214
1 24 9259116288
1 24 9659979241
1 24 9799728284
1 24 9109218369
1 25 0649733932
1 25 0102854769
1 25 0269716971
1 25 0737721162
1 25 0822337460
1 25 0912931760
1 25 0697947769
1 25 0812134567
1 25 0338554920
1 25 0128335149
1 26 0035386785
1 26 0061946802
1 26 0026811821
1 26 0089474051
1 26 0078647795
1 26 0093129822
1 26 0019129209
1 26 0025688872
1 26 0081410755
1 26 0028294638
1 26 9998125361
1 26 6967798305
1 26 1987056141
1 26 4011427057
1 26 4226526806
1 26 7476084824
1 26 8076137672
1 26 7341441586
1 26 2629208538
1 26 8783814575
1 27 0212032908
1 27 0688292259
1 27 0726979909
1 27 0876421926
1 27 0366369874
1 27 0279381180
1 27 0148515877
1 27 0590450409
1 27 0517711263
1 27 0973793730
1 27 9667859486
1 27 3476688053
1 27 4375858085
1 27 1666260607
1 27 1287007600
1 27 3730349436
1 27 8373586382
1 27 7322413120
1 27 6185363686
1 27 1295547502
1 28 2108161104
1 28 6864640212
1 28 9703424000
1 28 8096647034
1 28 1257542988
1 28 3990757090
1 28 5365706315
1 28 6951027045
1 28 2343514356
1 28 8506295257
1 29 2505932627
1 29 2490593465
1 29 9176780280
1 29 8715476864
1 29 2197471267
1 29 7287648895
1 29 5035472845
1 29 8739322893
1 29 1444249086
1 29 3411705769
1 30 7933782989
1 30 5401307387
1 30 7915465315
1 30 7448551174
1 30 7199875314
1 30 2596450598
1 30 9649195839
1 30 4583914582
1 30 1006958263
1 30 9348850289
1 31 2600323406
1 31 9187162016
1 31 8031193207
1 31 4073769855
1 31 3491040809
1 31 2816106233
1 31 2680689593
1 31 9653922750
1 31 6662619639
1 31 6897386944
1 32 1793931382
1 32 5263660613
1 32 9339991794
1 32 3922814722
1 32 2270951587
1 32 9586326790
1 32 8409920030
1 32 4255209374
1 32 4622191784
1 32 3296613195
1 33 6463694070
1 33 3388103403
1 33 4083318876
1 33 5636633577
1 33 6905153990
1 33 8911678058
1 33 2660982040
1 33 9341987980
1 33 7685867586
1 33 8432356778
1 34 9824846822
1 34 7449116475
1 34 4672521895
1 34 9251446220
1 34 4416681105
1 34 2463449786
1 34 9131298167
1 34 6775191780
1 34 8590486860
1 34 1523566232
1 35 8509858615
1 35 5918083704
1 35 8363129902
1 35 9346565184
1 35 9643802644
1 35 1287191216
1 35 6889155671
1 35 5937917248
1 35 8455495467
1 35 3702609994
1 36 7914094545
1 36 6082064282
1 36 6192400721
1 36 1317683440
1 36 1117289922
1 36 4855617697
1 36 4762393948
1 36 5420334470
1 36 5195679775
1 36 4829885139
1 37 4293398590
1 37 4490573773
1 37 5249147731
1 37 7679719365
1 37 7292300572
1 37 4118263919
1 37 4423755972
1 37 3976088196
1 37 6234657715
1 37 2238984960
1 38 6299680815
1 38 3737275971
1 38 4202337352
1 38 6133643300
1 38 1643532651
1 38 3992844223
1 38 7682806921
1 38 1626494320
1 38 1047013154
1 38 4620764377
1 39 9558511647
1 39 8261905399
1 39 7520886283
1 39 4081586735
1 39 9113846030
1 39 3436460990
1 39 1176740670
1 39 9990850850
1 39 2583586034
1 39 8545965800
1 40 6122702657
1 40 1605765465
1 40 3235896503
1 40 9202000528
1 40 7079101091
1 40 7764395841
1 40 5511620378
1 40 5866766966
1 40 2505733161
1 40 2144187985
1 41 2969730862
1 41 3739766098
1 41 8729140245
1 41 4019903188
1 41 2699842105
1 41 6279306697
1 41 4799563115
1 41 9639966995
1 41 1039430836
1 41 4859733262
1 41 8331310154
1 41 3255277554
1 41 9409942830
1 41 2322576394
1 41 9629647124
1 41 7652492021
1 41 4719035205
1 41 9039683509
1 41 8512431704
1 41 8739794942
1 42 3386930880
1 42 5804600546
1 42 1505189160
1 42 9114455970
1 42 4739086413
1 42 5447351753
1 42 5868487368
1 42 7403044200
1 42 7322381541
1 42 4253793602
1 43 9114518089
1 43 3280676096
1 43 5418079003
1 43 3276621065
1 43 7884578668
1 43 1993651532
1 43 3590043630
1 43 9903385669
1 43 6546861541
1 43 7163359249
1 44 3944716201
1 44 7967635815
1 44 8245954461
1 44 2210217197
1 44 2268177500
1 44 8301755534
1 44 5559293501
1 44 3414800454
1 44 9536141604
1 44 2182992687
2 45 0981964726
2 45 0383349814
2 45 0875437054
2 45 0175321394
2 45 0318358469
2 45 0422231164
2 45 0765943930
2 45 0902616568
2 45 0245419992
2 45 0422824116
2 45 6738164495
2 45 4704199436
2 45 5329128501
2 45 1080169914
2 45 7796197560
2 45 9122155004
2 45 7931177071
2 45 3763126698
2 45 4631174039
2 45 4598139529
1 45 4927848798
1 45 5912511952
1 45 8605912149
1 45 7729874730
1 45 5056414765
1 45 5272469429
1 45 8966963376
1 45 2268957129
1 45 3735656443
1 45 7953432494
1 46 6186773047
1 46 2616722392
1 46 2404734163
1 46 7428373871
1 46 2419239261
1 46 9263705097
1 46 9933523194
1 46 2325832692
1 46 4316694494
1 46 9344810926
1 47 4072857302
1 47 9304306254
1 47 7608682132
1 47 9063844530
1 47 6846077701
1 47 5868641459
1 47 8201540164
1 47 9877521851
1 47 9301478773
1 47 7765675582
1 48 8404767303
1 48 7301028495
1 48 2519219830
1 48 9464561540
1 48 7669776006
1 48 6867131817
1 48 2966527357
1 48 8743071193
1 48 1801094014
1 48 8243763580
1 49a 4719475446
1 49a 1718949074
1 49a 5905088547
1 49a 1318408745
1 49a 8884351704
1 49a 1727478610
1 49a 3981686557
1 49a 7602963444
1 49a 1899692667
1 49a 9503306590
1 49b 7353472319
1 49b 4464815002
1 49b 5793365734
1 49b 7278596741
1 49b 9924843980
1 49b 5050839941
1 49b 1948873020
1 49b 6968392861
1 49b 3147606742
1 49b 4393961302
1 50a 4130189891
1 50a 8215405419
1 50a 6137105691
1 50a 7517602827
1 50a 1590626973
1 50a 5763657845
1 50a 8073007265
1 50a 2558670639
1 50a 3799670144
1 50a 7379617788
1 50b 0006524575
1 50b 0004594029
1 50b 0001108522
1 50b 0003828760
1 50b 0009697578
1 50b 0005932610
1 50b 0003454975
1 50b 0007862709
1 50b 0002639750
1 50b 0002074940
1 51 4199772820
1 51 6799045891
1 51 5299127200
1 51 6099888225
1 51 6099529870
1 51 2599077469
1 51 4599755726
1 51 5999308282
1 51 5399366231
1 51 1099538025
1 51a 3776377432
1 51a 7826678645
1 51a 2621253433
1 51a 8378142092
1 51a 9649365141
1 51a 5581430173
1 51a 7923353605
1 51a 9511904426
1 51a 2773562751
1 51a 9568151628
1 51b 6654696315
1 51b 3229653217
1 51b 1354958115
1 51b 2473877921
1 51b 5423527726
1 51b 3720691585
1 51b 5000042765
1 51b 4147119180
1 51b 1462433551
1 51b 8813972827
1 51c 1705000383
1 51c 1806518170
1 51c 4500441241
1 51c 2109507721
1 51c 4903337250
1 51c 8300445536
1 51c 9204313785
1 51c 6105522933
1 51c 2809412044
1 51c 3706272570
1 51c 9510268781
1 51c 4910725705
1 51c 8317258160
1 51c 1617088102
1 51c 4810028770
1 51c 5016010741
1 51c 4316613154
1 51c 1617204305
1 51c 7617774133
1 51c 9713852204
1 51c 6126062492
1 51c 5429202001
1 51c 6228536763
1 51c 2420561134
1 51c 7922007576
1 51c 6020898183
1 51c 2425388813
1 51c 2725811494
1 51c 8528163144
1 51c 6522885422
1 51c 4530234374
1 51c 8436699996
1 51c 5931996846
1 51c 7439983335
1 51c 5630898055
1 51c 6934102031
1 51c 7137360001
1 51c 7039693396
1 51c 7232763135
1 51c 9836498356
1 51c 5543658535
1 51c 6246728000
1 51c 7247153390
1 51c 4247919452
1 51c 3541128241
1 51c 1940216554
1 51c 3145111262
1 51c 2840036750
1 51c 7647675576
1 51c 9244985292
1 51c 3857666040
1 51c 7755935725
1 51c 5556858820
1 51c 1455878194
1 51c 1256159750
1 51c 4056547641
1 51c 9851246135
1 51c 9153343811
1 51c 2750687264
1 51c 3053803154
1 51c 4961839536
1 51c 8962562942
1 51c 2768329076
1 51c 6165770754
1 51c 6665633804
1 51c 7265397940
1 51c 5263309741
1 51c 5363194580
1 51c 4967904785
1 51c 1168431181
1 51c 4775976513
1 51c 2374324462
1 51c 9072020283
1 51c 3170365002
1 51c 7977518966
1 51c 8572585411
1 51c 9475936694
1 51c 8577185840
1 51c 9174848060
1 51c 7070689070
1 51c 8584977393
1 51c 9981153985
1 51c 4286882780
1 51c 3287986755
1 51c 1081141245
1 51c 1486947170
1 51c 6480763681
1 51c 2387363394
1 51c 9680650691
1 51c 7684577485
1 52a 9874816594
1 52a 9192912220
1 52a 9696321896
1 52a 9717478853
1 52a 9178684398
1 52a 9129964501
1 52a 9326809878
1 52a 9422824947
1 52a 9755023760
1 52a 9099969713
1 53a 9420695260
1 53a 9443003020
1 53a 9843411681
1 53a 9600942118
1 53a 9030984969
1 53a 9014633537
1 53a 9614317296
1 53a 9512431952
1 53a 9315623603
1 53a 9570287273
1 54 4905827353
1 54 4994611636
1 54 4902613395
1 54 4945279545
1 54 4933571828
1 54 4915817046
1 54 4951987284
1 54 4938777084
1 54 4930996038
1 54 4977673059
1 55 9989440223
1 55 8235603258
1 55 3822945510
1 55 9425739017
1 55 8570888043
1 55 6495188127
1 55 6131190995
1 55 6733970817
1 55 1672162036
1 55 4043210040
1 56 6898497117
1 56 7845954539
1 56 3566488476
1 56 3485354319
1 56 8990035084
1 56 9116121821
1 56 3546534455
1 56 5210705238
1 56 7613305003
1 56 1804749736
-3 57 0852595457
-3 57 0726321006
-3 57 0572471201
-3 57 0927862025
-3 57 0667810205
-3 57 0425791071
-3 57 0465840885
-3 57 0788939117
-3 57 0124382612
-3 57 0433477730
-3 57 1807638220
-3 57 1234748246
-3 57 1558024295
-3 57 1660445964
-3 57 1687563541
-3 57 1014920771
-3 57 1455180088
-3 57 1238082868
-3 57 1695684944
-3 57 1325066047
2 57 2809394185
-3 57 2221516797
-3 57 2068718472
-3 57 2242352961
-3 57 2569560373
-3 57 2174488670
-3 57 2087457612
-3 57 2660405385
2 57 2902244422
-3 57 2173522894
0 57 3286242423
0 57 3358892376
0 57 3632712346
0 57 3683692400
0 57 3337030548
0 57 3786326992
0 57 3578762390
0 57 3614442460
0 57 3527684518
0 57 3418614491
0 57 4148098114
2 57 4084357769
0 57 4768507561
0 57 4374645182
0 57 4606055702
0 57 4993638015
1 57 4306383863
0 57 4572819820
0 57 4915562153
2 57 4014423343
2 57 5063983669
2 57 5080064552
2 57 5027903085
2 57 5015940011
2 57 5056343842
2 57 5073548449
2 57 5091620320
2 57 5044304325
2 57 5045211696
2 57 5095903140
2 57 9188763644
2 57 9116463620
2 57 9157093309
2 57 9145403731
2 57 9181624439
2 57 9133336933
2 57 9170101310
2 57 9141799459
2 57 9123452225
2 57 9146871473
0 57 9628496745
1 57 9638295953
0 57 9612054950
0 57 9655380771
0 57 9696622999
0 57 9671344709
0 57 9696369882
0 57 9642338800
0 57 9654370809
0 57 9678509752
0 57 9792979437
0 57 9793167962
0 57 9742278946
0 57 9791697477
0 57 9712156213
1 57 9707980739
0 57 9784713953
0 57 9712966605
0 57 9750934532
0 57 9799118380
0 57 9860760286
0 57 9898169177
0 57 9878111110
0 57 9879169171
0 57 9845912081
1 57 9814197797
0 57 9810863288
0 57 9840026952
0 57 9874271423
0 57 9826147312
2 57 9941521328
2 57 9954955276
2 57 9933415046
2 57 9921515318
2 57 9920679995
2 57 9975053495
2 57 9936121284
2 57 9959754527
2 57 9944909629
2 57 9943524904
2 57 7777776593
2 57 7777779646
2 57 7777774842
2 57 7777774329
2 57 7777779976
2 57 7777774703
2 57 7777773651
2 57 7777772545
2 57 7777771167
2 57 7777778762
2 57 8888882354
2 57 8888881822
2 57 8888887180
2 57 8888883631
2 57 8888883320
2 57 8888887791
2 57 8888885414
2 57 8888887893
2 57 8888883243
2 57 8888889104
0 57 6052800169
0 57 6300114993
0 57 6266926529
1 57 6576515779
1 57 6118603372
0 57 6752728127
1 57 6435223753
0 57 6809435370
0 57 6789716098
0 57 6811533796
1 57 7022162948
0 57 7411947874
1 57 7989901221
1 57 7013916492
1 57 7340210367
1 57 7082371841
0 57 7255490769
0 57 7472220865
1 57 7519622457
1 57 7955916966
0 57 8530603045
1 57 8877804724
1 57 8836739640
0 57 8508417494
1 57 8446775126
1 57 8174922279
0 57 8452013947
1 57 8893226071
1 57 8233853365
0 57 8528173726
1 57 9556558080
0 57 9215032631
0 57 9277773340
0 57 9834706251
2 57 9974025246
0 57 9733831334
0 57 9212616295
0 57 9827215469
0 57 9864610409
1 57 9306168475
-3 57 1819456017
1 57 8871522112
0 57 5471744367
1 57 6774460640
-3 57 2427914754
-3 57 2174214113
0 57 9628517265
1 57 8332530197
0 57 9021095012
-3 57 2966308183
1 58 0000937207
1 58 0000443611
1 58 0000476366
1 58 0000687243
1 58 0000327131
1 58 0000536563
1 58 0000303747
1 58 0000678112
1 58 0000666866
1 58 0000836222
1 58 0001171085
1 58 0001732958
1 58 0009757292
1 58 0003677507
1 58 0006380032
1 58 0001225886
1 58 0002309796
1 58 0001821292
1 58 0007982490
1 58 0004859605
1 58 0041182850
1 58 0038018295
1 58 0011123129
1 58 0032090913
1 58 0088706442
1 58 0019838225
1 58 0042536881
1 58 0073082791
1 58 0016916293
1 58 0044085502
1 58 0939392340
1 58 0622490830
1 58 0105482595
1 58 0913349674
1 58 0842579971
1 58 0363655929
1 58 0872979856
1 58 0898230502
1 58 0554570664
1 58 0902182575
1 58 5874363715
1 58 7835352586
1 58 4930082546
1 58 1474811661
1 58 3960206601
1 58 8447904821
1 58 5689838829
1 58 7743031550
1 58 9875827630
1 58 3981602167
2 59 0042960522
2 59 0050177099
2 59 0093385174
2 59 0031473068
2 59 0023178376
2 59 0088364245
2 59 0016236527
2 59 0088277007
2 59 0039768329
2 59 0053306613
1 59 0614544476
1 59 0313077240
1 59 0399092808
1 59 0932655822
1 59 0428687453
1 59 0494188279
1 59 0681609012
1 59 0138934799
1 59 0305259632
1 59 0757285127
1 59 9955870572
1 59 1981288432
1 59 8491495027
1 59 5251970082
1 59 8988216704
1 59 5958731423
1 59 2472597695
1 59 8203103513
1 59 2356230595
1 59 5671917408
1 60 8816941676
1 60 7710094787
1 60 6455239974
1 60 2459545095
1 60 5653797171
1 60 1113478755
1 60 5321049341
1 60 6960230596
1 60 6074100694
1 60 7916548562
1 61a 4176713879
1 61a 6375235654
1 61a 3670949190
1 61a 2872612359
1 61a 4526748125
1 61a 2407422167
1 61a 6237250379
1 61a 9578345247
1 61a 5585630653
1 61a 1548408232
1 61b 8949949780
1 61b 6111129185
1 61b 6527337885
1 61b 4061494784
1 61b 1966120188
1 61b 4562335082
1 61b 6712872080
1 61b 8093134881
1 61b 8456290583
1 61b 2549178388
1 62 4812066727
1 62 7290790725
1 62 4087385159
1 62 5368149406
1 62 7747081550
1 62 6029755624
1 62 8427735046
1 62 4360974367
1 62 3356581204
1 62 7895681365
1 63 0008909277
1 63 0004951489
1 63 0007287717
1 63 0009050386
1 63 0008850620
1 63 0003255742
1 63 0009291774
1 63 0003837812
1 63 0006257356
1 63 0003389491
1 63 0788990005
1 63 0286662237
1 63 0343089956
1 63 0951357351
1 63 0215015908
1 63 0704276538
1 63 0912478518
1 63 0496298185
1 63 0358903356
1 63 0495185156
1 64 4178164141
1 64 9663450996
1 64 7670007197
1 64 4941596558
1 64 3325345320
1 64 3713006351
1 64 9258948549
1 64 7921419804
1 64 1364463287
1 64 6841070048
1 65 4740857498
1 65 9722653455
1 65 5786636080
1 65 5297638852
1 65 4873351318
1 65 5492909623
1 65 8961263485
1 65 9611664533
1 65 7072491958
1 65 5649986619
1 65 2962120497
1 65 2705969190
1 65 3355637296
1 65 8086843997
1 65 6800722696
1 65 1672249099
1 65 9834422995
1 65 4988346396
1 65 1208277897
1 65 6287722498
1 66 0394817253
1 66 0848165840
1 66 0758173661
1 66 0971627201
1 66 0643954740
1 66 0853661456
1 66 0644631177
1 66 0145215248
1 66 0791494050
1 66 0860994510
1 67 7909301932
1 67 9367793802
1 67 1316123716
1 67 1669227942
1 67 3626933020
1 67 5702739345
1 67 9909912926
1 67 7494748235
1 67 6664179682
1 67 8414203372
2 68 0469024442
2 68 0497484997
2 68 0406947215
2 68 0481416763
2 68 0486229005
2 68 0424016876
2 68 0437588560
2 68 0470873994
2 68 0470468519
2 68 0422133748
1 68a 4819846791
1 68a 6529866492
1 68a 5859676842
1 68a 4729577362
1 68a 8549318940
1 68a 1639877325
1 68a 2209004607
1 68a 6789008178
1 68a 4599856543
1 68a 6159414962
1 68b 0000420414
1 68b 0000556753
1 68b 0000819300
1 68b 0000864918
1 68b 0000619957
1 68b 0000493007
1 68b 0000567933
1 68b 0000181230
1 68b 0000136481
1 68b 0000772384
1 68b 0009741760
1 68b 0002086221
1 68b 0008769093
1 68b 0009778861
1 68b 0005322003
1 68b 0007996820
1 68b 0003590825
1 68b 0004234100
1 68b 0004023693
1 68b 0001705227
1 68b 0073707788
1 68b 0045648169
1 68b 0095119244
1 68b 0043548213
1 68b 0074143520
1 68b 0080215742
1 68b 0041498650
1 68b 0030307979
1 68b 0088197116
1 68b 0035654524
1 68b 0477528871
1 68b 0657315933
1 68b 0673633160
1 68b 0310256805
1 68b 0626030134
1 68b 0445389133
1 68b 0273878124
1 68b 0101997815
1 68b 0836419325
1 68b 0229921119
1 68c 0000473629
1 68c 0000671172
1 68c 0000393827
1 68c 0000571786
1 68c 0000399253
1 68c 0000523779
1 68c 0000475566
1 68c 0000928879
1 68c 0000462234
1 68c 0000719674
1 68c 0004104224
1 68c 0003046904
1 68c 0006717298
1 68c 0006910703
1 68c 0004170373
1 68c 0001758987
1 68c 0001237420
1 68c 0006051854
1 68c 0007428334
1 68c 0008509935
1 68c 0023252817
1 68c 0098474726
1 68c 0052426825
1 68c 0037505040
1 68c 0085070094
1 68c 0038000893
1 68c 0096568709
1 68c 0044688184
1 68c 0094597229
1 68c 0050399220
1 68c 0293825628
1 68c 0372138443
1 68c 0711918527
1 68c 0892552218
1 68c 0127355429
1 68c 0131789262
1 68c 0188929926
1 68c 0677421366
1 68c 0761328271
1 68c 0595309828
1 68c 0446272860
1 68c 0465910477
1 68c 0438082673
1 68c 0404070520
1 68c 0428285250
1 68c 0419776258
1 68c 0464948634
1 68c 0451678959
1 68c 0422052718
1 68c 0407297610
2 69 9352617617
2 69 9377097208
2 69 9376000251
2 69 9312000884
2 69 9337415650
2 69 9369584264
2 69 9364427509
2 69 9383318551
2 69 9379917810
2 69 9325975758
1 69 9795052789
1 69 9769758477
1 69 9782636219
1 69 9709747697
1 69 9776642482
1 69 9737772116
1 69 9705942480
1 69 9722733367
1 69 9797380286
1 69 9740699099
1 69a 1402428494
1 69a 1935145383
1 69a 1139939232
1 69a 1464484353
1 69a 1332053090
1 69a 1238094606
1 69a 1038229151
1 69a 1736988636
1 69a 1098790898
1 69a 1226046030
1 69a 2451932424
1 69a 2986368626
1 69a 2157213575
1 69a 2913162656
1 69a 2225179040
1 69a 2363593252
1 69a 2816090878
1 69a 2866682838
1 69a 2253559404
1 69a 2519140363
1 69a 3565462727
1 69a 3849122232
1 69a 3824242747
1 69a 3978820202
1 69a 3588562969
1 69a 3613387616
1 69a 3302966030
1 69a 3533956090
1 69a 3021526979
1 69a 3779720454
1 69a 4492902131
1 69a 4621444525
1 69a 4745150505
1 69a 4393857454
1 69a 4700336727
1 69a 4106055525
1 69a 4207676565
1 69a 4483608242
1 69a 4576173646
1 69a 4057283848
1 69a 5073596959
1 69a 5231697141
1 69a 5267420747
1 69a 5021646595
1 69a 5639582575
1 69a 5880040999
1 69a 5838814131
1 69a 5832555747
1 69a 5215650808
1 69a 5315607232
1 69a 6961128949
1 69a 6416990121
1 69a 6413502080
1 69a 6377569737
1 69a 6055724979
1 69a 6778476353
1 69a 6767000818
1 69a 6803910797
1 69a 6007609747
1 69a 6864117646
1 69a 7349675888
1 69a 7758019272
1 69a 7620791989
1 69a 7989076848
1 69a 7159545757
1 69a 7252352242
1 69a 7073166717
1 69a 7332518010
1 69a 7974937272
1 69a 7099191000
1 69a 8187530484
1 69a 8975648797
1 69a 8703011050
1 69a 8181968404
1 69a 8348269515
1 69a 8186041292
1 69a 8489373757
1 69a 8414027535
1 69a 8801996959
1 69a 8453015444
1 69a 2123813888
1 69a 3136707070
1 69a 7108712585
1 69a 3140345000
1 69a 2150637070
1 69a 7131047999
1 69a 5142150020
1 69a 5121110686
1 69a 5154098323
1 69a 6179384131
1 69a 5282919707
1 69a 1220024747
1 69a 1250887030
1 69a 9246029161
1 69a 1229720818
1 69a 2260319030
1 69a 5292778404
1 69a 9235255333
1 69a 4281326383
1 69a 4235507969
1 69a 4431106000
1 69a 9493838545
1 69a 5431292292
1 69a 7476151090
1 69a 9496449181
1 69a 8400086474
1 69a 5436968161
1 69a 1417419747
1 69a 1457231181
1 69a 4453367505
1 69a 8504793767
1 69a 1549510898
1 69a 7530687505
1 69a 6570545939
1 69a 7582523646
1 69a 1578615373
1 69a 7517889393
1 69a 2566451484
1 69a 4531333464
1 69a 3501935292
1 69a 6670891575
1 69a 7613192050
1 69a 7695632656
1 69a 1698436666
1 69a 4637798010
1 69a 6651144535
1 69a 1627627232
1 69a 4613912585
1 69a 7617760202
1 69a 7699852535
1 69a 3876197181
1 69a 4841960505
1 69a 1894562777
1 69a 6821342575
1 69a 5850924050
1 69a 7861551878
1 69a 7890211888
1 69a 1876645575
1 69a 5839503202
1 69a 3884627676
1 69a 4901032878
1 69a 6922323848
1 69a 7954623484
1 69a 7903111000
1 69a 6932880393
1 69a 8924014646
1 69a 8918444020
1 69a 4963770393
1 69a 1923956494
1 69a 1962493080
1 69b 1520064291
1 69b 1215490084
1 69b 1049921978
1 69b 1278538679
1 69b 1091493857
1 69b 1201729993
1 69b 1834753645
1 69b 1918549943
1 69b 1446350299
1 69b 1744252763
1 69b 2482718765
1 69b 2064452131
1 69b 2067449695
1 69b 2899128329
1 69b 2343448757
1 69b 2131172870
1 69b 2427814359
1 69b 2823021717
1 69b 2033065802
1 69b 2438732196
1 69b 3648991743
1 69b 3415891697
1 69b 3138978837
1 69b 3093168743
1 69b 3741479966
1 69b 3613114228
1 69b 3658631921
1 69b 3958670461
1 69b 3550123833
1 69b 3331916044
1 69b 4875650050
1 69b 4239182240
1 69b 4804775924
1 69b 4838220514
1 69b 4973767210
1 69b 4536516465
1 69b 4015924169
1 69b 4276693691
1 69b 4653253678
1 69b 4617127118
1 69b 5220947349
1 69b 5933258231
1 69b 5607888743
1 69b 5875313525
1 69b 5519169789
1 69b 5901321455
1 69b 5705939675
1 69b 5650323281
1 69b 5425748263
1 69b 5344683567
1 69b 6647123847
1 69b 6608119984
1 69b 6634131002
1 69b 6982888656
1 69b 6149099773
1 69b 6456816270
1 69b 6174141847
1 69b 6611264664
1 69b 6135569903
1 69b 6238588435
1 69b 7889037104
1 69b 7677822266
1 69b 7987539089
1 69b 7287684946
1 69b 7915063673
1 69b 7969783861
1 69b 7141339431
1 69b 7239961532
1 69b 7222825936
1 69b 7059631904
1 69b 8236755667
1 69b 8278828239
1 69b 8804119832
1 69b 8947371458
1 69b 8993072309
1 69b 8992717365
1 69b 8260461184
1 69b 8376159163
1 69b 8153145986
1 69b 8030013087
1 69b 6174949487
1 69b 2110754207
1 69b 9172015289
1 69b 7122229438
1 69b 5180793477
1 69b 3123266902
1 69b 5132493734
1 69b 6119702317
1 69b 8107512573
1 69b 3180194253
1 69b 1224470607
1 69b 4267576608
1 69b 2266907495
1 69b 7209890083
1 69b 4257728420
1 69b 1280318886
1 69b 7214568858
1 69b 4252378262
1 69b 3283789849
1 69b 9276040031
1 69b 1473420280
1 69b 9425822055
1 69b 7408426425
1 69b 3449357064
1 69b 7434913931
1 69b 4481499580
1 69b 7479724196
1 69b 1418687242
1 69b 9415722127
1 69b 6475188839
1 69b 2539893811
1 69b 1532123062
1 69b 7513628178
1 69b 5564306923
1 69b 8500973331
1 69b 2529564186
1 69b 9572430752
1 69b 6556701162
1 69b 2534807432
1 69b 6508622560
1 69b 4698233153
1 69b 2657176737
1 69b 7693965619
1 69b 9683768809
1 69b 7638969646
1 69b 4674340702
1 69b 8609055213
1 69b 6637840023
1 69b 5679026439
1 69b 3676760767
1 69b 1862697115
1 69b 5898810436
1 69b 4800578715
1 69b 5895157056
1 69b 8821139610
1 69b 3882030218
1 69b 6841461260
1 69b 4886319927
1 69b 3842921402
1 69b 1824741503
1 69b 5963611930
1 69b 5994760941
1 69b 7964374237
1 69b 7906918968
1 69b 2938784264
1 69b 2932123976
1 69b 6962886671
1 69b 8989673206
1 69b 1902147773
1 69b 7941813615
1 70 6431458029
1 70 8761163354
1 70 5140220738
1 70 5714697562
1 70 1989527157
1 70 7530597070
1 70 1880834211
1 70 3555432430
1 70 4563290094
1 70 1240577395
1 70 6385330912
1 70 5355528720
1 70 5505125219
1 70 9225647827
1 70 3445521890
1 70 6455266793
1 70 5645453259
1 70 2805140480
1 70 5895897971
1 70 9575351839
1 70 1316924166
1 70 6236983405
1 70 6636963986
1 70 8936975127
1 70 8916950787
1 70 2266935281
1 70 5876975585
1 70 9466905609
1 70 6396986862
1 70 4466998755
1 71 9066254963
1 71 3796387610
1 71 1208892580
1 71 4669316772
1 71 9922660088
1 71 9825295303
1 71 8664269921
1 71 2282995260
1 71 2668777563
1 71 4901233784
1 72 8787623135
1 72 4017401466
1 72 9814333795
1 72 5281360197
1 72 1453567617
1 72 2068614562
1 72 9923678695
1 72 8543265253
1 72 1288200172
1 72 2833914678
1 73 8296611243
1 73 2063418564
1 73 8929323954
1 73 4447719391
1 73 8580268883
1 73 2108167796
1 73 9133247073
1 73 7643946686
1 73 4968253763
1 73 5523982244
1 73 3897033739
1 73 3290608204
1 73 8895425723
1 73 2698801174
1 73 6493062691
1 73 4597794603
1 73 6194317442
1 73 4093502722
1 73 9492501201
1 73 3590480475
1 74 0001501378
1 74 0002601094
1 74 0007551112
1 74 0003746690
1 74 0005198270
1 74 0008119463
1 74 0008280802
1 74 0007996838
1 74 0007914401
1 74 0007992183
1 74 0080528300
1 74 0022120869
1 74 0042518290
1 74 0044252922
1 74 0033579103
1 74 0028991677
1 74 0017908880
1 74 0073045734
1 74 0024418782
1 74 0063939953
1 74 0848501268
1 74 0590522041
1 74 0173302217
1 74 0341422681
1 74 0889260253
1 74 0811900091
1 74 0145511291
1 74 0131745184
1 74 0459980116
1 74 0140833435
1 74 4251886695
1 74 5356971639
1 74 3889884692
1 74 9201200970
1 74 6614639356
1 74 1167388931
1 74 9463771270
1 74 3322286521
1 74 3757056324
1 74 8403967063
1 74 0000768168
1 74 0000960013
1 74 0000735282
1 74 0000122952
1 74 0000849083
1 74 0000156935
1 74 0000142695
1 74 0000233346
1 74 0000983684
1 74 0000777805
1 74 0000477422
1 74 0000834168
1 74 0000777685
1 74 0000370858
1 74 0000103213
1 74 0000435714
1 74 0000794623
1 74 0000823802
1 74 0000124102
1 74 0000323717
1 75a 0000312918
1 75a 0000798447
1 75a 0000625848
1 75a 0000152363
1 75a 0000839860
1 75a 0000181503
1 75a 0000415885
1 75a 0000142398
1 75a 0000443390
1 75a 0000753525
1 75a 0007966788
1 75a 0006643635
1 75a 0002516740
1 75a 0009753277
1 75a 0004979542
1 75a 0005150490
1 75a 0007552554
1 75a 0003492744
1 75a 0008964213
1 75a 0007523365
1 75b 0917923404
1 75b 0996175585
1 75b 0973505000
1 75b 0970660626
1 75b 0990701474
1 75b 0958398909
1 75b 0905796828
1 75b 0962504606
1 75b 0965795787
1 75b 0912939575
1 75c 0116160776
1 75c 0181040051
1 75c 0139485359
1 75c 0108720292
1 75c 0116285575
1 75c 0140608397
1 75c 0110437621
1 75c 0140715231
1 75c 0199612550
1 75c 0186585386
1 75c 0267070944
1 75c 0250738947
1 75c 0208926254
1 75c 0271494078
1 75c 0200519448
1 75c 0282772804
1 75c 0259127012
1 75c 0217968637
1 75c 0248401642
1 75c 0243394637
1 75c 0309740957
1 75c 0387357196
1 75c 0371245163
1 75c 0323709658
1 75c 0395525923
1 75c 0364422415
1 75c 0348631964
1 75c 0378844458
1 75c 0354407568
1 75c 0327825707
1 75c 0477760421
1 75c 0499145613
1 75c 0470690611
1 75c 0481655727
1 75c 0415604588
1 75c 0424218830
1 75c 0438226882
1 75c 0419176748
1 75c 0457887298
1 75c 0415901944
1 75c 0554212405
1 75c 0597302467
1 75c 0554071601
1 75c 0516153707
1 75c 0544049229
1 75c 0568683792
1 75c 0563247817
1 75c 0505545707
1 75c 0520940899
1 75c 0593947702
1 75c 0605410143
1 75c 0680157437
1 75c 0649954583
1 75c 0661959406
1 75c 0633255911
1 75c 0684324121
1 75c 0601179985
1 75c 0605360898
1 75c 0607762369
1 75c 0628107194
1 75c 0750646496
1 75c 0759183027
1 75c 0718072385
1 75c 0759829072
1 75c 0746537462
1 75c 0740951543
1 75c 0788257377
1 75c 0764001636
1 75c 0727388301
1 75c 0706127900
1 75c 0878231222
1 75c 0881292931
1 75c 0856237042
1 75c 0837849322
1 75c 0884270170
1 75c 0803726888
1 75c 0843169089
1 75c 0846964244
1 75c 0816728920
1 75c 0802454109
1 75c 0933622241
1 75c 0980953368
1 75c 0938464425
1 75c 0988063311
1 75c 0938563315
1 75c 0956383373
1 75c 0979781159
1 75c 0926683370
1 75c 0941856605
1 75c 0909010075
1 76a 0005538482
1 76a 0005765460
1 76a 0008933339
1 76a 0007923695
1 76a 0007429966
1 76a 0003665138
1 76a 0003248708
1 76a 0008709901
1 76a 0003840450
1 76a 0005962663
1 76a 0058859373
1 76a 0074907269
1 76a 0089938076
1 76a 0092899969
1 76a 0091799026
1 76a 0045632994
1 76a 0097367130
1 76a 0043505335
1 76a 0020985511
1 76a 0067430851
1 76a 0600444124
1 76a 0385768216
1 76a 0790684566
1 76a 0345075270
1 76a 0664003508
1 76a 0174701040
1 76a 0720146166
1 76a 0746620100
1 76a 0534967912
1 76a 0744836390
1 76a 7119122621
1 76a 7417180959
1 76a 4151087319
1 76a 4341349462
1 76a 6502281256
1 76a 9149129527
1 76a 7253426594
1 76a 9811301475
1 76a 6962770440
1 76a 4048844601
1 76b 0000065808
1 76b 0000052085
1 76b 0000070312
1 76b 0000095291
1 76b 0000070063
1 76b 0000084384
1 76b 0000030806
1 76b 0000036614
1 76b 0000065791
1 76b 0000057332
1 76b 0000308614
1 76b 0000120121
1 76b 0000360764
1 76b 0000197750
1 76b 0000199515
1 76b 0000925895
1 76b 0000981333
1 76b 0000741127
1 76b 0000457607
1 76b 0000874073
1 76b 0003327838
1 76b 0003685482
1 76b 0008692087
1 76b 0009805345
1 76b 0005285227
1 76b 0003577296
1 76b 0001012216
1 76b 0002599107
1 76b 0008150035
1 76b 0005246325
1 76b 0096500973
1 76b 0085214026
1 76b 0078246415
1 76b 0061647878
1 76b 0084168367
1 76b 0048077915
1 76b 0081037997
1 76b 0044731979
1 76b 0041826359
1 76b 0061898486
1 76b 0072837973
1 76b 0084835347
1 76b 0078994560
1 76b 0094276097
1 76b 0079644751
1 76b 0061461345
1 76b 0075782855
1 76b 0082095865
1 76b 0044490526
1 76b 0077744274
1 77a 0000633340
1 77a 0000841424
1 77a 0000186088
1 77a 0000115792
1 77a 0000829319
1 77a 0000617736
1 77a 0000839918
1 77a 0000618961
1 77a 0000546922
1 77a 0000118155
1 77a 0005784204
1 77a 0004217876
1 77a 0007424201
1 77a 0007920370
1 77a 0001587955
1 77a 0005490948
1 77a 0009392770
1 77a 0001348615
1 77a 0001549581
1 77a 0001759293
1 77a 0090861999
1 77a 0029532492
1 77a 0043404871
1 77a 0073588501
1 77a 0028480306
1 77a 0055387939
1 77a 0014366656
1 77a 0014481159
1 77a 0021774241
1 77a 0068142986
1 77a 0434383089
1 77a 0940518287
1 77a 0529189478
1 77a 0471477240
1 77a 0192999198
1 77a 0221199392
1 77a 0470422357
1 77a 0910589761
1 77a 0272201627
1 77a 0734598892
1 77a 8286412084
1 77a 6366176767
1 77a 1193554208
1 77a 1547253139
1 77a 7577574683
1 77a 4542224015
1 77a 6068872125
1 77a 9141270289
1 77a 1360730031
1 77a 6188207935
1 77b 0000799738
1 77b 0000700265
1 77b 0000239412
1 77b 0000918720
1 77b 0000318093
1 77b 0000204835
1 77b 0000683728
1 77b 0000826690
1 77b 0000446917
1 77b 0000614400
1 77b 0006858170
1 77b 0006052949
1 77b 0005856218
1 77b 0008507315
1 77b 0003316356
1 77b 0002467197
1 77b 0009170822
1 77b 0002238461
1 77b 0002057455
1 77b 0007650461
1 77b 0034309327
1 77b 0087868959
1 77b 0046720369
1 77b 0014021013
1 77b 0073093854
1 77b 0043315278
1 77b 0047562070
1 77b 0019835935
1 77b 0038101696
1 77b 0091303193
1 77b 0589357857
1 77b 0119862754
1 77b 0278685874
1 77b 0821795961
1 77b 0785407354
1 77b 0564270861
1 77b 0235448559
1 77b 0591125252
1 77b 0961802012
1 77b 0526513065
1 77b 2237861122
1 77b 7096305039
1 77b 9289650165
1 77b 8594882135
1 77b 9232122130
1 77b 5932817829
1 77b 4377398988
1 77b 8769344020
1 77b 4095778517
1 77b 8125005092
2 78 0026163794
2 78 0045693680
2 78 0056159666
2 78 0056522749
2 78 0013300317
2 78 0064099856
2 78 0065538303
2 78 0093492862
2 78 0082525576
2 78 0059609648
1 78 7231297008
1 78 2560753580
1 78 1729673283
1 78 8729501877
1 78 7800505369
1 78 3486039039
1 78 7436247394
1 78 8028055559
1 78 2327190068
1 78 8590607738
1 79 3489611057
1 79 3648281834
1 79 3016352746
1 79 3849092782
1 79 3642579456
1 79 3625884444
1 79 3184087967
1 79 3083437321
1 79 3766123610
1 79 3109684344
1 79 4480211848
1 79 4736704695
1 79 4209602632
1 79 4351309895
1 79 4630007773
1 79 4952515056
1 79 4660458250
1 79 4374129635
1 79 4532626456
1 79 4383528025
1 79 5202065206
1 79 5773367635
1 79 5942269589
1 79 5904702718
1 79 5030092075
1 79 5056795221
1 79 5151019691
1 79 5179931737
1 79 5990636267
1 79 5939865191
1 79 6999793869
1 79 6223464881
1 79 6196207804
1 79 6058092641
1 79 6434302185
1 79 6021644742
1 79 6567959876
1 79 6298305571
1 79 6673297385
1 79 6726256644
1 79 7348397790
1 79 7823150805
1 79 7306995239
1 79 7618189596
1 79 7365737514
1 79 7443487702
1 79 7183453955
1 79 7335704974
1 79 7075874797
1 79 7020049867
1 79 8441239707
1 79 8289577317
1 79 8185826453
1 79 8340742082
1 79 8273660947
1 79 8160249671
1 79 8267430893
1 79 8104128809
1 79 8434554286
1 79 8539493067
1 79 1476316180
1 79 1683199110
1 79 1549815340
1 79 1088959050
1 79 1335557970
1 79 1530785550
1 79 1512548020
1 79 1279887640
1 79 1440258300
1 79 1735190000
1 79 2598270380
1 79 2839185710
1 79 2426591000
1 79 2184428790
1 79 2503123290
1 79 2708240630
1 79 2423857060
1 79 2038650430
1 79 2061355190
1 79 2444477440
1 79 9244386580
1 79 9957167840
1 79 9718115830
1 79 9341192070
1 79 9573717350
1 79 9234125300
1 79 9208005390
1 79 9394088940
1 79 9960328500
1 79 9832402680
1 80 2799785668
1 80 9099806703
1 80 8599113151
1 80 9499047972
1 80 5599691284
1 80 6899908220
1 80 9899982423
1 80 9899003794
1 80 9799808650
1 80 2299877908
1 80a 3261058156
1 80a 3013278937
1 80a 2047626499
1 80a 2204474346
1 80a 7779089557
1 80a 8880317537
1 80a 2540796581
1 80a 2114317305
1 80a 2131001073
1 80a 2771439208
1 80b 1155224962
1 80b 6652667746
1 80b 3000540702
1 80b 2464945254
1 80b 3962359385
1 80b 4941726446
1 80b 1042930751
1 80b 3412992893
1 80b 8268157246
1 80b 4113873765
1 81 2192683669
1 81 9145023068
1 81 2473601242
1 81 4001491008
1 81 6362828294
1 81 1262496780
1 81 5238370249
1 81 6224126874
1 81 6723311830
1 81 3378119724
1 81 5290527699
1 81 7293571534
1 81 9793906642
1 81 4099705494
1 81 3698202069
1 81 3193130419
1 81 2696733708
1 81 2990500286
1 81 5794826277
1 81 8393471141
1 82 6164619370
1 82 1264079367
1 82 4269120030
1 82 8134780758
1 82 6358411752
1 82 5377716197
1 82 9525966231
1 82 3399588364
1 82 3943834670
1 82 5801513610
1 82 1199419508
1 82 5399445948
1 82 9299649618
1 82 6399260345
1 82 5199211110
1 82 6399770297
1 82 8599183451
1 82 4899854773
1 82 1499361971
1 82 3099133280
1 83a 1865446830
1 83a 4237290187
1 83a 8423917398
1 83a 4459693939
1 83a 4723095169
1 83a 1762444895
1 83a 7064711939
1 83a 6667538766
1 83a 5936319726
1 83a 3205885892
1 83b 8704089974
1 83b 7969731048
1 83b 7097899224
1 83b 3276999954
1 83b 7943062456
1 83b 5612088889
1 83b 2279148415
1 83b 1435143359
1 83b 8904827290
1 83b 1533059307
1 83c 2695482551
1 83c 4486546332
1 83c 8837903600
1 83c 3182478360
1 83c 8861883381
1 83c 3874361461
1 83c 1414508063
1 83c 1912248061
1 83c 1581683951
1 83c 3836073466
1 83d 1699255782
1 83d 1999498871
1 83d 3999074001
1 83d 4899330768
1 83d 2699821486
1 83d 8699184486
1 83d 8299763052
1 83d 2599880938
1 83d 1299444593
1 83d 9399491370
1 84a 1638749443
1 84a 4129494437
1 84a 1721102695
1 84a 5634250023
1 84a 4005218820
1 84a 4980699756
1 84a 6911887013
1 84a 1247532584
1 84a 1978230332
1 84a 2615533653
1 84b 9230155686
1 84b 7817821875
1 84b 6851662893
1 84b 3431223330
1 84b 5688615056
1 84b 3615167285
1 84b 5134233282
1 84b 3721510576
1 84b 5972114144
1 84b 7161763070
1 84c 8499505827
1 84c 1399910276
1 84c 8599402645
1 84c 9999518635
1 84c 1499694522
1 84c 9299927365
1 84c 8099200090
1 84c 4399341239
1 84c 4099939690
1 84c 8499939339
1 85a 7377714726
1 85a 4374179587
1 85a 7310886009
1 85a 9956759785
1 85a 5810884685
1 85a 5951956140
1 85a 7763154998
1 85a 6298336725
1 85a 8025285151
1 85a 5986644341
1 85b 1392260100
1 85b 9642879002
1 85b 1852529591
1 85b 5369388300
1 85b 3222299804
1 85b 2328133221
1 85b 4563110698
1 85b 1017081167
1 85b 7032404640
1 85b 9551506419
1 85c 1920631910
1 85c 7023049522
1 85c 3898516090
1 85c 9868285953
1 85c 6863666690
1 85c 6075536515
1 85c 6748229303
1 85c 6696670946
1 85c 1666218611
1 85c 2129279434
1 85d 9399320398
1 85d 6799433419
1 85d 4199434172
1 85d 7599685140
1 85d 3699598353
1 85d 3999887428
1 85d 3999568373
1 85d 4399411377
1 85d 6499368188
1 85d 2799246023
1 86a 4711560648
1 86a 5711408640
1 86a 8411898550
1 86a 5018021016
1 86a 7011120732
1 86a 2110734954
1 86a 3710056549
1 86a 4317039381
1 86a 3115291265
1 86a 4517081508
1 86a 5620287417
1 86a 5829999780
1 86a 7229266529
1 86a 5822918605
1 86a 1925510789
1 86a 7727377849
1 86a 7322224525
1 86a 3420917690
1 86a 7621443688
1 86a 7420024372
1 86a 8939176876
1 86a 9138950867
1 86a 5130295089
1 86a 3236262364
1 86a 6332344190
1 86a 8335612684
1 86a 4230705806
1 86a 5036807291
1 86a 7537229107
1 86a 3439523093
1 86a 7940998765
1 86a 7343932837
1 86a 1542186419
1 86a 9448824443
1 86a 6849006735
1 86a 4446617849
1 86a 8948898967
1 86a 1044592382
1 86a 6947417058
1 86a 1047842891
1 86a 7753281995
1 86a 8252223741
1 86a 2055888375
1 86a 2554008827
1 86a 9756946073
1 86a 2855010160
1 86a 3751094077
1 86a 1254227450
1 86a 5851622810
1 86a 8454597134
1 86a 5669396292
1 86a 4669565466
1 86a 8562911790
1 86a 4868021883
1 86a 1163366473
1 86a 2565683487
1 86a 6961923168
1 86a 9568039430
1 86a 9669116542
1 86a 1664438917
1 86a 6277738701
1 86a 9870026559
1 86a 2777827389
1 86a 3377267826
1 86a 3571324250
1 86a 7672426476
1 86a 1479072794
1 86a 1174185260
1 86a 5376841308
1 86a 8974323069
1 86a 7082245652
1 86a 5881739630
1 86a 3385103858
1 86a 7580667527
1 86a 2585092119
1 86a 8383866548
1 86a 3186407019
1 86a 4081344597
1 86a 5488176372
1 86a 7589136854
1 86b 3618224099
1 86b 2811187066
1 86b 3617372671
1 86b 9313638421
1 86b 8513490653
1 86b 7515430933
1 86b 7513773000
1 86b 2919346252
1 86b 1513199410
1 86b 5819966080
1 86b 8621101714
1 86b 5820583774
1 86b 4924167686
1 86b 2727709366
1 86b 1820322660
1 86b 1027826150
1 86b 5623012433
1 86b 6129022716
1 86b 5721612450
1 86b 4022061830
1 86b 7333451445
1 86b 5133573877
1 86b 5639171118
1 86b 2132887452
1 86b 8133194000
1 86b 3839377450
1 86b 1338554366
1 86b 4638910456
1 86b 9438665320
1 86b 9034987268
1 86b 4041600745
1 86b 8449335668
1 86b 5646027776
1 86b 3443718077
1 86b 2248204772
1 86b 6341346644
1 86b 7344508890
1 86b 3148063320
1 86b 4447694610
1 86b 5743176606
1 86b 6157617348
1 86b 6357595174
1 86b 3053475140
1 86b 6059950400
1 86b 9158783586
1 86b 3451770250
1 86b 9152722895
1 86b 7855872200
1 86b 5057976577
1 86b 9854258452
1 86b 8464578554
1 86b 9764762797
1 86b 3868893110
1 86b 3867203063
1 86b 1061808915
1 86b 4569288910
1 86b 2961924664
1 86b 5269579591
1 86b 4361203347
1 86b 3265570000
1 86b 5477210930
1 86b 8974332938
1 86b 1072856719
1 86b 1675312965
1 86b 2075340268
1 86b 6279456899
1 86b 4174714679
1 86b 9179043551
1 86b 3470558737
1 86b 3774680944
1 86b 7884767551
1 86b 6285421918
1 86b 5284405110
1 86b 1380460966
1 86b 4482974347
1 86b 2487093918
1 86b 8288293783
1 86b 4680364657
1 86b 1083419940
1 86b 7683643891
1 86c 2591998212
1 86c 7394004374
1 86c 1598001302
1 86c 7393900708
1 86c 5297853267
1 86c 6692525032
1 86c 4299290871
1 86c 1394361673
1 86c 9797382671
1 86c 2393118414
1 87a 4150744174
1 87a 2048400750
1 87a 8361314161
1 87a 3635983862
1 87a 2987284050
1 87a 2939447242
1 87a 5720478911
1 87a 2258788732
1 87a 5672617032
1 87a 5776150738
1 87b 0000227889
1 87b 0000672130
1 87b 0000619698
1 87b 0000224138
1 87b 0000776092
1 87b 0000385476
1 87b 0000254940
1 87b 0000401153
1 87b 0000895725
1 87b 0000224456
1 87c 0000889002
1 87c 0000515724
1 87c 0000746036
1 87c 0000769492
1 87c 0000149040
1 87c 0000885171
1 87c 0000892503
1 87c 0000340801
1 87c 0000397135
1 87c 0000424293
1 87d 0091416264
1 87d 0098083252
1 87d 0095143963
1 87d 0099376660
1 87d 0093922221
1 87d 0091263816
1 87d 0091498317
1 87d 0091684552
1 87d 0091893585
1 87d 0098820370
1 87e 0095042024
1 87e 0090653688
1 87e 0099257726
1 87e 0097537462
1 87e 0090184211
1 87e 0097735590
1 87e 0097733717
1 87e 0099084503
1 87e 0093481616
1 87e 0091503469
1 88 4684030389
1 88 9331934481
1 88 8603126641
1 88 1951845942
1 88 3832826097
1 88 1764191641
1 88 2303393909
1 88 8511662430
1 88 6258127859
1 88 8063200558
1 88 1892921329
1 88 4692630308
1 88 5890688651
1 88 6995014462
1 88 4396976454
1 88 5691375959
1 88 4597185779
1 88 7995463550
1 88 2092796079
1 88 7699577410
2 89 0000059218
2 89 0000070171
2 89 0000017302
2 89 0000074089
2 89 0000073982
2 89 0000089300
2 89 0000060971
2 89 0000070439
2 89 0000043903
2 89 0000069081
2 89 0000493929
2 89 0000326079
2 89 0000258156
2 89 0000908179
2 89 0000786061
2 89 0000900193
2 89 0000177001
2 89 0000980575
2 89 0000599675
2 89 0000451934
1 89 0002035780
1 89 0004862181
1 89 0008258374
1 89 0001720900
1 89 0005448733
1 89 0003551021
1 89 0002297460
1 89 0009293384
1 89 0007884245
1 89 0001631585
1 89 0088537137
1 89 0033439249
1 89 0099366371
1 89 0047448580
1 89 0081696736
1 89 0099068508
1 89 0096074280
1 89 0011173742
1 89 0042348811
1 89 0088866009
1 89 0646458353
1 89 0650805437
1 89 0266535240
1 89 0117295264
1 89 0619840323
1 89 0185481779
1 89 0432051090
1 89 0998348538
1 89 0476892783
1 89 0559638159
2 89 9737245609
2 89 6766689768
2 89 6438955871
2 89 2729098531
2 89 1428193583
2 89 2836580425
2 89 3276868618
2 89 1713615131
2 89 8729670440
2 89 9518204306
1 90 1599309645
1 90 6199895820
1 90 9099968380
1 90 1999993120
1 90 3699203960
1 90 7799754177
1 90 4499786079
1 90 8099552884
1 90 7199621991
1 90 9199320347
1 90a 2008742642
1 90a 7135751241
1 90a 9056051014
1 90a 5722336820
1 90a 8946953484
1 90a 6440651893
1 90a 5875609950
1 90a 5828758115
1 90a 8658711356
1 90a 9929858741
1 90b 1300931896
1 90b 1278252263
1 90b 2580311308
1 90b 7946416398
1 90b 4522624128
1 90b 6162544965
1 90b 2523842796
1 90b 9666996750
1 90b 9459908096
1 90b 3839316270
1 90c 5710749955
1 90c 5655086811
1 90c 9023457321
1 90c 6318013654
1 90c 1472512030
1 90c 1048256853
1 90c 3019114883
1 90c 8240406055
1 90c 4913166421
1 90c 1454650702
1 90d 7547495650
1 90d 1311260344
1 90d 8934750435
1 90d 8744400344
1 90d 5629629705
1 90d 2568914096
1 90d 8867140464
1 90d 6028138731
1 90d 6745561608
1 90d 9744683424
1 90e 6660827652
1 90e 5365394502
1 90e 9233327397
1 90e 4182544826
1 90e 7447984098
1 90e 5969687220
1 90e 9455150722
1 90e 2767800236
1 90e 8010934621
1 90e 3989219990
1 90a 4801794590
1 90a 9601347195
1 90a 1009250166
1 90a 7101294750
1 90a 2000069400
1 90a 2909574034
1 90a 6908353980
1 90a 2608306311
1 90a 1202469600
1 90a 7004428315
1 90b 6007921343
1 90b 1109884820
1 90b 4808096679
1 90b 7502460087
1 90b 4600996173
1 90b 3600141100
1 90b 1800700568
1 90b 4807914657
1 90b 5604150088
1 90b 1202552453
1 90c 1108650741
1 90c 2409883292
1 90c 9809203743
1 90c 9107374716
1 90c 9300810483
1 90c 3003807473
1 90c 6302158174
1 90c 9300806566
1 90c 6501968684
1 90c 3402348480
1 90d 1608731481
1 90d 6002745576
1 90d 2902605923
1 90d 5501004432
1 90d 3700522930
1 90d 9605475943
1 90d 2709470223
1 90d 2300181597
1 90d 6006481783
1 90d 6809869790
1 90e 8906611386
1 90e 2907473322
1 90e 1802455627
1 90e 4103643686
1 90e 5305000373
1 90e 5103700163
1 90e 4004713570
1 90e 1501649824
1 90e 3707699085
1 90e 4404296443
1 90a 5916964877
1 90a 6516134785
1 90a 4617597339
1 90a 5013864405
1 90a 8415246458
1 90a 5919613692
1 90a 3811576291
1 90a 2419877177
1 90a 9510128945
1 90a 8313334791
1 90b 4815219673
1 90b 5119289337
1 90b 3017760510
1 90b 9618996980
1 90b 6710087335
1 90b 2310197610
1 90b 8619100250
1 90b 4119463027
1 90b 3117575496
1 90b 9417328928
1 90c 4913390441
1 90c 3516920776
1 90c 4510957036
1 90c 9714532363
1 90c 7316582006
1 90c 1212667921
1 90c 9718976536
1 90c 1818982452
1 90c 1514714190
1 90c 2714235130
1 90d 8111061140
1 90d 6417987304
1 90d 6013084526
1 90d 1218653113
1 90d 9213485606
1 90d 3115580676
1 90d 6513566930
1 90d 8417729262
1 90d 1818286021
1 90d 5916867643
1 90e 9016289753
1 90e 6510577421
1 90e 7117251330
1 90e 4719421173
1 90e 2717868812
1 90e 3514894619
1 90e 5419485963
1 90e 3017583353
1 90e 3013102202
1 90e 4410410712
1 90a 8026142990
1 90a 5027641702
1 90a 3028604371
1 90a 9927871767
1 90a 7225499364
1 90a 7029527621
1 90a 7225138043
1 90a 9129285334
1 90a 2228910790
1 90a 4525958164
1 90b 3920819026
1 90b 6822670596
1 90b 9925764442
1 90b 5328085812
1 90b 5821073326
1 90b 2529707139
1 90b 8422637769
1 90b 2327513083
1 90b 9125226688
1 90b 6623158747
1 90c 7321876373
1 90c 4527426810
1 90c 4323207451
1 90c 8920946402
1 90c 4128909241
1 90c 6029945004
1 90c 3627130313
1 90c 3923145653
1 90c 4122983552
1 90c 7723186611
1 90d 8027405472
1 90d 7826739955
1 90d 8124292737
1 90d 8423622593
1 90d 1126460917
1 90d 3323629405
1 90d 3322034638
1 90d 1725695672
1 90d 7121474882
1 90d 8327124304
1 90e 9426342981
1 90e 3929772154
1 90e 1029596174
1 90e 9828265737
1 90e 4120069048
1 90e 2429341090
1 90e 3923098287
1 90e 1129005836
1 90e 7520665870
1 90e 3023189200
1 90a 4235182450
1 90a 2434886585
1 90a 2031549162
1 90a 7938762848
1 90a 4434795539
1 90a 7133720411
1 90a 7638332274
1 90a 9030275905
1 90a 9430086533
1 90a 6335085144
1 90b 8630053805
1 90b 8937897060
1 90b 7937256064
1 90b 4237805670
1 90b 9431305693
1 90b 6234790923
1 90b 5138474037
1 90b 4838630705
1 90b 5435563366
1 90b 8439832057
1 90c 8636152386
1 90c 8834899310
1 90c 7039975580
1 90c 3136000650
1 90c 5936495041
1 90c 2537501450
1 90c 9538714240
1 90c 5238861532
1 90c 8233775755
1 90c 7632007916
1 90d 3530152630
1 90d 6532786124
1 90d 6330369282
1 90d 7531708275
1 90d 5830332394
1 90d 4537613375
1 90d 7737243601
1 90d 1632721364
1 90d 8032321094
1 90d 7832615505
1 90e 3831506090
1 90e 8832697253
1 90e 4235203208
1 90e 2635420084
1 90e 9336508129
1 90e 6431273178
1 90e 1233451683
1 90e 2238452277
1 90e 5132579427
1 90e 5233223834
1 90a 9848174970
1 90a 2946335411
1 90a 5447291817
1 90a 7242128250
1 90a 2542618850
1 90a 6641321447
1 90a 4244239652
1 90a 5040282120
1 90a 9143961621
1 90a 7740546267
1 90b 7949359696
1 90b 7149858897
1 90b 2944406848
1 90b 7942788171
1 90b 8542860166
1 90b 9540530409
1 90b 6347748544
1 90b 2944788040
1 90b 2247278017
1 90b 9246010090
1 90c 7942130352
1 90c 7242897624
1 90c 6747641212
1 90c 6345223384
1 90c 3443729386
1 90c 5747074133
1 90c 8543594576
1 90c 6544235041
1 90c 4641635985
1 90c 3949111440
1 90d 4749963985
1 90d 3640924042
1 90d 9148438926
1 90d 3342144433
1 90d 4445110778
1 90d 5749632183
1 90d 7148863325
1 90d 8543083165
1 90d 9045241771
1 90d 2042059951
1 90e 6441638843
1 90e 5646012063
1 90e 6746900036
1 90e 1646110172
1 90e 4544780214
1 90e 9647913245
1 90e 5449514887
1 90e 8541566557
1 90e 1344250217
1 90e 7448614869
1 90a 1452987600
1 90a 4953018792
1 90a 8950051136
1 90a 6551342410
1 90a 8153007081
1 90a 4355722624
1 90a 7858629536
1 90a 3358678693
1 90a 1355336945
1 90a 2857313837
1 90b 3154519278
1 90b 4558526541
1 90b 4358962139
1 90b 8357916145
1 90b 8055418323
1 90b 2454641359
1 90b 5651205214
1 90b 8455234230
1 90b 2154282456
1 90b 1153553832
1 90c 5455183512
1 90c 8052788590
1 90c 4155356251
1 90c 8258190454
1 90c 6653675994
1 90c 1555600850
1 90c 4754750676
1 90c 9353647506
1 90c 3954941923
1 90c 6457427442
1 90d 7253414600
1 90d 1555581737
1 90d 2054392756
1 90d 8755626951
1 90d 1952204851
1 90d 4159997210
1 90d 9759103796
1 90d 1254856854
1 90d 4754224153
1 90d 3456115654
1 90e 4858936255
1 90e 6251629199
1 90e 1255825713
1 90e 8254604951
1 90e 4351381765
1 90e 6552114885
1 90e 5059380569
1 90e 5454174087
1 90e 6056929888
1 90e 4051244731
1 90a 4864218264
1 90a 4261562622
1 90a 6160050547
1 90a 1660536040
1 90a 9967852886
1 90a 6862140187
1 90a 3766294774
1 90a 9564015150
1 90a 6563296016
1 90a 8760663948
1 90b 5460503835
1 90b 9563090417
1 90b 2766256064
1 90b 8369048518
1 90b 2266634506
1 90b 4068314919
1 90b 1061564427
1 90b 6764494070
1 90b 3567624578
1 90b 1461179256
1 90c 3461117340
1 90c 5360088640
1 90c 3761182296
1 90c 9069443336
1 90c 5368904673
1 90c 1562612696
1 90c 3765734685
1 90c 5161317075
1 90c 8069428194
1 90c 8366587046
1 90d 5763659635
1 90d 1269696352
1 90d 2165687450
1 90d 6162747236
1 90d 2369511590
1 90d 7265006028
1 90d 4764385328
1 90d 9960908515
1 90d 5668943418
1 90d 3367109190
1 90e 2366362335
1 90e 6161935786
1 90e 8763217613
1 90e 4760099623
1 90e 2061046012
1 90e 7865265894
1 90e 7865269052
1 90e 7267936742
1 90e 5565666753
1 90e 4864278730
1 90a 8977806515
1 90a 6877808534
1 90a 2370677175
1 90a 7872176360
1 90a 5772328542
1 90a 1478208310
1 90a 8276313272
1 90a 1777699034
1 90a 1477058802
1 90a 5871098292
1 90b 8470917664
1 90b 4379962562
1 90b 8073670359
1 90b 5276492817
1 90b 8371095516
1 90b 7078027413
1 90b 2073155004
1 90b 9971775347
1 90b 7479830305
1 90b 7079772399
1 90c 4774362940
1 90c 2770148632
1 90c 6676254073
1 90c 4071441256
1 90c 7276133725
1 90c 2279982846
1 90c 6870777576
1 90c 3871587391
1 90c 3575257415
1 90c 2077706221
1 90d 4879970172
1 90d 7170948732
1 90d 3378867416
1 90d 8079708031
1 90d 7476086170
1 90d 5671846583
1 90d 2074743591
1 90d 7573397608
1 90d 9477810853
1 90d 8272218516
1 90e 7673754409
1 90e 7175863648
1 90e 2978957657
1 90e 4572039439
1 90e 4779329343
1 90e 3371308305
1 90e 7674377003
1 90e 5875339631
1 90e 3878771099
1 90e 7570176398
1 90a 4484399498
1 90a 4285717191
1 90a 4382457911
1 90a 4588493090
1 90a 2483635651
1 90a 4983171515
1 90a 8789952071
1 90a 6183254313
1 90a 4486726437
1 90a 1581715194
1 90b 1685415332
1 90b 6887010430
1 90b 2989944300
1 90b 9785825360
1 90b 4583157112
1 90b 2086021148
1 90b 8382367567
1 90b 2988285528
1 90b 4487830275
1 90b 1484228516
1 90c 1388464723
1 90c 8488541474
1 90c 1982571473
1 90c 5281492472
1 90c 4884566352
1 90c 2480453764
1 90c 2384398185
1 90c 2983956756
1 90c 7887191314
1 90c 1285571353
1 90d 9786955058
1 90d 2786924772
1 90d 3386096636
1 90d 1384207808
1 90d 1589665556
1 90d 6186728963
1 90d 8687123243
1 90d 5280490555
1 90d 7081583195
1 90d 2987647185
1 90e 1689250209
1 90e 6784781444
1 90e 8884993073
1 90e 1381540783
1 90e 6383978827
1 90e 9289912677
1 90e 1186496580
1 90e 6389502048
1 90e 1783682824
1 90e 3681150160
1 90a 3740597139
1 90a 7170295418
1 90a 8350771503
1 90a 2800455555
1 90a 7670188573
1 90a 4070347795
1 90a 4220816264
1 90a 9900654787
1 90a 7500637777
1 90a 3780966061
1 90b 5040740365
1 90b 3740598887
1 90b 3160880132
1 90b 3350515825
1 90b 7450441350
1 90b 8070894583
1 90b 8950284726
1 90b 6920810550
1 90b 9320960853
1 90b 1350525740
1 90c 5150645152
1 90c 7510034492
1 90c 9540730784
1 90c 3630556180
1 90c 5500714062
1 90c 5200666113
1 90c 4730725671
1 90c 3560041526
1 90c 9630906401
1 90c 5570447872
1 90d 6360425747
1 90d 8870035375
1 90d 8980318835
1 90d 5330965256
1 90d 6430853751
1 90d 7570013561
1 90d 2650074928
1 90d 6610901427
1 90d 3360165607
1 90d 9060272470
1 90e 2270535669
1 90e 9700800997
1 90e 5510968141
1 90e 1120176926
1 90e 5560395427
1 90e 2440626484
1 90e 2460752297
1 90e 5400737968
1 90e 8770648511
1 90e 7860807232
1 90a 1921926004
1 90a 4621596578
1 90a 5931358782
1 90a 9611447904
1 90a 7271287664
1 90a 5641085956
1 90a 1311968556
1 90a 9481926454
1 90a 6551321099
1 90a 2911425722
1 90b 7641270318
1 90b 5341172049
1 90b 6871720429
1 90b 9901996068
1 90b 4921194417
1 90b 8751941859
1 90b 4421291439
1 90b 5741989100
1 90b 6371950262
1 90b 2481237485
1 90c 5511327425
1 90c 3851916086
1 90c 6611457553
1 90c 8101396991
1 90c 2901190582
1 90c 8721719272
1 90c 3241406972
1 90c 1431613935
1 90c 6111691970
1 90c 7811168482
1 90d 5471681756
1 90d 2771208707
1 90d 4621091046
1 90d 3231899906
1 90d 6681520987
1 90d 2891684234
1 90d 8571229824
1 90d 2841372027
1 90d 4401348010
1 90d 5301222785
1 90e 1241138520
1 90e 9981668460
1 90e 7481024307
1 90e 7941404509
1 90e 7211749856
1 90e 3271170580
1 90e 1541227688
1 90e 7451626153
1 90e 5011449795
1 90e 6331985442
1 90a 9602930706
1 90a 9152914794
1 90a 2812381370
1 90a 8562715503
1 90a 7842890224
1 90a 7352544580
1 90a 5312767058
1 90a 3682385392
1 90a 3402572664
1 90a 9622977249
1 90b 1852001643
1 90b 1762908037
1 90b 7932771716
1 90b 6002063100
1 90b 3922611751
1 90b 6482787914
1 90b 4042275654
1 90b 8712295256
1 90b 4502201820
1 90b 9332858838
1 90c 9772182412
1 90c 1532411300
1 90c 8482296854
1 90c 7942089160
1 90c 5812375445
1 90c 6522452111
1 90c 7432741310
1 90c 8362868926
1 90c 6062143670
1 90c 6802742700
1 90d 9902872421
1 90d 7302817803
1 90d 4972149520
1 90d 7052544914
1 90d 6322515373
1 90d 6212748662
1 90d 3162646456
1 90d 6052805361
1 90d 1482403633
1 90d 6982762853
1 90e 3722398372
1 90e 4462362682
1 90e 9762147399
1 90e 1062744830
1 90e 4872902214
1 90e 4422863838
1 90e 8372099871
1 90e 1982296849
1 90e 5162541971
1 90e 5852491415
1 90a 4923928020
1 90a 3423463800
1 90a 5403521419
1 90a 9723855708
1 90a 4783562441
1 90a 3863756157
1 90a 9633639061
1 90a 6843505553
1 90a 4473221709
1 90a 2913440990
1 90b 7903084042
1 90b 5223824674
1 90b 8543122874
1 90b 4983123080
1 90b 2883941069
1 90b 6133443140
1 90b 9463429465
1 90b 4263799599
1 90b 3373762814
1 90b 1333667250
1 90c 1883999292
1 90c 2373092726
1 90c 5303413225
1 90c 8233779424
1 90c 3363424954
1 90c 6303259905
1 90c 4103130174
1 90c 7813039574
1 90c 7353655282
1 90c 1883932890
1 90d 6363001946
1 90d 9753875443
1 90d 8733920787
1 90d 6813933374
1 90d 1953438261
1 90d 6443657342
1 90d 6883154275
1 90d 7833100522
1 90d 7413042210
1 90d 6803235097
1 90e 6213035106
1 90e 9133132382
1 90e 5733104688
1 90e 7153281816
1 90e 4263392960
1 90e 5903738809
1 90e 4203108416
1 90e 6053286212
1 90e 5743262288
1 90e 9123145541
1 90a 5814830229
1 90a 1424002369
1 90a 5314898753
1 90a 9444957601
1 90a 6904083164
1 90a 4724512375
1 90a 8514138970
1 90a 8124040805
1 90a 1684048369
1 90a 4184477197
1 90b 9874886912
1 90b 2154542105
1 90b 6644393134
1 90b 9524508063
1 90b 5054914886
1 90b 6384303011
1 90b 3834418935
1 90b 1664679410
1 90b 6384095141
1 90b 9334358347
1 90c 3074994913
1 90c 8334720333
1 90c 6024092340
1 90c 9204819033
1 90c 7364398220
1 90c 4564348700
1 90c 2364495822
1 90c 1664113284
1 90c 8204312871
1 90c 6634125304
1 90d 3074827750
1 90d 4034257048
1 90d 1264740618
1 90d 4754786198
1 90d 9584314363
1 90d 2274776761
1 90d 1064093663
1 90d 9614712584
1 90d 9114486498
1 90d 3224500330
1 90e 7324881442
1 90e 3304784042
1 90e 1014347858
1 90e 8344838047
1 90e 7704702218
1 90e 8334695306
1 90e 8154686818
1 90e 7864889876
1 90e 2424546872
1 90e 3484878704
1 90a 7665712254
1 90a 1085477751
1 90a 6755442494
1 90a 2155429943
1 90a 2225102952
1 90a 6835207266
1 90a 2105726263
1 90a 2225578043
1 90a 5125245028
1 90a 3035727880
1 90b 8275599166
1 90b 4325464635
1 90b 4175347906
1 90b 2355192538
1 90b 9735031925
1 90b 7505237698
1 90b 8145497215
1 90b 6535029653
1 90b 4225694274
1 90b 1455794384
1 90c 5215938774
1 90c 2165922102
1 90c 1145981715
1 90c 3205090453
1 90c 9985740361
1 90c 8235985914
1 90c 5475894003
1 90c 4885088582
1 90c 8665056835
1 90c 5465209844
1 90d 6865188425
1 90d 2825317352
1 90d 6625499425
1 90d 6735531735
1 90d 6755408526
1 90d 2145126338
1 90d 2575793471
1 90d 9625626821
1 90d 3045927015
1 90d 6425539600
1 90e 5835590754
1 90e 3575826985
1 90e 7135832312
1 90e 2575379570
1 90e 5135774910
1 90e 4285684200
1 90e 4015835895
1 90e 8285942921
1 90e 8375054643
1 90e 7385421743
1 90a 7906820840
1 90a 2276992250
1 90a 3206186050
1 90a 8046876706
1 90a 4916672256
1 90a 7236803121
1 90a 5446289959
1 90a 2866321305
1 90a 2756454739
1 90a 8616341705
1 90b 3816677531
1 90b 6326390216
1 90b 1856140325
1 90b 3806095141
1 90b 3936204323
1 90b 8836642169
1 90b 5436359920
1 90b 9616428256
1 90b 1176193550
1 90b 1626681750
1 90c 8016945631
1 90c 6336720186
1 90c 7346774141
1 90c 8566113906
1 90c 2566643605
1 90c 4966063603
1 90c 5916624933
1 90c 1846070046
1 90c 5486911762
1 90c 9206793053
1 90d 2806856246
1 90d 5386080987
1 90d 6376209866
1 90d 8086285406
1 90d 2376494313
1 90d 3526881104
1 90d 3626633463
1 90d 4846856376
1 90d 8386566347
1 90d 8126005867
1 90e 9646868747
1 90e 6966212481
1 90e 1906119075
1 90e 8016300525
1 90e 2546014803
1 90e 5946697914
1 90e 2046597031
1 90e 9716177453
1 90e 8056593625
1 90e 2356043977
1 90a 8627916264
1 90a 5987064284
1 90a 8447356226
1 90a 9437261349
1 90a 7907383258
1 90a 5427716494
1 90a 1127550278
1 90a 3127586973
1 90a 6457262809
1 90a 3617683910
1 90b 3097034401
1 90b 9897889040
1 90b 5597154644
1 90b 6047509094
1 90b 8477866067
1 90b 7077690201
1 90b 7647427349
1 90b 5727966002
1 90b 6377160407
1 90b 4117355089
1 90c 2287941923
1 90c 4017545031
1 90c 4987067091
1 90c 1467611414
1 90c 9527311055
1 90c 2747599604
1 90c 2437482961
1 90c 2087460002
1 90c 9607130986
1 90c 7447127431
1 90d 5837539285
1 90d 3167221456
1 90d 1217821634
1 90d 7347271458
1 90d 6377914136
1 90d 2557454672
1 90d 5987747674
1 90d 3387140601
1 90d 5417570834
1 90d 1077914655
1 90e 4877431255
1 90e 6807380501
1 90e 8457281866
1 90e 5557261222
1 90e 4957530966
1 90e 1397210196
1 90e 8047313338
1 90e 7227077314
1 90e 1337993437
1 90e 8387773152
1 90a 9868272140
1 90a 3928469563
1 90a 7328747210
1 90a 2308159076
1 90a 1108166641
1 90a 8838825521
1 90a 2088267855
1 90a 8238377120
1 90a 1228728801
1 90a 6728127190
1 90b 2528992100
1 90b 9888064416
1 90b 8348695858
1 90b 3008226017
1 90b 9238161691
1 90b 7018493708
1 90b 1288075949
1 90b 1118186597
1 90b 3748438022
1 90b 6358375683
1 90c 4368242002
1 90c 1668207613
1 90c 6708069646
1 90c 7578318956
1 90c 4228175300
1 90c 2028898980
1 90c 3268187862
1 90c 7378305163
1 90c 7368134624
1 90c 6358423073
1 90d 5558145998
1 90d 2948886143
1 90d 1218203385
1 90d 3078634508
1 90d 4608571003
1 90d 5168799425
1 90d 2338192491
1 90d 5098280473
1 90d 2178811363
1 90d 4788403593
1 90e 9928402214
1 90e 9518725525
1 90e 8558928004
1 90e 9178357576
1 90e 6438642323
1 90e 6708673203
1 90e 5558356908
1 90e 5508430322
1 90e 3138758584
1 90e 5678204644
1 91a 4475275316
1 91a 6915558403
1 91a 6994113748
1 91a 6571980846
1 91a 2541939708
1 91a 1698656078
1 91a 7551614782
1 91a 4422058176
1 91a 7051131658
1 91a 5655730931
1 91b 3397064852
1 91b 3631676242
1 91b 4040012417
1 91b 7609031701
1 91b 5511672607
1 91b 8783339418
1 91b 1008830754
1 91b 4465593873
1 91b 4280026794
1 91b 2625153021
1 91c 4587320591
1 91c 8444271415
1 91c 9442932098
1 91c 5827463948
1 91c 9042639788
1 91c 1759824498
1 91c 6400358270
1 91c 9719020187
1 91c 8146211552
1 91c 3531195704
1 92 2247785713
1 92 5974242431
1 92 1315527162
1 92 7241516342
1 92 4328993906
1 92 4474037828
1 92 6730042013
1 92 9755002742
1 92 4983214927
1 92 9667086278
1 93a 6293837345
1 93a 2629005619
1 93a 1779201247
1 93a 9340979336
1 93a 7583291529
1 93a 4510451044
1 93a 2188124278
1 93a 5540656272
1 93a 9605780150
1 93a 2996346989
1 93b 0000684090
1 93b 0000952796
1 93b 0000245844
1 93b 0000565636
1 93b 0000567329
1 93b 0000679283
1 93b 0000193151
1 93b 0000958883
1 93b 0000700177
1 93b 0000426997
1 93c 8575658913
1 93c 2942525607
1 93c 2030745012
1 93c 6046235128
1 93c 4596722035
1 93c 1774733410
1 93c 2981928813
1 93c 2440945151
1 93c 7000702989
1 93c 1649914673
1 93d 0000356525
1 93d 0000925190
1 93d 0000152846
1 93d 0000633696
1 93d 0000728530
1 93d 0000684084
1 93d 0000414341
1 93d 0000781060
1 93d 0000319886
1 93d 0000996935
1 94 3981119783
1 94 5189734900
1 94 9956099989
1 94 2563129127
1 94 4461960516
1 94 9982617531
1 94 6478324154
1 94 7926561509
1 94 9686288331
1 94 4668077963
2 95 0001783710
2 95 0001460870
2 95 0001318377
2 95 0001818561
2 95 0001702070
2 95 0001344265
2 95 0001083407
2 95 0001832918
2 95 0001512053
2 95 0001055702
2 95 0009275352
2 95 0009459541
2 95 0009409139
2 95 0009682470
2 95 0009474009
2 95 0009136479
2 95 0009583884
2 95 0009554390
2 95 0009341147
2 95 0009888549
2 95 0015022882
2 95 0017966209
2 95 0010087920
2 95 0015975934
2 95 0013606406
2 95 0018664747
2 95 0013220947
2 95 0016950143
2 95 0011149153
2 95 0016195604
2 95 0020306580
2 95 0020742299
2 95 0020460123
2 95 0020877779
2 95 0020502509
2 95 0020295619
2 95 0020741020
2 95 0020443540
2 95 0020076027
2 95 0020990768
2 95 0021993743
2 95 0021766927
2 95 0021796166
2 95 0021600423
2 95 0021841960
2 95 0021975385
2 95 0021152791
2 95 0021207479
2 95 0021427226
2 95 0021155680
2 95 0022804846
2 95 0022966356
2 95 0022538594
2 95 0022957788
2 95 0022209098
2 95 0022326271
2 95 0022105302
2 95 0022280989
2 95 0022993571
2 95 0022160982
2 95 0023163917
2 95 0023376952
2 95 0023131903
2 95 0023922252
2 95 0023841281
2 95 0023586580
2 95 0023486316
2 95 0023595954
2 95 0023902670
2 95 0023020405
2 95 0024927217
2 95 0024940817
2 95 0024693776
2 95 0024122930
2 95 0024893052
2 95 0024185930
2 95 0024099679
2 95 0024870089
2 95 0024257535
2 95 0024074308
2 95 0025756375
2 95 0025209929
2 95 0025272218
2 95 0025060231
2 95 0025936579
2 95 0025270899
2 95 0025364666
2 95 0025633938
2 95 0025389058
2 95 0025847894
2 95 0396179190
2 95 0396858492
2 95 0396937057
2 95 0396589627
2 95 0396711450
2 95 0396132813
2 95 0396137603
2 95 0396542285
2 95 0396259149
2 95 0396818586
2 95 0397832735
2 95 0397108687
2 95 0397726095
2 95 0397206834
2 95 0397946237
2 95 0397451922
2 95 0397147454
2 95 0397416128
2 95 0397455324
2 95 0397833363
2 95 0398479467
2 95 0398122632
2 95 0398166531
2 95 0398215565
2 95 0398244688
2 95 0398750528
2 95 0398341112
2 95 0398387619
2 95 0398330468
2 95 0398220021
2 95 0399123170
2 95 0399163469
2 95 0399429959
2 95 0399991414
2 95 0399838272
2 95 0399787612
2 95 0399494556
2 95 0399786333
2 95 0399171647
2 95 0399498793
2 95 0447014061
2 95 0461085413
2 95 0415693206
2 95 0430055423
2 95 0455285468
2 95 0427635637
2 95 0446766195
2 95 0416166176
2 95 0418249176
2 95 0435970866
2 95 0764171519
2 95 0760355582
2 95 0798031259
2 95 0774733401
2 95 0712370394
2 95 0756414793
2 95 0769162375
2 95 0777455204
2 95 0718908755
2 95 0739349919
1 95 3820914871
1 95 8057246341
1 95 4859711583
1 95 4317218686
1 95 8850116602
1 95 1890739314
1 95 5575150057
1 95 9081550635
1 95 8949366783
1 95 7877478186
1 96a 7659526054
1 96a 8157956566
1 96a 1306560789
1 96a 8250045764
1 96a 5629322240
1 96a 9137714051
1 96a 9111925241
1 96a 8382303566
1 96a 1182279897
1 96a 3885618588
1 96b 1593306119
1 96b 2038758880
1 96b 1073155705
1 96b 7466939977
1 96b 2080242171
1 96b 9722281137
1 96b 5029760732
1 96b 3712360209
1 96b 8275808551
1 96b 5424021938
2 96c 0001322279
2 96c 0001304463
2 96c 0001339998
2 96c 0001362548
2 96c 0001329225
2 96c 0001367282
2 96c 0001367512
2 96c 0001388077
2 96c 0001396267
2 96c 0001307921
2 96c 0001481546
2 96c 0001445981
2 96c 0001458190
2 96c 0001416146
2 96c 0001422568
2 96c 0001441471
2 96c 0001422043
2 96c 0001444147
2 96c 0001403208
2 96c 0001419685
2 96c 0001580359
2 96c 0001530083
2 96c 0001538020
2 96c 0001556598
2 96c 0001519606
2 96c 0001587190
2 96c 0001598887
2 96c 0001510855
2 96c 0001538976
2 96c 0001507296
2 96c 0001699277
2 96c 0001657579
2 96c 0001609448
2 96c 0001665582
2 96c 0001687005
2 96c 0001622128
2 96c 0001689314
2 96c 0001610606
2 96c 0001640202
2 96c 0001602518
2 96c 0001734513
2 96c 0001758951
2 96c 0001753951
2 96c 0001765375
2 96c 0001780838
2 96c 0001722593
2 96c 0001787590
2 96c 0001788104
2 96c 0001709249
2 96c 0001761781
2 96c 0001801298
2 96c 0001803550
2 96c 0001812331
2 96c 0001868608
2 96c 0001863388
2 96c 0001827798
2 96c 0001854012
2 96c 0001829262
2 96c 0001893594
2 96c 0001888743
2 96c 0001970964
2 96c 0001934562
2 96c 0001975765
2 96c 0001903794
2 96c 0001966994
2 96c 0001962578
2 96c 0001976325
2 96c 0001990429
2 96c 0001952043
2 96c 0001917409
2 96c 0002852193
2 96c 0002714389
2 96c 0002723612
2 96c 0002408394
2 96c 0002165149
2 96c 0002775565
2 96c 0002717339
2 96c 0002815418
2 96c 0002532858
2 96c 0002403756
2 96c 0003927073
2 96c 0003449729
2 96c 0003711881
2 96c 0003609851
2 96c 0003369418
2 96c 0003411977
2 96c 0003730608
2 96c 0003721228
2 96c 0003761298
2 96c 0003310365
2 96c 0004353835
2 96c 0004275636
2 96c 0004825401
2 96c 0004828011
2 96c 0004001035
2 96c 0004291481
2 96c 0004835088
2 96c 0004088042
2 96c 0004956938
2 96c 0004971246
2 96c 0005602576
2 96c 0005483381
2 96c 0005878407
2 96c 0005048043
2 96c 0005852076
2 96c 0005219056
2 96c 0005752767
2 96c 0005699484
2 96c 0005502033
2 96c 0005619789
2 96c 0006657458
2 96c 0006514884
2 96c 0006657737
2 96c 0006754421
2 96c 0006850986
2 96c 0006079915
2 96c 0006438307
2 96c 0006820795
2 96c 0006113219
2 96c 0006227061
2 96c 0007684137
2 96c 0007609691
2 96c 0007810215
2 96c 0007118727
2 96c 0007528205
2 96c 0007930230
2 96c 0007087249
2 96c 0007886658
2 96c 0007341980
2 96c 0007038451
2 96c 0008995471
2 96c 0008528083
2 96c 0008100809
2 96c 0008204150
2 96c 0008624822
2 96c 0008468215
2 96c 0008079656
2 96c 0008426201
2 96c 0008596397
2 96c 0008564923
2 96c 0009321137
2 96c 0009880714
2 96c 0009197961
2 96c 0009066069
2 96c 0009687579
2 96c 0009380324
2 96c 0009039517
2 96c 0009777334
2 96c 0009979593
2 96c 0009039583
2 96c 0010011320
2 96c 0010875235
2 96c 0010172857
2 96c 0010123073
2 96c 0010266427
2 96c 0010339153
2 96c 0010271845
2 96c 0010489298
2 96c 0010500851
2 96c 0010080870
2 96c 0020743299
2 96c 0020169414
2 96c 0020679381
2 96c 0020732812
2 96c 0020363634
2 96c 0020882408
2 96c 0020254487
2 96c 0020864486
2 96c 0020867157
2 96c 0020387046
2 96c 0030542844
2 96c 0030113913
2 96c 0030652415
2 96c 0030985655
2 96c 0030163909
2 96c 0030555448
2 96c 0030397469
2 96c 0030056416
2 96c 0030044235
2 96c 0030438295
2 96c 0040506204
2 96c 0040411401
2 96c 0040582394
2 96c 0040020223
2 96c 0040385957
2 96c 0040439474
2 96c 0040523243
2 96c 0040601906
2 96c 0040664368
2 96c 0040161578
2 96c 0050523431
2 96c 0050058622
2 96c 0050375441
2 96c 0050680459
2 96c 0050540339
2 96c 0050646831
2 96c 0050056332
2 96c 0050995857
2 96c 0050549103
2 96c 0050701001
2 96c 0060537327
2 96c 0060356865
2 96c 0060451614
2 96c 0060201212
2 96c 0060475124
2 96c 0060110421
2 96c 0060408038
2 96c 0060155640
2 96c 0060481323
2 96c 0060385350
2 96c 0070424149
2 96c 0070698319
2 96c 0070750516
2 96c 0070048610
2 96c 0070552878
2 96c 0070441626
2 96c 0070846861
2 96c 0070322923
2 96c 0070873920
2 96c 0070760391
2 96c 0080842068
2 96c 0080626738
2 96c 0080879007
2 96c 0080449270
2 96c 0080208082
2 96c 0080713044
2 96c 0080376128
2 96c 0080592319
2 96c 0080614071
2 96c 0080468945
2 96c 0090503416
2 96c 0090664359
2 96c 0090762340
2 96c 0090014179
2 96c 0090651331
2 96c 0090222033
2 96c 0090660076
2 96c 0090496193
2 96c 0090745910
2 96c 0090027465
2 96c 0091669379
2 96c 0091048961
2 96c 0091475863
2 96c 0091694044
2 96c 0091684495
2 96c 0091615828
2 96c 0091486963
2 96c 0091074263
2 96c 0091022585
2 96c 0091475380
2 96c 0092983353
2 96c 0092433808
2 96c 0092216217
2 96c 0092493871
2 96c 0092900749
2 96c 0092486077
2 96c 0092331478
2 96c 0092300651
2 96c 0092776858
2 96c 0092726173
2 96c 0093388308
2 96c 0093044515
2 96c 0093430610
2 96c 0093635421
2 96c 0093973026
2 96c 0093007204
2 96c 0093006813
2 96c 0093410584
2 96c 0093243597
2 96c 0093321896
2 96c 0094378914
2 96c 0094554739
2 96c 0094623223
2 96c 0094143808
2 96c 0094800721
2 96c 0094627363
2 96c 0094387347
2 96c 0094099171
2 96c 0094104979
2 96c 0094611803
2 96c 0095102229
2 96c 0095133955
2 96c 0095891252
2 96c 0095272575
2 96c 0095444192
2 96c 0095574654
2 96c 0095948828
2 96c 0095024903
2 96c 0095531306
2 96c 0095534833
2 96c 0096247524
2 96c 0096384954
2 96c 0096043271
2 96c 0096357844
2 96c 0096608369
2 96c 0096040631
2 96c 0096964503
2 96c 0096429473
2 96c 0096172645
2 96c 0096210419
2 96c 0097480157
2 96c 0097366035
2 96c 0097230923
2 96c 0097383422
2 96c 0097094030
2 96c 0097584098
2 96c 0097156149
2 96c 0097855605
2 96c 0097316859
2 96c 0097444086
2 96c 0098728376
2 96c 0098917614
2 96c 0098533398
2 96c 0098822978
2 96c 0098980621
2 96c 0098126944
2 96c 0098196603
2 96c 0098637308
2 96c 0098100996
2 96c 0098810326
1 96c 0099854619
2 96c 0099185665
2 96c 0099071240
2 96c 0099153842
1 96c 0099940442
2 96c 0099084827
1 96c 0099750287
1 96c 0099755637
1 96c 0099819171
2 96c 0099044267
2 96c 0099169193
2 96c 0099137520
2 96c 0099137808
2 96c 0099135958
2 96c 0099141853
2 96c 0099105847
2 96c 0099139708
2 96c 0099126285
2 96c 0099169347
2 96c 0099146440
2 96c 0099267315
2 96c 0099220147
2 96c 0099225946
2 96c 0099239355
2 96c 0099246462
2 96c 0099247345
2 96c 0099272102
2 96c 0099262682
2 96c 0099263839
2 96c 0099285374
2 96c 0099349469
2 96c 0099314832
2 96c 0099398879
2 96c 0099308768
2 96c 0099364760
2 96c 0099394262
2 96c 0099342504
2 96c 0099356920
2 96c 0099351338
2 96c 0099341393
1 97 0000060368
1 97 0000091278
1 97 0000064119
1 97 0000073205
1 97 0000022220
1 97 0000015730
1 97 0000048598
1 97 0000086240
1 97 0000097449
1 97 0000057178
1 97 0000856350
1 97 0000785081
1 97 0000950170
1 97 0000460053
1 97 0000399102
1 97 0000559196
1 97 0000471526
1 97 0000378862
1 97 0000950972
1 97 0000819786
1 97 0003520231
1 97 0002107490
1 97 0001937122
1 97 0002197613
1 97 0006284333
1 97 0009195208
1 97 0002398517
1 97 0005797099
1 97 0005100458
1 97 0008552566
1 97 0076048380
1 97 0070170375
1 97 0090500718
1 97 0042910527
1 97 0032464894
1 97 0034917179
1 97 0067497782
1 97 0082127309
1 97 0067998678
1 97 0085591913
1 97 0555382784
1 97 0476693921
1 97 0943272946
1 97 0679181184
1 97 0859636558
1 97 0592433534
1 97 0894653023
1 97 0192658280
1 97 0385237534
1 97 0678803224
1 97 5890977939
1 97 1948311750
1 97 7971927799
1 97 5396791928
1 97 7844305139
1 97 7087749570
1 97 5514409824
1 97 9070956730
1 97 1196917238
1 97 2238070330
1 98a 5758864562
1 98a 5585384839
1 98a 4389523926
1 98a 1750920314
1 98a 3742819420
1 98a 4641151312
1 98a 1407716665
1 98a 1885913657
1 98a 3512012501
1 98a 9759144599
1 98b 8471186361
1 98b 9606984932
1 98b 6066820859
1 98b 1185598443
1 98b 8651768883
1 98b 3428538247
1 98b 1149210563
1 98b 2801468162
1 98b 8664421280
1 98b 2011475711
1 99 9633960540
1 99 2764843722
1 99 1483083854
1 99 1682964223
1 99 3255682686
1 99 3047296306
1 99 8810383144
1 99 6038838685
1 99 8603650795
1 99 5989370911
1 99 0396565646
1 99 0396540867
1 99 0396977392
1 99 0396454881
1 99 0396537558
1 99 0396632918
1 99 0396313162
1 99 0396464410
1 99 0396081373
1 99 0396711949
1 99 0397938758
1 99 0397604729
1 99 0397784824
1 99 0397024395
1 99 0397595589
1 99 0397217153
1 99 0397421617
1 99 0397631899
1 99 0397448603
1 99 0397589846
1 99 0398558000
1 99 0398691046
1 99 0398080478
1 99 0398897536
1 99 0398599082
1 99 0398341081
1 99 0398185902
1 99 0398518179
1 99 0398410697
1 99 0398714222
1 99 0399038631
1 99 0399605932
1 99 0399658455
1 99 0399585939
1 99 0399877337
1 99 0399338288
1 99 0399587080
1 99 0399329525
1 99 0399392975
1 99 0399573709
1 99 0445955203
1 99 0447020244
1 99 0458881817
1 99 0464707210
1 99 0449779650
1 99 0491396775
1 99 0480110996
1 99 0464095651
1 99 0438965026
1 99 0485011110
1 a0 9792155660
1 a0 8989305349
1 a0 3620261850
1 a0 5683034260
1 a0 9182765695
1 a0 2898241189
1 a0 1379491209
1 a0 7775051916
1 a0 9393294870
1 a0 5952315539
2 a0 0000000316
2 a0 0000000977
2 a0 0000000619
2 a0 0000000449
2 a0 0000000661
2 a0 0000000448
2 a0 0000000481
2 a0 0000000827
2 a0 0000000628
2 a0 0000000556
1 a1 0086704517
1 a1 0097653364
1 a1 0077285195
1 a1 0099333932
1 a1 0072584329
1 a1 0058439480
1 a1 0051644730
1 a1 0055479711
1 a1 0089887632
1 a1 0080804560
1 a1 5322458822
1 a1 7826308254
1 a1 4552047479
1 a1 9013802434
1 a1 2593776789
1 a1 3794878147
1 a1 3763707053
1 a1 8663634331
1 a1 5734821348
1 a1 4640543027
1 a2a 2091246039
1 a2a 5450410724
1 a2a 2275296487
1 a2a 8452074142
1 a2a 8489754617
1 a2a 8393324150
1 a2a 6305674027
1 a2a 8045346023
1 a2a 3819035373
1 a2a 5195743892
1 a2b 2532747263
1 a2b 8803582506
1 a2b 5649114112
1 a2b 6403088712
1 a2b 9441918744
1 a2b 1708448644
1 a2b 2917545904
1 a2b 1695432069
1 a2b 4870875776
1 a2b 8328100879
1 a3a 4907615167
1 a3a 6619934299
1 a3a 1485617987
1 a3a 1625659881
1 a3a 2827642949
1 a3a 8992165129
1 a3a 7076646780
1 a3a 1247955931
1 a3a 8229668770
1 a3a 4694231715
1 a3b 6082105966
1 a3b 9772100843
1 a3b 5265281371
1 a3b 9707961171
1 a3b 5291012560
1 a3b 5668239381
1 a3b 8068849467
1 a3b 4082203257
1 a3b 4519802482
1 a3b 3676192451
1 a4a 1400907103
1 a4a 1904580508
1 a4a 8601614622
1 a4a 5004134273
1 a4a 4803817075
1 a4a 2307342411
1 a4a 3309522212
1 a4a 8703115720
1 a4a 8706219900
1 a4a 7906567100
1 a4a 8116533477
1 a4a 5417184832
1 a4a 4613342174
1 a4a 6414813863
1 a4a 1916157670
1 a4a 8518110670
1 a4a 2017655312
1 a4a 3714409060
1 a4a 3610957259
1 a4a 1910982385
1 a4a 1923498344
1 a4a 8224214188
1 a4a 9229004190
1 a4a 7727356374
1 a4a 2925308852
1 a4a 9129708626
1 a4a 1121884840
1 a4a 3121551418
1 a4a 7029820620
1 a4a 8020832820
1 a4a 5936456588
1 a4a 4136806856
1 a4a 2137634030
1 a4a 1930015636
1 a4a 4830359785
1 a4a 5634325273
1 a4a 1739409521
1 a4a 5936494765
1 a4a 7933576507
1 a4a 1131133756
1 a4a 3046036015
1 a4a 6142679388
1 a4a 6145393140
1 a4a 9244268512
1 a4a 1940384984
1 a4a 8548128901
1 a4a 2541640232
1 a4a 3449630465
1 a4a 5847324103
1 a4a 3740357979
1 a4a 6659969357
1 a4a 5950502243
1 a4a 3254113233
1 a4a 9553957004
1 a4a 8751541099
1 a4a 7359788310
1 a4a 9453961516
1 a4a 2650750280
1 a4a 1051655191
1 a4a 6252338815
1 a4a 1769749470
1 a4a 3969143394
1 a4a 3361518968
1 a4a 2864341988
1 a4a 2863242978
1 a4a 4967314752
1 a4a 7267756836
1 a4a 9761622854
1 a4a 3360725250
1 a4a 4664493672
1 a4a 9574324927
1 a4a 9178136882
1 a4a 7772362058
1 a4a 3475147808
1 a4a 2174269977
1 a4a 3379147551
1 a4a 4776404588
1 a4a 8675086094
1 a4a 1871731998
1 a4a 6670386332
1 a4a 7789940235
1 a4a 7683610020
1 a4a 2082944561
1 a4a 9083874508
1 a4a 1181006665
1 a4a 6480259284
1 a4a 7981794230
1 a4a 1785922232
1 a4a 5986455115
1 a4a 1185475880
1 a4a 9540743550
1 a4a 9560039675
1 a4a 8130926450
1 a4a 3190232556
1 a4a 2020531278
1 a4a 8190205699
1 a4a 2570336530
1 a4a 7110042498
1 a4a 7470278319
1 a4a 4590835021
1 a4a 3001803654
1 a4a 5461502743
1 a4a 3141378392
1 a4a 1761440764
1 a4a 9701676890
1 a4a 1121440934
1 a4a 1051327267
1 a4a 2261781804
1 a4a 9991221540
1 a4a 2981640399
1 a4a 7032574500
1 a4a 5122151979
1 a4a 5262187590
1 a4a 9842728230
1 a4a 3422088576
1 a4a 4442839784
1 a4a 1292780100
1 a4a 9722374790
1 a4a 5382194511
1 a4a 2382150174
1 a4a 6323896366
1 a4a 9103229610
1 a4a 9983530515
1 a4a 1973762831
1 a4a 2133081710
1 a4a 6863321380
1 a4a 8313032647
1 a4a 2613226883
1 a4a 9973923355
1 a4a 2703924564
1 a4a 5834530403
1 a4a 8804916689
1 a4a 2284848373
1 a4a 1844670248
1 a4a 1314420624
1 a4a 7284702298
1 a4a 4164411790
1 a4a 1134980573
1 a4a 3284080319
1 a4a 9784682556
1 a4a 2825946891
1 a4a 2015443717
1 a4a 1615120519
1 a4a 6025185327
1 a4a 4805027071
1 a4a 5495352339
1 a4a 4605767601
1 a4a 3335122244
1 a4a 5745769183
1 a4a 9685346428
1 a4a 8386198120
1 a4a 2986080260
1 a4a 6876399851
1 a4a 1256500889
1 a4a 1316433944
1 a4a 8216095470
1 a4a 5636750320
1 a4a 1746386792
1 a4a 8606573690
1 a4a 8756116485
1 a4a 3387993480
1 a4a 7197734964
1 a4a 8937304790
1 a4a 8527887515
1 a4a 1627447361
1 a4a 5007784333
1 a4a 5937142854
1 a4a 5087944373
1 a4a 4597387881
1 a4a 4597732821
1 a4a 3598455392
1 a4a 9398799393
1 a4a 1948811849
1 a4a 5438937621
1 a4a 6578138575
1 a4a 1368450595
1 a4a 3768431213
1 a4a 2998525315
1 a4a 7258428832
1 a4a 5568788219
1 a4b 2519087555
1 a4b 4915710876
1 a4b 4814919564
1 a4b 6617779014
1 a4b 1216320240
1 a4b 8015836302
1 a4b 3610955320
1 a4b 7617717926
1 a4b 8817539290
1 a4b 1311560363
1 a4b 7726818061
1 a4b 9221200393
1 a4b 4728228652
1 a4b 2628645481
1 a4b 7020598102
1 a4b 5926952542
1 a4b 3020411002
1 a4b 5420600730
1 a4b 3925887773
1 a4b 4123351501
1 a4b 9230148125
1 a4b 2135277532
1 a4b 2536735070
1 a4b 9731348561
1 a4b 2039388032
1 a4b 8238374295
1 a4b 4634428693
1 a4b 1536088415
1 a4b 7034172522
1 a4b 5739239924
1 a4b 3345230210
1 a4b 9941585500
1 a4b 8341983053
1 a4b 2843984636
1 a4b 8543312712
1 a4b 5648525123
1 a4b 7643799533
1 a4b 7149910012
1 a4b 3547041341
1 a4b 6247864662
1 a4b 5053169253
1 a4b 7152343873
1 a4b 2554850960
1 a4b 1256641243
1 a4b 8250036885
1 a4b 7856324334
1 a4b 8152794404
1 a4b 3150301881
1 a4b 6950011102
1 a4b 2959295626
1 a4b 1263252654
1 a4b 5867763000
1 a4b 4366404242
1 a4b 5369034090
1 a4b 2461137770
1 a4b 7563910155
1 a4b 2860790816
1 a4b 5362137843
1 a4b 2865386404
1 a4b 6165736630
1 a4b 4375693431
1 a4b 9674059385
1 a4b 2973153842
1 a4b 3972116286
1 a4b 6976291346
1 a4b 4879206803
1 a4b 6773489864
1 a4b 4472820021
1 a4b 4877696464
1 a4b 6570118664
1 a4b 2083325175
1 a4b 5081894081
1 a4b 5484525870
1 a4b 6681150670
1 a4b 6580749286
1 a4b 3383209554
1 a4b 6589951001
1 a4b 5685494993
1 a4b 2382081694
1 a4b 4983180703
1 a4b 7781224074
1 a4b 1141127705
1 a4b 7551492232
1 a4b 8871135523
1 a4b 4251381256
1 a4b 2071857534
1 a4b 2051515933
1 a4b 7871983471
1 a4b 8091747233
1 a4b 8071693705
1 a4b 8722442832
1 a4b 7082866386
1 a4b 9092611526
1 a4b 9092179360
1 a4b 9152486212
1 a4b 2112757750
1 a4b 9022441883
1 a4b 9162257373
1 a4b 2242822155
1 a4b 8862816391
1 a4b 3113603570
1 a4b 8803764703
1 a4b 7983448794
1 a4b 6763413635
1 a4b 8093096473
1 a4b 9873808492
1 a4b 7053062600
1 a4b 2823744900
1 a4b 2713151271
1 a4b 6103763313
1 a4b 5784252090
1 a4b 8484964705
1 a4b 3544489713
1 a4b 3914485611
1 a4b 8834781616
1 a4b 5704856272
1 a4b 5774765850
1 a4b 4374659593
1 a4b 4364743796
1 a4b 9234668232
1 a4b 2415638732
1 a4b 1655838371
1 a4b 9915177651
1 a4b 2415754771
1 a4b 2435065126
1 a4b 9455679872
1 a4b 8325119822
1 a4b 5545952790
1 a4b 6915236655
1 a4b 4975121941
1 a4b 2156793366
1 a4b 2186676661
1 a4b 7836379594
1 a4b 8766944063
1 a4b 4176198121
1 a4b 5566995626
1 a4b 7966730680
1 a4b 1326390182
1 a4b 2586275363
1 a4b 4696824274
1 a4b 7567984934
1 a4b 8107776004
1 a4b 1777564593
1 a4b 6507130611
1 a4b 6387560251
1 a4b 3037970934
1 a4b 9947936261
1 a4b 2057372996
1 a4b 7777166042
1 a4b 6027725752
1 a4b 7648017806
1 a4b 8748287581
1 a4b 3838099742
1 a4b 6348686470
1 a4b 9868916322
1 a4b 4468908021
1 a4b 4898158344
1 a4b 6258134574
1 a4b 7458639573
1 a4b 9738943373
1 a4c 2899755486
1 a4c 6399792349
1 a4c 3099783846
1 a4c 8199743585
1 a4c 8699988405
1 a4c 6299912972
1 a4c 7699391590
1 a4c 8999646865
1 a4c 3199110612
1 a4c 2699773620
1 a4d 0000466581
1 a4d 0000729299
1 a4d 0000497371
1 a4d 0000760153
1 a4d 0000457531
1 a4d 0000820407
1 a4d 0000415375
1 a4d 0000735256
1 a4d 0000448540
1 a4d 0000884278
1 a4d 3809892169
1 a4d 7825723472
1 a4d 6934050605
1 a4d 4723529292
1 a4d 3664554965
1 a4d 1254077287
1 a4d 8937498869
1 a4d 3937897479
1 a4d 1449592699
1 a4d 4528663246
1 a4e 3066810241
1 a4e 2038015451
1 a4e 9981614571
1 a4e 8250765786
1 a4e 4946255575
1 a4e 4303638123
1 a4e 1564267926
1 a4e 6427456785
1 a4e 3809068256
1 a4e 7055624192
1 a5a 4507099390
1 a5a 4831593654
1 a5a 9023759203
1 a5a 7514968812
1 a5a 9843628315
1 a5a 6601277376
1 a5a 5719100215
1 a5a 6290080909
1 a5a 2753974597
1 a5a 3335564583
1 a5b 0122481992
1 a5b 0876631243
1 a5b 0166015610
1 a5b 0742715833
1 a5b 0513835938
1 a5b 0828702934
1 a5b 0861927532
1 a5b 0621669830
1 a5b 0552272809
1 a5b 0243430736
1 a5b 1151286508
1 a5b 1060793369
1 a5b 1885593546
1 a5b 1010548840
1 a5b 1814143432
1 a5b 1284800040
1 a5b 1093920858
1 a5b 1118565797
1 a5b 1647284880
1 a5b 1784129348
1 a5b 2185155059
1 a5b 2327708036
1 a5b 2942033460
1 a5b 2237062404
1 a5b 2191608914
1 a5b 2207371409
1 a5b 2921235129
1 a5b 2841668479
1 a5b 2107806551
1 a5b 2735689670
1 a5b 3758265061
1 a5b 3654660444
1 a5b 3969419794
1 a5b 3295072183
1 a5b 3140163746
1 a5b 3896033620
1 a5b 3769722264
1 a5b 3401998625
1 a5b 3985397309
1 a5b 3544677040
1 a5b 4947878096
1 a5b 4845358689
1 a5b 4180986035
1 a5b 4595084935
1 a5b 4131594005
1 a5b 4916805712
1 a5b 4200205483
1 a5b 4314846470
1 a5b 4802793081
1 a5b 4025998254
1 a5b 5243113298
1 a5b 5766370857
1 a5b 5277304355
1 a5b 5132618065
1 a5b 5685348860
1 a5b 5786390764
1 a5b 5393560770
1 a5b 5647744095
1 a5b 5466244457
1 a5b 5247586972
1 a5b 6745177285
1 a5b 6079496402
1 a5b 6335472910
1 a5b 6809120548
1 a5b 6004938254
1 a5b 6999524378
1 a5b 6480776755
1 a5b 6680993008
1 a5b 6637289949
1 a5b 6302198577
1 a5b 7294036624
1 a5b 7366796085
1 a5b 7915545426
1 a5b 7383624246
1 a5b 7449465213
1 a5b 7413895927
1 a5b 7489679591
1 a5b 7315353712
1 a5b 7426860639
1 a5b 7286911104
1 a5b 8056267271
1 a5b 8408590103
1 a5b 8523117628
1 a5b 8708634106
1 a5b 8420370851
1 a5b 8933078975
1 a5b 8520414583
1 a5b 8751004437
1 a5b 8167566951
1 a5b 8982943129
1 a6a 6875549484
1 a6a 3872252980
1 a6a 7847160160
1 a6a 6811708947
1 a6a 8896591727
1 a6a 8833619367
1 a6a 2867299303
1 a6a 1838377503
1 a6a 4846843367
1 a6a 9826920382
1 a6b 9050744874
1 a6b 6021640357
1 a6b 9066640467
1 a6b 4061140046
1 a6b 5072636249
1 a6b 3026094217
1 a6b 3031279254
1 a6b 8062783161
1 a6b 9015736999
1 a6b 2071833589
1 a6b 4182705377
1 a6b 9192821868
1 a6b 2177879179
1 a6b 4132576769
1 a6b 4135045493
1 a6b 3143308068
1 a6b 1162296665
1 a6b 2137082449
1 a6b 8120458819
1 a6b 4146593848
1 a6b 5239471175
1 a6b 2292006456
1 a6b 8255469209
1 a6b 2249903416
1 a6b 3280493283
1 a6b 9273678136
1 a6b 7210490661
1 a6b 2233242602
1 a6b 9237816147
1 a6b 2204464495
1 a6b 2397199725
1 a6b 8365638078
1 a6b 2338231068
1 a6b 9336232055
1 a6b 4332368526
1 a6b 7367629031
1 a6b 2367908609
1 a6b 1328404796
1 a6b 7391703961
1 a6b 1378842102
1 a6b 6437677251
1 a6b 6412379608
1 a6b 2401208870
1 a6b 9438273503
1 a6b 4431900878
1 a6b 9499310371
1 a6b 5433460652
1 a6b 6485564127
1 a6b 5400779510
1 a6b 1471655045
1 a6b 2544916562
1 a6b 5568054050
1 a6b 1514282203
1 a6b 8559712676
1 a6b 6596530992
1 a6b 3558591594
1 a6b 8563910691
1 a6b 7505803073
1 a6b 4573011625
1 a6b 2584820601
1 a6b 6683473632
1 a6b 4656800911
1 a6b 7680960666
1 a6b 3623042961
1 a6b 4640892519
1 a6b 2616173501
1 a6b 4646629827
1 a6b 9626234763
1 a6b 6643598179
1 a6b 4671700364
1 a6b 1743822348
1 a6b 9786840073
1 a6b 9776042135
1 a6b 7754643527
1 a6b 7790212338
1 a6b 3718834871
1 a6b 5786484787
1 a6b 4749688387
1 a6b 3773427182
1 a6b 7782994231
1 a6b 4906666599
1 a6b 3936873827
1 a6b 5909803437
1 a6b 7916305641
1 a6b 3904341800
1 a6b 5920246303
1 a6b 5967637717
1 a6b 6980367654
1 a6b 5994825640
1 a6b 7913872809
1 a7a 4701921571
1 a7a 9551675102
1 a7a 1619743568
1 a7a 1101846259
1 a7a 7135645989
1 a7a 5003591301
1 a7a 4985920372
1 a7a 1459128292
1 a7a 5032271776
1 a7a 1013128077
1 a7b 9113647428
1 a7b 9119683004
1 a7b 7120912420
1 a7b 2974031153
1 a7b 6463633206
1 a7b 9145411297
1 a7b 4919783533
1 a7b 3783442979
1 a7b 8517739724
1 a7b 3966607829
1 a8a 9802399016
1 a8a 5106173039
1 a8a 9407205988
1 a8a 2709780483
1 a8a 5101285513
1 a8a 8208417032
1 a8a 3108259640
1 a8a 4801699601
1 a8a 4804113810
1 a8a 7903857808
1 a8a 6211671685
1 a8a 1911255991
1 a8a 6318367957
1 a8a 3317712987
1 a8a 7018565090
1 a8a 6416554741
1 a8a 5113813088
1 a8a 6210235261
1 a8a 2614223055
1 a8a 3912048027
1 a8a 9025310784
1 a8a 7528071101
1 a8a 5126486673
1 a8a 9527194870
1 a8a 7527698917
1 a8a 9826002749
1 a8a 8020668168
1 a8a 7622117142
1 a8a 4721348132
1 a8a 6127228660
1 a8a 6739877975
1 a8a 9534722019
1 a8a 1634486307
1 a8a 3835723191
1 a8a 6630623008
1 a8a 6635102936
1 a8a 2036998100
1 a8a 4733302199
1 a8a 4439110402
1 a8a 6039059776
1 a8a 7749872647
1 a8a 3245708591
1 a8a 8647168551
1 a8a 8246396445
1 a8a 6343196674
1 a8a 8844020421
1 a8a 4544276094
1 a8a 5940971901
1 a8a 1848453349
1 a8a 2343026108
1 a8a 7951752405
1 a8a 7559701249
1 a8a 4854279689
1 a8a 5954717341
1 a8a 7554768493
1 a8a 9557682395
1 a8a 8254178157
1 a8a 4852910527
1 a8a 3357235984
1 a8a 9451277413
1 a8a 3466996531
1 a8a 3563264548
1 a8a 4062387263
1 a8a 1065560276
1 a8a 3665883750
1 a8a 5561955454
1 a8a 8563361136
1 a8a 9167409222
1 a8a 5463606155
1 a8a 4166648967
1 a8a 2977137753
1 a8a 6677809395
1 a8a 6279740295
1 a8a 8172677318
1 a8a 7078846065
1 a8a 1175683610
1 a8a 9777962592
1 a8a 6676811850
1 a8a 1179578544
1 a8a 8577373503
1 a8a 2989615105
1 a8a 3282037335
1 a8a 9986153232
1 a8a 4285018749
1 a8a 8882180820
1 a8a 1081810740
1 a8a 8481665146
1 a8a 1688742197
1 a8a 5083957098
1 a8a 4580812757
1 a8b 4105360581
1 a8b 9005844972
1 a8b 3507621352
1 a8b 7701660299
1 a8b 1809054958
1 a8b 9702628501
1 a8b 2101954981
1 a8b 7409363359
1 a8b 1503619061
1 a8b 3509435942
1 a8b 3819505488
1 a8b 8910828053
1 a8b 3815280649
1 a8b 8316144539
1 a8b 7117435621
1 a8b 7918611006
1 a8b 2914072070
1 a8b 1110590828
1 a8b 6819790486
1 a8b 3318621930
1 a8b 5229759184
1 a8b 6224514824
1 a8b 4726743157
1 a8b 1429351792
1 a8b 4828835373
1 a8b 2523201514
1 a8b 3623073574
1 a8b 8121848209
1 a8b 6822952794
1 a8b 6327232291
1 a8b 9331293869
1 a8b 8734979134
1 a8b 6230410480
1 a8b 3339348442
1 a8b 5239738956
1 a8b 2232824761
1 a8b 7435576467
1 a8b 4339255779
1 a8b 1832928273
1 a8b 6136445332
1 a8b 2844575460
1 a8b 5546199848
1 a8b 8042085298
1 a8b 9040361303
1 a8b 8041170166
1 a8b 8446782189
1 a8b 2947421977
1 a8b 3649149436
1 a8b 3444419511
1 a8b 1449848912
1 a8b 7955980875
1 a8b 2054654380
1 a8b 2155241914
1 a8b 1159552944
1 a8b 2758074668
1 a8b 8752529311
1 a8b 3653324993
1 a8b 8057686975
1 a8b 7457007081
1 a8b 3952204899
1 a8b 9163846599
1 a8b 1666137012
1 a8b 3164296620
1 a8b 9867995558
1 a8b 3469411406
1 a8b 7960861500
1 a8b 2264912481
1 a8b 7666381768
1 a8b 3869766817
1 a8b 5066951735
1 a8b 7774090288
1 a8b 8175704689
1 a8b 1778373755
1 a8b 2572471530
1 a8b 6377863640
1 a8b 5972340297
1 a8b 3871799030
1 a8b 3778929564
1 a8b 9470749309
1 a8b 7378905374
1 a8b 7184458121
1 a8b 6884810099
1 a8b 5880482224
1 a8b 4184798757
1 a8b 7683991858
1 a8b 2286868426
1 a8b 6886929244
1 a8b 5286089163
1 a8b 8781734441
1 a8b 8382730000
1 a8c 5192142257
1 a8c 2894527105
1 a8c 4499571749
1 a8c 8297752088
1 a8c 1690058267
1 a8c 3791389038
1 a8c 2392977600
1 a8c 8299670453
1 a8c 7497762237
1 a8c 6994045305
1 a8d 2996971540
1 a8d 2292387190
1 a8d 8297861430
1 a8d 8993585105
1 a8d 4093157430
1 a8d 8892456784
1 a8d 5394510415
1 a8d 4395440622
1 a8d 9599969987
1 a8d 1199451789
1 a9a 1266725537
1 a9a 8338200079
1 a9a 9091965296
1 a9a 7471451133
1 a9a 3736494279
1 a9a 4157739811
1 a9a 8969448578
1 a9a 4804242565
1 a9a 3543184459
1 a9a 9734529157
1 a9b 3455531003
1 a9b 8290320071
1 a9b 5139701978
1 a9b 1097954026
1 a9b 1059858099
1 a9b 2234918195
1 a9b 6598236540
1 a9b 1213115169
1 a9b 7211739716
1 a9b 6801643190
2 b0a 6610898187
2 b0a 2422616189
2 b0a 9174390191
2 b0a 7597941136
2 b0a 2855482129
2 b0a 4923819116
2 b0a 4766917144
2 b0a 5179931176
2 b0a 6601693180
2 b0a 3373370101
2 b0a 6474106268
2 b0a 7328981284
2 b0a 7395267287
2 b0a 1564527292
2 b0a 4553463227
2 b0a 1448624297
2 b0a 3640145233
2 b0a 9065485250
2 b0a 9970253243
2 b0a 6299978259
2 b0a 3496079399
2 b0a 2321511393
2 b0a 4775927379
2 b0a 9219384309
2 b0a 9017091312
2 b0a 4782732339
2 b0a 3818363378
2 b0a 2251585382
2 b0a 1782535306
2 b0a 7736203376
2 b0a 3308097630
2 b0a 5719814698
2 b0a 1878783622
2 b0a 1797142698
2 b0a 6294067614
2 b0a 2163107623
2 b0a 3289178658
2 b0a 2085744698
2 b0a 2261738691
2 b0a 4476425635
1 b0b 1447883054
1 b0b 7987970086
1 b0b 7348734029
1 b0b 5371766032
1 b0b 5655404009
1 b0b 1719924073
1 b0b 3637941096
1 b0b 3066387061
1 b0b 6852389093
1 b0b 1541423091
1 b0b 2123605414
1 b0b 5496092491
1 b0b 1322337422
1 b0b 2619805405
1 b0b 1738638413
1 b0b 4930859481
1 b0b 2595005453
1 b0b 4309969451
1 b0b 2326382470
1 b0b 3796319401
1 b0b 2548951553
1 b0b 7314537542
1 b0b 1044950550
1 b0b 5407259574
1 b0b 7257199597
1 b0b 1481402510
1 b0b 5255582536
1 b0b 4142702520
1 b0b 2324592507
1 b0b 6503038550
1 b0b 6875923747
1 b0b 3049446780
1 b0b 3765434750
1 b0b 6897993790
1 b0b 2567109707
1 b0b 4137571744
1 b0b 5384693743
1 b0b 6681819760
1 b0b 6940261706
1 b0b 5150247723
1 b0b 4681188865
1 b0b 1711598860
1 b0b 9807406865
1 b0b 7048821833
1 b0b 6387196836
1 b0b 1260717835
1 b0b 6190468893
1 b0b 3941771806
1 b0b 4265554801
1 b0b 6707924843
1 b0b 5138998918
1 b0b 3781066930
1 b0b 1303763968
1 b0b 3197205945
1 b0b 6357030984
1 b0b 1328288954
1 b0b 7957602970
1 b0b 6438234991
1 b0b 7492992903
1 b0b 1935915925
1 b1a 9867535146
1 b1a 1013919789
1 b1a 3295863868
1 b1a 2304366655
1 b1a 7406323342
1 b1a 7648791787
1 b1a 7745716063
1 b1a 6075207230
1 b1a 5761189634
1 b1a 8529525288
1 b1b 7117770477
1 b1b 3532299056
1 b1b 6774296759
1 b1b 6187115582
1 b1b 7573809322
1 b1b 6620767325
1 b1b 8283207024
1 b1b 6824000912
1 b1b 4947084886
1 b1b 2019443230
1 b2a 0838934013
1 b2a 0576811998
1 b2a 0690964048
1 b2a 0865181519
1 b2a 0324987358
1 b2a 0920526268
1 b2a 0495809330
1 b2a 0976128519
1 b2a 0299502074
1 b2a 0717839303
1 b2a 1088601577
1 b2a 1553047513
1 b2a 1418786192
1 b2a 1078123729
1 b2a 1004829040
1 b2a 1762929918
1 b2a 1657634415
1 b2a 1048234271
1 b2a 1672181787
1 b2a 1413767491
1 b2a 2053017958
1 b2a 2021878079
1 b2a 2598288208
1 b2a 2989302799
1 b2a 2295006435
1 b2a 2410600713
1 b2a 2134009599
1 b2a 2788348945
1 b2a 2566464205
1 b2a 2489733758
1 b2a 3624437676
1 b2a 3530378773
1 b2a 3874088016
1 b2a 3785529254
1 b2a 3119093078
1 b2a 3853499947
1 b2a 3252328773
1 b2a 3610030978
1 b2a 3010943301
1 b2a 3538911152
1 b2a 4582161803
1 b2a 4396247248
1 b2a 4935704313
1 b2a 4083719299
1 b2a 4258727120
1 b2a 4051479195
1 b2a 4540022686
1 b2a 4361336457
1 b2a 4007899621
1 b2a 4656611106
1 b2a 5091479291
1 b2a 5059339013
1 b2a 5861754213
1 b2a 5497763800
1 b2a 5376396963
1 b2a 5929349890
1 b2a 5598454315
1 b2a 5203668090
1 b2a 5406078042
1 b2a 5549420860
1 b2a 6207991137
1 b2a 6020341317
1 b2a 6347932702
1 b2a 6551589115
1 b2a 6666190908
1 b2a 6880193254
1 b2a 6268751977
1 b2a 6294569870
1 b2a 6690556399
1 b2a 6310578069
1 b2a 7801309821
1 b2a 7674641814
1 b2a 7381734878
1 b2a 7100519994
1 b2a 7821555763
1 b2a 7152654299
1 b2a 7096256629
1 b2a 7328390043
1 b2a 7108805287
1 b2a 7997916874
1 b2b 8152413210
1 b2b 8712860421
1 b2b 8943644644
1 b2b 8331689177
1 b2b 8602521919
1 b2b 8523178997
1 b2b 8196079936
1 b2b 8887613720
1 b2b 8587080360
1 b2b 8816472446
1 b2b 9110016053
1 b2b 9759936397
1 b2b 9704275446
1 b2b 9174083890
1 b2b 9595698508
1 b2b 9748437168
1 b2b 9668821524
1 b2b 9277011285
1 b2b 9013349403
1 b2b 9269184009
1 b3a 0735963265
1 b3a 0367378157
1 b3a 0287862261
1 b3a 0993839885
1 b3a 0634897064
1 b3a 0487893744
1 b3a 0108218323
1 b3a 0948388350
1 b3a 0619886095
1 b3a 0502358549
1 b3a 1364519914
1 b3a 1502231956
1 b3a 1290600873
1 b3a 1618469598
1 b3a 1311143930
1 b3a 1985803713
1 b3a 1344687108
1 b3a 1849517880
1 b3a 1823744477
1 b3a 1361575449
1 b3a 2347298986
1 b3a 2851336100
1 b3a 2728612927
1 b3a 2841627678
1 b3a 2553714950
1 b3a 2980624233
1 b3a 2429068783
1 b3a 2327308051
1 b3a 2612713098
1 b3a 2923466612
1 b3a 3110789828
1 b3a 3118534942
1 b3a 3443616851
1 b3a 3590371602
1 b3a 3294965833
1 b3a 3334077385
1 b3a 3521393189
1 b3a 3291161431
1 b3a 3579053522
1 b3a 3848050783
1 b3a 4548536244
1 b3a 4732530244
1 b3a 4487714335
1 b3a 4755009898
1 b3a 4765092175
1 b3a 4045444209
1 b3a 4020525731
1 b3a 4071286943
1 b3a 4752330490
1 b3a 4646625592
1 b3a 5704368100
1 b3a 5940728187
1 b3a 5915241634
1 b3a 5124372654
1 b3a 5219674144
1 b3a 5157705999
1 b3a 5949805966
1 b3a 5397221940
1 b3a 5512287234
1 b3a 5271748432
1 b3a 6163559297
1 b3a 6810899810
1 b3a 6592834375
1 b3a 6043423204
1 b3a 6541463829
1 b3a 6954393287
1 b3a 6346252842
1 b3a 6536485260
1 b3a 6825131014
1 b3a 6842003562
1 b3a 7784714377
1 b3a 7924321472
1 b3a 7057080719
1 b3a 7528246904
1 b3a 7843274225
1 b3a 7268092311
1 b3a 7122845415
1 b3a 7532109670
1 b3a 7933383873
1 b3a 7562185687
1 b3a 8493696618
1 b3a 8044771192
1 b3a 8955738520
1 b3a 8489823905
1 b3a 8335410231
1 b3a 8948880409
1 b3a 8669698957
1 b3a 8436220517
1 b3a 8211476777
1 b3a 8979537007
1 b3b 9675710195
1 b3b 9313272378
1 b3b 9120333213
1 b3b 9086954947
1 b3b 9923241784
1 b3b 9215521491
1 b3b 9910448568
1 b3b 9830465607
1 b3b 9615070634
1 b3b 9425927253
1 b4a 9798672326
1 b4a 9748510303
1 b4a 9658341251
1 b4a 9543696356
1 b4a 9391293736
1 b4a 9526105078
1 b4a 9427555280
1 b4a 9711960964
1 b4a 9009287567
1 b4a 9973343875
1 b4b 0580713679
1 b4b 0419968059
1 b4b 0646123629
1 b4b 0802642349
1 b4b 0258941030
1 b4b 0369741900
1 b4b 0512315086
1 b4b 0183061055
1 b4b 0773397434
1 b4b 0563622601
1 b4b 1211340554
1 b4b 1107689023
1 b4b 1145683649
1 b4b 1677980559
1 b4b 1984937448
1 b4b 1397649739
1 b4b 1771019743
1 b4b 1579458645
1 b4b 1970089105
1 b4b 1482900521
1 b4b 2710912392
1 b4b 2410116493
1 b4b 2953382739
1 b4b 2400597952
1 b4b 2006461753
1 b4b 2554813795
1 b4b 2438059117
1 b4b 2183880287
1 b4b 2617781739
1 b4b 2507998997
1 b4b 3589340002
1 b4b 3173168763
1 b4b 3921433908
1 b4b 3259841555
1 b4b 3625325039
1 b4b 3576375104
1 b4b 3569598950
1 b4b 3838855396
1 b4b 3232030505
1 b4b 3805766025
1 b4b 4994431663
1 b4b 4849596037
1 b4b 4520976650
1 b4b 4924639605
1 b4b 4154383116
1 b4b 4027502078
1 b4b 4855906832
1 b4b 4917836824
1 b4b 4175243348
1 b4b 4872375181
1 b4b 5599034348
1 b4b 5029555145
1 b4b 5454716774
1 b4b 5949829395
1 b4b 5423314917
1 b4b 5327323633
1 b4b 5406492357
1 b4b 5448265286
1 b4b 5724148862
1 b4b 5203182906
1 b4b 6922200357
1 b4b 6988533427
1 b4b 6608767609
1 b4b 6618679184
1 b4b 6791436190
1 b4b 6580212349
1 b4b 6290979760
1 b4b 6961175821
1 b4b 6893269692
1 b4b 6119193502
1 b4b 7807942010
1 b4b 7728403699
1 b4b 7769795591
1 b4b 7863742218
1 b4b 7606753032
1 b4b 7936636757
1 b4b 7165405941
1 b4b 7939567810
1 b4b 7532500322
1 b4b 7978857174
1 b4b 8930877419
1 b4b 8992658168
1 b4b 8994362681
1 b4b 8257067482
1 b4b 8224230821
1 b4b 8542033612
1 b4b 8100593787
1 b4b 8449117542
1 b4b 8712796638
1 b4b 8369228909
1 b5a 6298893146
1 b5a 3169134908
1 b5a 4728968938
1 b5a 8565522614
1 b5a 4198467849
1 b5a 9126520630
1 b5a 8192701552
1 b5a 1761998926
1 b5a 7643344692
1 b5a 4030259102
1 b5b 0543929392
1 b5b 0658375753
1 b5b 0567587175
1 b5b 0602069536
1 b5b 0948143391
1 b5b 0631866977
1 b5b 0463363242
1 b5b 0766374474
1 b5b 0300754033
1 b5b 0357521376
1 b5b 1055340010
1 b5b 1974757401
1 b5b 1172950212
1 b5b 1128563028
1 b5b 1034741916
1 b5b 1327347876
1 b5b 1015462540
1 b5b 1770216552
1 b5b 1536426511
1 b5b 1720354727
1 b5b 2401087859
1 b5b 2299933701
1 b5b 2812298608
1 b5b 2049479955
1 b5b 2906627050
1 b5b 2780922056
1 b5b 2257401493
1 b5b 2849113366
1 b5b 2952385421
1 b5b 2548774435
1 b5b 3862199613
1 b5b 3068236359
1 b5b 3541822569
1 b5b 3130939493
1 b5b 3568060119
1 b5b 3397972070
1 b5b 3538119607
1 b5b 3530340037
1 b5b 3627719531
1 b5b 3613841232
1 b5b 4686186372
1 b5b 4404575658
1 b5b 4311741005
1 b5b 4514067075
1 b5b 4837546359
1 b5b 4233039587
1 b5b 4401202512
1 b5b 4328432309
1 b5b 4232290736
1 b5b 4753494659
1 b5b 5641367841
1 b5b 5167664480
1 b5b 5374972189
1 b5b 5657151006
1 b5b 5193686333
1 b5b 5549630050
1 b5b 5953841243
1 b5b 5512567438
1 b5b 5213836496
1 b5b 5349269919
1 b5b 6621362190
1 b5b 6387932962
1 b5b 6002967765
1 b5b 6468245730
1 b5b 6289832757
1 b5b 6738856043
1 b5b 6270576561
1 b5b 6939422587
1 b5b 6997351975
1 b5b 6476096661
1 b5b 7831713230
1 b5b 7334174856
1 b5b 7213159523
1 b5b 7921579327
1 b5b 7301475740
1 b5b 7140677241
1 b5b 7039028464
1 b5b 7387667947
1 b5b 7242914195
1 b5b 7229064733
1 b6a 1054123868
1 b6a 1006916438
1 b6a 1841791489
1 b6a 1057305177
1 b6a 1006948089
1 b6a 1483427176
1 b6a 1458549379
1 b6a 1991238025
1 b6a 1826618305
1 b6a 1437501636
1 b6a 2026237789
1 b6a 2859111037
1 b6a 2307834411
1 b6a 2408455939
1 b6a 2103506750
1 b6a 2298789323
1 b6a 2445352897
1 b6a 2601123187
1 b6a 2087381103
1 b6a 2286296084
1 b6a 3320406204
1 b6a 3065437952
1 b6a 3339147875
1 b6a 3151452190
1 b6a 3704284210
1 b6a 3267585154
1 b6a 3476662780
1 b6a 3167054289
1 b6a 3910387062
1 b6a 3002187371
1 b6a 4477400832
1 b6a 4957338898
1 b6a 4420215238
1 b6a 4916009466
1 b6a 4786869517
1 b6a 4573056349
1 b6a 4731238710
1 b6a 4033914558
1 b6a 4064404373
1 b6a 4499856049
1 b6a 5362591373
1 b6a 5874769244
1 b6a 5430398995
1 b6a 5644910433
1 b6a 5406435371
1 b6a 5572657095
1 b6a 5417974236
1 b6a 5393982170
1 b6a 5405093094
1 b6a 5214102757
1 b6a 6897573238
1 b6a 6542393968
1 b6a 6912192368
1 b6a 6094907769
1 b6a 6927557421
1 b6a 6022298782
1 b6a 6029565557
1 b6a 6515336932
1 b6a 6203973511
1 b6a 6152726008
1 b6a 7968141197
1 b6a 7585598500
1 b6a 7480940313
1 b6a 7704077770
1 b6a 7443549991
1 b6a 7019243376
1 b6a 7057348619
1 b6a 7842438492
1 b6a 7359299432
1 b6a 7405823305
1 b6a 8991549498
1 b6a 8211472270
1 b6a 8674146610
1 b6a 8033574969
1 b6a 8148537128
1 b6a 8777012292
1 b6a 8489526894
1 b6a 8894018807
1 b6a 8954199586
1 b6a 8648670943
1 b6a 9573081633
1 b6a 9762087787
1 b6a 9303773702
1 b6a 9377529333
1 b6a 9793664824
1 b6a 9580037474
1 b6a 9673838388
1 b6a 9159557289
1 b6a 9188999626
1 b6a 9313383362
1 b7a 0001452248
1 b7a 0001562004
1 b7a 0001471078
1 b7a 0001109302
1 b7a 0001735343
1 b7a 0001394296
1 b7a 0001049273
1 b7a 0001594333
1 b7a 0001670972
1 b7a 0001543164
1 b7a 0002299802
1 b7a 0002459886
1 b7a 0002789556
1 b7a 0002294209
1 b7a 0002341255
1 b7a 0002960564
1 b7a 0002210805
1 b7a 0002448732
1 b7a 0002101756
1 b7a 0002705248
1 b7a 0003073625
1 b7a 0003480696
1 b7a 0003584341
1 b7a 0003105414
1 b7a 0003840724
1 b7a 0003273676
1 b7a 0003860199
1 b7a 0003229046
1 b7a 0003271245
1 b7a 0003530371
1 b7a 0004451480
1 b7a 0004342764
1 b7a 0004792503
1 b7a 0004636391
1 b7a 0004072436
1 b7a 0004365583
1 b7a 0004958000
1 b7a 0004737324
1 b7a 0004591010
1 b7a 0004118376
1 b7a 0005145238
1 b7a 0005415315
1 b7a 0005137806
1 b7a 0005525425
1 b7a 0005225196
1 b7a 0005139048
1 b7a 0005341661
1 b7a 0005419438
1 b7a 0005486722
1 b7a 0005366000
1 b7a 0700664825
1 b7a 0728173518
1 b7a 0730147611
1 b7a 0711124639
1 b7a 0733987861
1 b7a 0726782334
1 b7a 0762254273
1 b7a 0787045364
1 b7a 0782253591
1 b7a 0711735619
1 b7a 0835686493
1 b7a 0855264723
1 b7a 0855585859
1 b7a 0886578976
1 b7a 0819571081
1 b7a 0853266943
1 b7a 0876599817
1 b7a 0844108560
1 b7a 0876984831
1 b7a 0804839642
1 b8a 1736715638
1 b8a 2486770740
1 b8a 4314585825
1 b8a 4420446108
1 b8a 2248283523
1 b8a 8922054108
1 b8a 8538974964
1 b8a 8180360661
1 b8a 8622662293
1 b8a 3690456486
1 b8b 1769736942
1 b8b 1426483684
1 b8b 3349099675
1 b8b 5812272137
1 b8b 9010402359
1 b8b 5021147626
1 b8b 4690521935
1 b8b 4711588114
1 b8b 2488871763
1 b8b 8578994917
1 b9a 0023789022
1 b9a 0015851096
1 b9a 0095969405
1 b9a 0071068947
1 b9a 0038482438
1 b9a 0022292378
1 b9a 0051683429
1 b9a 0068515849
1 b9a 0048576054
1 b9a 0089408313
1 b9b 0006100193
1 b9b 0001779794
1 b9b 0003237191
1 b9b 0005762679
1 b9b 0009637996
1 b9b 0004212725
1 b9b 0002439699
1 b9b 0005663189
1 b9b 0007448397
1 b9b 0006534584
1 c0b 2859130570
1 c0b 7354539028
1 c0b 2045876589
1 c0b 8630225190
1 c0b 4614525844
1 c0b 2348547980
1 c0b 6797657324
1 c0b 3665701243
1 c0b 2286404278
1 c0b 6473853691
1 c1a 0144332789
1 c1a 0849766598
1 c1a 0102576860
1 c1a 0908912237
1 c1a 0513596071
1 c1a 0812333693
1 c1a 0630230321
1 c1a 0868379375
1 c1a 0800303235
1 c1a 0199996419
1 c1a 1174833729
1 c1a 1650379402
1 c1a 1515330151
1 c1a 1963945429
1 c1a 1927364475
1 c1a 1058257093
1 c1a 1792149096
1 c1a 1450405815
1 c1a 1689458216
1 c1a 1171427006
1 c1a 2598646112
1 c1a 2731702035
1 c1a 2258624927
1 c1a 2225897126
1 c1a 2101053990
1 c1a 2678600080
1 c1a 2527958717
1 c1a 2504536678
1 c1a 2185808632
1 c1a 2025857749
1 c1a 3108843724
1 c1a 3466823573
1 c1a 3214222495
1 c1a 3631760957
1 c1a 3951947421
1 c1a 3305256247
1 c1a 3332670124
1 c1a 3715917487
1 c1a 3073943621
1 c1a 3059375941
1 c1a 4902018336
1 c1a 4355788484
1 c1a 4071853912
1 c1a 4511561521
1 c1a 4942072393
1 c1a 4622569583
1 c1a 4629048349
1 c1a 4040999932
1 c1a 4841140038
1 c1a 4154794546
1 c1a 6171876923
1 c1a 6314896529
1 c1a 6473345003
1 c1a 6193378035
1 c1a 6103232718
1 c1a 6200701277
1 c1a 6042267808
1 c1a 6249472614
1 c1a 6880661776
1 c1a 6711075494
1 c1a 7980380371
1 c1a 7523873157
1 c1a 7365319614
1 c1a 7742353002
1 c1a 7118334520
1 c1a 7772002428
1 c1a 7111397932
1 c1a 7357599390
1 c1a 7894430133
1 c1a 7711441965
1 c1a 8281457528
1 c1a 8348685258
1 c1a 8952057007
1 c1a 8218651078
1 c1a 8714547038
1 c1a 8505915119
1 c1a 8654802041
1 c1a 8057702591
1 c1a 8470741255
1 c1a 8763868065
1 c1a 9162277006
1 c1a 9391379970
1 c1a 9975249873
1 c1a 9175491347
1 c1a 9686059022
1 c1a 9719319052
1 c1a 9070089019
1 c1a 9060647757
1 c1a 9634797902
1 c1a 9701779402
1 c1b 5389153813
1 c1b 5487492790
1 c1b 5791580706
1 c1b 5305813053
1 c1b 5510082990
1 c1b 5721998069
1 c1b 5373298217
1 c1b 5192267529
1 c1b 5867388077
1 c1b 5222011773
1 c2a 4168048386
1 c2a 7350340046
1 c2a 3851666333
1 c2a 1442628647
1 c2a 1286249022
1 c2a 7296115722
1 c2a 7249078760
1 c2a 3426660964
1 c2a 6822466284
1 c2a 1136298736
1 c2b 1209297942
1 c2b 9051799477
1 c2b 5542066849
1 c2b 5205280794
1 c2b 9670520270
1 c2b 2688476379
1 c2b 3130691292
1 c2b 5779371458
1 c2b 8463927775
1 c2b 8282995573
1 c3a 0126362672
1 c3a 0170888838
1 c3a 0696256643
1 c3a 0271947871
1 c3a 0166822452
1 c3a 0188990022
1 c3a 0180851701
1 c3a 0238279269
1 c3a 0779702083
1 c3a 0479334658
1 c3a 1602604165
1 c3a 1706442694
1 c3a 1598510806
1 c3a 1614864328
1 c3a 1970682454
1 c3a 1713496477
1 c3a 1381083664
1 c3a 1461126193
1 c3a 1492408818
1 c3a 1258386950
1 c3a 2422493383
1 c3a 2770316707
1 c3a 2199473170
1 c3a 2329634568
1 c3a 2449571385
1 c3a 2457956171
1 c3a 2003207392
1 c3a 2958440824
1 c3a 2708906843
1 c3a 2200921472
1 c3a 3781351055
1 c3a 3501141596
1 c3a 3023100435
1 c3a 3478073186
1 c3a 3906597459
1 c3a 3366931834
1 c3a 3444334019
1 c3a 3203169499
1 c3a 3239754140
1 c3a 3203228972
1 c3a 4225842642
1 c3a 4413599806
1 c3a 4215227382
1 c3a 4266065525
1 c3a 4684923404
1 c3a 4330109077
1 c3a 4845529389
1 c3a 4374242701
1 c3a 4298527369
1 c3a 4015245006
1 c3a 5248224148
1 c3a 5201451944
1 c3a 5048850365
1 c3a 5738961670
1 c3a 5652686592
1 c3a 5082387688
1 c3a 5911504396
1 c3a 5284438693
1 c3a 5828763770
1 c3a 5065603580
1 c3a 6195322356
1 c3a 6456535902
1 c3a 6964513144
1 c3a 6589911855
1 c3a 6310961989
1 c3a 6567329948
1 c3a 6777690451
1 c3a 6602718477
1 c3a 6740123093
1 c3a 6771678593
1 c3a 7534292854
1 c3a 7747556889
1 c3a 7269425141
1 c3a 7645309480
1 c3a 7818857331
1 c3a 7842715075
1 c3a 7009457867
1 c3a 7855422262
1 c3a 7308159776
1 c3a 7042495437
1 c3a 8084065146
1 c3a 8345044625
1 c3a 8335716471
1 c3a 8487515770
1 c3a 8106903860
1 c3a 8436468725
1 c3a 8373650954
1 c3a 8294956530
1 c3a 8023772414
1 c3a 8813624429
1 c3b 9023712922
1 c3b 9079604933
1 c3b 9972990353
1 c3b 9291336084
1 c3b 9536615501
1 c3b 9278169374
1 c3b 9637553468
1 c3b 9320295086
1 c3b 9954666351
1 c3b 9657683523
1 c4a 0971117221
1 c4a 0154016624
1 c4a 0611020281
1 c4a 0718437664
1 c4a 0742243133
1 c4a 0249172001
1 c4a 0859660283
1 c4a 0806522640
1 c4a 0148895567
1 c4a 0958597403
1 c4a 1114071790
1 c4a 1504251993
1 c4a 1099350822
1 c4a 1613228584
1 c4a 1894478506
1 c4a 1177138636
1 c4a 1752029211
1 c4a 1022389559
1 c4a 1924268624
1 c4a 1903074837
1 c4a 2257193882
1 c4a 2077755956
1 c4a 2610668373
1 c4a 2622537087
1 c4a 2564859889
1 c4a 2480108222
1 c4a 2927657266
1 c4a 2272339888
1 c4a 2843993769
1 c4a 2642950822
1 c4a 3662432930
1 c4a 3578208567
1 c4a 3125640436
1 c4a 3914203573
1 c4a 3162200876
1 c4a 3327927278
1 c4a 3204872605
1 c4a 3816707676
1 c4a 3904414630
1 c4a 3704913889
1 c4a 4482430287
1 c4a 4070320508
1 c4a 4312223817
1 c4a 4399803387
1 c4a 4873060275
1 c4a 4607814699
1 c4a 4381145365
1 c4a 4296356006
1 c4a 4451585898
1 c4a 4335641696
1 c4a 5358314818
1 c4a 5553719160
1 c4a 5239088587
1 c4a 5135468241
1 c4a 5847388196
1 c4a 5713326964
1 c4a 5453513471
1 c4a 5375472508
1 c4a 5181339969
1 c4a 5187502518
1 c4a 6638853953
1 c4a 6683448631
1 c4a 6482058386
1 c4a 6098558076
1 c4a 6793648828
1 c4a 6684914044
1 c4a 6747563118
1 c4a 6417987602
1 c4a 6431820320
1 c4a 6619094919
1 c4a 7119010120
1 c4a 7363062758
1 c4a 7139245349
1 c4a 7515160178
1 c4a 7610555530
1 c4a 7850013790
1 c4a 7571925992
1 c4a 7091651233
1 c4a 7835617442
1 c4a 7606621830
1 c4a 8829370114
1 c4a 8827960941
1 c4a 8816616080
1 c4a 8208609164
1 c4a 8758653082
1 c4a 8767523027
1 c4a 8169336161
1 c4a 8894907986
1 c4a 8496735661
1 c4a 8475253627
1 c4b 9395308501
1 c4b 9224780898
1 c4b 9946914363
1 c4b 9719875244
1 c4b 9118733628
1 c4b 9293853615
1 c4b 9276075795
1 c4b 9289892564
1 c4b 9761003506
1 c4b 9750828009
1 c5a 0000122507
1 c5a 0000143321
1 c5a 0000175869
1 c5a 0000151845
1 c5a 0000125401
1 c5a 0000151894
1 c5a 0000114793
1 c5a 0000187609
1 c5a 0000112722
1 c5a 0000112821
1 c5a 0000244038
1 c5a 0000284737
1 c5a 0000212365
1 c5a 0000248963
1 c5a 0000252684
1 c5a 0000293902
1 c5a 0000290643
1 c5a 0000288852
1 c5a 0000234237
1 c5a 0000238808
1 c5a 0000372870
1 c5a 0000317487
1 c5a 0000308072
1 c5a 0000372664
1 c5a 0000308171
1 c5a 0000305300
1 c5a 0000316091
1 c5a 0000372870
1 c5a 0000308544
1 c5a 0000345454
1 c5a 0000438002
1 c5a 0000444463
1 c5a 0000474643
1 c5a 0000487280
1 c5a 0000404392
1 c5a 0000482836
1 c5a 0000445239
1 c5a 0000416362
1 c5a 0000408187
1 c5a 0000406470
1 c5a 0000596320
1 c5a 0000522185
1 c5a 0000507194
1 c5a 0000544684
1 c5a 0000598219
1 c5a 0000598516
1 c5a 0000512608
1 c5a 0000586974
1 c5a 0000517870
1 c5a 0000551408
1 c5a 0000669598
1 c5a 0000621839
1 c5a 0000635144
1 c5a 0000618041
1 c5a 0000605055
1 c5a 0000665034
1 c5a 0000653956
1 c5a 0000625665
1 c5a 0000640441
1 c5a 0000646414
1 c5a 0000789909
1 c5a 0000713586
1 c5a 0000764597
1 c5a 0000775692
1 c5a 0000749648
1 c5a 0000778134
1 c5a 0000740985
1 c5a 0000712919
1 c5a 0000795658
1 c5a 0000700336
1 c5a 0000818369
1 c5a 0000803395
1 c5a 0000876797
1 c5a 0000833558
1 c5a 0000898635
1 c5a 0000841064
1 c5a 0000860866
1 c5a 0000864629
1 c5a 0000805374
1 c5a 0000876474
1 c5a 0134817549
1 c5a 0144246404
1 c5a 0192690375
1 c5a 0166397852
1 c5a 0139352835
1 c5a 0145698221
1 c5a 0104547801
1 c5a 0182071851
1 c5a 0145201533
1 c5a 0125617881
1 c5a 0245233574
1 c5a 0246272680
1 c5a 0255018806
1 c5a 0209445064
1 c5a 0271742604
1 c5a 0214403677
1 c5a 0253302406
1 c5a 0209148452
1 c5a 0267195969
1 c5a 0201913726
1 c5a 0349225335
1 c5a 0343947160
1 c5a 0320234098
1 c5a 0341255809
1 c5a 0342253463
1 c5a 0327791473
1 c5a 0324582344
1 c5a 0336321725
1 c5a 0333294917
1 c5a 0390484285
1 c5a 0426437379
1 c5a 0441501438
1 c5a 0418517044
1 c5a 0434340124
1 c5a 0442566902
1 c5a 0426833018
1 c5a 0498402492
1 c5a 0455899118
1 c5a 0453928236
1 c5a 0421313313
1 c5a 0561548937
1 c5a 0591081371
1 c5a 0556092804
1 c5a 0515148439
1 c5a 0581942543
1 c5a 0571307339
1 c5a 0540351291
1 c5a 0592121386
1 c5a 0533760314
1 c5a 0598896259
1 c5a 0628404837
1 c5a 0643767658
1 c5a 0645549449
1 c5a 0620211222
1 c5a 0648204229
1 c5a 0667147530
1 c5a 0665695025
1 c5a 0657155055
1 c5a 0613588812
1 c5a 0643114587
1 c5a 0736959515
1 c5a 0747477193
1 c5a 0755124312
1 c5a 0733691260
1 c5a 0785303076
1 c5a 0701771252
1 c5a 0768523235
1 c5a 0776708086
1 c5a 0717199466
1 c5a 0796581350
1 c5a 0801035347
1 c5a 0832139524
1 c5a 0868976635
1 c5a 0842682829
1 c5a 0827121907
1 c5a 0805291433
1 c5a 0844597995
1 c5a 0882225888
1 c5a 0838318563
1 c5a 0804021751
1 c5b 1535082974
1 c5b 1093733926
1 c5b 1601760144
1 c5b 1482966203
1 c5b 1301355898
1 c5b 1052520188
1 c5b 1371140516
1 c5b 1796283876
1 c5b 1022032536
1 c5b 1357525305
1 c5b 4369261202
1 c5b 4923498522
1 c5b 4741809267
1 c5b 4575513736
1 c5b 4990740379
1 c5b 4587916928
1 c5b 4912475706
1 c5b 4404415715
1 c5b 4681450176
1 c5b 4443103798
1 c5b 5665328378
1 c5b 5114637376
1 c5b 5912768160
1 c5b 5315329705
1 c5b 5541696779
1 c5b 5215985523
1 c5b 5391799564
1 c5b 5030531531
1 c5b 5897306863
1 c5b 5498911666
1 c5b 6654559156
1 c5b 6104085114
1 c5b 6148999265
1 c5b 6357694644
1 c5b 6836291366
1 c5b 6235577817
1 c5b 6359977690
1 c5b 6965385474
1 c5b 6928661886
1 c5b 6681053460
1 c5b 9646432462
1 c5b 9501601561
1 c5b 9339349969
1 c5b 9433575414
1 c5b 9840261929
1 c5b 9183831673
1 c5b 9299867725
1 c5b 9596167581
1 c5b 9460788531
1 c5b 9693635555
1 c5c 3201383472
1 c5c 3760388979
1 c5c 3141418883
1 c5c 3936981707
1 c5c 3834960704
1 c5c 3416990384
1 c5c 3796837858
1 c5c 3047870864
1 c5c 3354990768
1 c5c 3907957728
2 c5d 0035732611
2 c5d 0036051623
2 c5d 0037628863
2 c5d 0034426878
2 c5d 0037593898
2 c5d 0038694427
2 c5d 0036382193
2 c5d 0036575501
2 c5d 0039556343
2 c5d 0037227433
2 c5d 0043623025
2 c5d 0043635130
2 c5d 0040109823
2 c5d 0045825814
2 c5d 0045445567
2 c5d 0049049192
2 c5d 0046128875
2 c5d 0049244110
2 c5d 0045407263
2 c5d 0046895275
2 c5d 0050754282
2 c5d 0052623918
2 c5d 0051595892
2 c5d 0057807152
2 c5d 0050414725
2 c5d 0059710600
2 c5d 0053296538
2 c5d 0054213545
2 c5d 0058977394
2 c5d 0057151513
2 c5d 7051315030
2 c5d 7039237554
2 c5d 7033398495
2 c5d 7018133646
2 c5d 7054402754
2 c5d 7071198403
2 c5d 7051152214
2 c5d 7020331102
2 c5d 7035374970
2 c5d 7080091325
2 c5d 8591347624
2 c5d 8562456522
2 c5d 8504418256
2 c5d 8519081408
2 c5d 8572076189
2 c5d 8580587928
2 c5d 8555619823
2 c5d 8598811595
2 c5d 8508866365
2 c5d 8575845416
-3 c6 8527631369
-3 c6 8572732492
-3 c6 8533946660
-3 c6 8596461656
-3 c6 8533349915
-3 c6 8593724379
-3 c6 8539641034
-3 c6 8541380225
-3 c6 8559717987
-3 c6 8528929754
1 c6 7008199027
1 c6 7002000023
1 c6 7000202027
1 c6 9000430223
1 c6 9000781153
1 c6 2003455189
1 c6 2004001016
1 c6 1031405209
1 c6 1082012201
1 c6 0000065516
1 c6 0203178249
0 c6 7000062022
0 c6 7006003027
0 c6 7003306026
0 c6 7001501029
0 c6 9000641509
0 c6 9000260986
0 c6 2004306518
0 c6 2016001206
0 c6 1082311275
0 c6 1000118821
0 c6 0525111212
0 c6 0091423614
1 c7 0008526105
1 c7 0004633277
1 c7 0007505522
1 c7 0005379169
1 c7 0003478831
1 c7 0003153046
1 c7a 0003826567
1 c7 0002083905
1 c7 0006590541
1 c7 0005126743
1 c7a 0483032977
1 c7a 0948855209
1 c7a 0246588875
1 c7a 0365701266
1 c7a 0912945348
1 c7a 0872792752
1 c7a 0759853549
1 c7a 0529339437
1 c7a 0846167507
1 c7a 0201685530
1 c7b 6462896423
1 c7b 2407307553
1 c7b 7945741583
1 c7b 5624077760
1 c7b 3575469611
1 c7b 2102060108
1 c7b 7273977028
1 c7b 8862773633
1 c7b 8281348575
1 c7b 4029588720
1 c8a 9349756966
1 c8a 9983382889
1 c8a 3520828090
1 c8a 1033289347
1 c8a 3283199184
1 c8a 8448896475
1 c8a 7386672674
1 c8a 5704563179
1 c8a 3876829379
1 c8a 6967811461
1 c8b 1246481330
1 c8b 1155845771
1 c8b 8524154448
1 c8b 4475576948
1 c8b 5861738762
1 c8b 1960979075
1 c8b 8169631620
1 c8b 2806259236
1 c8b 4197635652
1 c8b 9732596833
1 c8c 7276001083
1 c8c 8549335622
1 c8c 2496507828
1 c8c 7467848188
1 c8c 6876530531
1 c8c 5908052787
1 c8c 8417165290
1 c8c 8923482196
1 c8c 3351358180
1 c8c 4217794746
1 c9a 2568024109
1 c9a 6980740325
1 c9a 6537445279
1 c9a 1758445017
1 c9a 8207264899
1 c9a 4299117681
1 c9a 6453575372
1 c9a 4043736661
1 c9a 6221362962
1 c9a 3988355875
1 c9b 2434400892
1 c9b 8126725680
1 c9b 8858532031
1 c9b 8578693647
1 c9b 9023404343
1 c9b 1229981470
1 c9b 5579572662
1 c9b 2322010049
1 c9b 7765083805
1 c9b 8456376728
1 d0a 8676409952
1 d0a 8086098711
1 d0a 6763459325
1 d0a 6082174354
1 d0a 6216395465
1 d0a 3130770495
1 d0a 7853174386
1 d0a 8282555305
1 d0a 8011947290
1 d0a 1223350009
2 d0b 5757413445
2 d0b 5717929323
2 d0b 5738134777
2 d0b 5718498472
2 d0b 5725358527
2 d0b 5713440788
2 d0b 5761757506
2 d0b 5728336164
2 d0b 5735237995
2 d0b 5799691543
0 d1 1588857929
0 d1 1321807744
0 d1 1749325410
0 d1 1424702818
0 d1 1650945586
0 d1 1440327939
0 d1 1374985215
0 d1 1223296467
0 d1 1666422505
0 d1 1761020626
0 d1 2547822830
0 d1 2387198614
0 d1 2196665159
0 d1 2116416626
0 d1 2419672750
0 d1 2083487238
0 d1 2975870731
0 d1 2660326882
0 d1 2732015372
0 d1 2328373508
0 d1 4712180408
0 d1 4097677119
0 d1 4171000311
0 d1 4792763594
0 d1 4878659203
0 d1 4836063977
0 d1 4529232863
0 d1 4254553020
0 d1 4663884412
0 d1 4396111505
0 d1 5753582543
0 d1 5712668110
0 d1 5109613133
0 d1 5841624679
0 d1 5587043548
0 d1 5283072973
0 d1 5044156958
0 d1 5361794829
0 d1 5762778850
0 d1 5327976676
0 d1 6639340007
0 d1 6914609381
0 d1 6023570243
0 d1 6650270315
0 d1 6906310592
0 d1 6841409483
0 d1 6867493056
0 d1 6300032693
0 d1 6493024192
0 d1 6664008552
-3 d1 7079571325
-3 d1 7138541152
-3 d1 7657988297
-3 d1 7796392153
-3 d1 7421342268
-3 d1 7939126971
-3 d1 7931146571
-3 d1 7667212886
-3 d1 7698491384
-3 d1 7355677010
-3 d1 8229551571
-3 d1 8455381347
-3 d1 8114963709
-3 d1 8026890206
-3 d1 8153221886
-3 d1 8815953751
-3 d1 8170356657
-3 d1 8689198905
-3 d1 8752483630
-3 d1 8971811348
1 00 1501824
1 00 1501832
1 00 539290858
1 00 9290701
1 06 5073321010
1 06 94012341
1 10 12345008
1 10 87654008
1 17 0446786040
1 19 0200520016
1 19 0240334000
1 24 0000138301
1 24 1306118605
1 24 3307118608
1 24 9307118603
1 25 521382181
1 26 0005501024
1 26 0520309001
1 26 1111118111
1 27 2847169488
1 28 19999000
1 28 9130000201
1 29 3145863029
1 31 1000000524
1 31 1000000583
1 32 0121114867
1 32 0122116979
1 32 1709107983
1 32 9030101192
1 32 9141405
1 32 9245500460
1 33 48658
1 33 84956
1 34 9913000700
1 34 9914001000
1 35 0000101599
1 35 0000101709
1 35 0000102349
1 35 0000102921
1 35 0000107451
1 35 0000108443
1 35 101599
1 35 108443
1 36 113178
1 36 146666
1 37 624315
1 37 632500
1 38 1100660
1 38 191919
1 39 10019400
1 39 200205
1 40 1258345
1 40 3231963
1 41 0166805317
1 41 4013410024
1 41 4016660195
1 41 4019151002
1 41 4019310079
1 41 4019340829
1 42 59498
1 42 59510
1 43 6135244
1 43 9516893476
1 44 2618040504
1 44 889006
1 45 3545343232
1 45 4013410024
1 46 0235468612
1 46 0837890901
1 46 1041447600
1 47 1003554450
1 47 1018000
1 50 4000005001
1 50 4444442001
1 51 0000156071
1 51 0000156078
1 51 0001156071
1 51 0001156136
1 51 3199500501
1 54 4900010987
1 54 4964137395
1 56 290545005
1 56 9718304037
1 57 7500021766
1 57 7800028282
1 57 8100244186
1 57 9400001734
1 58 1015222224
1 58 1800293377
1 58 1800881120
1 58 3703169668
1 58 9200654108
1 61 0260760481
1 61 2063099200
1 62 5029076701
1 63 1234566
1 63 123456600
1 64 1206473010
1 64 5016511020
1 65 1234567400
1 65 1234567590
1 66 100150502
1 66 100154508
1 66 100154516
1 66 101154508
1 66 101154516
1 68 8889654328
1 68 987654324
1 68 987654328
1 69 1234567006
1 69 1234567900
1 69 9721134869
1 71 7101234007
1 73 3503398
1 73 7899100003
1 74 235374
1 74 500512
1 74 836601
1 74 844675
1 74 857193
1 74 239314
1 74 239314
1 74 239319
1 74 239319
1 76 0006543200
1 76 123456
1 76 12345600
1 76 7876543100
1 76 9012345600
1 77 10338
1 77 1234554321
1 77 13844
1 77 65354
1 77 69258
1 78 7581499
1 78 9999999981
1 79 1550167850
1 79 3230012688
1 79 4230028872
1 79 5440001898
1 79 6330001063
1 79 7000149349
1 79 8000003577
1 79 9011200140
1 80 3199500501
1 80 340966
1 80 340968
1 81 0646440
1 81 1359100
1 81 3199500501
1 82 123897
1 82 3199500501
1 83 0000156071
1 83 0000156078
1 83 0001156071
1 83 0001156136
1 83 0099100002
1 84 100005
1 84 3199500501
1 84 393814
1 84 950360
1 85 0000156071
1 85 0000156078
1 85 0001156071
1 85 0001156136
1 85 3199100002
1 86 1001171
1 86 1009588
1 86 123897
1 86 3199500501
1 86 340968
1 87 0000000406
1 87 0000051768
1 87 0000100005
1 87 0000393814
1 87 0000950360
1 87 0010701590
1 87 0010720185
1 87 3199500501
1 88 1000500
1 88 2525259
1 88 90013000
1 88 92525253
1 88 99913003
1 89 1098506
1 89 218433000
1 89 32028008
1 90 0000156071
1 90 0000156073
1 90 0000156077
1 90 0000156132
1 90 0001156132
1 90 0001156136
1 90 0099100002
1 91 2974117000
1 91 2974118000
1 91 5281741000
1 91 5281770000
1 91 9952810000
1 91 9952812000
1 93 0000127783
1 93 0000127791
1 93 0000306754
1 93 0000671479
1 93 1277830000
1 93 1277910000
1 93 3067540000
1 93 6714790000
1 94 6782533003
1 95 0068007003
1 95 0847321750
1 95 6450060494
1 95 6454000003
1 96 0000000208
1 96 0000254100
1 96 0101115152
1 96 0301204301
1 96 9421000009
1 97 24010019
1 98 3009800016
1 98 5989800173
1 98 6719430018
1 98 9619319999
1 98 9619439213
1 98 9619509976
1 98 9619608118
1 99 0068007003
1 99 0847321750
1 a0 18761
1 a0 28290
1 a0 3287
1 a0 521003287
1 a0 54500
1 a1 0010030005
1 a1 0010030997
1 a1 1010030054
1 a21 3456789019
1 a21 5678901231
1 a21 6789012348
1 a22 3456789012
1 a31 0123456782
1 a31 1234567897
1 a32 0123456789
1 a32 1234567890
1 a32 9876543210
1 a41 0004711173
1 a41 0007093330
1 a42 0004711172
1 a42 0007093335
1 a43 1199503010
1 a43 8499421235
1 a44 0000905844
1 a44 5030101099
1 a44 9058440000
1 a45 0000862342
1 a45 8623420000
1 a51 9380027210
1 a51 9932290910
1 a51 9941510001
1 a51 9961230019
1 a52 0000051640
1 a52 0000159590
1 a52 0000251437
1 a52 0007948344
1 a61 0855000014
1 a61 800048548
1 a62 150178033
1 a62 17
1 a62 55300030
1 a62 600003555
1 a62 900291823
1 a71 19010008
1 a71 19010438
1 a72 19010660
1 a72 19010876
1 a72 209010892
1 a81 1359100
1 a81 7436661
1 a81 7436670
1 a82 0001340967
1 a82 0003503398
1 a82 7436660
1 a82 7436678
1 a83 0099100010
1 a83 0199100002
1 a83 2599100002
1 a84 0199100004
1 a84 2599100003
1 a84 3199204090
1 a91 5043608
1 a91 86725
1 a92 32577083
1 a92 504360
1 a92 822035
1 b0 1000000406
1 b0 1035791538
1 b0 1126939724
1 b0 1197423460
1 b11 1434253150
1 b11 2746315471
1 b12 7414398260
1 b12 8347251693
1 b21 0020012357
1 b21 0080012345
1 b21 0926801910
1 b21 1002345674
1 b22 8000990054
1 b22 9000481805
1 b31 0000000019
1 b31 0000000140
1 b31 1000000060
1 b31 1002798417
1 b31 8409915001
1 b32 9635000101
1 b32 9730200100
1 b41 9380027210
1 b41 9932290910
1 b41 9941510001
1 b41 9961230019
1 b42 0000051640
1 b42 0000251437
1 b42 0007948344
1 b51 0159006955
1 b51 1151043216
1 b51 2000123451
1 b51 9000939033
1 b52 0123456782
1 b52 0130098767
1 b52 1045000252 
1 B61 9110000000
1 B61 0269876545
1 B71 0001001008
1 B71 0001007222
1 B71 0001057887
1 B71 0005922372
1 B71 0700001529
1 B71 0730000019
1 B71 0800107653
1 B71 0810011825
1 B81 0734192657
1 B81 6932875274
1 B82 2938692523
1 B82 3145863029
1 B91 41203755
1 B91 58467232
1 B91 61287958
1 B91 81069577
1 B91 87920182
1 B91 87920187
1 B91 87920187
1 B92 1253657
1 B92 4353631
1 B92 7125633
1 C02 0082335729
1 C02 0734192657
1 C02 6932875274
1 C11 0446786040
1 C11 0478046940
1 C11 0701625830
1 C11 0701625840
1 C11 0882095630
1 C12 5432112349
1 C12 5543223456
1 C12 5654334563
1 C12 5765445670
1 C12 5876556788
1 C21 2394871426
1 C21 4218461950
1 C21 7352569148
1 C22 5127485166
1 C22 8738142564
1 c31 19919
1 c31 4431276
1 c31 9294182
1 c32 9000010006
1 c32 9000420530
1 c32 9000577650
1 c41 0000000019
1 c41 0000094455
1 c41 0000292932
1 c42 9000010006
1 c42 9000420530
1 c42 9000577650
1 c5 0000301168
1 c5 0000302554
1 c5 0300020050
1 c5 0300566000
1 c51 0000301168
1 c51 0000302554
1 c5 1000061378
1 c5 1000061412
1 c51 0300020050
1 c51 0300566000
1 c52 1000061378
1 c52 1000061412
1 c52 4450164064
1 c52 4863476104
1 c52 5000000028
1 c52 5000000391
1 c52 6450008149
1 c52 6800001016
1 c52 9000100012
1 c52 9000210017
1 c5 3060188103
1 c5 3070402023
1 c53 3060188103
1 c53 3070402023
1 c5 4450164064
1 c5 4863476104
1 c5 5000000028
1 c5 5000000391
1 c5 6450008149
1 c5 6800001016
1 c5 9000100012
1 c5 9000210017
1 c6 7000005024
1 c6 7000202027
1 c6 7002000023
1 c6 7008199027
1 c73 3500022
1 c71 38150900
1 c71 39101181
1 c71 600103660
1 c72 5073321010
1 c72 5073321010
1 C72 5073321010
1 c72 94012341
1 c72 94012341
1 C72 94012341
1 c7 3500022
1 c7 38150900
1 c7 39101181
1 c7 600103660
2 45 0000012340
2 45 0100114240
2 45 0994681254
2 45 1000199999
2 57 1909700805
2 57 5001050352
2 57 5045090090
2 57 7777778800
2 96 0001300000
2 96 0099399999
2 c5 0030001230
2 c5 0040230000
2 c5 0050044000
2 c5 0059999999
2 c5 7000000000
2 c5 7000334560
2 c5 7023445000
2 c5 7099999999
2 c5 8500000000
2 c5 8502334450
2 c5 8599999999
1 c51 0000301168
1 c51 0000302554
1 c51 0300020050
1 c51 0300566000
1 c52 1000061378
1 c52 1000061412
1 c52 4450164064
1 c52 4863476104
1 c52 5000000028
1 c52 5000000391
1 c52 6450008149
1 c52 6800001016
1 c52 9000100012
1 c52 9000210017
1 c53 3060188103
1 c53 3070402023
1 c6 7000005024
1 c6 7008199027
1 c6 7002000023
1 c6 7000202027
1 c71 38150900
1 c71 600103660
1 c71 39101181
1 c72 94012341
1 c72 5073321010
1 c7 38150900
1 c7 600103660
1 c7 39101181
1 c72 94012341
1 c72 5073321010
1 C72 94012341
1 C72 5073321010
1 C81 3456789019
1 C81 5678901231
1 C82 3456789012
1 C83 0123456789
1 C91 3456789019
1 C91 5678901231
1 C92 0123456789
1 D0 6100272324
1 D0 6100273479
2 D0 5724434334
2 D0 5721233334
2 D0 5723453334
1 D1 0082012203
1 D1 1452683581
1 D1 2129642505
1 D1 3002000027
1 D1 4230001407
1 D1 5000065514
1 D1 6001526215
1 D1 9000430223
0 D1 0000260986
0 D1 1062813622
0 D1 2256412314
0 D1 2001501026
0 D1 3012084101
0 D1 4006003027
0 D1 5814500990
0 D1 6128462594
-3 D1 7000062025
-3 D1 8003306026
0 D1 9000641509
0 a1 0010030998
-3 a1 0000030005
-3 a1 0110030005
0 a21 1234567890
0 a21 3456789012
0 a22 0123456789
0 a22 1234567890
0 a31 0543216789
0 a31 1234567890
0 a31 6543217890
0 a31 9876543210
0 a32 0543216789
0 a32 6543217890
0 a41 0004711172
0 a41 8623420004
0 a42 0001123458
0 a42 8623420000
0 a43 1299503117
0 a43 6099702031
0 a44 0000399443
0 a44 0000553313
0 a44 3994430000
0 a44 5533130000
0 a51 9941510002
0 a51 9961230020
0 a52 0000251438
0 a52 0007948345
0 a61 810033652
0 a61 860000817
0 a62 200071280
0 a62 305888
0 a71 19010660
0 a71 19010876
0 a71 209010892
0 a71 209010893
0 a72 209010893
0 a81 7436660
0 a81 7436678
0 a82 7436666
0 a82 7436666
0 a82 7436677
0 a82 7436677
0 a83 0099345678
0 a83 0199100004
0 a83 2599100003
0 a84 0099100110
0 a84 0099345678
0 a84 0199100040
0 a91 32577083
0 a91 504360
0 a91 822035
0 a91 86724
0 a92 292497
0 a92 30767208
0 a92 86724
0 b0 1000000405
0 b0 1035791539
-3 b0 51234901
-3 b0 535791830
-3 b0 8035791532
0 b11 0123456789
0 b11 2345678901
0 b11 5678901234
0 b11 7414398260
0 b11 8347251693
0 b12 0123456789
0 b12 2345678901
0 b12 5678901234
0 b21 0080012347
0 b21 0932100027
0 b21 3310123454
-3 b21 0020012399
-3 b21 0080012370
0 b22 8000990057
0 b22 8011000126
0 b22 9000481800
0 b22 9980480111
0 b31 0002799899
0 b31 1000000111
0 b32 9635100101
0 b32 9730300100
0 b41 9941510002
0 b41 9961230020
0 b42 0000251438
0 b42 0007948345
-3 b42 0000159590
0 b51 1151043211
0 b51 2345678901
0 b51 5678901234
0 b51 7414398260
0 b51 8347251693
0 b51 9000293707
0 b52 0023456787
0 b52 0056789018
0 b52 0159004165
0 b52 3045000333
0 B61 9111000000
0 B61 0269456780
0 B71 0001057886
0 B71 0003815570
0 B71 0005620516
0 B71 0740912243
0 B71 0893524479
0 B81 0132572975
0 B81 2938692523
0 B81 3145863029
0 B82 0132572975
0 B91 43025432
0 B91 54352684
0 B91 61256523
0 B91 86521362
0 B91 88034023
0 B92 2356412
0 B92 5435886
0 B92 9435414
0 C02 0132572975
0 C02 3038752371
0 C11 0446786240
0 C11 0478046340
0 C11 0701625440
0 C11 0701625730
0 C11 0882095130
0 C12 5432112341
0 C12 5543223458
0 C12 5654334565
0 C12 5765445672
0 C12 5876556780
0 C21 0328705282
0 C21 5127485166
0 C21 8738142564
0 C21 9024675131
0 C22 0328705282
0 C22 9024675131
0 c31 122448
0 c31 123451
0 c31 17002
0 c32 9000726558
0 c32 9000732000
0 c32 9001733457
0 c4a 0000000017
0 c4a 0000094459
0 c4a 0000292933
0 c4b 9000726558
0 c4b 9000732000
0 c4b 9001733457
0 c5 0000302589
0 c5 0000507336
0 c5 0302555000
0 c5 0302589000
0 c51 0000302589
0 c51 0000507336
0 c5 1000061457
0 c5 1000061498
0 c51 0302555000
0 c51 0302589000
0 c52 1000061457
0 c52 1000061498
0 c52 4864446015
0 c52 4865038012
0 c52 5000001028
0 c52 5000001075
0 c52 6450008150
0 c52 6542812818
0 c52 9000110012
0 c52 9000300310
0 c5 3081000783
0 c5 3081308871
0 c53 3081000783
0 c53 3081308871
0 c5 4864446015
0 c5 4865038012
0 c5 5000001028
0 c5 5000001075
0 c5 6450008150
0 c5 6542812818
0 c5 9000110012
0 c5 9000300310
0 c6 7000062022
0 c6 7001501029
0 c6 7003306026
0 c6 7006003027
0 c71 5073321010
0 c71 94012341
0 c72 1234517892
0 c72 987614325
0 C81 3456789012
0 C81 0123456789
0 C81 1234567890
0 C81 9012345678
0 C82 0123456789
0 C82 1234567890
0 C82 9012345678
0 C82 0123456789
-3 C83 1234567890
0 C83 9012345678
0 C91 3456789012
0 C91 0123456789
0 C91 1234567890
0 C91 9012345678
-3 C92 1234567890
0 C92 9012345678
0 D0 6100272885
0 D0 6100273377
0 D0 6100274012
1 D21 189912137
1 D21 235308215
1 D22 4455667784
1 D22 1234567897
1 D23 51181008
1 D23 71214205
0 D21 4455667784
0 D21 1234567897
0 D21 51181008
0 D21 71214205
0 D21 6414241
0 D21 179751314
0 D22 51181008
0 D22 71214205
0 D22 6414241
0 D22 179751314
0 D23 6414241
0 D23 179751314
1 D31 1600169591
1 D31 1600189151
1 D31 1800084079
1 D32 6019937007
1 D32 6021354007
1 D32 6030642006
0 D31 1600166307
0 D31 1600176485
0 D31 1600201934
0 D32 6025017009
0 D32 6028267003
0 D32 6019835001
1 D4 3000005012
1 D4 4143406984
1 D4 5926485111
1 D4 9002364588
1 D4 1000062025
-3 D4 0006003027
0 D4 8003306026
0 D4 9916524534
0 D4 5212744564
0 D4 3000255397
1 D51 5999242133
1 D51 5999718138
1 D51 1799222116
1 D51 0099632004
1 D52 0004711173
1 D52 0007093330
1 D52 0000127787
1 D53 0004711172
1 D53 0007093335
1 D54 0004711174
1 D54 0000100062
1 D54 0000100088
0 D51 3299632008  
0 D51 1999204293  
0 D51 0399242139  
0 D52 0004711172  
0 D52 8623420004  
0 D52 0001123458  
0 D53 8623410000  
0 D53 0001123458  
0 D54 0000100084  
0 D54 0000100085  
1 D61 3409
1 D61 585327
1 D61 1650513
1 D62 3601671056
1 D62 4402001046
1 D62 6100268241
1 D63 7001000681
1 D63 9000111105
1 D63 9001291005
0 D61 33394
0 D61 595795
0 D61 16400501
0 D62 3615071237
0 D62 6039267013
0 D62 6039316014
0 D63 7004017653
0 D63 9002720007
0 D63 9017483524
1 D7 0500018205
1 D7 0301000434
1 D7 0420001202
1 D7 0201005939
1 D7 0230103715
1 D7 0330035104
1 D7 0134637709
1 D7 0602006999
1 D8 1403414848
1 D8 6800000439
1 D8 6899999954 
2 D8 0012349954 
2 D8 0092349954 
0 D7 0501006102
0 D7 0301005331
0 D7 0420001302
0 D7 0202005939
0 D7 0231307867
0 D7 0330034104
0 D7 0135638809
0 D7 0601006977
0 D8 3012084101
0 D8 1062813622
-3 D8 0000260986
-3 D8 0500260986
