
use strict;
use warnings;



use ExtUtils::MakeMaker 6.30;



my %WriteMakefileArgs = (
  'ABSTRACT' => 'tools for working with the SIO ontology',
  'AUTHOR' => 'Mark D Wilkinson <markw@illuminae.com>',
  'BUILD_REQUIRES' => {
    'Data::Dumper' => '0',
    'English' => '0',
    'Test::More' => '0'
  },
  'CONFIGURE_REQUIRES' => {
    'ExtUtils::MakeMaker' => '6.30'
  },
  'DISTNAME' => 'RDF-SIO-Utils',
  'EXE_FILES' => [],
  'LICENSE' => 'bsd',
  'NAME' => 'RDF::SIO::Utils',
  'PREREQ_PM' => {
    'Carp' => '0',
    'Exporter' => '0',
    'RDF::Trine' => '0',
    'RDF::Trine::Node::Literal' => '0',
    'RDF::Trine::Node::Resource' => '0',
    'RDF::Trine::Statement' => '0',
    'constant' => '0',
    'vars' => '0'
  },
  'VERSION' => '0.001',
  'test' => {
    'TESTS' => 't/*.t'
  }
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



