use v5.12;
use warnings;


package Data::Proxy::TieArray;
require Tie::Array;
use Carp;
use Data::Dump qw/pp/;
our @ISA = qw(Tie::StdArray);

$SIG{__WARN__} = sub { warn $_[0] unless $_[0] =~ /Use of reference "bless=HASH\(0x[0-9a-f]+\)"/};


# All methods provided by default, define 
# only those needing overrides
# Accessors access the storage in %{$_[0][0]};
# TIEHASH should return an array reference with the first element
# being the reference to the actual storage

sub _report { carp "Doing \U$_[0]\E at $_[2] -> $_[1] \n"};

sub DELETE { 
  _report('delete', $_[0][0], $_[1]); 
  delete $_[0]->[$_[1]];           #  $_[0]->SUPER::DELETE($_[1])
}

sub FETCH {
    warn pp $_[1];
    _report('FETCH', $_[0], $_[1]); 
    #return "<XXX>";
    return "<" . $_[0]->[ $_[1] ] . ">";
}

#sub TIEHASH  { bless [ %, @_], $p }

package main;
use Data::Dump;

my @arr =(40..42);

dd
my $obj = tie @arr, "Data::Proxy::TieArray", \@arr;

$arr[0]=666;

dd tied @arr;

sub a {
    $a = bless {a=>1},"bless";
    warn  "INSIDE", 0+ $a;
    return $a;
}

say $arr[ a() ];


