use 5.012;
use warnings;
use Data::Dump;


package main;

my %hash;
@hash{"a".."c"} = 40 ..42;              # init

say \%hash;

#my $copy =

ddx "TIE: ",
tie                                     # bind wrapper
  %hash,
  'Wrapper::TieHash',
  \%hash;                               # redundant, why?

ddx "TIED: ",tied %hash;

dd $hash{a};



BEGIN {
    package Wrapper::TieHash;           # TODO NAME
    use Data::Dump;
    use Scalar::Util qw/blessed/;

    # Storage for wrapped object
    #  Inside Out to avoid recursion by Inspection
    my %wrapped;

    sub TIEHASH  {
        ddx "TIEHASH: ", 
          my ($class, $orig) = @_;
        my $self = bless {}, $class;
        $wrapped{$self} = $orig;        # store original object
        ddx \%wrapped;
        
        return $self;
    }

    sub FETCH {
        my ($self, $key) = @_;
        my $orig = $wrapped{$self};
        delete $wrapped{$self};
        #_report('FETCH', $orig, $key);

        my $class = blessed $self;
        undef $self;                     # avoid warning
        untie %{$orig};

        
        my $ret = $orig->{$key};

        tie %{$orig}, $class, $orig;

        return "<$ret>" if defined $ret;
        return undef;
    }

    our $AUTOLOAD;
    sub AUTOLOAD {
        my $meth = $AUTOLOAD
          =~ s/^.*:://
          ;

        ddx "AUTOLOAD: ",$AUTOLOAD, \@_;
        ddx "Meth:", $meth;
    }

    sub _local_untie {
    }
    
}


=pod

package Tie::StdHash;
# @ISA = qw(Tie::Hash);		# would inherit new() only

sub TIEHASH  { bless {}, $_[0] }
sub STORE    { $_[0]->{$_[1]} = $_[2] }
sub FETCH    { $_[0]->{$_[1]} }
sub FIRSTKEY { my $a = scalar keys %{$_[0]}; each %{$_[0]} }
sub NEXTKEY  { each %{$_[0]} }
sub EXISTS   { exists $_[0]->{$_[1]} }
sub DELETE   { delete $_[0]->{$_[1]} }
sub CLEAR    { %{$_[0]} = () }
sub SCALAR   { scalar %{$_[0]} }
# The Tie::StdHash package implements standard perl hash behaviour.
# It exists to act as a base class for classes which only wish to
# alter some parts of their behaviour.

package Tie::StdHash;
# @ISA = qw(Tie::Hash);		# would inherit new() only

sub TIEHASH  { bless {}, $_[0] }
sub STORE    { $_[0]->{$_[1]} = $_[2] }
sub FETCH    { $_[0]->{$_[1]} }
sub FIRSTKEY { my $a = scalar keys %{$_[0]}; each %{$_[0]} }
sub NEXTKEY  { each %{$_[0]} }
sub EXISTS   { exists $_[0]->{$_[1]} }
sub DELETE   { delete $_[0]->{$_[1]} }
sub CLEAR    { %{$_[0]} = () }
sub SCALAR   { scalar %{$_[0]} }

package Tie::ExtraHash;

sub TIEHASH  { my $p = shift; bless [{}, @_], $p }
sub STORE    { $_[0][0]{$_[1]} = $_[2] }
sub FETCH    { $_[0][0]{$_[1]} }
sub FIRSTKEY { my $a = scalar keys %{$_[0][0]}; each %{$_[0][0]} }
sub NEXTKEY  { each %{$_[0][0]} }
sub EXISTS   { exists $_[0][0]->{$_[1]} }
sub DELETE   { delete $_[0][0]->{$_[1]} }
sub CLEAR    { %{$_[0][0]} = () }
sub SCALAR   { scalar %{$_[0][0]} }

1;

=cut
