package # hide from PAUSE
App::YTDL::Arguments;

use warnings;
use strict;
use 5.010000;

use Exporter qw( import );
our @EXPORT_OK = qw( from_arguments_to_choices );

use Term::ANSIScreen qw( :cursor :screen );
use Term::Choose     qw( choose );

use if $^O eq 'MSWin32', 'Win32::Console::ANSI';

use App::YTDL::ChooseVideos qw( choose_videos );
use App::YTDL::DataExtract  qw( prepare_info );
use App::YTDL::GetData      qw( get_vimeo_list_info get_download_info get_youtube_list_info );



sub from_arguments_to_choices {
    my ( $opt, @ids ) = @_;
    my $info = {};
    my $invalid_char = $opt->{invalid_char};
    my $more = 0;
    for my $webpage_url ( @ids ) {
        if ( $webpage_url =~ /^c#([\p{PerlWord}-]+)\z/ ) {
            $webpage_url = sprintf 'https://www.youtube.com/user/%s/', $1;
        }
        if ( $webpage_url =~ /^p#(?:[FP]L)?([\p{PerlWord}-]+)\z/ ) {
            $webpage_url = sprintf 'https://www.youtube.com/playlist?list=%s/', $1;
        }
        if ( my $uploader_id = _youtube_user_id( $opt, $webpage_url ) ) {
            my $ex = 'youtube';
            my $tmp = _youtube_list_info( $opt, 'CL', $uploader_id );
            next if ! defined $tmp;
            my ( $vi ) = keys %{$tmp->{$ex}};
            my $prompt = $tmp->{$ex}{$vi}{uploader};
            choose_videos( $opt, $info, $tmp, $ex, $prompt );
        }
        #elsif ( my $playlist_id = _youtube_playlist_id( $opt, $webpage_url ) ) {
        #    my $ex = 'youtube';
        #    my $tmp = _yt_list_info( $opt, 'PL', $playlist_id );
        #    next if ! defined $tmp;
        #    my $prompt = $playlist_id;
        #    choose_videos( $opt, $info, $tmp, $ex, $prompt );
        #}
        elsif ( my $video_id = _youtube_video_id( $opt, $webpage_url )  ) {
            my $ex = 'youtube';
            $info->{$ex}{$video_id}{extractor}   = 'youtube';
            $info->{$ex}{$video_id}{webpage_url} = sprintf 'https://www.youtube.com/watch?v=%s', $video_id;
            prepare_info( $opt, $info, $ex, $video_id );
        }
        elsif ( my $vimeo_uploader_id = _vimeo_uploader_id( $opt, $webpage_url )  ) {
            my $ex = 'vimeo';
            my $tmp = _vimeo_list_info( $opt, $vimeo_uploader_id );
            next if ! defined $tmp;
            my ( $vi ) = keys %{$tmp->{$ex}};
            my $prompt = $tmp->{$ex}{$vi}{uploader} || $vimeo_uploader_id;
            choose_videos( $opt, $info, $tmp, $ex, $prompt );
        }
        else {
            _generic( $opt, $info, $webpage_url );
        }
    }
    return $info;
}


sub _generic {
    my ( $opt, $info, $webpage_url ) = @_;
    my $message = "Fetching download info: ";
    my $tmp = get_download_info( $opt, $webpage_url, $message );
    next if ! defined $tmp;
    my ( $ex ) = keys %$tmp;
    my @keys = keys %{$tmp->{$ex}};
    if ( @keys == 1 ) {
        my $video_id = $keys[0];
        $info->{$ex}{$video_id} = $tmp->{$ex}{$video_id};
    }
    else {
        my $prompt = $tmp->{$ex}{$keys[0]}{uploader} || $webpage_url;
        choose_videos( $opt, $info, $tmp, $ex, $prompt );
    }
}


sub _youtube_video_id {
    my ( $opt, $webpage_url ) = @_;
    my $invalid_char = $opt->{invalid_char};
    return     if ! $opt->{fast_list_youtube};
    return     if ! $webpage_url;
    return $1  if   $webpage_url =~ m{^([\p{PerlWord}-]{11})\z};
    return     if   $webpage_url !~ $opt->{yt_regexp};
    return $1  if   $webpage_url =~ m{/.*?[?&;!](?:v|video_id)=([^$invalid_char]+)};
    return $1  if   $webpage_url =~ m{/(?:e|v|embed)/([^$invalid_char]+)};
    return $1  if   $webpage_url =~ m{#p/(?:u|search)/\d+/([^&?/]+)};
    return $1  if   $webpage_url =~ m{youtu.be/([^$invalid_char]+)};
    return;
}


#sub _youtube_playlist_id {
#    my ( $opt, $webpage_url ) = @_;
#    my $invalid_char = $opt->{invalid_char};
#    return    if ! $opt->{fast_list_youtube};
#    return    if ! $webpage_url;
#    return    if   $webpage_url !~ $opt->{yt_regexp};
#    return $1 if   $webpage_url =~ m{/.*?[?&;!]list=([^$invalid_char]+)};
#    return;
#}


sub _youtube_user_id {
    my ( $opt, $webpage_url ) = @_;
    my $invalid_char = $opt->{invalid_char};
    return    if ! $opt->{fast_list_youtube};
    return    if ! $webpage_url;
    return    if   $webpage_url !~ $opt->{yt_regexp};
    return $1 if   $webpage_url =~ m{/user/([^$invalid_char]+)};
    return $1 if   $webpage_url =~ m{/channel/([^$invalid_char]+)}; # ?
    return;
}


sub _vimeo_uploader_id {
    my ( $opt, $webpage_url ) = @_;
    return    if ! $opt->{fast_list_vimeo};
    return    if ! $webpage_url;
    return $1 if   $webpage_url =~ m{https?://vimeo\.com/(?![0-9]+(?:$|[?#/]))([^/]+)(?:/videos|[#?]|$)};
    return;
}


sub _youtube_list_info {
    my( $opt, $type, $list_id ) = @_;
    printf "Fetching info data ... \n";
    #my $url = sprintf 'https://www.youtube.com/user/%s/videos?sort=dd&view=0&flow=list', $list_id;
    my $url = sprintf 'https://www.youtube.com/user/%s/videos', $list_id;
    my $ex = 'youtube';
    my $tmp_info = {};
    my $a_ref = get_youtube_list_info( $opt, $url );
    if ( ! defined $a_ref ) {
        push @{$opt->{error_get_download_infos}}, sprintf "%s: %s", $type, $list_id;
        my $prompt = "Error list info: $type - $url";
        choose( [ 'ENTER to continue' ], { prompt => $prompt } );
        return;
    }
    for my $entry ( @{$a_ref} ) {
        my $video_id = $entry->{video_id};
        $tmp_info->{$ex}{$video_id} = {
            video_id        => $video_id,
            title           => $entry->{title},
            upload_date_rel => $entry->{upload_date_rel},
            uploader        => $entry->{uploader},
            view_count      => $entry->{view_count},
            duration        => $entry->{duration},
            date_sort       => $entry->{date_sort},
            webpage_url     => $entry->{webpage_url},
        };
        prepare_info( $opt, $tmp_info, $ex, $video_id );
    }
    if ( ! keys %{$tmp_info->{$ex}} ) {
        my $prompt = "No videos found: $type - $url";
        choose( [ 'Continue with ENTER' ], { prompt => $prompt } );
    }
    my $up = keys %{$tmp_info->{$ex}};
    print up( $up + 2 ), cldown;
    return $tmp_info;
}


sub _vimeo_list_info {
    my( $opt, $list_id ) = @_;
    printf "Fetching info ... \n";
    my $page_nr = 1;
    my $ex = 'vimeo';
    my $tmp_info = {};
    my $videos = 0;
    my $url;
    while ( 1 ) {
        $url = sprintf 'https://vimeo.com/%s/videos/page:%d/sort:date', $list_id, $page_nr;
        my ( $a_ref, $next ) = get_vimeo_list_info( $opt, $url );
        if ( ! defined $a_ref ) {
            push @{$opt->{error_get_download_infos}}, sprintf "%s: error", $list_id;
            return;
        }
        if ( ! @$a_ref ) {
            push @{$opt->{error_get_download_infos}}, sprintf "%s: no videos found.", $url;
        }
        for my $entry ( @{$a_ref} ) {
            my $video_id = $entry->{video_id};
            $tmp_info->{$ex}{$video_id} = {
                video_id    => $video_id,
                title       => $entry->{title},
                published   => $entry->{published},
                uploader    => $entry->{uploader},
                webpage_url => $entry->{webpage_url},
            };
            prepare_info( $opt, $tmp_info, $ex, $video_id );
        }
        $videos += @{$a_ref};
        last if $opt->{small_list_size} && $videos >= 48;
        last if ! $next;
        $page_nr++;
    }
    if ( ! keys %{$tmp_info->{$ex}} ) {
        my $prompt = "No videos found: $url";
        choose( [ 'Continue with ENTER' ], { prompt => $prompt } );
    }
    my $up = keys %{$tmp_info->{$ex}};
    print up( $up + 2 ), cldown;
    return $tmp_info;
}




1;


__END__
