package # hide from PAUSE
App::YTDL::Data_Extract;

use warnings;
use strict;
use 5.010000;

use Exporter qw( import );
our @EXPORT_OK = qw( add_entry_to_info_hash json_to_hash );

use JSON qw( decode_json );

use App::YTDL::Helper qw( sec_to_time insert_sep );



sub add_entry_to_info_hash {
    my ( $opt, $info, $entry, $type, $list_id ) = @_;
    die '$entry node not defined!' if ! defined $entry;
    die 'empty $entry node!'       if ! $entry;
    my $video_id = $entry->{'media$group'}{'yt$videoid'}{'$t'};
    die 'no video_id!' if ! $video_id;
    my $title       = $entry->{'title'}{'$t'};
    my $description = $entry->{'media$group'}{'media$description'}{'$t'};
    my $keywords    = $entry->{'media$group'}{'media$keywords'}{'$t'};
    my $author      = $entry->{'author'}[0]{'name'}{'$t'};
    my $author_uri  = $entry->{'author'}[0]{'uri'}{'$t'};
    my $user_id     = $entry->{'author'}[0]{'yt$userId'}{'$t'};
    #my $categories  = $entry->{'media$group'}{'media$category'}[0]{'$t'};
    my $published   = $entry->{'published'}{'$t'};
    my $seconds     = $entry->{'media$group'}{'yt$duration'}{'seconds'};
    my $avg_rating  = $entry->{'gd$rating'}{'average'};
    my $num_raters  = $entry->{'gd$rating'}{'num_raters'};
    my $view_count  = $entry->{'yt$statistics'}{'viewCount'};
    my $likes       = $entry->{'yt$rating'}{'numLikes'};
    my $dislikes    = $entry->{'yt$rating'}{'numDislikes'};
    $info->{$video_id} = {
        uploader    => $author,
        author_uri  => $author_uri,
        user_id     => $user_id,
        avg_rating  => $avg_rating,
        #categories  => $categories,
        description => $description,
        keywords    => $keywords,
        duration    => $seconds,
        upload_date => $published,
        raters      => $num_raters,
        title       => $title,
        video_id    => $video_id,
        view_count  => $view_count,
        likes       => $likes,
        dislikes    => $dislikes,
    };
    if ( $info->{$video_id}{author_uri} && $info->{$video_id}{author_uri} =~ m|/users/([^$opt->{invalid_char}]+)| ) {
        $info->{$video_id}{uploader_id} = $1;
    }
    if ( $info->{$video_id}{upload_date} && $info->{$video_id}{upload_date} =~ /^(\d\d\d\d-\d\d-\d\d)T/ ) {
        $info->{$video_id}{upload_date} = $1;
    }
    if ( defined $type && $type eq 'PL' ) {
        $info->{$video_id}{playlist_id} = $list_id;
    }
    _prepare_info_hash( $info, $video_id );
}


sub json_to_hash {
    my ( $json, $tmp ) = @_;
    my $h_ref = decode_json( $json );
    my $formats  = {};
    for my $format ( @{$h_ref->{formats}} ) {
        my $fmt = $format->{format_id};
        $formats->{$fmt}{ext}         = $format->{ext};
        $formats->{$fmt}{format}      = $format->{format};
        $formats->{$fmt}{format_note} = $format->{format_note};
        $formats->{$fmt}{height}      = $format->{height};
        $formats->{$fmt}{width}       = $format->{width};
        $formats->{$fmt}{url}         = $format->{url};
    }
    my $video_id = $h_ref->{id} // $h_ref->{title};
    $tmp->{$video_id}{video_id} = $video_id;
    my @keys = ( qw( uploader uploader_id description format_id dislike_count dislike_count
                     duration extractor extractor_key like_coun playlist_id title upload_date view_count ) );
                     # age_limit annotations fulltitle playlist stitle categories
    for my $key ( @keys ) {
        if ( defined $h_ref->{$key} ) {
            $tmp->{$video_id}{$key} = $h_ref->{$key};
        }
    }
    if ( $tmp->{$video_id}{upload_date} && $tmp->{$video_id}{upload_date} =~ /^(\d{4})(\d{2})(\d{2})\z/ ) {
            $tmp->{$video_id}{upload_date} = $1 . '-' . $2 . '-' . $3;
    }
    $tmp->{$video_id}{fmt_to_info} = $formats;
    _prepare_info_hash( $tmp, $video_id );
    return;
}


sub _prepare_info_hash {
    my ( $info, $video_id ) = @_;
    if ( $info->{$video_id}{duration} =~ /^[0-9]+\z/ ) {
        $info->{$video_id}{duration} = sec_to_time( $info->{$video_id}{duration}, 1 );
    }
    $info->{$video_id}{duration}    ||= '-:--:--';
    $info->{$video_id}{upload_date} ||= '0000-00-00';
    if ( $info->{$video_id}{like_count} && $info->{$video_id}{dislike_count} ) {
        $info->{$video_id}{raters}     ||= $info->{$video_id}{like_count} + $info->{$video_id}{dislike_count};
        $info->{$video_id}{avg_rating} ||= $info->{$video_id}{like_count} * 5 / $info->{$video_id}{raters};
    }
    if ( $info->{$video_id}{avg_rating} ) {
        $info->{$video_id}{avg_rating} = sprintf "%.2f", $info->{$video_id}{avg_rating};
    }
    if ( $info->{$video_id}{raters} ) {
        $info->{$video_id}{raters} = insert_sep( $info->{$video_id}{raters} );
    }
    if ( $info->{$video_id}{view_count} ) {
        $info->{$video_id}{view_count} = insert_sep( $info->{$video_id}{view_count} );
    }
    $info->{$video_id}{uploader}      //= $info->{$video_id}{uploader_id};
    $info->{$video_id}{extractor}     //= $info->{$video_id}{extractor_key};
    $info->{$video_id}{extractor_key} //= $info->{$video_id}{extractor} // '';
}





1;


__END__
