use strict;
use warnings;

use IUP ':all';

my $imgdata1 = [
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,
  2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
  2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
  2,2,2,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
  2,2,2,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
  2,2,2,0,2,0,2,0,2,2,0,2,2,2,0,0,0,2,2,2,0,0,2,0,2,2,0,0,0,2,2,2,
  2,2,2,0,2,0,0,2,0,0,2,0,2,0,2,2,2,0,2,0,2,2,0,0,2,0,2,2,2,0,2,2,
  2,2,2,0,2,0,2,2,0,2,2,0,2,2,2,2,2,0,2,0,2,2,2,0,2,0,2,2,2,0,2,2,
  2,2,2,0,2,0,2,2,0,2,2,0,2,2,0,0,0,0,2,0,2,2,2,0,2,0,0,0,0,0,2,2,
  2,2,2,0,2,0,2,2,0,2,2,0,2,0,2,2,2,0,2,0,2,2,2,0,2,0,2,2,2,2,2,2,
  2,2,2,0,2,0,2,2,0,2,2,0,2,0,2,2,2,0,2,0,2,2,0,0,2,0,2,2,2,0,2,2,
  2,2,2,0,2,0,2,2,0,2,2,0,2,2,0,0,0,0,2,2,0,0,2,0,2,2,0,0,0,2,2,2,
  2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,2,2,2,2,2,2,2,2,
  2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,2,2,2,0,2,2,2,2,2,2,2,2,
  2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,2,2,2,2,2,2,2,2,2,
  2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
  2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
  1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
];

my $imgdata2 = [
  2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,
  2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,
  2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,
  2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,
  2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,
  2,2,2,2,2,2,2,2,2,2,3,3,3,3,1,1,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,
  2,2,2,2,2,2,2,2,2,3,3,3,3,3,1,1,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,
  2,2,2,2,2,2,2,2,3,3,3,3,3,3,1,1,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
  3,3,3,0,3,3,3,3,3,3,3,3,3,3,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
  3,3,3,0,3,3,3,3,3,3,3,3,3,3,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
  3,3,3,0,3,0,3,0,3,3,0,3,3,3,1,1,0,3,3,3,0,0,3,0,3,3,0,0,0,3,3,3,
  3,3,3,0,3,0,0,3,0,0,3,0,3,0,1,1,3,0,3,0,3,3,0,0,3,0,3,3,3,0,3,3,
  3,3,3,0,3,0,3,3,0,3,3,0,3,3,1,1,3,0,3,0,3,3,3,0,3,0,3,3,3,0,3,3,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  3,3,3,0,3,0,3,3,0,3,3,0,3,0,1,1,3,0,3,0,3,3,0,0,3,0,3,3,3,0,3,3,
  3,3,3,0,3,0,3,3,0,3,3,0,3,3,1,1,0,0,3,3,0,0,3,0,3,3,0,0,0,3,3,3,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,3,3,3,3,3,3,3,0,3,3,3,3,3,3,3,3,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,3,3,3,0,3,3,3,0,3,3,3,3,3,3,3,3,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,3,3,3,3,0,0,0,3,3,3,3,3,3,3,3,3,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
  2,2,2,2,2,2,2,3,3,3,3,3,3,3,1,1,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,
  2,2,2,2,2,2,3,3,3,3,3,3,3,3,1,1,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,
  2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,
  2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
  2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
  2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
  2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
];

sub myaction {
  my $self = shift;
  # xxxTODO xxx some better callback
  #IUP->Message("Hello", $self->name);
}

sub init_dialog {
  my $img1 = IUP::Image->new( HEIGHT=>32, WIDTH=>32, pixels=>$imgdata1,
                              0=>"0 0 0", 1=>"BGCOLOR", 2=>"255 0 0" );

  my $img2 = IUP::Image->new( HEIGHT=>32, WIDTH=>32, pixels=>$imgdata2,
                              0=>"0 0 0", 1=>"0 255 0", 2=>"BGCOLOR", 3=>"255 0 0" );

  my $menu = IUP::Menu->new( child=>[
               IUP::Submenu->new( TITLE=>"IupSubmenu 1", child=>IUP::Menu->new( child=>[
                 IUP::Item->new( TITLE=>"IupItem 1 Checked", ACTION=>\&myaction, VALUE=>"ON" ),
                 IUP::Separator->new(),
                 IUP::Item->new( TITLE=>"IupItem 2 Disabled", ACTION=>\&myaction, ACTIVE=>"NO" ),
               ])),
               IUP::Item->new(TITLE=>"IupItem 3", ACTION=>\&myaction ),
               IUP::Item->new(TITLE=>"IupItem 4", ACTION=>\&myaction ),
             ]);

  my $frm1 = IUP::Frame->new( TITLE=>"IupButton", child=>
               IUP::Vbox->new( child=>[
                 IUP::Button->new( TITLE=>"Button Text", ACTION=>\&myaction ),
                 IUP::Button->new( ACTION=>\&myaction, IMAGE=>$img1 ),
                 IUP::Button->new( ACTION=>\&myaction, IMAGE=>$img1, IMPRESS=>$img2 ),
               ])
             );

  my $frm2 = IUP::Frame->new( TITLE=>"IupLabel", child=>
               IUP::Vbox->new( child=>[
                 IUP::Label->new( TITLE=>"Label Text" ),
                 IUP::Label->new( SEPARATOR=>"HORIZONTAL" ),
                 IUP::Label->new( IMAGE=>$img1 ),
               ])
             );

  my $frm3 = IUP::Frame->new( TITLE=>"IupToggle", child=>
               IUP::Vbox->new( child=>[
                 IUP::Toggle->new( TITLE=>"Toggle Text", ACTION=>\&myaction, VALUE=>"ON" ),
                 IUP::Toggle->new( ACTION=>\&myaction, IMAGE=>$img1, IMPRESS=>$img2 ),
                 IUP::Frame->new( TITLE=>"IupRadio", child=>
                   IUP::Radio->new( child=>
                     IUP::Vbox->new( child=>[
                       IUP::Toggle->new( TITLE=>"Toggle Text", ACTION=>\&myaction ),
                       IUP::Toggle->new( TITLE=>"Toggle Text", ACTION=>\&myaction ),
                     ])
                   )
                 )
               ])
             );

  my $frm4 = IUP::Frame->new( TITLE=>"IupText", child=>
               IUP::Vbox->new( child=>[
                 IUP::Text->new( ACTION=>\&myaction, VALUE=>"IupText Text", SIZE=>"80x" ),
                 IUP::Text->new( MULTILINE=>"YES", VALUE=>"Multiline Text\nSecond Line\nThird Line",
                                 ACTION=>\&myaction, EXPAND=>"YES", SIZE=>"80x60" )
               ])
             );

  my $frm5 = IUP::Frame->new( TITLE=>"IupList", child => 
               IUP::Vbox->new( child=>[
                 IUP::List->new( ACTION=>\&myaction, EXPAND=>"YES", VALUE=>"1",
                                 1=>"Item 1 Text", 2=>"Item 2 Text", 3=>"Item 3 Text" ),
                 IUP::List->new( ACTION=>\&myaction, DROPDOWN=>"YES", EXPAND=>"YES", VALUE=>"2",
                                 1=>"Item 1 Text", 2=>"Item 2 Text", 3=>"Item 3 Text" ),
                 IUP::List->new( ACTION=>\&myaction, EDITBOX=>"YES",  EXPAND=>"YES", VALUE=>"3",
                                 1=>"Item 1 Text", 2=>"Item 2 Text", 3=>"Item 3 Text" ),
               ])
	     );

  my $frm6 = IUP::Frame->new( TITLE=>"IupVal", child=>IUP::Val->new( MIN=>0, MAX=>100 ) );

  my $frm7 = IUP::Frame->new( TITLE=>"IupProgressBar", child=>IUP::ProgressBar->new( MIN=>0, MAX=>100, VALUE=>50 ) );

  my $frm8 = IUP::Frame->new( TITLE=>"IupTabs",
                              child=>IUP::Tabs->new( child=>[
			          IUP::Label->new( TABTITLE=>"Tab Title 0", EXPAND=>"HORIZONTAL"),
				  IUP::Label->new( TABTITLE=>"Tab Title 1", EXPAND=>"HORIZONTAL"),
				  IUP::Label->new( TABTITLE=>"Tab Title 2", EXPAND=>"HORIZONTAL"),
                              ] ) );
  
  my $frm9 = IUP::Frame->new( TITLE=>"IupCanvas", child=>IUP::Canvas->new( SIZE=>"x50", SCROLLBAR=>"YES", BGCOLOR=>"128 255 0" ) );

  my $hbox1 = IUP::Hbox->new( child=>[ $frm1, $frm2, $frm3, $frm4, $frm5] );
  my $hbox2 = IUP::Hbox->new( child=>[ $frm6, $frm7, $frm8] );
  my $vbox1 = IUP::Vbox->new( child=> [$hbox1, $hbox2, $frm9], MARGIN=>"5x5", ALIGNMENT=>"ARIGHT", GAP=>"5" );

  return IUP::Dialog->new( MENU=>$menu, TITLE=>"Iup Sample", child=>$vbox1, SIZE=>"400x" );
}

# main program
my $dlg = init_dialog();
$dlg->Show();
IUP->MainLoop();
