package Telegram::Bot::Message::Video;

# ABSTRACT: The base class for Telegram message 'Video' type.

use Mojo::Base 'Telegram::Bot::Message';

has 'file_id';
has 'width';
has 'height';
has 'duration';
has 'thumb';
has 'mime_type';
has 'file_size';
has 'caption';

sub is_array { return; }

sub fields {
  return { scalar => [qw/file_id width height duration mime_type file_size caption/],
           'Telegram::Bot::Message::PhotoSize' => [qw/thumb/]
         };
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Telegram::Bot::Message::Video - The base class for Telegram message 'Video' type.

=head1 VERSION

version 0.001

=head1 AUTHOR

Justin Hawkins <justin@eatmorecode.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Justin Hawkins.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
