package Telegram::Bot::Message::UserOrGroup;

# ABSTRACT: The base class for Telegram message 'User' type.

use Mojo::Base 'Telegram::Bot::Message';

use Telegram::Bot::Message::User;
use Telegram::Bot::Message::Group;

sub is_array { return; }

sub create_from_hash {
  my $class = shift;
  my $hash  = shift;
  if ($hash->{id} < 0) {
    return Telegram::Bot::Message::Group->create_from_hash($hash);
  }
  else {
    return Telegram::Bot::Message::User->create_from_hash($hash);
  }
}
    

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Telegram::Bot::Message::UserOrGroup - The base class for Telegram message 'User' type.

=head1 VERSION

version 0.001

=head1 AUTHOR

Justin Hawkins <justin@eatmorecode.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Justin Hawkins.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
