=encoding utf8

=head1 NAME

Locale::CLDR::Locales::Ur - Package for language Urdu

=cut

package Locale::CLDR::Locales::Ur;
# This file auto generated from Data\common\main\ur.xml
#	on Sun  3 Dec 10:46:28 am GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.34.4');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $region, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}،{1}', grep {$_} (
		$region,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'aa' => 'افار',
 				'ab' => 'ابقازیان',
 				'ace' => 'اچائینیز',
 				'ach' => 'اکولی',
 				'ada' => 'ادانگمے',
 				'ady' => 'ادیگھے',
 				'af' => 'افریقی',
 				'agq' => 'اغم',
 				'ain' => 'اینو',
 				'ak' => 'اکان',
 				'ale' => 'الیوت',
 				'alt' => 'جنوبی الٹائی',
 				'am' => 'امہاری',
 				'an' => 'اراگونیز',
 				'anp' => 'انگیکا',
 				'ar' => 'عربی',
 				'ar_001' => 'ماڈرن اسٹینڈرڈ عربی',
 				'arn' => 'ماپوچے',
 				'arp' => 'اراپاہو',
 				'as' => 'آسامی',
 				'asa' => 'آسو',
 				'ast' => 'اسٹوریائی',
 				'av' => 'اواری',
 				'awa' => 'اوادھی',
 				'ay' => 'ایمارا',
 				'az' => 'آذربائیجانی',
 				'az@alt=short' => 'ازیری',
 				'az_Arab' => 'آزربائیجانی (عربی)',
 				'ba' => 'باشکیر',
 				'ban' => 'بالینیز',
 				'bas' => 'باسا',
 				'be' => 'بیلاروسی',
 				'bem' => 'بیمبا',
 				'bez' => 'بینا',
 				'bg' => 'بلغاری',
 				'bgn' => 'مغربی بلوچی',
 				'bho' => 'بھوجپوری',
 				'bi' => 'بسلاما',
 				'bin' => 'بینی',
 				'bla' => 'سکسیکا',
 				'bm' => 'بمبارا',
 				'bn' => 'بنگالی',
 				'bo' => 'تبتی',
 				'br' => 'بریٹن',
 				'brx' => 'بوڈو',
 				'bs' => 'بوسنیائی',
 				'bug' => 'بگینیز',
 				'byn' => 'بلین',
 				'ca' => 'کیٹالان',
 				'ce' => 'چیچن',
 				'ceb' => 'سیبوآنو',
 				'cgg' => 'چیگا',
 				'ch' => 'چیمارو',
 				'chk' => 'چوکیز',
 				'chm' => 'ماری',
 				'cho' => 'چاکٹاؤ',
 				'chr' => 'چیروکی',
 				'chy' => 'چینّے',
 				'ckb' => 'سینٹرل کردش',
 				'co' => 'کوراسیکن',
 				'crs' => 'سیسلوا کریولے فرانسیسی',
 				'cs' => 'چیک',
 				'cu' => 'چرچ سلاوک',
 				'cv' => 'چوواش',
 				'cy' => 'ویلش',
 				'da' => 'ڈینش',
 				'dak' => 'ڈاکوٹا',
 				'dar' => 'درگوا',
 				'dav' => 'تائتا',
 				'de' => 'جرمن',
 				'de_AT' => 'آسٹریائی جرمن',
 				'de_CH' => 'سوئس ہائی جرمن',
 				'dgr' => 'دوگریب',
 				'dje' => 'زرما',
 				'dsb' => 'ذیلی سربیائی',
 				'dua' => 'دوالا',
 				'dv' => 'ڈیویہی',
 				'dyo' => 'جولا فونيا',
 				'dz' => 'ژونگکھا',
 				'dzg' => 'دزاگا',
 				'ebu' => 'امبو',
 				'ee' => 'ایو',
 				'efi' => 'ایفِک',
 				'eka' => 'ایکاجوی',
 				'el' => 'یونانی',
 				'en' => 'انگریزی',
 				'en_AU' => 'آسٹریلیائی انگریزی',
 				'en_CA' => 'کینیڈین انگریزی',
 				'en_GB' => 'برطانوی انگریزی',
 				'en_GB@alt=short' => 'انگریزی (یو کے)',
 				'en_US' => 'امریکی انگریزی',
 				'en_US@alt=short' => 'امریکی انگریزی',
 				'eo' => 'ایسپرانٹو',
 				'es' => 'ہسپانوی',
 				'es_419' => 'لاطینی امریکی ہسپانوی',
 				'es_ES' => 'یورپی ہسپانوی',
 				'es_MX' => 'میکسیکن ہسپانوی',
 				'et' => 'اسٹونین',
 				'eu' => 'باسکی',
 				'ewo' => 'ایوانڈو',
 				'fa' => 'فارسی',
 				'ff' => 'فولہ',
 				'fi' => 'فینیش',
 				'fil' => 'فلیپینو',
 				'fj' => 'فجی',
 				'fo' => 'فیروئیز',
 				'fon' => 'فون',
 				'fr' => 'فرانسیسی',
 				'fr_CA' => 'کینیڈین فرانسیسی',
 				'fr_CH' => 'سوئس فرینچ',
 				'frc' => 'کاجن فرانسیسی',
 				'fur' => 'فریولیائی',
 				'fy' => 'مغربی فریسیئن',
 				'ga' => 'آئیرِش',
 				'gaa' => 'گا',
 				'gag' => 'غاغاوز',
 				'gan' => 'gan',
 				'gd' => 'سکاٹش گیلک',
 				'gez' => 'گیز',
 				'gil' => 'گلبرتیز',
 				'gl' => 'گالیشیائی',
 				'gn' => 'گُارانی',
 				'gor' => 'گورانٹالو',
 				'gsw' => 'سوئس جرمن',
 				'gu' => 'گجراتی',
 				'guz' => 'گسی',
 				'gv' => 'مینکس',
 				'gwi' => 'گوئچ ان',
 				'ha' => 'ہؤسا',
 				'hak' => 'hak',
 				'haw' => 'ہوائی',
 				'he' => 'عبرانی',
 				'hi' => 'ہندی',
 				'hil' => 'ہالیگینون',
 				'hmn' => 'ہمانگ',
 				'hr' => 'کراتی',
 				'hsb' => 'اپر سربیائی',
 				'hsn' => 'hsn',
 				'ht' => 'ہیتی',
 				'hu' => 'ہنگیرین',
 				'hup' => 'ہیوپا',
 				'hy' => 'آرمینیائی',
 				'hz' => 'ہریرو',
 				'ia' => 'بین لسانیات',
 				'iba' => 'ایبان',
 				'ibb' => 'ابی بیو',
 				'id' => 'انڈونیثیائی',
 				'ig' => 'اِگبو',
 				'ii' => 'سچوان ای',
 				'ilo' => 'ایلوکو',
 				'inh' => 'انگوش',
 				'io' => 'ایڈو',
 				'is' => 'آئس لینڈک',
 				'it' => 'اطالوی',
 				'iu' => 'اینُکٹیٹٹ',
 				'ja' => 'جاپانی',
 				'jbo' => 'لوجبان',
 				'jgo' => 'نگومبا',
 				'jmc' => 'ماشیم',
 				'jv' => 'جاوی',
 				'ka' => 'جارجیائی',
 				'kab' => 'قبائلی',
 				'kac' => 'کاچن',
 				'kaj' => 'جے جو',
 				'kam' => 'کامبا',
 				'kbd' => 'کبارڈین',
 				'kcg' => 'تیاپ',
 				'kde' => 'ماکونده',
 				'kea' => 'کابويرديانو',
 				'kfo' => 'کورو',
 				'kg' => 'کانگو',
 				'kha' => 'کھاسی',
 				'khq' => 'کويرا شيني',
 				'ki' => 'کیکویو',
 				'kj' => 'کونیاما',
 				'kk' => 'قزاخ',
 				'kkj' => 'کاکو',
 				'kl' => 'کالاليست',
 				'kln' => 'کالينجين',
 				'km' => 'خمیر',
 				'kmb' => 'کیمبونڈو',
 				'kn' => 'کنّاڈا',
 				'ko' => 'کوریائی',
 				'koi' => 'کومی پرمیاک',
 				'kok' => 'کونکنی',
 				'kpe' => 'کیپیلّے',
 				'kr' => 'کنوری',
 				'krc' => 'کراچے بالکر',
 				'krl' => 'کیرلین',
 				'kru' => 'کوروکھ',
 				'ks' => 'کشمیری',
 				'ksb' => 'شامبالا',
 				'ksf' => 'بافيا',
 				'ksh' => 'کولوگنیائی',
 				'ku' => 'کردش',
 				'kum' => 'کومیک',
 				'kv' => 'کومی',
 				'kw' => 'کورنش',
 				'ky' => 'کرغیزی',
 				'la' => 'لاطینی',
 				'lad' => 'لیڈینو',
 				'lag' => 'لانگی',
 				'lb' => 'لکسمبرگیش',
 				'lez' => 'لیزگیان',
 				'lg' => 'گینڈا',
 				'li' => 'لیمبرگش',
 				'lkt' => 'لاکوٹا',
 				'ln' => 'لِنگَلا',
 				'lo' => 'لاؤ',
 				'lou' => 'لوزیانا کریول',
 				'loz' => 'لوزی',
 				'lrc' => 'شمالی لری',
 				'lt' => 'لیتھوینین',
 				'lu' => 'لبا-کاتانجا',
 				'lua' => 'لیوبا لولوآ',
 				'lun' => 'لونڈا',
 				'luo' => 'لو',
 				'lus' => 'میزو',
 				'luy' => 'لویا',
 				'lv' => 'لیٹوین',
 				'mad' => 'مدورسی',
 				'mag' => 'مگاہی',
 				'mai' => 'میتھیلی',
 				'mak' => 'مکاسر',
 				'mas' => 'مسائی',
 				'mdf' => 'موکشا',
 				'men' => 'میندے',
 				'mer' => 'میرو',
 				'mfe' => 'موریسیین',
 				'mg' => 'ملاگاسی',
 				'mgh' => 'ماخاوا-ميتو',
 				'mgo' => 'میٹا',
 				'mh' => 'مارشلیز',
 				'mi' => 'ماؤری',
 				'mic' => 'مکمیک',
 				'min' => 'منانگکباؤ',
 				'mk' => 'مقدونیائی',
 				'ml' => 'مالایالم',
 				'mn' => 'منگولین',
 				'mni' => 'منی پوری',
 				'moh' => 'موہاک',
 				'mos' => 'موسی',
 				'mr' => 'مراٹهی',
 				'ms' => 'مالے',
 				'mt' => 'مالٹی',
 				'mua' => 'منڈانگ',
 				'mul' => 'متعدد زبانیں',
 				'mus' => 'کریک',
 				'mwl' => 'میرانڈیز',
 				'my' => 'برمی',
 				'myv' => 'ارزیا',
 				'mzn' => 'مزندرانی',
 				'na' => 'ناؤرو',
 				'nan' => 'nan',
 				'nap' => 'نیاپولیٹن',
 				'naq' => 'ناما',
 				'nb' => 'نارویجین بوکمل',
 				'nd' => 'شمالی دبیل',
 				'nds' => 'ادنی جرمن',
 				'nds_NL' => 'ادنی سیکسن',
 				'ne' => 'نیپالی',
 				'new' => 'نیواری',
 				'ng' => 'نڈونگا',
 				'nia' => 'نیاس',
 				'niu' => 'نیویائی',
 				'nl' => 'ڈچ',
 				'nl_BE' => 'فلیمِش',
 				'nmg' => 'کوايسو',
 				'nn' => 'نارویجین نینورسک',
 				'nnh' => 'نگیمبون',
 				'no' => 'نارویجین',
 				'nog' => 'نوگائی',
 				'nqo' => 'اینکو',
 				'nr' => 'جنوبی نڈیبیلی',
 				'nso' => 'شمالی سوتھو',
 				'nus' => 'نویر',
 				'nv' => 'نواجو',
 				'ny' => 'نیانجا',
 				'nyn' => 'نینکول',
 				'oc' => 'آکسیٹان',
 				'om' => 'اورومو',
 				'or' => 'اڑیہ',
 				'os' => 'اوسیٹک',
 				'pa' => 'پنجابی',
 				'pag' => 'پنگاسنان',
 				'pam' => 'پامپنگا',
 				'pap' => 'پاپیامینٹو',
 				'pau' => 'پالاون',
 				'pcm' => 'نائجیریائی پڈگن',
 				'pl' => 'پولش',
 				'prg' => 'پارسی',
 				'ps' => 'پشتو',
 				'pt' => 'پُرتگالی',
 				'pt_BR' => 'برازیلی پرتگالی',
 				'pt_PT' => 'یورپی پرتگالی',
 				'qu' => 'کویچوآ',
 				'quc' => 'کيشی',
 				'rap' => 'رپانوی',
 				'rar' => 'راروتونگان',
 				'rm' => 'رومانش',
 				'rn' => 'رونڈی',
 				'ro' => 'رومینین',
 				'ro_MD' => 'مالدووا',
 				'rof' => 'رومبو',
 				'root' => 'روٹ',
 				'ru' => 'روسی',
 				'rup' => 'ارومانی',
 				'rw' => 'کینیاروانڈا',
 				'rwk' => 'روا',
 				'sa' => 'سنسکرت',
 				'sad' => 'سنڈاوے',
 				'sah' => 'ساکھا',
 				'saq' => 'سامبورو',
 				'sat' => 'سنتالی',
 				'sba' => 'نگامبے',
 				'sbp' => 'سانگو',
 				'sc' => 'سردینین',
 				'scn' => 'سیسیلین',
 				'sco' => 'سکاٹ',
 				'sd' => 'سندھی',
 				'sdh' => 'جنوبی کرد',
 				'se' => 'شمالی سامی',
 				'seh' => 'سینا',
 				'ses' => 'کويرابورو سينی',
 				'sg' => 'ساںغو',
 				'sh' => 'سربو-کروئیشین',
 				'shi' => 'تشلحيت',
 				'shn' => 'شان',
 				'si' => 'سنہالا',
 				'sk' => 'سلوواک',
 				'sl' => 'سلووینیائی',
 				'sm' => 'ساموآن',
 				'sma' => 'جنوبی سامی',
 				'smj' => 'لول سامی',
 				'smn' => 'اناری سامی',
 				'sms' => 'سکولٹ سامی',
 				'sn' => 'شونا',
 				'snk' => 'سوننکے',
 				'so' => 'صومالی',
 				'sq' => 'البانی',
 				'sr' => 'سربین',
 				'srn' => 'سرانن ٹونگو',
 				'ss' => 'سواتی',
 				'ssy' => 'ساہو',
 				'st' => 'جنوبی سوتھو',
 				'su' => 'سنڈانیز',
 				'suk' => 'سکوما',
 				'sv' => 'سویڈش',
 				'sw' => 'سواحلی',
 				'sw_CD' => 'کانگو سواحلی',
 				'swb' => 'کوموریائی',
 				'syr' => 'سریانی',
 				'ta' => 'تمل',
 				'te' => 'تیلگو',
 				'tem' => 'ٹمنے',
 				'teo' => 'تیسو',
 				'tet' => 'ٹیٹم',
 				'tg' => 'تاجک',
 				'th' => 'تھائی',
 				'ti' => 'ٹگرینیا',
 				'tig' => 'ٹگرے',
 				'tk' => 'ترکمان',
 				'tl' => 'ٹیگا لوگ',
 				'tlh' => 'کلنگن',
 				'tn' => 'سوانا',
 				'to' => 'ٹونگن',
 				'tpi' => 'ٹوک پِسِن',
 				'tr' => 'ترکی',
 				'trv' => 'ٹوروکو',
 				'ts' => 'زونگا',
 				'tt' => 'تاتار',
 				'tum' => 'ٹمبوکا',
 				'tvl' => 'تووالو',
 				'tw' => 'توی',
 				'twq' => 'تاساواق',
 				'ty' => 'تاہیتی',
 				'tyv' => 'تووینین',
 				'tzm' => 'سینٹرل ایٹلس ٹمازائٹ',
 				'udm' => 'ادمورت',
 				'ug' => 'یوئگہر',
 				'uk' => 'یوکرینیائی',
 				'umb' => 'اومبوندو',
 				'und' => 'نامعلوم زبان',
 				'ur' => 'اردو',
 				'uz' => 'ازبیک',
 				'vai' => 'وائی',
 				've' => 'وینڈا',
 				'vi' => 'ویتنامی',
 				'vo' => 'وولاپوک',
 				'vun' => 'ونجو',
 				'wa' => 'والون',
 				'wae' => 'والسر',
 				'wal' => 'وولایتا',
 				'war' => 'وارے',
 				'wbp' => 'وارلپیری',
 				'wo' => 'وولوف',
 				'wuu' => 'wuu',
 				'xal' => 'کالمیک',
 				'xh' => 'ژوسا',
 				'xog' => 'سوگا',
 				'yav' => 'یانگبین',
 				'ybb' => 'یمبا',
 				'yi' => 'یدش',
 				'yo' => 'یوروبا',
 				'yue' => 'کینٹونیز',
 				'zgh' => 'اسٹینڈرڈ مراقشی تمازیقی',
 				'zh' => 'چینی',
 				'zh_Hans' => 'چینی (آسان کردہ)',
 				'zh_Hant' => 'روایتی چینی',
 				'zu' => 'زولو',
 				'zun' => 'زونی',
 				'zxx' => 'کوئی لسانی مواد نہیں',
 				'zza' => 'زازا',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'عربی',
 			'Arab@alt=variant' => 'فارسی عربی',
 			'Armn' => 'آرمینیائی',
 			'Beng' => 'بنگالی',
 			'Bopo' => 'بوپوموفو',
 			'Brai' => 'بریل',
 			'Cyrl' => 'سیریلک',
 			'Deva' => 'دیوناگری',
 			'Ethi' => 'ایتھوپیائی',
 			'Geor' => 'جارجیائی',
 			'Grek' => 'یونانی',
 			'Gujr' => 'گجراتی',
 			'Guru' => 'گرمکھی',
 			'Hanb' => 'ہینب',
 			'Hang' => 'ہنگول',
 			'Hani' => 'ہان',
 			'Hans' => 'آسان',
 			'Hans@alt=stand-alone' => 'آسان ہان',
 			'Hant' => 'روایتی',
 			'Hant@alt=stand-alone' => 'روایتی ہان',
 			'Hebr' => 'عبرانی',
 			'Hira' => 'ہیراگینا',
 			'Hrkt' => 'جاپانی سیلابریز',
 			'Jamo' => 'جامو',
 			'Jpan' => 'جاپانی',
 			'Kana' => 'کٹاکانا',
 			'Khmr' => 'خمیر',
 			'Knda' => 'کنڑ',
 			'Kore' => 'کوریائی',
 			'Laoo' => 'لاؤ',
 			'Latn' => 'لاطینی',
 			'Mlym' => 'ملیالم',
 			'Mong' => 'منگولیائی',
 			'Mymr' => 'میانمار',
 			'Orya' => 'اڑیہ',
 			'Sinh' => 'سنہالا',
 			'Taml' => 'تمل',
 			'Telu' => 'تیلگو',
 			'Thaa' => 'تھانا',
 			'Thai' => 'تھائی',
 			'Tibt' => 'تبتی',
 			'Zmth' => 'ریاضی کی علامتیں',
 			'Zsye' => 'ایموجی',
 			'Zsym' => 'علامات',
 			'Zxxx' => 'غیر تحریر شدہ',
 			'Zyyy' => 'عام',
 			'Zzzz' => 'نامعلوم رسم الخط',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'دنیا',
 			'002' => 'افریقہ',
 			'003' => 'شمالی امریکہ',
 			'005' => 'جنوبی امریکہ',
 			'009' => 'اوشیانیا',
 			'011' => 'مغربی افریقہ',
 			'013' => 'وسطی امریکہ',
 			'014' => 'مشرقی افریقہ',
 			'015' => 'شمالی افریقہ',
 			'017' => 'وسطی افریقہ',
 			'018' => 'جنوبی افریقہ کے علاقہ',
 			'019' => 'امیریکاز',
 			'021' => 'شمالی امریکہ کا علاقہ',
 			'029' => 'کریبیائی',
 			'030' => 'مشرقی ایشیا',
 			'034' => 'جنوبی ایشیا',
 			'035' => 'جنوب مشرقی ایشیا',
 			'039' => 'جنوبی یورپ',
 			'053' => 'آسٹریلیشیا',
 			'054' => 'مالینیشیا',
 			'057' => 'مائکرونیشیائی علاقہ',
 			'061' => 'پولینیشیا',
 			'142' => 'ایشیا',
 			'143' => 'وسطی ایشیا',
 			'145' => 'مغربی ایشیا',
 			'150' => 'یورپ',
 			'151' => 'مشرقی یورپ',
 			'154' => 'شمالی یورپ',
 			'155' => 'مغربی یورپ',
 			'202' => 'ذیلی صحارن افریقہ',
 			'419' => 'لاطینی امریکہ',
 			'AC' => 'اسینشن آئلینڈ',
 			'AD' => 'انڈورا',
 			'AE' => 'متحدہ عرب امارات',
 			'AF' => 'افغانستان',
 			'AG' => 'انٹیگوا اور باربودا',
 			'AI' => 'انگوئیلا',
 			'AL' => 'البانیہ',
 			'AM' => 'آرمینیا',
 			'AO' => 'انگولا',
 			'AQ' => 'انٹارکٹیکا',
 			'AR' => 'ارجنٹینا',
 			'AS' => 'امریکی ساموآ',
 			'AT' => 'آسٹریا',
 			'AU' => 'آسٹریلیا',
 			'AW' => 'اروبا',
 			'AX' => 'آلینڈ آئلینڈز',
 			'AZ' => 'آذربائیجان',
 			'BA' => 'بوسنیا اور ہرزیگووینا',
 			'BB' => 'بارباڈوس',
 			'BD' => 'بنگلہ دیش',
 			'BE' => 'بیلجیم',
 			'BF' => 'برکینا فاسو',
 			'BG' => 'بلغاریہ',
 			'BH' => 'بحرین',
 			'BI' => 'برونڈی',
 			'BJ' => 'بینن',
 			'BL' => 'سینٹ برتھلیمی',
 			'BM' => 'برمودا',
 			'BN' => 'برونائی',
 			'BO' => 'بولیویا',
 			'BQ' => 'کریبیائی نیدرلینڈز',
 			'BR' => 'برازیل',
 			'BS' => 'بہاماس',
 			'BT' => 'بھوٹان',
 			'BV' => 'بؤویٹ آئلینڈ',
 			'BW' => 'بوتسوانا',
 			'BY' => 'بیلاروس',
 			'BZ' => 'بیلائز',
 			'CA' => 'کینیڈا',
 			'CC' => 'کوکوس (کیلنگ) جزائر',
 			'CD' => 'کانگو - کنشاسا',
 			'CD@alt=variant' => 'کانگو (DRC)',
 			'CF' => 'وسط افریقی جمہوریہ',
 			'CG' => 'کانگو - برازاویلے',
 			'CG@alt=variant' => 'کانگو (جمہوریہ)',
 			'CH' => 'سوئٹزر لینڈ',
 			'CI' => 'کوٹ ڈی آئیوری',
 			'CI@alt=variant' => 'آئیوری کوسٹ',
 			'CK' => 'کک آئلینڈز',
 			'CL' => 'چلی',
 			'CM' => 'کیمرون',
 			'CN' => 'چین',
 			'CO' => 'کولمبیا',
 			'CP' => 'کلپرٹن آئلینڈ',
 			'CR' => 'کوسٹا ریکا',
 			'CU' => 'کیوبا',
 			'CV' => 'کیپ ورڈی',
 			'CW' => 'کیوراکاؤ',
 			'CX' => 'جزیرہ کرسمس',
 			'CY' => 'قبرص',
 			'CZ' => 'چیکیا',
 			'CZ@alt=variant' => 'چیک جمہوریہ',
 			'DE' => 'جرمنی',
 			'DG' => 'ڈائجو گارسیا',
 			'DJ' => 'جبوتی',
 			'DK' => 'ڈنمارک',
 			'DM' => 'ڈومنیکا',
 			'DO' => 'جمہوریہ ڈومينيکن',
 			'DZ' => 'الجیریا',
 			'EA' => 'سیئوٹا اور میلیلا',
 			'EC' => 'ایکواڈور',
 			'EE' => 'اسٹونیا',
 			'EG' => 'مصر',
 			'EH' => 'مغربی صحارا',
 			'ER' => 'اریٹیریا',
 			'ES' => 'ہسپانیہ',
 			'ET' => 'ایتھوپیا',
 			'EU' => 'یوروپی یونین',
 			'EZ' => 'یوروزون',
 			'FI' => 'فن لینڈ',
 			'FJ' => 'فجی',
 			'FK' => 'فاکلینڈ جزائر',
 			'FK@alt=variant' => 'فاکلینڈ جزائر (مالویناس)',
 			'FM' => 'مائکرونیشیا',
 			'FO' => 'جزائر فارو',
 			'FR' => 'فرانس',
 			'GA' => 'گیبون',
 			'GB' => 'سلطنت متحدہ',
 			'GB@alt=short' => 'یو کے',
 			'GD' => 'گریناڈا',
 			'GE' => 'جارجیا',
 			'GF' => 'فرینچ گیانا',
 			'GG' => 'گوئرنسی',
 			'GH' => 'گھانا',
 			'GI' => 'جبل الطارق',
 			'GL' => 'گرین لینڈ',
 			'GM' => 'گیمبیا',
 			'GN' => 'گنی',
 			'GP' => 'گواڈیلوپ',
 			'GQ' => 'استوائی گیانا',
 			'GR' => 'یونان',
 			'GS' => 'جنوبی جارجیا اور جنوبی سینڈوچ جزائر',
 			'GT' => 'گواٹے مالا',
 			'GU' => 'گوام',
 			'GW' => 'گنی بساؤ',
 			'GY' => 'گیانا',
 			'HK' => 'ہانگ کانگ SAR چین',
 			'HK@alt=short' => 'ہانگ کانگ',
 			'HM' => 'ہیرڈ جزیرہ و میکڈولینڈ جزائر',
 			'HN' => 'ہونڈاروس',
 			'HR' => 'کروشیا',
 			'HT' => 'ہیٹی',
 			'HU' => 'ہنگری',
 			'IC' => 'کینری آئلینڈز',
 			'ID' => 'انڈونیشیا',
 			'IE' => 'آئرلینڈ',
 			'IL' => 'اسرائیل',
 			'IM' => 'آئل آف مین',
 			'IN' => 'بھارت',
 			'IO' => 'برطانوی بحر ہند کا علاقہ',
 			'IQ' => 'عراق',
 			'IR' => 'ایران',
 			'IS' => 'آئس لینڈ',
 			'IT' => 'اٹلی',
 			'JE' => 'جرسی',
 			'JM' => 'جمائیکا',
 			'JO' => 'اردن',
 			'JP' => 'جاپان',
 			'KE' => 'کینیا',
 			'KG' => 'کرغزستان',
 			'KH' => 'کمبوڈیا',
 			'KI' => 'کریباتی',
 			'KM' => 'کوموروس',
 			'KN' => 'سینٹ کٹس اور نیویس',
 			'KP' => 'شمالی کوریا',
 			'KR' => 'جنوبی کوریا',
 			'KW' => 'کویت',
 			'KY' => 'کیمین آئلینڈز',
 			'KZ' => 'قزاخستان',
 			'LA' => 'لاؤس',
 			'LB' => 'لبنان',
 			'LC' => 'سینٹ لوسیا',
 			'LI' => 'لیشٹنسٹائن',
 			'LK' => 'سری لنکا',
 			'LR' => 'لائبیریا',
 			'LS' => 'لیسوتھو',
 			'LT' => 'لیتھونیا',
 			'LU' => 'لکسمبرگ',
 			'LV' => 'لٹویا',
 			'LY' => 'لیبیا',
 			'MA' => 'مراکش',
 			'MC' => 'موناکو',
 			'MD' => 'مالدووا',
 			'ME' => 'مونٹے نیگرو',
 			'MF' => 'سینٹ مارٹن',
 			'MG' => 'مڈغاسکر',
 			'MH' => 'مارشل آئلینڈز',
 			'MK' => 'مقدونیہ',
 			'MK@alt=variant' => 'مقدونیہ (FYROM)',
 			'ML' => 'مالی',
 			'MM' => 'میانمار (برما)',
 			'MN' => 'منگولیا',
 			'MO' => 'مکاؤ SAR چین',
 			'MO@alt=short' => 'مکاؤ',
 			'MP' => 'شمالی ماریانا آئلینڈز',
 			'MQ' => 'مارٹینک',
 			'MR' => 'موریطانیہ',
 			'MS' => 'مونٹسیراٹ',
 			'MT' => 'مالٹا',
 			'MU' => 'ماریشس',
 			'MV' => 'مالدیپ',
 			'MW' => 'ملاوی',
 			'MX' => 'میکسیکو',
 			'MY' => 'ملائشیا',
 			'MZ' => 'موزمبیق',
 			'NA' => 'نامیبیا',
 			'NC' => 'نیو کلیڈونیا',
 			'NE' => 'نائجر',
 			'NF' => 'نارفوک آئلینڈ',
 			'NG' => 'نائجیریا',
 			'NI' => 'نکاراگووا',
 			'NL' => 'نیدر لینڈز',
 			'NO' => 'ناروے',
 			'NP' => 'نیپال',
 			'NR' => 'نؤرو',
 			'NU' => 'نیئو',
 			'NZ' => 'نیوزی لینڈ',
 			'OM' => 'عمان',
 			'PA' => 'پانامہ',
 			'PE' => 'پیرو',
 			'PF' => 'فرانسیسی پولینیشیا',
 			'PG' => 'پاپوآ نیو گنی',
 			'PH' => 'فلپائن',
 			'PK' => 'پاکستان',
 			'PL' => 'پولینڈ',
 			'PM' => 'سینٹ پیئر اور میکلیئون',
 			'PN' => 'پٹکائرن جزائر',
 			'PR' => 'پیورٹو ریکو',
 			'PS' => 'فلسطینی خطے',
 			'PS@alt=short' => 'فلسطین',
 			'PT' => 'پرتگال',
 			'PW' => 'پلاؤ',
 			'PY' => 'پیراگوئے',
 			'QA' => 'قطر',
 			'QO' => 'بیرونی اوشیانیا',
 			'RE' => 'ری یونین',
 			'RO' => 'رومانیہ',
 			'RS' => 'سربیا',
 			'RU' => 'روس',
 			'RW' => 'روانڈا',
 			'SA' => 'سعودی عرب',
 			'SB' => 'سولومن آئلینڈز',
 			'SC' => 'سشلیز',
 			'SD' => 'سوڈان',
 			'SE' => 'سویڈن',
 			'SG' => 'سنگاپور',
 			'SH' => 'سینٹ ہیلینا',
 			'SI' => 'سلووینیا',
 			'SJ' => 'سوالبرڈ اور جان ماین',
 			'SK' => 'سلوواکیہ',
 			'SL' => 'سیرالیون',
 			'SM' => 'سان مارینو',
 			'SN' => 'سینیگل',
 			'SO' => 'صومالیہ',
 			'SR' => 'سورینام',
 			'SS' => 'جنوبی سوڈان',
 			'ST' => 'ساؤ ٹوم اور پرنسپے',
 			'SV' => 'ال سلواڈور',
 			'SX' => 'سنٹ مارٹن',
 			'SY' => 'شام',
 			'SZ' => 'سوازی لینڈ',
 			'TA' => 'ٹرسٹن ڈا کیونہا',
 			'TC' => 'ترکس اور کیکاؤس جزائر',
 			'TD' => 'چاڈ',
 			'TF' => 'فرانسیسی جنوبی خطے',
 			'TG' => 'ٹوگو',
 			'TH' => 'تھائی لینڈ',
 			'TJ' => 'تاجکستان',
 			'TK' => 'ٹوکیلاؤ',
 			'TL' => 'تیمور لیسٹ',
 			'TL@alt=variant' => 'مشرقی تیمور',
 			'TM' => 'ترکمانستان',
 			'TN' => 'تونس',
 			'TO' => 'ٹونگا',
 			'TR' => 'ترکی',
 			'TT' => 'ترینیداد اور ٹوباگو',
 			'TV' => 'ٹووالو',
 			'TW' => 'تائیوان',
 			'TZ' => 'تنزانیہ',
 			'UA' => 'یوکرین',
 			'UG' => 'یوگنڈا',
 			'UM' => 'امریکہ سے باہر کے چھوٹے جزائز',
 			'UN' => 'اقوام متحدہ',
 			'UN@alt=short' => 'اقوام متحدہ',
 			'US' => 'ریاستہائے متحدہ',
 			'US@alt=short' => 'امریکا',
 			'UY' => 'یوروگوئے',
 			'UZ' => 'ازبکستان',
 			'VA' => 'ویٹیکن سٹی',
 			'VC' => 'سینٹ ونسنٹ اور گرینیڈائنز',
 			'VE' => 'وینزوئیلا',
 			'VG' => 'برٹش ورجن آئلینڈز',
 			'VI' => 'امریکی ورجن آئلینڈز',
 			'VN' => 'ویتنام',
 			'VU' => 'وینوآٹو',
 			'WF' => 'ویلیز اور فیوٹیونا',
 			'WS' => 'ساموآ',
 			'XK' => 'کوسووو',
 			'YE' => 'یمن',
 			'YT' => 'مایوٹ',
 			'ZA' => 'جنوبی افریقہ',
 			'ZM' => 'زامبیا',
 			'ZW' => 'زمبابوے',
 			'ZZ' => 'نامعلوم علاقہ',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'کیلنڈر',
 			'cf' => 'کرنسی فارمیٹ',
 			'colalternate' => 'علامات کی چھٹائی نظرانداز کریں',
 			'colbackwards' => 'معکوس تلفظ کی چھٹائی',
 			'colcasefirst' => 'بڑے حروف/ چھوٹے حروف کی ترتیب بندی',
 			'colcaselevel' => 'حروف کے تئیں حساس چھٹائی',
 			'collation' => 'چھٹائی کی ترتیب',
 			'colnormalization' => 'معمول کی چھٹائی',
 			'colnumeric' => 'عددی چھٹائی',
 			'colstrength' => 'چھٹائی کی قوت',
 			'currency' => 'کرنسی',
 			'hc' => 'گھنٹہ سائیکل (12 بنام 24)',
 			'lb' => 'لائن بریک انداز',
 			'ms' => 'پیمائش کا نظام',
 			'numbers' => 'اعداد',
 			'timezone' => 'منطقۂ وقت',
 			'va' => 'مقام کا متغیرہ',
 			'x' => 'نجی-استعمال',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{بودھ کلینڈر},
 				'chinese' => q{چینی کیلنڈر},
 				'coptic' => q{کاپٹک کیلنڈر},
 				'dangi' => q{ڈانگی کیلنڈر},
 				'ethiopic' => q{ایتھوپیائی کیلنڈر},
 				'ethiopic-amete-alem' => q{ایتھوپک امیٹ الیم کیلنڈر},
 				'gregorian' => q{جارجیائی کیلنڈر},
 				'hebrew' => q{عبرانی کیلنڈر},
 				'indian' => q{ہندوستانی قومی کیلنڈر},
 				'islamic' => q{اسلامی کیلنڈر},
 				'islamic-civil' => q{اسلامی شہری کیلنڈر},
 				'islamic-umalqura' => q{اسلامی کیلنڈر (ام القراہ)},
 				'iso8601' => q{ISO-8601 کیلنڈر},
 				'japanese' => q{جاپانی کیلنڈر},
 				'persian' => q{فارسی کیلنڈر},
 				'roc' => q{منگوو کیلنڈر},
 			},
 			'cf' => {
 				'account' => q{اکاؤنٹنگ کرنسی فارمیٹ},
 				'standard' => q{اسٹینڈرڈ کرنسی فارمیٹ},
 			},
 			'colalternate' => {
 				'non-ignorable' => q{علامات کی چھٹائی کریں},
 				'shifted' => q{علامات کو نظرانداز کرکے چھٹائی کریں},
 			},
 			'colbackwards' => {
 				'no' => q{لہجوں کی چھٹائی معمول کے انداز میں کریں},
 				'yes' => q{لہجوں کی معکوس چھٹائی کریں},
 			},
 			'colcasefirst' => {
 				'lower' => q{پہلے چھوٹے حروف کی چھٹائی کریں},
 				'no' => q{معمول کے حروف کی ترتیب کی چھٹائی کریں},
 				'upper' => q{پہلے بالائی حروف کی چھٹائی کریں},
 			},
 			'colcaselevel' => {
 				'no' => q{حروف کی عدم حساسیت کی چھٹائی کریں},
 				'yes' => q{حروف کے تئیں حساس کی چھٹائی کریں},
 			},
 			'collation' => {
 				'big5han' => q{روایتی چینی کی چھٹائی کی ترتیب - Big5},
 				'compat' => q{سابقہ چھٹائی کی ترتیب، مطابقت کیلئے},
 				'dictionary' => q{لغت کی چھٹنی کی ترتیب},
 				'ducet' => q{ڈیفالٹ یونیکوڈ کی چھٹنی کی ترتیب},
 				'eor' => q{یورپی ترتیبی قوانین},
 				'gb2312han' => q{آسان چینی کی چھٹائی کی ترتیب - GB2312},
 				'phonebook' => q{فون بک کی چھٹنی کی ترتیب},
 				'phonetic' => q{صوتی چھٹائی کی ترتیب},
 				'pinyin' => q{پن ین کی چھٹنی کی ترتیب},
 				'reformed' => q{دوبارہ تشکیل شدہ چھٹنی کی ترتیب},
 				'search' => q{عام-مقصد کی تلاش},
 				'searchjl' => q{Hangul Initial Consonant کے لحاظ سے تلاش کریں},
 				'standard' => q{معیاری چھنٹائی کی ترتیب},
 				'stroke' => q{سٹروک کی چھٹنی کی ترتیب},
 				'traditional' => q{روایتی چھٹنی کی ترتیب},
 				'unihan' => q{اساسی-سٹروک کی چھٹنی کی ترتیب},
 			},
 			'colnormalization' => {
 				'no' => q{حسب معمول بنائے بغیر چھٹائی کریں},
 				'yes' => q{معمول کے یونیکوڈ کی چھٹائی کریں},
 			},
 			'colnumeric' => {
 				'no' => q{انفرادی طور پر ہندسوں کی چھٹائی کریں},
 				'yes' => q{اعداد کے لحاظ سے ہندسوں کی چھٹائی کریں},
 			},
 			'colstrength' => {
 				'identical' => q{سبھی کی چھٹائی کریں},
 				'primary' => q{صرف اساسی حروف کی چھٹائی کریں},
 				'quaternary' => q{لہجہ/ بڑے چھوٹے حروف/چوڑائی/Kana کی چھٹائی کریں},
 				'secondary' => q{لہجوں کی چھٹائی کریں},
 				'tertiary' => q{لہجوں/حروف/چوڑائی کی چھٹائی کریں},
 			},
 			'd0' => {
 				'fwidth' => q{پورا عرض},
 				'hwidth' => q{نصف عرض},
 				'npinyin' => q{عددی},
 			},
 			'hc' => {
 				'h11' => q{12 گھنٹے کا نظام (0–11)},
 				'h12' => q{12 گھنٹے کا نظام (1–12)},
 				'h23' => q{24 گھنٹے کا نظام (0–23)},
 				'h24' => q{24 گھنٹے کا نظام (1–24)},
 			},
 			'lb' => {
 				'loose' => q{ڈھیلا لائن بریک انداز},
 				'normal' => q{عمومی لائن بریک انداز},
 				'strict' => q{سخت لائن بریک انداز},
 			},
 			'm0' => {
 				'bgn' => q{US BGN},
 				'ungegn' => q{UN GEGN},
 			},
 			'ms' => {
 				'metric' => q{میٹرک نظام},
 				'uksystem' => q{پیمائش کا امپیریل نظام},
 				'ussystem' => q{پیمائش کا امریکی نظام},
 			},
 			'numbers' => {
 				'arab' => q{عربی ہندی ہندسے},
 				'arabext' => q{توسیع شدہ عربی ہندی ہندسے},
 				'armn' => q{آرمینیائی اعداد},
 				'armnlow' => q{آرمینیائی زیریں اعداد},
 				'beng' => q{بنگالی ہندسے},
 				'deva' => q{دیوناگری ہندسے},
 				'ethi' => q{ایتھوپیائی اعداد},
 				'finance' => q{مالیاتی ہندسے},
 				'fullwide' => q{پورے عرض والے ہندسے},
 				'geor' => q{جارجیائی اعداد},
 				'grek' => q{یونانی اعداد},
 				'greklow' => q{یونانی زیریں اعداد},
 				'gujr' => q{گجراتی ہندسے},
 				'guru' => q{گرمکھی ہندسے},
 				'hanidec' => q{چینی اعشاری اعداد},
 				'hans' => q{آسان چینی اعداد},
 				'hansfin' => q{آسان چینی مالی اعداد},
 				'hant' => q{روایتی چینی اعداد},
 				'hantfin' => q{روایتی چینی مالی اعداد},
 				'hebr' => q{عبرانی اعداد},
 				'jpan' => q{جاپانی اعداد},
 				'jpanfin' => q{جاپانی مالی اعداد},
 				'khmr' => q{خمیر ہندسے},
 				'knda' => q{کنڑ ہندسے},
 				'laoo' => q{لاؤ ہندسے},
 				'latn' => q{مغربی ہندسے},
 				'mlym' => q{ملیالم ہندسے},
 				'mong' => q{منگولیائی ہندسے},
 				'mymr' => q{میانمار کے ہندسے},
 				'native' => q{اصل ہندسے},
 				'orya' => q{اڑیہ ہندسے},
 				'roman' => q{رومن اعداد},
 				'romanlow' => q{رومن زیریں اعداد},
 				'taml' => q{روایتی تمل اعداد},
 				'tamldec' => q{تمل اعداد},
 				'telu' => q{تیلگو ہندسے},
 				'thai' => q{تھائی ہندسے},
 				'tibt' => q{تبتی اعداد},
 				'traditional' => q{روایتی اعداد},
 				'vaii' => q{وائی ہندسے},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{میٹرک},
 			'UK' => q{سلطنت متحدہ},
 			'US' => q{ریاستہائے متحدہ},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => 'زبان:{0}',
 			'script' => 'رسم الخط:{0}',
 			'region' => 'خطہ:{0}',

		}
	},
);

has 'text_orientation' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { return {
			lines => '',
			characters => 'right-to-left',
		}}
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{[؀؁؂؃‌‍‎‏ ً ٌ ٍ َ ُ ِ ّ ْ ٔ ٖ ٗ ٘ ٰ ۃ ٻ ٺ ټ ٽ ي]},
			index => ['ا', 'ب', 'پ', 'ت', 'ٹ', 'ث', 'ج', 'چ', 'ح', 'خ', 'د', 'ڈ', 'ذ', 'ر', 'ڑ', 'ز', 'ژ', 'س', 'ش', 'ص', 'ض', 'ط', 'ظ', 'ع', 'غ', 'ف', 'ق', 'ک', 'گ', 'ل', 'م', 'ن', 'و', 'ہ', 'ھ', 'ء', 'ی', 'ے'],
			main => qr{[ا أ آ ب پ ت ٹ ث ج چ ح خ د ڈ ذ ر ڑ ز ژ س ش ص ض ط ظ ع غ ف ق ک گ ل م ن ں و ؤ ہ ۂ ھ ء ی ئ ے ة ه]},
			numbers => qr{[‎ \- , ٫ ٬ . % ‰ + 0۰ 1۱ 2۲ 3۳ 4۴ 5۵ 6۶ 7۷ 8۸ 9۹]},
			punctuation => qr{[، ؍ ٫ ٬ ؛ \: ؟ . ۔ ( ) \[ \]]},
		};
	},
EOT
: sub {
		return { index => ['ا', 'ب', 'پ', 'ت', 'ٹ', 'ث', 'ج', 'چ', 'ح', 'خ', 'د', 'ڈ', 'ذ', 'ر', 'ڑ', 'ز', 'ژ', 'س', 'ش', 'ص', 'ض', 'ط', 'ظ', 'ع', 'غ', 'ف', 'ق', 'ک', 'گ', 'ل', 'م', 'ن', 'و', 'ہ', 'ھ', 'ء', 'ی', 'ے'], };
},
);


has 'ellipsis' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
			'word-final' => '{0} …',
			'word-initial' => '… {0}',
			'word-medial' => '{0} … {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{؟},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{”},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{“},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{’},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'' => {
						'name' => q(کارڈینل ڈائریکشن),
					},
					'acre' => {
						'name' => q(ایکڑ),
						'one' => q({0} ایکڑ),
						'other' => q({0} ایکڑ),
					},
					'acre-foot' => {
						'name' => q(ایکڑ فٹ),
						'one' => q({0} ایکڑ فٹ),
						'other' => q({0} ایکڑ فٹ),
					},
					'ampere' => {
						'name' => q(ایمپیئر),
						'one' => q({0} ایمپیئر),
						'other' => q({0} ایمپیئر),
					},
					'arc-minute' => {
						'name' => q(آرک منٹ),
						'one' => q({0} آرک منٹ),
						'other' => q({0} آرک منٹ),
					},
					'arc-second' => {
						'name' => q(آرک سیکنڈ),
						'one' => q({0} آرک سیکنڈ),
						'other' => q({0} آرک سیکنڈ),
					},
					'astronomical-unit' => {
						'name' => q(ایسٹرونومیکل یونٹس),
						'one' => q({0} ایسٹرونومیکل یونٹ),
						'other' => q({0} ایسٹرونومیکل یونٹس),
					},
					'atmosphere' => {
						'name' => q(ماحول),
						'one' => q({0} ماحول),
						'other' => q({0} ماحول),
					},
					'bit' => {
						'name' => q(بٹس),
						'one' => q({0} بٹ),
						'other' => q({0} بٹس),
					},
					'byte' => {
						'name' => q(بائٹ),
						'one' => q({0} بائٹ),
						'other' => q({0} بائٹس),
					},
					'calorie' => {
						'name' => q(کیلوریز),
						'one' => q({0} کیلوری),
						'other' => q({0} کیلوریز),
					},
					'carat' => {
						'name' => q(قیراط),
						'one' => q({0} قیراط),
						'other' => q({0} قیراط),
					},
					'celsius' => {
						'name' => q(ڈگری سیلسیس),
						'one' => q({0} ڈگری سیلسیس),
						'other' => q({0} ڈگری سیلسیس),
					},
					'centiliter' => {
						'name' => q(سینٹی لیٹر),
						'one' => q({0} سینٹی لیٹر),
						'other' => q({0} سینٹی لیٹر),
					},
					'centimeter' => {
						'name' => q(سینٹی میٹر),
						'one' => q({0} سینٹی میٹر),
						'other' => q({0} سینٹی میٹر),
						'per' => q({0} فی سینٹی میٹر),
					},
					'century' => {
						'name' => q(صدیاں),
						'one' => q({0} صدی),
						'other' => q({0} صدیاں),
					},
					'coordinate' => {
						'east' => q({0} مشرق),
						'north' => q({0} شمال),
						'south' => q({0} جنوب),
						'west' => q({0} مغرب),
					},
					'cubic-centimeter' => {
						'name' => q(کیوبک سینٹی میٹر),
						'one' => q({0} کیوبک سینٹی میٹر),
						'other' => q({0} کیوبک سینٹی میٹر),
						'per' => q({0} فی کیوبک سینٹی میٹر),
					},
					'cubic-foot' => {
						'name' => q(کیوبک فیٹ),
						'one' => q({0} کیوبک فیٹ),
						'other' => q({0} کیوبک فٹ),
					},
					'cubic-inch' => {
						'name' => q(کیوبک انچ),
						'one' => q({0} کیوبک انچ),
						'other' => q({0} کیوبک انچ),
					},
					'cubic-kilometer' => {
						'name' => q(کیوبک کلو میٹر),
						'one' => q({0} کیوبک کلو میٹر),
						'other' => q({0} کیوبک کلو میٹر),
					},
					'cubic-meter' => {
						'name' => q(کیوبک میٹر),
						'one' => q({0} کیوبک میٹر),
						'other' => q({0} کیوبک میٹر),
						'per' => q({0} فی کیوبک میٹر),
					},
					'cubic-mile' => {
						'name' => q(کیوبک میل),
						'one' => q({0} کیوبک میل),
						'other' => q({0} کیوبک میل),
					},
					'cubic-yard' => {
						'name' => q(کیوبک گز),
						'one' => q({0} کیوبک گز),
						'other' => q({0} کیوبک گز),
					},
					'cup' => {
						'name' => q(کپ),
						'one' => q({0} کپ),
						'other' => q({0} کپ),
					},
					'cup-metric' => {
						'name' => q(میٹرک کپ),
						'one' => q({0} میٹرک کپ),
						'other' => q({0} میٹرک کپ),
					},
					'day' => {
						'name' => q(دن),
						'one' => q({0} دن),
						'other' => q({0} دن),
						'per' => q({0} فی دن),
					},
					'deciliter' => {
						'name' => q(ڈیسی لیٹر),
						'one' => q({0} ڈیسی لیٹر),
						'other' => q({0} ڈیسی لیٹر),
					},
					'decimeter' => {
						'name' => q(ڈیسی میٹر),
						'one' => q({0} ڈیسی میٹر),
						'other' => q({0} ڈیسی میٹر),
					},
					'degree' => {
						'name' => q(ڈگری),
						'one' => q({0} ڈگری),
						'other' => q({0} ڈگری),
					},
					'fahrenheit' => {
						'name' => q(ڈگری فارن ہائیٹ),
						'one' => q({0} ڈگری فارن ہائیٹ),
						'other' => q({0} ڈگری فارن ہائیٹ),
					},
					'fluid-ounce' => {
						'name' => q(فلوئڈ اونس),
						'one' => q({0} فلوئڈ اونس),
						'other' => q({0} فلوئڈ اونس),
					},
					'foodcalorie' => {
						'name' => q(کیلوریز),
						'one' => q({0} کیلوری),
						'other' => q({0} کیلوریز),
					},
					'foot' => {
						'name' => q(فیٹ),
						'one' => q({0} فیٹ),
						'other' => q({0} فیٹ),
						'per' => q({0} فی فوٹ),
					},
					'g-force' => {
						'name' => q(جی-فورس),
						'one' => q({0} جی-فورس),
						'other' => q({0} جی-فورس),
					},
					'gallon' => {
						'name' => q(گیلن),
						'one' => q({0} گیلن),
						'other' => q({0} گیلن),
						'per' => q({0} فی گیلن),
					},
					'gallon-imperial' => {
						'name' => q(امپیریل گیلن),
						'one' => q({0} امپیریل گیلن),
						'other' => q({0} امپیریل گیلن),
						'per' => q({0} فی امپیریل گیلن),
					},
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'gigabit' => {
						'name' => q(گیگابٹس),
						'one' => q({0} گیگابٹ),
						'other' => q({0} گیگابٹس),
					},
					'gigabyte' => {
						'name' => q(گیگابائٹس),
						'one' => q({0} گیگابائٹ),
						'other' => q({0} گیگابائٹ),
					},
					'gigahertz' => {
						'name' => q(گیگاہرٹز),
						'one' => q({0} گیگاہرٹز),
						'other' => q({0} گیگاہرٹز),
					},
					'gigawatt' => {
						'name' => q(گیگا واٹ),
						'one' => q({0} گیگا واٹ),
						'other' => q({0} گیگا واٹ),
					},
					'gram' => {
						'name' => q(گرام),
						'one' => q({0} گرام),
						'other' => q({0} گرام),
						'per' => q({0} فی گرام),
					},
					'hectare' => {
						'name' => q(ہیکٹر),
						'one' => q({0} ہیکٹر),
						'other' => q({0} ہیکٹر),
					},
					'hectoliter' => {
						'name' => q(ہیکٹو لیٹر),
						'one' => q({0} ہیکٹو لیٹر),
						'other' => q({0} ہیکٹو لیٹر),
					},
					'hectopascal' => {
						'name' => q(ہیکٹو پاسکل),
						'one' => q({0} ہیکٹو پاسکل),
						'other' => q({0} ہیکٹو پاسکل),
					},
					'hertz' => {
						'name' => q(ہرٹز),
						'one' => q({0} ہرٹز),
						'other' => q({0} ہرٹز),
					},
					'horsepower' => {
						'name' => q(ہارس پاور),
						'one' => q({0} ہارس پاور),
						'other' => q({0} ہارس پاور),
					},
					'hour' => {
						'name' => q(گھنٹے),
						'one' => q({0} گھنٹہ),
						'other' => q({0} گھنٹے),
						'per' => q({0} فی گھنٹہ),
					},
					'inch' => {
						'name' => q(انچ),
						'one' => q({0} انچ),
						'other' => q({0} انچ),
						'per' => q({0} فی انچ),
					},
					'inch-hg' => {
						'name' => q(انچ مرکری),
						'one' => q({0} انچ مرکری),
						'other' => q({0} انچ مرکری),
					},
					'joule' => {
						'name' => q(جول),
						'one' => q({0} جول),
						'other' => q({0} جول),
					},
					'karat' => {
						'name' => q(قیراط),
						'one' => q({0} قیراط),
						'other' => q({0} قیراط),
					},
					'kelvin' => {
						'name' => q(کیلون),
						'one' => q({0} کیلون),
						'other' => q({0} کیلون),
					},
					'kilobit' => {
						'name' => q(کلوبٹس),
						'one' => q({0} کلوبٹ),
						'other' => q({0} کلوبٹس),
					},
					'kilobyte' => {
						'name' => q(کلوبائٹس),
						'one' => q({0} کلوبائٹ),
						'other' => q({0} کلوبائٹس),
					},
					'kilocalorie' => {
						'name' => q(کلو کیلوریز),
						'one' => q({0} کلو کیلوری),
						'other' => q({0} کلو کیلوریز),
					},
					'kilogram' => {
						'name' => q(کلو گرام),
						'one' => q({0} کلو گرام),
						'other' => q({0} کلو گرام),
						'per' => q({0} فی کلو گرام),
					},
					'kilohertz' => {
						'name' => q(کلوہرٹز),
						'one' => q({0} کلوہرٹز),
						'other' => q({0} کلوہرٹز),
					},
					'kilojoule' => {
						'name' => q(کلو جول),
						'one' => q({0} کلو جول),
						'other' => q({0} کلو جول),
					},
					'kilometer' => {
						'name' => q(کلو میٹر),
						'one' => q({0} کلو میٹر),
						'other' => q({0} کلو میٹر),
						'per' => q({0} فی کلومیٹر),
					},
					'kilometer-per-hour' => {
						'name' => q(کلومیٹر فی گھنٹہ),
						'one' => q({0} کلومیٹر فی گھنٹہ),
						'other' => q({0} کلومیٹر فی گھنٹہ),
					},
					'kilowatt' => {
						'name' => q(کلو واٹ),
						'one' => q({0} کلو واٹ),
						'other' => q({0} کلو واٹ),
					},
					'kilowatt-hour' => {
						'name' => q(کلو واٹ آور),
						'one' => q({0} کلو واٹ آور),
						'other' => q({0} کلو واٹ آور),
					},
					'knot' => {
						'name' => q(ناٹس),
						'one' => q({0} ناٹ),
						'other' => q({0} ناٹس),
					},
					'light-year' => {
						'name' => q(نوری سال),
						'one' => q({0} نوری سال),
						'other' => q({0} نوری سال),
					},
					'liter' => {
						'name' => q(لیٹر),
						'one' => q({0} لیٹر),
						'other' => q({0} لیٹر),
						'per' => q({0} فی لیٹر),
					},
					'liter-per-100kilometers' => {
						'name' => q(لیٹر فی 100 کلو میٹر),
						'one' => q({0} لیٹر فی 100 کلو میٹر),
						'other' => q({0} لیٹر فی 100 کلو میٹر),
					},
					'liter-per-kilometer' => {
						'name' => q(لیٹر فی کلومیٹر),
						'one' => q({0} لیٹر فی کلومیٹر),
						'other' => q({0} لیٹر فی کلومیٹر),
					},
					'lux' => {
						'name' => q(lux),
						'one' => q({0} lux),
						'other' => q({0} lux),
					},
					'megabit' => {
						'name' => q(میگابٹس),
						'one' => q({0} میگابٹ),
						'other' => q({0} میگابٹس),
					},
					'megabyte' => {
						'name' => q(ميگابائٹس),
						'one' => q({0} میگابائٹ),
						'other' => q({0} ميگابائٹس),
					},
					'megahertz' => {
						'name' => q(میگاہرٹز),
						'one' => q({0} میگاہرٹز),
						'other' => q({0} میگاہرٹز),
					},
					'megaliter' => {
						'name' => q(میگا لیٹر),
						'one' => q({0} میگا لیٹر),
						'other' => q({0} میگا لیٹر),
					},
					'megawatt' => {
						'name' => q(میگا واٹ),
						'one' => q({0} میگا واٹ),
						'other' => q({0} میگا واٹ),
					},
					'meter' => {
						'name' => q(میٹر),
						'one' => q({0} میٹر),
						'other' => q({0} میٹر),
						'per' => q({0} فی میٹر),
					},
					'meter-per-second' => {
						'name' => q(میٹر فی سیکنڈ),
						'one' => q({0} میٹر فی سیکنڈ),
						'other' => q({0} میٹر فی سیکنڈ),
					},
					'meter-per-second-squared' => {
						'name' => q(میٹر فی مربع سیکنڈ),
						'one' => q({0} میٹر فی مربع سیکنڈ),
						'other' => q({0} میٹر فی مربع سیکنڈ),
					},
					'metric-ton' => {
						'name' => q(میٹرک ٹن),
						'one' => q({0} میٹرک ٹن),
						'other' => q({0} میٹرک ٹن),
					},
					'microgram' => {
						'name' => q(مائکرو گرام),
						'one' => q({0} مائکرو گرام),
						'other' => q({0} مائکرو گرام),
					},
					'micrometer' => {
						'name' => q(مائیکرو میٹر),
						'one' => q({0} مائیکرو میٹر),
						'other' => q({0} مائیکرو میٹر),
					},
					'microsecond' => {
						'name' => q(مائیکرو سیکنڈز),
						'one' => q({0} مائیکرو سیکنڈ),
						'other' => q({0} مائیکرو سیکنڈز),
					},
					'mile' => {
						'name' => q(میل),
						'one' => q({0} میل),
						'other' => q({0} میل),
					},
					'mile-per-gallon' => {
						'name' => q(میل فی گیلن),
						'one' => q({0} میل فی گیلن),
						'other' => q({0} میل فی گیلن),
					},
					'mile-per-gallon-imperial' => {
						'name' => q(میل فی امپیریل گیلن),
						'one' => q({0} میل فی امپیریل گیلن),
						'other' => q({0} میل فی امپیریل گیلن),
					},
					'mile-per-hour' => {
						'name' => q(میل فی گھنٹہ),
						'one' => q({0} میل فی گھنٹہ),
						'other' => q({0} میل فی گھنٹہ),
					},
					'mile-scandinavian' => {
						'name' => q(اسکینڈی نیویائی میل),
						'one' => q({0} اسکینڈی نیویائی میل),
						'other' => q({0} اسکینڈی نیویائی میل),
					},
					'milliampere' => {
						'name' => q(ملی ایمپیئر),
						'one' => q({0} ملی ایمپیئر),
						'other' => q({0} ملی ایمپیئر),
					},
					'millibar' => {
						'name' => q(ملی بار),
						'one' => q({0} ملی بار),
						'other' => q({0} ملی بار),
					},
					'milligram' => {
						'name' => q(ملی گرام),
						'one' => q({0} ملی گرام),
						'other' => q({0} ملی گرام),
					},
					'milligram-per-deciliter' => {
						'name' => q(ملی گرام فی ڈیسی لیٹر),
						'one' => q({0} ملی گرام فی ڈیسی لیٹر),
						'other' => q({0} ملی گرام فی ڈیسی لیٹر),
					},
					'milliliter' => {
						'name' => q(ملی لیٹر),
						'one' => q({0} ملی لیٹر),
						'other' => q({0} ملی لیٹر),
					},
					'millimeter' => {
						'name' => q(ملی میٹر),
						'one' => q({0} ملیمیٹر),
						'other' => q({0} ملیمیٹر),
					},
					'millimeter-of-mercury' => {
						'name' => q(ملی میٹر مرکری),
						'one' => q({0} ملی میٹر مرکری),
						'other' => q({0} ملی میٹر مرکری),
					},
					'millimole-per-liter' => {
						'name' => q(ملی مولس فی لیٹر),
						'one' => q({0} ملی مول فی لیٹر),
						'other' => q({0} ملی مول فی لیٹر),
					},
					'millisecond' => {
						'name' => q(ملی سیکنڈز),
						'one' => q({0} ملی سیکنڈ),
						'other' => q({0} میل سیکنڈ),
					},
					'milliwatt' => {
						'name' => q(ملی واٹ),
						'one' => q({0} ملی واٹ),
						'other' => q({0} ملی واٹ),
					},
					'minute' => {
						'name' => q(منٹ),
						'one' => q({0} منٹ),
						'other' => q({0} منٹ),
						'per' => q({0} فی منٹ),
					},
					'month' => {
						'name' => q(مہینے),
						'one' => q({0} مہینہ),
						'other' => q({0} مہینے),
						'per' => q({0}/m),
					},
					'nanometer' => {
						'name' => q(نینو میٹر),
						'one' => q({0} نینو میٹر),
						'other' => q({0} نینو میٹر),
					},
					'nanosecond' => {
						'name' => q(نینو سیکنڈز),
						'one' => q({0} نینو سیکنڈ),
						'other' => q({0} نینو سیکنڈ),
					},
					'nautical-mile' => {
						'name' => q(بحری میل),
						'one' => q({0} بحری میل),
						'other' => q({0} بحری میل),
					},
					'ohm' => {
						'name' => q(اوہم),
						'one' => q({0} اوہم),
						'other' => q({0} اوہم),
					},
					'ounce' => {
						'name' => q(اونس),
						'one' => q({0} اونس),
						'other' => q({0} اونس),
						'per' => q({0} فی اونس),
					},
					'ounce-troy' => {
						'name' => q(ٹرائے اونس),
						'one' => q({0} ٹرائے اونس),
						'other' => q({0} ٹرائے اونس),
					},
					'parsec' => {
						'name' => q(پارسیک),
						'one' => q({0} پارسیک),
						'other' => q({0} پارسیک),
					},
					'part-per-million' => {
						'name' => q(فی ملین حصے),
						'one' => q({0} فی ملین حصے),
						'other' => q({0} فی ملین حصے),
					},
					'per' => {
						'1' => q({0} فی {1}),
					},
					'percent' => {
						'name' => q(فیصد),
						'one' => q({0} فیصد),
						'other' => q({0} فیصد),
					},
					'permille' => {
						'name' => q(فی ہزار),
						'one' => q({0} فی ہزار),
						'other' => q({0} فی ہزار),
					},
					'petabyte' => {
						'name' => q(پیٹا بائٹس),
						'one' => q({0} پیٹا بائٹ),
						'other' => q({0} پیٹا بائٹس),
					},
					'picometer' => {
						'name' => q(پیکو میٹر),
						'one' => q({0} پیکو میٹر),
						'other' => q({0} پیکو میٹر),
					},
					'pint' => {
						'name' => q(پائنٹ),
						'one' => q({0} پائنٹ),
						'other' => q({0} پائنٹ),
					},
					'pint-metric' => {
						'name' => q(میٹرک پائنٹ),
						'one' => q({0} میٹرک پائنٹ),
						'other' => q({0} میٹرک پائنٹ),
					},
					'point' => {
						'name' => q(پوائنٹس),
						'one' => q({0} پوائنٹ),
						'other' => q({0} پوائنٹس),
					},
					'pound' => {
						'name' => q(پاؤنڈ),
						'one' => q({0} پاؤنڈ),
						'other' => q({0} پاؤنڈ),
						'per' => q({0} فی پاؤنڈ),
					},
					'pound-per-square-inch' => {
						'name' => q(پاؤنڈز فی مربع انچ),
						'one' => q({0} پاؤنڈ فی مربع انچ),
						'other' => q({0} پاؤنڈز فی مربع انچ),
					},
					'quart' => {
						'name' => q(کوارٹ),
						'one' => q({0} کوارٹ),
						'other' => q({0} کوارٹ),
					},
					'radian' => {
						'name' => q(ریڈینس),
						'one' => q({0} ریڈین),
						'other' => q({0} ریڈینس),
					},
					'revolution' => {
						'name' => q(گردش),
						'one' => q({0} rev),
						'other' => q({0} گردش),
					},
					'second' => {
						'name' => q(سیکنڈ),
						'one' => q({0} سیکنڈ),
						'other' => q({0} سیکنڈ),
						'per' => q({0} فی سیکنڈ),
					},
					'square-centimeter' => {
						'name' => q(مربع سینٹی میٹر),
						'one' => q({0} مربع سینٹی میٹر),
						'other' => q({0} مربع سینٹی میٹر),
						'per' => q({0} فی مربع سینٹی میٹر),
					},
					'square-foot' => {
						'name' => q(مربع فٹ),
						'one' => q({0} مربع فٹ),
						'other' => q({0} مربع فٹ),
					},
					'square-inch' => {
						'name' => q(مربع انچ),
						'one' => q({0} مربع انچ),
						'other' => q({0} مربع انچ),
						'per' => q({0} فی مربع انچ),
					},
					'square-kilometer' => {
						'name' => q(مربع کلو میٹر),
						'one' => q({0} مربع کلو میٹر),
						'other' => q({0} مربع کلو میٹر),
						'per' => q({0} فی مربع کلو میٹر),
					},
					'square-meter' => {
						'name' => q(مربع میٹر),
						'one' => q({0} مربع میٹر),
						'other' => q({0} مربع میٹر),
						'per' => q({0} فی مربع میٹر),
					},
					'square-mile' => {
						'name' => q(مربع میل),
						'one' => q({0} مربع میل),
						'other' => q({0} مربع میل),
						'per' => q({0} فی مربع میل),
					},
					'square-yard' => {
						'name' => q(مربع گز),
						'one' => q({0} مربع گز),
						'other' => q({0} مربع گز),
					},
					'stone' => {
						'name' => q(اسٹونز),
						'one' => q({0} اسٹون),
						'other' => q({0} اسٹونز),
					},
					'tablespoon' => {
						'name' => q(ٹیبل سپون),
						'one' => q({0} ٹیبل سپون),
						'other' => q({0} ٹیبل سپون),
					},
					'teaspoon' => {
						'name' => q(ٹی سپون),
						'one' => q({0} ٹی سپون),
						'other' => q({0} ٹی سپون),
					},
					'terabit' => {
						'name' => q(ٹیرابٹس),
						'one' => q({0} ٹیرابٹ),
						'other' => q({0} ٹیرابٹس),
					},
					'terabyte' => {
						'name' => q(ٹیرابائٹس),
						'one' => q({0} ٹیرابائٹ),
						'other' => q({0} ٹیرابائٹ),
					},
					'ton' => {
						'name' => q(ٹن),
						'one' => q({0} ٹن),
						'other' => q({0} ٹن),
					},
					'volt' => {
						'name' => q(وولٹ),
						'one' => q({0} وولٹ),
						'other' => q({0} وولٹ),
					},
					'watt' => {
						'name' => q(واٹ),
						'one' => q({0} واٹ),
						'other' => q({0} واٹ),
					},
					'week' => {
						'name' => q(ہفتے),
						'one' => q({0} ہفتہ),
						'other' => q({0} ہفتے),
						'per' => q({0} فی ہفتہ),
					},
					'yard' => {
						'name' => q(گز),
						'one' => q({0} یارڈ),
						'other' => q({0} یارڈ),
					},
					'year' => {
						'name' => q(سال),
						'one' => q({0} سال),
						'other' => q({0} سال),
						'per' => q(فی سال {0}),
					},
				},
				'narrow' => {
					'' => {
						'name' => q(ڈائریکشن),
					},
					'acre' => {
						'one' => q({0} ایکڑ),
						'other' => q({0} ایکڑ),
					},
					'arc-minute' => {
						'one' => q({0} منٹ),
						'other' => q({0} منٹ),
					},
					'arc-second' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					'celsius' => {
						'name' => q(⁰C),
						'one' => q({0}‎°),
						'other' => q({0}‎°),
					},
					'centimeter' => {
						'name' => q(سینٹی میٹر),
						'one' => q({0}cm),
						'other' => q({0}cm),
						'per' => q({0} فی سینٹی میٹر),
					},
					'coordinate' => {
						'east' => q({0}E),
						'north' => q({0}N),
						'south' => q({0}S),
						'west' => q({0}W),
					},
					'cubic-kilometer' => {
						'name' => q(km³),
						'one' => q({0}km³),
						'other' => q({0}km³),
					},
					'cubic-mile' => {
						'name' => q(mi³),
						'one' => q({0}mi³),
						'other' => q({0}mi³),
					},
					'day' => {
						'name' => q(دن),
						'one' => q({0} دن),
						'other' => q({0} دن),
						'per' => q({0} فی دن),
					},
					'decimeter' => {
						'name' => q(ڈیسی میٹر),
						'one' => q({0} dm),
						'other' => q({0} dm),
					},
					'degree' => {
						'one' => q({0} ڈگری),
						'other' => q({0} ڈگری),
					},
					'fahrenheit' => {
						'name' => q(°F),
						'one' => q({0}‎°F),
						'other' => q({0}°F),
					},
					'foot' => {
						'name' => q(فیٹ),
						'one' => q({0}′),
						'other' => q({0}′),
						'per' => q({0} فی فیٹ),
					},
					'g-force' => {
						'one' => q({0}g),
						'other' => q({0}g),
					},
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'gram' => {
						'name' => q(گرام),
						'one' => q({0} گرام),
						'other' => q({0} گرام),
						'per' => q({0} فی گرام),
					},
					'hectare' => {
						'one' => q({0} ہیکٹر),
						'other' => q({0} ہیکٹر),
					},
					'hectopascal' => {
						'name' => q(hPa),
						'one' => q({0}hPa),
						'other' => q({0}hPa),
					},
					'horsepower' => {
						'one' => q({0}hp),
						'other' => q({0}hp),
					},
					'hour' => {
						'name' => q(گھنٹہ),
						'one' => q({0} گھنٹہ),
						'other' => q({0} گھنٹے),
						'per' => q({0} فی گھنٹہ),
					},
					'inch' => {
						'name' => q(انچ),
						'one' => q({0} انچ),
						'other' => q({0} انچ),
						'per' => q({0} فی انچ),
					},
					'inch-hg' => {
						'name' => q(″ Hg),
						'one' => q({0} انچ مرکری),
						'other' => q({0} انچ مرکری),
					},
					'kelvin' => {
						'name' => q(K),
						'one' => q({0} K),
						'other' => q({0} K),
					},
					'kilogram' => {
						'name' => q(kg),
						'one' => q({0}kg),
						'other' => q({0}kg),
						'per' => q({0} فی کلو گرام),
					},
					'kilometer' => {
						'name' => q(کلو میٹر),
						'one' => q({0} کلو میٹر),
						'other' => q({0} کلو میٹر),
						'per' => q({0} فی کلو میٹر),
					},
					'kilometer-per-hour' => {
						'name' => q(km/hr),
						'one' => q({0}kph),
						'other' => q({0}kph),
					},
					'kilowatt' => {
						'one' => q({0}kW),
						'other' => q({0}kW),
					},
					'light-year' => {
						'one' => q({0}ly),
						'other' => q({0}ly),
					},
					'liter' => {
						'name' => q(لیٹر),
						'one' => q({0} لیٹر),
						'other' => q({0} لیٹر),
					},
					'liter-per-100kilometers' => {
						'name' => q(لیٹر/100 کلو میٹر),
						'one' => q({0}L/100km),
						'other' => q({0}L/100km),
					},
					'meter' => {
						'name' => q(میٹر),
						'one' => q({0} میٹر),
						'other' => q({0} میٹر),
						'per' => q({0} فی میٹر),
					},
					'meter-per-second' => {
						'name' => q(میٹر فی سیکنڈ),
						'one' => q({0}m/s),
						'other' => q({0}m/s),
					},
					'mile' => {
						'name' => q(میل),
						'one' => q({0} میل),
						'other' => q({0} میل),
					},
					'mile-per-hour' => {
						'name' => q(میل فی گھنٹہ),
						'one' => q({0}mph),
						'other' => q({0}mph),
					},
					'millibar' => {
						'name' => q(mbar),
						'one' => q({0}mb),
						'other' => q({0}mb),
					},
					'millimeter' => {
						'name' => q(ملی میٹر),
						'one' => q({0} ملیمیٹر),
						'other' => q({0} ملیمیٹر),
					},
					'millimeter-of-mercury' => {
						'name' => q(mm Hg),
						'one' => q({0} mm Hg),
						'other' => q({0} mm Hg),
					},
					'millisecond' => {
						'name' => q(ملی سیکنڈ),
						'one' => q({0} ms),
						'other' => q({0} ms),
					},
					'minute' => {
						'name' => q(منٹ),
						'one' => q({0} منٹ),
						'other' => q({0} منٹ),
						'per' => q({0} فی منٹ),
					},
					'month' => {
						'name' => q(مہینہ),
						'one' => q({0} مہینہ),
						'other' => q({0} مہینے),
					},
					'ounce' => {
						'name' => q(oz),
						'one' => q({0} ونس),
						'other' => q({0} ونس),
						'per' => q({0}/oz),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'percent' => {
						'name' => q(%),
						'one' => q({0}%),
						'other' => q({0}%),
					},
					'picometer' => {
						'one' => q({0}pm),
						'other' => q({0}pm),
					},
					'pound' => {
						'one' => q({0} پونڈ),
						'other' => q({0} پونڈ),
					},
					'pound-per-square-inch' => {
						'name' => q(psi),
						'one' => q({0} psi),
						'other' => q({0} psi),
					},
					'second' => {
						'name' => q(سیکنڈ),
						'one' => q({0} سیکنڈ),
						'other' => q({0} سیکنڈ),
						'per' => q({0} فی سیکنڈ),
					},
					'square-foot' => {
						'one' => q({0}ft²),
						'other' => q({0}ft²),
					},
					'square-kilometer' => {
						'one' => q({0} km²),
						'other' => q({0} km²),
					},
					'square-meter' => {
						'one' => q({0} m²),
						'other' => q({0} m²),
					},
					'square-mile' => {
						'one' => q({0}mi²),
						'other' => q({0}mi²),
					},
					'stone' => {
						'name' => q(st),
						'one' => q({0} st),
						'other' => q({0} st),
					},
					'watt' => {
						'one' => q({0} واٹ),
						'other' => q({0} واٹ),
					},
					'week' => {
						'name' => q(ہفتہ),
						'one' => q({0} ہفتہ),
						'other' => q({0} ہفتے),
					},
					'yard' => {
						'name' => q(گز),
						'one' => q({0} یارڈ),
						'other' => q({0} یارڈ),
					},
					'year' => {
						'name' => q(سال),
						'one' => q({0} سال),
						'other' => q({0} سال),
					},
				},
				'short' => {
					'' => {
						'name' => q(ڈائریکشن),
					},
					'acre' => {
						'name' => q(ایکڑ),
						'one' => q({0} ایکڑ),
						'other' => q({0} ایکڑ),
					},
					'acre-foot' => {
						'name' => q(ایکڑ فٹ),
						'one' => q({0} ac ft),
						'other' => q({0} ac ft),
					},
					'ampere' => {
						'name' => q(amps),
						'one' => q({0} A),
						'other' => q({0} A),
					},
					'arc-minute' => {
						'name' => q(آرک منٹ),
						'one' => q({0} آرک منٹ),
						'other' => q({0} آرک منٹ),
					},
					'arc-second' => {
						'name' => q(آرک سیکنڈ),
						'one' => q({0} آرک سیکنڈ),
						'other' => q({0} آرک سیکنڈ),
					},
					'astronomical-unit' => {
						'name' => q(au),
						'one' => q({0} au),
						'other' => q({0} au),
					},
					'atmosphere' => {
						'name' => q(atm),
						'one' => q({0} atm),
						'other' => q({0} atm),
					},
					'bit' => {
						'name' => q(bit),
						'one' => q({0} bit),
						'other' => q({0} bit),
					},
					'byte' => {
						'name' => q(بائٹ),
						'one' => q({0} byte),
						'other' => q({0} byte),
					},
					'calorie' => {
						'name' => q(cal),
						'one' => q({0} cal),
						'other' => q({0} cal),
					},
					'carat' => {
						'name' => q(قیراط),
						'one' => q({0} CD),
						'other' => q({0} CD),
					},
					'celsius' => {
						'name' => q(ڈگری سیلسیس),
						'one' => q({0}‎°C),
						'other' => q({0}‎°C),
					},
					'centiliter' => {
						'name' => q(سینٹی لیٹر),
						'one' => q({0} cL),
						'other' => q({0} cL),
					},
					'centimeter' => {
						'name' => q(سینٹی میٹر),
						'one' => q({0} سینٹی میٹر),
						'other' => q({0} سینٹی میٹر),
						'per' => q({0}/cm),
					},
					'century' => {
						'name' => q(صدی),
						'one' => q({0} صدی),
						'other' => q({0} صدیاں),
					},
					'coordinate' => {
						'east' => q({0}E),
						'north' => q({0}N),
						'south' => q({0}S),
						'west' => q({0}W),
					},
					'cubic-centimeter' => {
						'name' => q(کیوبک سینٹی میٹر),
						'one' => q({0} cm³),
						'other' => q({0} cm³),
						'per' => q({0}/cm³),
					},
					'cubic-foot' => {
						'name' => q(کیوبک فٹ),
						'one' => q({0} ft³),
						'other' => q({0} ft³),
					},
					'cubic-inch' => {
						'name' => q(کیوبک انچ),
						'one' => q({0} in³),
						'other' => q({0} in³),
					},
					'cubic-kilometer' => {
						'name' => q(km³),
						'one' => q({0} km³),
						'other' => q({0} km³),
					},
					'cubic-meter' => {
						'name' => q(m³),
						'one' => q({0} m³),
						'other' => q({0} m³),
						'per' => q({0}/m³),
					},
					'cubic-mile' => {
						'name' => q(کیوبک میل),
						'one' => q({0} کیوبک میل),
						'other' => q({0} کیوبک میل),
					},
					'cubic-yard' => {
						'name' => q(کیوبک گز),
						'one' => q({0} yd³),
						'other' => q({0} yd³),
					},
					'cup' => {
						'name' => q(کپ),
						'one' => q({0} c),
						'other' => q({0} c),
					},
					'cup-metric' => {
						'name' => q(mcup),
						'one' => q({0} mc),
						'other' => q({0} mc),
					},
					'day' => {
						'name' => q(دن),
						'one' => q({0} دن),
						'other' => q({0} دن),
						'per' => q({0} فی دن),
					},
					'deciliter' => {
						'name' => q(ڈیسی لیٹر),
						'one' => q({0} dL),
						'other' => q({0} dL),
					},
					'decimeter' => {
						'name' => q(dm),
						'one' => q({0} dm),
						'other' => q({0} dm),
					},
					'degree' => {
						'name' => q(ڈگری),
						'one' => q({0} ڈگری),
						'other' => q({0} ڈگری),
					},
					'fahrenheit' => {
						'name' => q(ڈگری فارن ہائیٹ),
						'one' => q({0}‎°F),
						'other' => q({0}‎°F),
					},
					'fluid-ounce' => {
						'name' => q(fl oz),
						'one' => q({0} fl oz),
						'other' => q({0} fl oz),
					},
					'foodcalorie' => {
						'name' => q(Cal),
						'one' => q({0} Cal),
						'other' => q({0} Cal),
					},
					'foot' => {
						'name' => q(فیٹ),
						'one' => q({0} فیٹ),
						'other' => q({0} فیٹ),
						'per' => q({0}/ft),
					},
					'g-force' => {
						'name' => q(جی-فورس),
						'one' => q({0} G),
						'other' => q({0} G),
					},
					'gallon' => {
						'name' => q(gal),
						'one' => q({0} gal),
						'other' => q({0} gal),
						'per' => q({0}/gal),
					},
					'gallon-imperial' => {
						'name' => q(Imp. gal),
						'one' => q({0} gal Imp.),
						'other' => q({0} gal Imp.),
						'per' => q({0}/gal Imp.),
					},
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'gigabit' => {
						'name' => q(Gbit),
						'one' => q({0} Gb),
						'other' => q({0} Gb),
					},
					'gigabyte' => {
						'name' => q(GB),
						'one' => q({0} GB),
						'other' => q({0} GB),
					},
					'gigahertz' => {
						'name' => q(GHz),
						'one' => q({0} GHz),
						'other' => q({0} GHz),
					},
					'gigawatt' => {
						'name' => q(GW),
						'one' => q({0} GW),
						'other' => q({0} GW),
					},
					'gram' => {
						'name' => q(گرام),
						'one' => q({0} g),
						'other' => q({0} g),
						'per' => q({0}/g),
					},
					'hectare' => {
						'name' => q(ہیکٹر),
						'one' => q({0} ہیکٹر),
						'other' => q({0} ہیکٹر),
					},
					'hectoliter' => {
						'name' => q(hL),
						'one' => q({0} hL),
						'other' => q({0} hL),
					},
					'hectopascal' => {
						'name' => q(hPa),
						'one' => q({0} hPa),
						'other' => q({0} hPa),
					},
					'hertz' => {
						'name' => q(Hz),
						'one' => q({0} Hz),
						'other' => q({0} Hz),
					},
					'horsepower' => {
						'name' => q(hp),
						'one' => q({0} hp),
						'other' => q({0} hp),
					},
					'hour' => {
						'name' => q(گھنٹے),
						'one' => q({0} گھنٹہ),
						'other' => q({0} گھنٹے),
						'per' => q({0} فی گھنٹہ),
					},
					'inch' => {
						'name' => q(انچ),
						'one' => q({0} انچ),
						'other' => q({0} in),
						'per' => q({0}/in),
					},
					'inch-hg' => {
						'name' => q(inHg),
						'one' => q({0} inHg),
						'other' => q({0} inHg),
					},
					'joule' => {
						'name' => q(joule),
						'one' => q({0} J),
						'other' => q({0} J),
					},
					'karat' => {
						'name' => q(قیراط),
						'one' => q({0} kt),
						'other' => q({0} kt),
					},
					'kelvin' => {
						'name' => q(K),
						'one' => q({0} K),
						'other' => q({0} K),
					},
					'kilobit' => {
						'name' => q(kbit),
						'one' => q({0} kb),
						'other' => q({0} kb),
					},
					'kilobyte' => {
						'name' => q(kByte),
						'one' => q({0} kB),
						'other' => q({0} kB),
					},
					'kilocalorie' => {
						'name' => q(kcal),
						'one' => q({0} kcal),
						'other' => q({0} kcal),
					},
					'kilogram' => {
						'name' => q(kg),
						'one' => q({0} kg),
						'other' => q({0} kg),
						'per' => q({0}/kg),
					},
					'kilohertz' => {
						'name' => q(kHz),
						'one' => q({0} kHz),
						'other' => q({0} kHz),
					},
					'kilojoule' => {
						'name' => q(kJ),
						'one' => q({0} kJ),
						'other' => q({0} kJ),
					},
					'kilometer' => {
						'name' => q(کلو میٹر),
						'one' => q({0} کلو میٹر),
						'other' => q({0} کلو میٹر),
						'per' => q({0} فی کلو میٹر),
					},
					'kilometer-per-hour' => {
						'name' => q(کلومیٹر/گھنٹہ),
						'one' => q({0} kph),
						'other' => q({0} kph),
					},
					'kilowatt' => {
						'name' => q(kW),
						'one' => q({0} کلو واٹ),
						'other' => q({0} کلو واٹ),
					},
					'kilowatt-hour' => {
						'name' => q(kW-hour),
						'one' => q({0} kWh),
						'other' => q({0} kWh),
					},
					'knot' => {
						'name' => q(kn),
						'one' => q({0} kn),
						'other' => q({0} kn),
					},
					'light-year' => {
						'name' => q(نوری سال),
						'one' => q({0} ly),
						'other' => q({0} ly),
					},
					'liter' => {
						'name' => q(لیٹر),
						'one' => q({0} لیٹر),
						'other' => q({0} لیٹر),
						'per' => q({0} فی لیٹر),
					},
					'liter-per-100kilometers' => {
						'name' => q(لیٹر/100 کلو میٹر),
						'one' => q({0} L/100km),
						'other' => q({0} L/100km),
					},
					'liter-per-kilometer' => {
						'name' => q(L/km),
						'one' => q({0} L/km),
						'other' => q({0} L/km),
					},
					'lux' => {
						'name' => q(lux),
						'one' => q({0} lx),
						'other' => q({0} lx),
					},
					'megabit' => {
						'name' => q(Mb),
						'one' => q({0} Mb),
						'other' => q({0} Mb),
					},
					'megabyte' => {
						'name' => q(MByte),
						'one' => q({0} MB),
						'other' => q({0} MB),
					},
					'megahertz' => {
						'name' => q(MHz),
						'one' => q({0} MHz),
						'other' => q({0} MHz),
					},
					'megaliter' => {
						'name' => q(ML),
						'one' => q({0} ML),
						'other' => q({0} ML),
					},
					'megawatt' => {
						'name' => q(MW),
						'one' => q({0} MW),
						'other' => q({0} MW),
					},
					'meter' => {
						'name' => q(میٹر),
						'one' => q({0} میٹر),
						'other' => q({0} میٹر),
						'per' => q({0}/m),
					},
					'meter-per-second' => {
						'name' => q(میٹر فی سیکنڈ),
						'one' => q({0} m/s),
						'other' => q({0} m/s),
					},
					'meter-per-second-squared' => {
						'name' => q(m/s²),
						'one' => q({0} m/s²),
						'other' => q({0} m/s²),
					},
					'metric-ton' => {
						'name' => q(t),
						'one' => q({0} t),
						'other' => q({0} t),
					},
					'microgram' => {
						'name' => q(µg),
						'one' => q({0} µg),
						'other' => q({0} µg),
					},
					'micrometer' => {
						'name' => q(µm),
						'one' => q({0} µm),
						'other' => q({0} µm),
					},
					'microsecond' => {
						'name' => q(مائیکرو سیکنڈ),
						'one' => q({0} مائیکرو سیکنڈ),
						'other' => q({0} مائیکرو سیکنڈ),
					},
					'mile' => {
						'name' => q(میل),
						'one' => q({0} میل),
						'other' => q({0} میل),
					},
					'mile-per-gallon' => {
						'name' => q(mpg),
						'one' => q({0} mpg),
						'other' => q({0} mpg),
					},
					'mile-per-gallon-imperial' => {
						'name' => q(miles/gal Imp.),
						'one' => q({0} mpg Imp.),
						'other' => q({0} mpg Imp.),
					},
					'mile-per-hour' => {
						'name' => q(میل فی گھنٹہ),
						'one' => q({0} mph),
						'other' => q({0} mph),
					},
					'mile-scandinavian' => {
						'name' => q(smi),
						'one' => q({0} smi),
						'other' => q({0} smi),
					},
					'milliampere' => {
						'name' => q(milliamps),
						'one' => q({0} mA),
						'other' => q({0} mA),
					},
					'millibar' => {
						'name' => q(mbar),
						'one' => q({0} mbar),
						'other' => q({0} mbar),
					},
					'milligram' => {
						'name' => q(mg),
						'one' => q({0} mg),
						'other' => q({0} mg),
					},
					'milligram-per-deciliter' => {
						'name' => q(mg/dL),
						'one' => q({0} mg/dL),
						'other' => q({0} mg/dL),
					},
					'milliliter' => {
						'name' => q(mL),
						'one' => q({0} mL),
						'other' => q({0} mL),
					},
					'millimeter' => {
						'name' => q(ملی میٹر),
						'one' => q({0} ملیمیٹر),
						'other' => q({0} ملیمیٹر),
					},
					'millimeter-of-mercury' => {
						'name' => q(mm Hg),
						'one' => q({0} mm Hg),
						'other' => q({0} mm Hg),
					},
					'millimole-per-liter' => {
						'name' => q(ملی مول/لیٹر),
						'one' => q({0} mmol/L),
						'other' => q({0} mmol/L),
					},
					'millisecond' => {
						'name' => q(ملی سیکنڈ),
						'one' => q({0} ملی سیکنڈ),
						'other' => q({0} ملی سیکنڈ),
					},
					'milliwatt' => {
						'name' => q(mW),
						'one' => q({0} mW),
						'other' => q({0} mW),
					},
					'minute' => {
						'name' => q(منٹ),
						'one' => q({0} منٹ),
						'other' => q({0} منٹ),
						'per' => q({0} فی منٹ),
					},
					'month' => {
						'name' => q(مہینے),
						'one' => q({0} مہینہ),
						'other' => q({0} مہینے),
						'per' => q({0}/m),
					},
					'nanometer' => {
						'name' => q(nm),
						'one' => q({0} nm),
						'other' => q({0} nm),
					},
					'nanosecond' => {
						'name' => q(نینو سیکنڈز),
						'one' => q({0} نینو سیکنڈ),
						'other' => q({0} نینو سیکنڈ),
					},
					'nautical-mile' => {
						'name' => q(nmi),
						'one' => q({0} nmi),
						'other' => q({0} nmi),
					},
					'ohm' => {
						'name' => q(اوہم),
						'one' => q({0} Ω),
						'other' => q({0} Ω),
					},
					'ounce' => {
						'name' => q(oz),
						'one' => q({0} oz),
						'other' => q({0} oz),
						'per' => q({0}/oz),
					},
					'ounce-troy' => {
						'name' => q(oz t),
						'one' => q({0} oz t),
						'other' => q({0} oz t),
					},
					'parsec' => {
						'name' => q(پارسیک),
						'one' => q({0} pc),
						'other' => q({0} pc),
					},
					'part-per-million' => {
						'name' => q(حصے/ملین),
						'one' => q({0} ppm),
						'other' => q({0} ppm),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'percent' => {
						'name' => q(فیصد),
						'one' => q({0}%),
						'other' => q({0}%),
					},
					'permille' => {
						'name' => q(فی ہزار),
						'one' => q({0}‰),
						'other' => q({0}‰),
					},
					'petabyte' => {
						'name' => q(پی بائٹ),
						'one' => q({0} پی بی),
						'other' => q({0} پی بی),
					},
					'picometer' => {
						'name' => q(پیکو میٹر),
						'one' => q({0} پیکو میٹر),
						'other' => q({0} پیکو میٹر),
					},
					'pint' => {
						'name' => q(pt),
						'one' => q({0} pt),
						'other' => q({0} pt),
					},
					'pint-metric' => {
						'name' => q(mpt),
						'one' => q({0} mpt),
						'other' => q({0} mpt),
					},
					'point' => {
						'name' => q(pt),
						'one' => q({0} pt),
						'other' => q({0} pt),
					},
					'pound' => {
						'name' => q(پاؤنڈ),
						'one' => q({0} lb),
						'other' => q({0} lb),
						'per' => q({0}/lb),
					},
					'pound-per-square-inch' => {
						'name' => q(psi),
						'one' => q({0} psi),
						'other' => q({0} psi),
					},
					'quart' => {
						'name' => q(qts),
						'one' => q({0} qt),
						'other' => q({0} qt),
					},
					'radian' => {
						'name' => q(ریڈینس),
						'one' => q({0} rad),
						'other' => q({0} rad),
					},
					'revolution' => {
						'name' => q(rev),
						'one' => q({0} rev),
						'other' => q({0} rev),
					},
					'second' => {
						'name' => q(سیکنڈ),
						'one' => q({0} سیکنڈ),
						'other' => q({0} سیکنڈ),
						'per' => q({0} فی سیکنڈ),
					},
					'square-centimeter' => {
						'name' => q(cm²),
						'one' => q({0} cm²),
						'other' => q({0} cm²),
						'per' => q({0}/cm²),
					},
					'square-foot' => {
						'name' => q(مربع فٹ),
						'one' => q({0} sq ft),
						'other' => q({0} sq ft),
					},
					'square-inch' => {
						'name' => q(مربع انچ),
						'one' => q({0} in²),
						'other' => q({0} in²),
						'per' => q({0}/in²),
					},
					'square-kilometer' => {
						'name' => q(km²),
						'one' => q({0} km²),
						'other' => q({0} km²),
						'per' => q({0}/km²),
					},
					'square-meter' => {
						'name' => q(مربع میٹر),
						'one' => q({0} m²),
						'other' => q({0} m²),
						'per' => q({0}/m²),
					},
					'square-mile' => {
						'name' => q(مربع میل),
						'one' => q({0} sq mi),
						'other' => q({0} sq mi),
						'per' => q({0}/mi²),
					},
					'square-yard' => {
						'name' => q(مربع گز),
						'one' => q({0} yd²),
						'other' => q({0} yd²),
					},
					'stone' => {
						'name' => q(st),
						'one' => q({0} st),
						'other' => q({0} st),
					},
					'tablespoon' => {
						'name' => q(tbsp),
						'one' => q({0} tbsp),
						'other' => q({0} tbsp),
					},
					'teaspoon' => {
						'name' => q(tsp),
						'one' => q({0} tsp),
						'other' => q({0} tsp),
					},
					'terabit' => {
						'name' => q(Tbit),
						'one' => q({0} Tb),
						'other' => q({0} Tb),
					},
					'terabyte' => {
						'name' => q(TB),
						'one' => q({0} TB),
						'other' => q({0} TB),
					},
					'ton' => {
						'name' => q(ٹن),
						'one' => q({0} tn),
						'other' => q({0} tn),
					},
					'volt' => {
						'name' => q(وولٹ),
						'one' => q({0} V),
						'other' => q({0} V),
					},
					'watt' => {
						'name' => q(واٹ),
						'one' => q({0} واٹ),
						'other' => q({0} واٹ),
					},
					'week' => {
						'name' => q(ہفتے),
						'one' => q({0} ہفتہ),
						'other' => q({0} ہفتے),
						'per' => q({0} فی ہفتہ),
					},
					'yard' => {
						'name' => q(گز),
						'one' => q({0} یارڈ),
						'other' => q({0} یارڈ),
					},
					'year' => {
						'name' => q(سال),
						'one' => q({0} سال),
						'other' => q({0} سال),
						'per' => q({0}/y),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:ہاں|ہاں|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:نہیں|نہیں|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}، {1}),
				middle => q({0}، {1}),
				end => q({0}، اور {1}),
				2 => q({0} اور {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'latn',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'arabext',
);

has 'minimum_grouping_digits' => (
	is			=>'ro',
	isa			=> Int,
	init_arg	=> undef,
	default		=> 1,
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'arabext' => {
			'decimal' => q(٫),
			'exponential' => q(×۱۰^),
			'group' => q(٬),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(‎-‎),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(‎+‎),
			'superscriptingExponent' => q(×),
		},
		'latn' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(‎-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(‎+),
			'superscriptingExponent' => q(×),
			'timeSeparator' => q(:),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'1000' => {
					'one' => '0 ہزار',
					'other' => '0 ہزار',
				},
				'10000' => {
					'one' => '00 ہزار',
					'other' => '00 ہزار',
				},
				'100000' => {
					'one' => '0 لاکھ',
					'other' => '0 لاکھ',
				},
				'1000000' => {
					'one' => '00 لاکھ',
					'other' => '00 لاکھ',
				},
				'10000000' => {
					'one' => '0 کروڑ',
					'other' => '0 کروڑ',
				},
				'100000000' => {
					'one' => '00 کروڑ',
					'other' => '00 کروڑ',
				},
				'1000000000' => {
					'one' => '0 ارب',
					'other' => '0 ارب',
				},
				'10000000000' => {
					'one' => '00 ارب',
					'other' => '00 ارب',
				},
				'100000000000' => {
					'one' => '0 کھرب',
					'other' => '0 کھرب',
				},
				'1000000000000' => {
					'one' => '00 کھرب',
					'other' => '00 کھرب',
				},
				'10000000000000' => {
					'one' => '00 ٹریلین',
					'other' => '00 ٹریلین',
				},
				'100000000000000' => {
					'one' => '000 ٹریلین',
					'other' => '000 ٹریلین',
				},
				'standard' => {
					'default' => '#,##0.###',
				},
			},
			'long' => {
				'1000' => {
					'one' => '0 ہزار',
					'other' => '0 ہزار',
				},
				'10000' => {
					'one' => '00 ہزار',
					'other' => '00 ہزار',
				},
				'100000' => {
					'one' => '0 لاکھ',
					'other' => '0 لاکھ',
				},
				'1000000' => {
					'one' => '00 لاکھ',
					'other' => '00 لاکھ',
				},
				'10000000' => {
					'one' => '0 کروڑ',
					'other' => '0 کروڑ',
				},
				'100000000' => {
					'one' => '00 کروڑ',
					'other' => '00 کروڑ',
				},
				'1000000000' => {
					'one' => '0 ارب',
					'other' => '0 ارب',
				},
				'10000000000' => {
					'one' => '00 ارب',
					'other' => '00 ارب',
				},
				'100000000000' => {
					'one' => '0 کھرب',
					'other' => '0 کھرب',
				},
				'1000000000000' => {
					'one' => '00 کھرب',
					'other' => '00 کھرب',
				},
				'10000000000000' => {
					'one' => '00 ٹریلین',
					'other' => '00 ٹریلین',
				},
				'100000000000000' => {
					'one' => '000 ٹریلین',
					'other' => '000 ٹریلین',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0 ہزار',
					'other' => '0 ہزار',
				},
				'10000' => {
					'one' => '00 ہزار',
					'other' => '00 ہزار',
				},
				'100000' => {
					'one' => '0 لاکھ',
					'other' => '0 لاکھ',
				},
				'1000000' => {
					'one' => '00 لاکھ',
					'other' => '00 لاکھ',
				},
				'10000000' => {
					'one' => '0 کروڑ',
					'other' => '0 کروڑ',
				},
				'100000000' => {
					'one' => '00 کروڑ',
					'other' => '00 کروڑ',
				},
				'1000000000' => {
					'one' => '0 ارب',
					'other' => '0 ارب',
				},
				'10000000000' => {
					'one' => '00 ارب',
					'other' => '00 ارب',
				},
				'100000000000' => {
					'one' => '0 کھرب',
					'other' => '0 کھرب',
				},
				'1000000000000' => {
					'one' => '00 کھرب',
					'other' => '00 کھرب',
				},
				'10000000000000' => {
					'one' => '00 ٹریلین',
					'other' => '00 ٹریلین',
				},
				'100000000000000' => {
					'one' => '000 ٹریلین',
					'other' => '000 ٹریلین',
				},
			},
		},
		percentFormat => {
			'default' => {
				'standard' => {
					'default' => '#,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'standard' => {
					'default' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'arabext' => {
			'pattern' => {
				'default' => {
					'standard' => {
						'positive' => '¤#,##0.00',
					},
				},
			},
		},
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '(¤#,##0.00)',
						'positive' => '¤#,##0.00',
					},
					'standard' => {
						'positive' => '¤ #,##0.00',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'AED' => {
			symbol => 'AED',
			display_name => {
				'currency' => q(متحدہ عرب اماراتی درہم),
				'one' => q(متحدہ عرب اماراتی درہم),
				'other' => q(متحدہ عرب اماراتی درہم),
			},
		},
		'AFN' => {
			symbol => 'AFN',
			display_name => {
				'currency' => q(افغان افغانی),
				'one' => q(افغان افغانی),
				'other' => q(افغان افغانی),
			},
		},
		'ALL' => {
			symbol => 'ALL',
			display_name => {
				'currency' => q(البانیا کا لیک),
				'one' => q(البانیا کا لیک),
				'other' => q(البانیا کا لیک),
			},
		},
		'AMD' => {
			symbol => 'AMD',
			display_name => {
				'currency' => q(آرمینیائی ڈرم),
				'one' => q(آرمینیائی ڈرم),
				'other' => q(آرمینیائی ڈرم),
			},
		},
		'ANG' => {
			symbol => 'ANG',
			display_name => {
				'currency' => q(نیدر لینڈز انٹیلیئن گلڈر),
				'one' => q(نیدر لینڈز انٹیلیئن گلڈر),
				'other' => q(نیدر لینڈز انٹیلیئن گلڈر),
			},
		},
		'AOA' => {
			symbol => 'AOA',
			display_name => {
				'currency' => q(انگولا کا کوانزا),
				'one' => q(انگولا کا کوانزا),
				'other' => q(انگولا کا کوانزا),
			},
		},
		'ARS' => {
			symbol => 'ARS',
			display_name => {
				'currency' => q(ارجنٹائن پیسہ),
				'one' => q(ارجنٹائن پیسہ),
				'other' => q(ارجنٹائن پیسہ),
			},
		},
		'AUD' => {
			symbol => 'A$',
			display_name => {
				'currency' => q(آسٹریلین ڈالر),
				'one' => q(آسٹریلین ڈالر),
				'other' => q(آسٹریلین ڈالر),
			},
		},
		'AWG' => {
			symbol => 'AWG',
			display_name => {
				'currency' => q(اروبن فلورِن),
				'one' => q(اروبن فلورِن),
				'other' => q(اروبن فلورِن),
			},
		},
		'AZN' => {
			symbol => 'AZN',
			display_name => {
				'currency' => q(آذربائجانی منات),
				'one' => q(آذربائجانی منات),
				'other' => q(آذربائجانی منات),
			},
		},
		'BAM' => {
			symbol => 'BAM',
			display_name => {
				'currency' => q(بوسنیا ہرزیگووینا کا قابل منتقلی نشان),
				'one' => q(بوسنیا ہرزیگووینا کا قابل منتقلی نشان),
				'other' => q(بوسنیا ہرزیگووینا کا قابل منتقلی نشان),
			},
		},
		'BBD' => {
			symbol => 'BBD',
			display_name => {
				'currency' => q(باربیڈین ڈالر),
				'one' => q(باربیڈین ڈالر),
				'other' => q(باربیڈین ڈالر),
			},
		},
		'BDT' => {
			symbol => 'BDT',
			display_name => {
				'currency' => q(بنگلہ دیشی ٹکا),
				'one' => q(بنگلہ دیشی ٹکا),
				'other' => q(بنگلہ دیشی ٹکا),
			},
		},
		'BGN' => {
			symbol => 'BGN',
			display_name => {
				'currency' => q(بلغارین لیو),
				'one' => q(بلغارین لیو),
				'other' => q(بلغارین لیو),
			},
		},
		'BHD' => {
			symbol => 'BHD',
			display_name => {
				'currency' => q(بحرینی دینار),
				'one' => q(بحرینی دینار),
				'other' => q(بحرینی دینار),
			},
		},
		'BIF' => {
			symbol => 'BIF',
			display_name => {
				'currency' => q(برونڈیئن فرانک),
				'one' => q(برونڈیئن فرانک),
				'other' => q(برونڈیئن فرانک),
			},
		},
		'BMD' => {
			symbol => 'BMD',
			display_name => {
				'currency' => q(برموڈا ڈالر),
				'one' => q(برموڈا ڈالر),
				'other' => q(برموڈا ڈالر),
			},
		},
		'BND' => {
			symbol => 'BND',
			display_name => {
				'currency' => q(برونئی ڈالر),
				'one' => q(برونئی ڈالر),
				'other' => q(برونئی ڈالر),
			},
		},
		'BOB' => {
			symbol => 'BOB',
			display_name => {
				'currency' => q(بولیوین بولیویانو),
				'one' => q(بولیوین بولیویانو),
				'other' => q(بولیوین بولیویانو),
			},
		},
		'BRL' => {
			symbol => 'R$',
			display_name => {
				'currency' => q(برازیلی ریئل),
				'one' => q(برازیلی ریئل),
				'other' => q(برازیلی ریئل),
			},
		},
		'BSD' => {
			symbol => 'BSD',
			display_name => {
				'currency' => q(بہامانی ڈالر),
				'one' => q(بہامانی ڈالر),
				'other' => q(بہامانی ڈالر),
			},
		},
		'BTN' => {
			symbol => 'BTN',
			display_name => {
				'currency' => q(بھوٹانی گُلٹرم),
				'one' => q(بھوٹانی گُلٹرم),
				'other' => q(بھوٹانی گُلٹرم),
			},
		},
		'BWP' => {
			symbol => 'BWP',
			display_name => {
				'currency' => q(بوتسوانا کا پولا),
				'one' => q(بوتسوانا کا پولا),
				'other' => q(بوتسوانا کا پولا),
			},
		},
		'BYN' => {
			symbol => 'BYN',
			display_name => {
				'currency' => q(بیلاروسی روبل),
				'one' => q(بیلاروسی روبل),
				'other' => q(بیلاروسی روبل),
			},
		},
		'BYR' => {
			symbol => 'BYR',
			display_name => {
				'currency' => q(بیلاروسی روبل \(۲۰۰۰–۲۰۱۶\)),
				'one' => q(بیلاروسی روبل \(۲۰۰۰–۲۰۱۶\)),
				'other' => q(بیلاروسی روبل \(۲۰۰۰–۲۰۱۶\)),
			},
		},
		'BZD' => {
			symbol => 'BZD',
			display_name => {
				'currency' => q(بیلیز ڈالر),
				'one' => q(بیلیز ڈالر),
				'other' => q(بیلیز ڈالرز),
			},
		},
		'CAD' => {
			symbol => 'CA$',
			display_name => {
				'currency' => q(کنیڈین ڈالر),
				'one' => q(کنیڈین ڈالر),
				'other' => q(کنیڈین ڈالر),
			},
		},
		'CDF' => {
			symbol => 'CDF',
			display_name => {
				'currency' => q(کانگولیز فرانک),
				'one' => q(کانگولیز فرانک),
				'other' => q(کانگولیز فرانک),
			},
		},
		'CHF' => {
			symbol => 'CHF',
			display_name => {
				'currency' => q(سوئس فرانکس),
				'one' => q(سوئس فرانکس),
				'other' => q(سوئس فرانکس),
			},
		},
		'CLP' => {
			symbol => 'CLP',
			display_name => {
				'currency' => q(چلّین پیسہ),
				'one' => q(چلّین پیسہ),
				'other' => q(چلّین پیسہ),
			},
		},
		'CNH' => {
			symbol => 'CNH',
			display_name => {
				'currency' => q(چینی یوآن \(آف شور\)),
				'one' => q(چینی یوآن \(آف شور\)),
				'other' => q(چینی یوآن \(آف شور\)),
			},
		},
		'CNY' => {
			symbol => 'CN¥',
			display_name => {
				'currency' => q(چینی یوآن),
				'one' => q(چینی یوآن),
				'other' => q(چینی یوآن),
			},
		},
		'COP' => {
			symbol => 'COP',
			display_name => {
				'currency' => q(کولمبین پیسہ),
				'one' => q(کولمبین پیسہ),
				'other' => q(کولمبین پیسہ),
			},
		},
		'CRC' => {
			symbol => 'CRC',
			display_name => {
				'currency' => q(کوسٹا ریکا کا کولن),
				'one' => q(کوسٹا ریکا کا کولن),
				'other' => q(کوسٹا ریکا کا کولن),
			},
		},
		'CUC' => {
			symbol => 'CUC',
			display_name => {
				'currency' => q(کیوبا کا قابل منتقلی پیسو),
				'one' => q(کیوبا کا قابل منتقلی پیسو),
				'other' => q(کیوبا کا قابل منتقلی پیسو),
			},
		},
		'CUP' => {
			symbol => 'CUP',
			display_name => {
				'currency' => q(کیوبا کا پیسو),
				'one' => q(کیوبا کا پیسو),
				'other' => q(کیوبا کا پیسو),
			},
		},
		'CVE' => {
			symbol => 'CVE',
			display_name => {
				'currency' => q(کیپ ورڈی کا اسکیوڈو),
				'one' => q(کیپ ورڈی کا اسکیوڈو),
				'other' => q(کیپ ورڈی کا اسکیوڈو),
			},
		},
		'CZK' => {
			symbol => 'CZK',
			display_name => {
				'currency' => q(جمہوریہ چیک کرونا),
				'one' => q(جمہوریہ چیک کرونا),
				'other' => q(جمہوریہ چیک کروناز),
			},
		},
		'DEM' => {
			display_name => {
				'currency' => q(ڈچ مارکس),
			},
		},
		'DJF' => {
			symbol => 'DJF',
			display_name => {
				'currency' => q(جبوتی فرانک),
				'one' => q(جبوتی فرانک),
				'other' => q(جبوتی فرانک),
			},
		},
		'DKK' => {
			symbol => 'DKK',
			display_name => {
				'currency' => q(ڈنمارک کرون),
				'one' => q(ڈنمارک کرون),
				'other' => q(ڈنمارک کرون),
			},
		},
		'DOP' => {
			symbol => 'DOP',
			display_name => {
				'currency' => q(ڈومنیکن پیسو),
				'one' => q(ڈومنیکن پیسو),
				'other' => q(ڈومنیکن پیسو),
			},
		},
		'DZD' => {
			symbol => 'DZD',
			display_name => {
				'currency' => q(الجیریائی دینار),
				'one' => q(الجیریائی دینار),
				'other' => q(الجیریائی دینار),
			},
		},
		'EEK' => {
			display_name => {
				'currency' => q(ایسٹونین کرون),
			},
		},
		'EGP' => {
			symbol => 'EGP',
			display_name => {
				'currency' => q(مصری پاؤنڈ),
				'one' => q(مصری پاؤنڈ),
				'other' => q(مصری پاؤنڈ),
			},
		},
		'ERN' => {
			symbol => 'ERN',
			display_name => {
				'currency' => q(اریٹیریا کا نافکا),
				'one' => q(اریٹیریا کا نافکا),
				'other' => q(اریٹیریا کا نافکا),
			},
		},
		'ETB' => {
			symbol => 'ETB',
			display_name => {
				'currency' => q(ایتھوپیائی بِرّ),
				'one' => q(ایتھوپیائی بِرّ),
				'other' => q(ایتھوپیائی بِرّ),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(یورو),
				'one' => q(یورو),
				'other' => q(یورو),
			},
		},
		'FJD' => {
			symbol => 'FJD',
			display_name => {
				'currency' => q(فجی کا ڈالر),
				'one' => q(فجی کا ڈالر),
				'other' => q(فجی کا ڈالر),
			},
		},
		'FKP' => {
			symbol => 'FKP',
			display_name => {
				'currency' => q(فاکلینڈ آئلینڈز پونڈ),
				'one' => q(فاکلینڈ آئلینڈز پونڈ),
				'other' => q(فاکلینڈ آئلینڈز پونڈ),
			},
		},
		'FRF' => {
			display_name => {
				'currency' => q(فرانسیسی فرانک),
			},
		},
		'GBP' => {
			symbol => '£',
			display_name => {
				'currency' => q(انگلستانی پاونڈ سٹرلنگ),
				'one' => q(انگلستانی پاونڈ سٹرلنگ),
				'other' => q(انگلستانی پاونڈ سٹرلنگ),
			},
		},
		'GEL' => {
			symbol => 'GEL',
			display_name => {
				'currency' => q(جارجیائی لاری),
				'one' => q(جارجیائی لاری),
				'other' => q(جارجیائی لاری),
			},
		},
		'GHS' => {
			symbol => 'GHS',
			display_name => {
				'currency' => q(گھانا کا سیڈی),
				'one' => q(گھانا کا سیڈی),
				'other' => q(گھانا کا سیڈی),
			},
		},
		'GIP' => {
			symbol => 'GIP',
			display_name => {
				'currency' => q(جبل الطارق پونڈ),
				'one' => q(جبل الطارق پونڈ),
				'other' => q(جبل الطارق پونڈ),
			},
		},
		'GMD' => {
			symbol => 'GMD',
			display_name => {
				'currency' => q(گامبیا کا ڈلاسی),
				'one' => q(گامبیا کا ڈلاسی),
				'other' => q(گامبیا کا ڈلاسی),
			},
		},
		'GNF' => {
			symbol => 'GNF',
			display_name => {
				'currency' => q(گنی فرانک),
				'one' => q(گنی فرانک),
				'other' => q(گنی فرانک),
			},
		},
		'GTQ' => {
			symbol => 'GTQ',
			display_name => {
				'currency' => q(گواٹے مالا کا کوئٹزل),
				'one' => q(گواٹے مالا کا کوئٹزل),
				'other' => q(گواٹے مالا کا کوئٹزل),
			},
		},
		'GYD' => {
			symbol => 'GYD',
			display_name => {
				'currency' => q(گویانیز ڈالر),
				'one' => q(گویانیز ڈالر),
				'other' => q(گویانیز ڈالر),
			},
		},
		'HKD' => {
			symbol => 'HK$',
			display_name => {
				'currency' => q(ھانگ کانگ ڈالر),
				'one' => q(ھانگ کانگ ڈالر),
				'other' => q(ھانگ کانگ ڈالر),
			},
		},
		'HNL' => {
			symbol => 'HNL',
			display_name => {
				'currency' => q(ہونڈوران لیمپیرا),
				'one' => q(ہونڈوران لیمپیرا),
				'other' => q(ہونڈوران لیمپیرا),
			},
		},
		'HRK' => {
			symbol => 'HRK',
			display_name => {
				'currency' => q(کروشین کونا),
				'one' => q(کروشین کونا),
				'other' => q(کروشین کونا),
			},
		},
		'HTG' => {
			symbol => 'HTG',
			display_name => {
				'currency' => q(ہیتی کا گؤرڈی),
				'one' => q(ہیتی کا گؤرڈی),
				'other' => q(ہیتی کا گؤرڈی),
			},
		},
		'HUF' => {
			symbol => 'HUF',
			display_name => {
				'currency' => q(ہنگرین فورنٹ),
				'one' => q(ہنگرین فورنٹ),
				'other' => q(ہنگرین فورنٹ),
			},
		},
		'IDR' => {
			symbol => 'IDR',
			display_name => {
				'currency' => q(انڈونیشین روپیہ),
				'one' => q(انڈونیشین روپیہ),
				'other' => q(انڈونیشین روپیہ),
			},
		},
		'ILS' => {
			symbol => '₪',
			display_name => {
				'currency' => q(اسرائیلی نیا شیکل),
				'one' => q(اسرائیلی نیا شیکل),
				'other' => q(اسرائیلی نیا شیکلز),
			},
		},
		'INR' => {
			symbol => '₹',
			display_name => {
				'currency' => q(بھارتی روپیہ),
				'one' => q(بھارتی روپیہ),
				'other' => q(بھارتی روپے),
			},
		},
		'IQD' => {
			symbol => 'IQD',
			display_name => {
				'currency' => q(عراقی دینار),
				'one' => q(عراقی دینار),
				'other' => q(عراقی دینار),
			},
		},
		'IRR' => {
			symbol => 'IRR',
			display_name => {
				'currency' => q(ایرانی ریال),
				'one' => q(ایرانی ریال),
				'other' => q(ایرانی ریال),
			},
		},
		'ISK' => {
			symbol => 'ISK',
			display_name => {
				'currency' => q(آئس لينڈی کرونا),
				'one' => q(آئس لينڈی کرونا),
				'other' => q(آئس لينڈی کرونوں),
			},
		},
		'JMD' => {
			symbol => 'JMD',
			display_name => {
				'currency' => q(جمائیکن ڈالر),
				'one' => q(جمائیکن ڈالر),
				'other' => q(جمائیکن ڈالر),
			},
		},
		'JOD' => {
			symbol => 'JOD',
			display_name => {
				'currency' => q(اردنی دینار),
				'one' => q(اردنی دینار),
				'other' => q(اردنی دینار),
			},
		},
		'JPY' => {
			symbol => 'JP¥',
			display_name => {
				'currency' => q(جاپانی ین),
				'one' => q(جاپانی ین),
				'other' => q(جاپانی ین),
			},
		},
		'KES' => {
			symbol => 'KES',
			display_name => {
				'currency' => q(کینیائی شلنگ),
				'one' => q(کینیائی شلنگ),
				'other' => q(کینیائی شلنگ),
			},
		},
		'KGS' => {
			symbol => 'KGS',
			display_name => {
				'currency' => q(کرغستانی سوم),
				'one' => q(کرغستانی سوم),
				'other' => q(کرغستانی سوم),
			},
		},
		'KHR' => {
			symbol => 'KHR',
			display_name => {
				'currency' => q(کمبوڈیائی ریئل),
				'one' => q(کمبوڈیائی ریئل),
				'other' => q(کمبوڈیائی ریئل),
			},
		},
		'KMF' => {
			symbol => 'KMF',
			display_name => {
				'currency' => q(کوموریئن فرانک),
				'one' => q(کوموریئن فرانک),
				'other' => q(کوموریئن فرانک),
			},
		},
		'KPW' => {
			symbol => 'KPW',
			display_name => {
				'currency' => q(شمالی کوریائی وون),
				'one' => q(شمالی کوریائی وون),
				'other' => q(شمالی کوریائی وون),
			},
		},
		'KRW' => {
			symbol => '₩',
			display_name => {
				'currency' => q(جنوبی کوریائی وون),
				'one' => q(جنوبی کوریائی وون),
				'other' => q(جنوبی کوریائی وون),
			},
		},
		'KWD' => {
			symbol => 'KWD',
			display_name => {
				'currency' => q(کویتی دینار),
				'one' => q(کویتی دینار),
				'other' => q(کویتی دینار),
			},
		},
		'KYD' => {
			symbol => 'KYD',
			display_name => {
				'currency' => q(کیمین آئلینڈز ڈالر),
				'one' => q(کیمین آئلینڈز ڈالر),
				'other' => q(کیمین آئلینڈز ڈالر),
			},
		},
		'KZT' => {
			symbol => 'KZT',
			display_name => {
				'currency' => q(قزاخستانی ٹینگ),
				'one' => q(قزاخستانی ٹینگ),
				'other' => q(قزاخستانی ٹینگ),
			},
		},
		'LAK' => {
			symbol => 'LAK',
			display_name => {
				'currency' => q(لاؤشیائی کِپ),
				'one' => q(لاؤشیائی کِپ),
				'other' => q(لاؤشیائی کِپ),
			},
		},
		'LBP' => {
			symbol => 'LBP',
			display_name => {
				'currency' => q(لبنانی پونڈ),
				'one' => q(لبنانی پونڈ),
				'other' => q(لبنانی پونڈ),
			},
		},
		'LKR' => {
			symbol => 'LKR',
			display_name => {
				'currency' => q(سری لنکائی روپیہ),
				'one' => q(سری لنکائی روپیہ),
				'other' => q(سری لنکائی روپیہ),
			},
		},
		'LRD' => {
			symbol => 'LRD',
			display_name => {
				'currency' => q(لائبریائی ڈالر),
				'one' => q(لائبریائی ڈالر),
				'other' => q(لائبریائی ڈالر),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(لیسوتھو لوٹی),
			},
		},
		'LTL' => {
			symbol => 'LTL',
			display_name => {
				'currency' => q(لیتھوینیائی لیٹاس),
				'one' => q(لیتھوینیائی لیٹاس),
				'other' => q(لیتھوینیائی لیٹاس),
			},
		},
		'LVL' => {
			symbol => 'LVL',
			display_name => {
				'currency' => q(لاتویائی لیٹس),
				'one' => q(لاتویائی لیٹس),
				'other' => q(لاتویائی لیٹس),
			},
		},
		'LYD' => {
			symbol => 'LYD',
			display_name => {
				'currency' => q(لیبیائی دینار),
				'one' => q(لیبیائی دینار),
				'other' => q(لیبیائی دینار),
			},
		},
		'MAD' => {
			symbol => 'MAD',
			display_name => {
				'currency' => q(مراکشی درہم),
				'one' => q(مراکشی درہم),
				'other' => q(مراکشی درہم),
			},
		},
		'MDL' => {
			symbol => 'MDL',
			display_name => {
				'currency' => q(مالدووی لیو),
				'one' => q(مالدووی لیو),
				'other' => q(مالدووی لیو),
			},
		},
		'MGA' => {
			symbol => 'MGA',
			display_name => {
				'currency' => q(ملاگاسی اریاری),
				'one' => q(ملاگاسی اریاری),
				'other' => q(ملاگاسی اریاری),
			},
		},
		'MKD' => {
			symbol => 'MKD',
			display_name => {
				'currency' => q(مقدونیائی دینار),
				'one' => q(مقدونیائی دینار),
				'other' => q(مقدونیائی دینار),
			},
		},
		'MMK' => {
			symbol => 'MMK',
			display_name => {
				'currency' => q(میانمار کیاٹ),
				'one' => q(میانمار کیاٹ),
				'other' => q(میانمار کیاٹ),
			},
		},
		'MNT' => {
			symbol => 'MNT',
			display_name => {
				'currency' => q(منگولیائی ٹگرِ),
				'one' => q(منگولیائی ٹگرِ),
				'other' => q(منگولیائی ٹگرِ),
			},
		},
		'MOP' => {
			symbol => 'MOP',
			display_name => {
				'currency' => q(میکانیز پٹاکا),
				'one' => q(میکانیز پٹاکا),
				'other' => q(میکانیز پٹاکا),
			},
		},
		'MRO' => {
			symbol => 'MRO',
			display_name => {
				'currency' => q(موریطانیائی اوگوئیا \(1973–2017\)),
				'one' => q(موریطانیائی اوگوئیا \(1973–2017\)),
				'other' => q(موریطانیائی اوگوئیا \(1973–2017\)),
			},
		},
		'MRU' => {
			symbol => 'MRU',
			display_name => {
				'currency' => q(موریطانیائی اوگوئیا),
				'one' => q(موریطانیائی اوگوئیا),
				'other' => q(موریطانیائی اوگوئیا),
			},
		},
		'MUR' => {
			symbol => 'MUR',
			display_name => {
				'currency' => q(ماریشس کا روپیہ),
				'one' => q(ماریشس کا روپیہ),
				'other' => q(ماریشس کا روپیہ),
			},
		},
		'MVR' => {
			symbol => 'MVR',
			display_name => {
				'currency' => q(مالدیپ کا روفیہ),
				'one' => q(مالدیپ کا روفیہ),
				'other' => q(مالدیپ کا روفیہ),
			},
		},
		'MWK' => {
			symbol => 'MWK',
			display_name => {
				'currency' => q(ملاوی کواچا),
				'one' => q(ملاوی کواچا),
				'other' => q(ملاوی کواچا),
			},
		},
		'MXN' => {
			symbol => 'MX$',
			display_name => {
				'currency' => q(میکسیکی پیسہ),
				'one' => q(میکسیکی پیسہ),
				'other' => q(میکسیکی پیسہ),
			},
		},
		'MYR' => {
			symbol => 'MYR',
			display_name => {
				'currency' => q(ملیشیائی رنگِٹ),
				'one' => q(ملیشیائی رنگِٹ),
				'other' => q(ملیشیائی رنگِٹ),
			},
		},
		'MZN' => {
			symbol => 'MZN',
			display_name => {
				'currency' => q(موزامبیقی میٹیکل),
				'one' => q(موزامبیقی میٹیکل),
				'other' => q(موزامبیقی میٹیکلز),
			},
		},
		'NAD' => {
			symbol => 'NAD',
			display_name => {
				'currency' => q(نامیبیائی ڈالر),
				'one' => q(نامیبیائی ڈالر),
				'other' => q(نامیبیائی ڈالر),
			},
		},
		'NGN' => {
			symbol => 'NGN',
			display_name => {
				'currency' => q(نائیجیریائی نائرا),
				'one' => q(نائیجیریائی نائرا),
				'other' => q(نائیجیریائی نائرا),
			},
		},
		'NIO' => {
			symbol => 'NIO',
			display_name => {
				'currency' => q(نکارا گوا کا کورڈوبا),
				'one' => q(نکارا گوا کا کورڈوبا),
				'other' => q(نکارا گوا کا کورڈوبا),
			},
		},
		'NOK' => {
			symbol => 'NOK',
			display_name => {
				'currency' => q(ناروے کرون),
				'one' => q(ناروے کرون),
				'other' => q(ناروے کرون),
			},
		},
		'NPR' => {
			symbol => 'NPR',
			display_name => {
				'currency' => q(نیپالی روپیہ),
				'one' => q(نیپالی روپیہ),
				'other' => q(نیپالی روپیہ),
			},
		},
		'NZD' => {
			symbol => 'NZ$',
			display_name => {
				'currency' => q(نیوزی لینڈ ڈالر),
				'one' => q(نیوزی لینڈ ڈالر),
				'other' => q(نیوزی لینڈ ڈالر),
			},
		},
		'OMR' => {
			symbol => 'OMR',
			display_name => {
				'currency' => q(عمانی ریال),
				'one' => q(عمانی ریال),
				'other' => q(عمانی ریال),
			},
		},
		'PAB' => {
			symbol => 'PAB',
			display_name => {
				'currency' => q(پنامہ کا بالبوآ),
				'one' => q(پنامہ کا بالبوآ),
				'other' => q(پنامہ کا بالبوآ),
			},
		},
		'PEN' => {
			symbol => 'PEN',
			display_name => {
				'currency' => q(پیرو نیووسول),
				'one' => q(پیرو نیووسول),
				'other' => q(پیرو نیووسول),
			},
		},
		'PGK' => {
			symbol => 'PGK',
			display_name => {
				'currency' => q(پاپوآ نیو گنی کا کینا),
				'one' => q(پاپوآ نیو گنی کا کینا),
				'other' => q(پاپوآ نیو گنی کا کینا),
			},
		},
		'PHP' => {
			symbol => 'PHP',
			display_name => {
				'currency' => q(فلپائینی پیسہ),
				'one' => q(فلپائینی پیسہ),
				'other' => q(فلپائینی پیسہ),
			},
		},
		'PKR' => {
			symbol => 'Rs',
			display_name => {
				'currency' => q(پاکستانی روپیہ),
				'one' => q(پاکستانی روپیہ),
				'other' => q(پاکستانی روپیہ),
			},
		},
		'PLN' => {
			symbol => 'PLN',
			display_name => {
				'currency' => q(پولش زلوٹی),
				'one' => q(پولش زلوٹی),
				'other' => q(پولش زلوٹی),
			},
		},
		'PYG' => {
			symbol => 'PYG',
			display_name => {
				'currency' => q(پیراگوئے کا گوآرنی),
				'one' => q(پیراگوئے کا گوآرنی),
				'other' => q(پیراگوئے کا گوآرنی),
			},
		},
		'QAR' => {
			symbol => 'QAR',
			display_name => {
				'currency' => q(قطری ریال),
				'one' => q(قطری ریال),
				'other' => q(قطری ریال),
			},
		},
		'RON' => {
			symbol => 'RON',
			display_name => {
				'currency' => q(رومانیائی لیو),
				'one' => q(رومانیائی لیو),
				'other' => q(رومانیائی لی),
			},
		},
		'RSD' => {
			symbol => 'RSD',
			display_name => {
				'currency' => q(سربین دینار),
				'one' => q(سربین دینار),
				'other' => q(سربین دینار),
			},
		},
		'RUB' => {
			symbol => 'RUB',
			display_name => {
				'currency' => q(روسی روبل),
				'one' => q(روسی روبل),
				'other' => q(روسی روبل),
			},
		},
		'RWF' => {
			symbol => 'RWF',
			display_name => {
				'currency' => q(روانڈا کا فرانک),
				'one' => q(روانڈا کا فرانک),
				'other' => q(روانڈا کا فرانک),
			},
		},
		'SAR' => {
			symbol => 'SAR',
			display_name => {
				'currency' => q(سعودی ریال),
				'one' => q(سعودی ریال),
				'other' => q(سعودی ریال),
			},
		},
		'SBD' => {
			symbol => 'SBD',
			display_name => {
				'currency' => q(سولومن آئلینڈز ڈالر),
				'one' => q(سولومن آئلینڈز ڈالر),
				'other' => q(سولومن آئلینڈز ڈالر),
			},
		},
		'SCR' => {
			symbol => 'SCR',
			display_name => {
				'currency' => q(سشلی کا روپیہ),
				'one' => q(سشلی کا روپیہ),
				'other' => q(سشلی کا روپیہ),
			},
		},
		'SDG' => {
			symbol => 'SDG',
			display_name => {
				'currency' => q(سوڈانی پاؤنڈ),
				'one' => q(سوڈانی پاؤنڈ),
				'other' => q(سوڈانی پاؤنڈ),
			},
		},
		'SEK' => {
			symbol => 'SEK',
			display_name => {
				'currency' => q(سویڈن کرونا),
				'one' => q(سویڈن کرونا),
				'other' => q(سویڈن کرونر),
			},
		},
		'SGD' => {
			symbol => 'SGD',
			display_name => {
				'currency' => q(سنگا پور ڈالر),
				'one' => q(سنگا پور ڈالر),
				'other' => q(سنگا پور ڈالر),
			},
		},
		'SHP' => {
			symbol => 'SHP',
			display_name => {
				'currency' => q(سینٹ ہیلینا پاؤنڈ),
				'one' => q(سینٹ ہیلینا پاؤنڈ),
				'other' => q(سینٹ ہیلینا پاؤنڈ),
			},
		},
		'SIT' => {
			display_name => {
				'currency' => q(سلوانین ٹولر),
			},
		},
		'SKK' => {
			display_name => {
				'currency' => q(سلووک کرونا),
			},
		},
		'SLL' => {
			symbol => 'SLL',
			display_name => {
				'currency' => q(سیئرا لیون لیون),
				'one' => q(سیئرا لیون لیون),
				'other' => q(سیئرا لیون لیون),
			},
		},
		'SOS' => {
			symbol => 'SOS',
			display_name => {
				'currency' => q(صومالی شلنگ),
				'one' => q(صومالی شلنگ),
				'other' => q(صومالی شلنگ),
			},
		},
		'SRD' => {
			symbol => 'SRD',
			display_name => {
				'currency' => q(سورینامی ڈالر),
				'one' => q(سورینامی ڈالر),
				'other' => q(سورینامی ڈالر),
			},
		},
		'SSP' => {
			symbol => 'SSP',
			display_name => {
				'currency' => q(جنوبی سوڈانی پاؤنڈ),
				'one' => q(جنوبی سوڈانی پاؤنڈ),
				'other' => q(جنوبی سوڈانی پاؤنڈز),
			},
		},
		'STD' => {
			symbol => 'STD',
			display_name => {
				'currency' => q(ساؤ ٹوم اور پرنسپے ڈوبرا \(1977–2017\)),
				'one' => q(ساؤ ٹوم اور پرنسپے ڈوبرا \(1977–2017\)),
				'other' => q(ساؤ ٹوم اور پرنسپے ڈوبرا \(1977–2017\)),
			},
		},
		'STN' => {
			symbol => 'STN',
			display_name => {
				'currency' => q(ساؤ ٹوم اور پرنسپے ڈوبرا),
				'one' => q(ساؤ ٹوم اور پرنسپے ڈوبرا),
				'other' => q(ساؤ ٹوم اور پرنسپے ڈوبرا),
			},
		},
		'SYP' => {
			symbol => 'SYP',
			display_name => {
				'currency' => q(شامی پونڈ),
				'one' => q(شامی پونڈ),
				'other' => q(شامی پونڈ),
			},
		},
		'SZL' => {
			symbol => 'SZL',
			display_name => {
				'currency' => q(سوازی لیلانجینی),
				'one' => q(سوازی لیلانجینی),
				'other' => q(سوازی لیلانجینی),
			},
		},
		'THB' => {
			symbol => '฿',
			display_name => {
				'currency' => q(تھائی باہت),
				'one' => q(تھائی باہت),
				'other' => q(تھائی باہت),
			},
		},
		'TJS' => {
			symbol => 'TJS',
			display_name => {
				'currency' => q(تاجکستانی سومونی),
				'one' => q(تاجکستانی سومونی),
				'other' => q(تاجکستانی سومونی),
			},
		},
		'TMT' => {
			symbol => 'TMT',
			display_name => {
				'currency' => q(ترکمانستانی منات),
				'one' => q(ترکمانستانی منات),
				'other' => q(ترکمانستانی منات),
			},
		},
		'TND' => {
			symbol => 'TND',
			display_name => {
				'currency' => q(تیونیسیائی دینار),
				'one' => q(تیونیسیائی دینار),
				'other' => q(تیونیسیائی دینار),
			},
		},
		'TOP' => {
			symbol => 'TOP',
			display_name => {
				'currency' => q(ٹونگن پانگا),
				'one' => q(ٹونگن پانگا),
				'other' => q(ٹونگن پانگا),
			},
		},
		'TRY' => {
			symbol => 'TRY',
			display_name => {
				'currency' => q(ترکی لیرا),
				'one' => q(ترکی لیرا),
				'other' => q(ترکی لیرا),
			},
		},
		'TTD' => {
			symbol => 'TTD',
			display_name => {
				'currency' => q(ترینیداد اور ٹوباگو کا ڈالر),
				'one' => q(ترینیداد اور ٹوباگو کا ڈالر),
				'other' => q(ترینیداد اور ٹوباگو کا ڈالر),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(نیو تائیوان ڈالر),
				'one' => q(نیو تائیوان ڈالر),
				'other' => q(نیو تائیوان ڈالر),
			},
		},
		'TZS' => {
			symbol => 'TZS',
			display_name => {
				'currency' => q(تنزانیائی شلنگ),
				'one' => q(تنزانیائی شلنگ),
				'other' => q(تنزانیائی شلنگ),
			},
		},
		'UAH' => {
			symbol => 'UAH',
			display_name => {
				'currency' => q(یوکرینیائی ہریونیا),
				'one' => q(یوکرینیائی ہریونیا),
				'other' => q(یوکرینیائی ہریونیا),
			},
		},
		'UGX' => {
			symbol => 'UGX',
			display_name => {
				'currency' => q(یوگانڈا شلنگ),
				'one' => q(یوگانڈا شلنگ),
				'other' => q(یوگانڈا شلنگ),
			},
		},
		'USD' => {
			symbol => '$',
			display_name => {
				'currency' => q(امریکی ڈالر),
				'one' => q(امریکی ڈالر),
				'other' => q(امریکی ڈالر),
			},
		},
		'UYU' => {
			symbol => 'UYU',
			display_name => {
				'currency' => q(یوروگویان پیسو),
				'one' => q(یوروگویان پیسو),
				'other' => q(یوروگویان پیسو),
			},
		},
		'UZS' => {
			symbol => 'UZS',
			display_name => {
				'currency' => q(ازبکستان سوم),
				'one' => q(ازبکستان سوم),
				'other' => q(ازبکستان سوم),
			},
		},
		'VEB' => {
			display_name => {
				'currency' => q(وینزویلا بولیور \(1871–2008\)),
			},
		},
		'VEF' => {
			symbol => 'VEF',
			display_name => {
				'currency' => q(وینزویلا بولیور \(2008–2018\)),
				'one' => q(وینزویلا بولیور \(2008–2018\)),
				'other' => q(وینزویلا بولیور \(2008–2018\)),
			},
		},
		'VES' => {
			symbol => 'VES',
			display_name => {
				'currency' => q(وینزویلا بولیور),
				'one' => q(وینزویلا بولیور),
				'other' => q(وینزویلا بولیور),
			},
		},
		'VND' => {
			symbol => '₫',
			display_name => {
				'currency' => q(ویتنامی ڈانگ),
				'one' => q(ویتنامی ڈانگ),
				'other' => q(ویتنامی ڈانگ),
			},
		},
		'VUV' => {
			symbol => 'VUV',
			display_name => {
				'currency' => q(وینوواتو واتو),
				'one' => q(وینوواتو واتو),
				'other' => q(وینوواتو واتو),
			},
		},
		'WST' => {
			symbol => 'WST',
			display_name => {
				'currency' => q(ساموآ کا ٹالا),
				'one' => q(ساموآ کا ٹالا),
				'other' => q(ساموآ کا ٹالا),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(وسطی افریقی [CFA] فرانک),
				'one' => q(وسطی افریقی [CFA] فرانک),
				'other' => q(وسطی افریقی [CFA] فرانک),
			},
		},
		'XCD' => {
			symbol => 'EC$',
			display_name => {
				'currency' => q(مشرقی کریبیا کا ڈالر),
				'one' => q(مشرقی کریبیا کا ڈالر),
				'other' => q(مشرقی کریبیا کا ڈالر),
			},
		},
		'XOF' => {
			symbol => 'CFA',
			display_name => {
				'currency' => q(مغربی افریقی [CFA] فرانک),
				'one' => q(مغربی افریقی [CFA] فرانک),
				'other' => q(مغربی افریقی [CFA] فرانک),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(CFP فرانک),
				'one' => q(CFP فرانک),
				'other' => q(CFP فرانکس),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(نامعلوم کرنسی),
				'one' => q(\(کرنسی کی نامعلوم یونٹ\)),
				'other' => q(نامعلوم کرنسی),
			},
		},
		'YER' => {
			symbol => 'YER',
			display_name => {
				'currency' => q(یمنی ریال),
				'one' => q(یمنی ریال),
				'other' => q(یمنی ریال),
			},
		},
		'ZAR' => {
			symbol => 'ZAR',
			display_name => {
				'currency' => q(جنوبی افریقی رانڈ),
				'one' => q(جنوبی افریقی رانڈ),
				'other' => q(جنوبی افریقی رانڈ),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(زامبیائی کواچا \(1968–2012\)),
			},
		},
		'ZMW' => {
			symbol => 'ZMW',
			display_name => {
				'currency' => q(زامبیائی کواچا),
				'one' => q(زامبیائی کواچا),
				'other' => q(زامبیائی کواچا),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'coptic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ٹاؤٹ',
							'بابا',
							'ہیٹر',
							'کیاہک',
							'توبا',
							'امشیر',
							'برمہات',
							'برموڈا',
							'بشانس',
							'پاؤنا',
							'ایپپ',
							'میسرا',
							'ناسی'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ٹاؤٹ',
							'بابا',
							'ہیٹر',
							'کیاہک',
							'توبا',
							'امشیر',
							'برمہات',
							'برموڈا',
							'بشانس',
							'پاؤنا',
							'ایپپ',
							'میسرا',
							'ناسی'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ٹاؤٹ',
							'بابا',
							'ہیٹر',
							'کیاہک',
							'توبا',
							'امشیر',
							'برمہات',
							'برموڈا',
							'بشانس',
							'پاؤنا',
							'ایپپ',
							'میسرا',
							'ناسی'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ٹاؤٹ',
							'بابا',
							'ہیٹر',
							'کیاہک',
							'توبا',
							'امشیر',
							'برمہات',
							'برموڈا',
							'بشانس',
							'پاؤنا',
							'ایپپ',
							'میسرا',
							'ناسی'
						],
						leap => [
							
						],
					},
				},
			},
			'ethiopic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'مسکرم',
							'تیکیمت',
							'ہیدر',
							'تہساس',
							'تیر',
							'یکاتیت',
							'میگابت',
							'میازیا',
							'گیمبوٹ',
							'سینے',
							'ہیملے',
							'نیہاسے',
							'پیگیومین'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'مسکرم',
							'تیکیمت',
							'ہیدر',
							'تہساس',
							'تیر',
							'یکاتیت',
							'میگابت',
							'میازیا',
							'گیمبوٹ',
							'سینے',
							'ہیملے',
							'نیہاسے',
							'پیگیومین'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'مسکرم',
							'تیکیمت',
							'ہیدر',
							'تہساس',
							'تیر',
							'یکاتیت',
							'میگابت',
							'میازیا',
							'گیمبوٹ',
							'سینے',
							'ہیملے',
							'نیہاسے',
							'پیگیومین'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'مسکرم',
							'تیکیمت',
							'ہیدر',
							'تہساس',
							'تیر',
							'یکاتیت',
							'میگابت',
							'میازیا',
							'گیمبوٹ',
							'سینے',
							'ہیملے',
							'نیہاسے',
							'پیگیومین'
						],
						leap => [
							
						],
					},
				},
			},
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'جنوری',
							'فروری',
							'مارچ',
							'اپریل',
							'مئی',
							'جون',
							'جولائی',
							'اگست',
							'ستمبر',
							'اکتوبر',
							'نومبر',
							'دسمبر'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'J',
							'F',
							'M',
							'A',
							'M',
							'J',
							'J',
							'A',
							'S',
							'O',
							'N',
							'D'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'جنوری',
							'فروری',
							'مارچ',
							'اپریل',
							'مئی',
							'جون',
							'جولائی',
							'اگست',
							'ستمبر',
							'اکتوبر',
							'نومبر',
							'دسمبر'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'جنوری',
							'فروری',
							'مارچ',
							'اپریل',
							'مئی',
							'جون',
							'جولائی',
							'اگست',
							'ستمبر',
							'اکتوبر',
							'نومبر',
							'دسمبر'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'J',
							'F',
							'M',
							'A',
							'M',
							'J',
							'J',
							'A',
							'S',
							'O',
							'N',
							'D'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'جنوری',
							'فروری',
							'مارچ',
							'اپریل',
							'مئی',
							'جون',
							'جولائی',
							'اگست',
							'ستمبر',
							'اکتوبر',
							'نومبر',
							'دسمبر'
						],
						leap => [
							
						],
					},
				},
			},
			'hebrew' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ٹشری',
							'هےشوان',
							'کسلیو',
							'تیویت',
							'شیوت',
							'آدر اوّل',
							'آدر',
							'نسان',
							'ایئر',
							'سیون',
							'تموز',
							'او',
							'ای لول'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'آدر دوّم'
						],
					},
					wide => {
						nonleap => [
							'ٹشری',
							'هےشوان',
							'کسلیو',
							'تیویت',
							'شیوت',
							'آدر اوّل',
							'آدر',
							'نسان',
							'ایئر',
							'سیون',
							'تموز',
							'او',
							'ای لول'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'آدر دوّم'
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ٹشری',
							'هےشوان',
							'کسلیو',
							'تیویت',
							'شیوت',
							'آدر اوّل',
							'آدر',
							'نسان',
							'ایئر',
							'سیون',
							'تموز',
							'او',
							'ای لول'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'آدر دوّم'
						],
					},
					wide => {
						nonleap => [
							'ٹشری',
							'هےشوان',
							'کسلیو',
							'تیویت',
							'شیوت',
							'آدر اوّل',
							'آدر',
							'نسان',
							'ایئر',
							'سیون',
							'تموز',
							'او',
							'ای لول'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'آدر دوّم'
						],
					},
				},
			},
			'indian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'چتررا',
							'ویساکھا',
							'جیہائشہ',
							'اسدھا',
							'سراؤنا',
							'بھدرا',
							'اسوینا',
							'کارتیکا',
							'اگراہانا',
							'پوسا',
							'میگا',
							'پھالگنا'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'چتررا',
							'ویساکھا',
							'جیہائشہ',
							'اسدھا',
							'سراؤنا',
							'بھدرا',
							'اسوینا',
							'کارتیکا',
							'اگراہانا',
							'پوسا',
							'میگا',
							'پھالگنا'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'چتررا',
							'ویساکھا',
							'جیہائشہ',
							'اسدھا',
							'سراؤنا',
							'بھدرا',
							'اسوینا',
							'کارتیکا',
							'اگراہانا',
							'پوسا',
							'میگا',
							'پھالگنا'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'چتررا',
							'ویساکھا',
							'جیہائشہ',
							'اسدھا',
							'سراؤنا',
							'بھدرا',
							'اسوینا',
							'کارتیکا',
							'اگراہانا',
							'پوسا',
							'میگا',
							'پھالگنا'
						],
						leap => [
							
						],
					},
				},
			},
			'islamic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'محرم',
							'صفر',
							'ربیع الاوّل',
							'ربیع الثّانی',
							'جمادی الاوّل',
							'جمادی الثّانی',
							'رجب',
							'شعبان',
							'رمضان',
							'شوال',
							'ذوالقعدۃ',
							'ذوالحجۃ'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'محرم',
							'صفر',
							'ر بیع الاول',
							'ر بیع الثانی',
							'جمادی الاول',
							'جمادی الثانی',
							'رجب',
							'شعبان',
							'رمضان',
							'شوال',
							'ذوالقعدۃ',
							'ذوالحجۃ'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'محرم',
							'صفر',
							'ربیع الاوّل',
							'ربیع الثّانی',
							'جمادی الاوّل',
							'جمادی الثّانی',
							'رجب',
							'شعبان',
							'رمضان',
							'شوال',
							'ذوالقعدۃ',
							'ذوالحجۃ'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'محرم',
							'صفر',
							'ر بیع الاول',
							'ر بیع الثانی',
							'جمادی الاول',
							'جمادی الثانی',
							'رجب',
							'شعبان',
							'رمضان',
							'شوال',
							'ذوالقعدۃ',
							'ذوالحجۃ'
						],
						leap => [
							
						],
					},
				},
			},
			'persian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'فروردن',
							'آرڈبائش',
							'خداداد',
							'تیر',
							'مرداد',
							'شہریوار',
							'مہر',
							'ابان',
							'آزر',
							'ڈے',
							'بہمن',
							'اسفند'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'فروردن',
							'آرڈبائش',
							'خداداد',
							'تیر',
							'مرداد',
							'شہریوار',
							'مہر',
							'ابان',
							'آزر',
							'ڈے',
							'بہمن',
							'اسفند'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'فروردن',
							'آرڈبائش',
							'خداداد',
							'تیر',
							'مرداد',
							'شہریوار',
							'مہر',
							'ابان',
							'آزر',
							'ڈے',
							'بہمن',
							'اسفند'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'فروردن',
							'آرڈبائش',
							'خداداد',
							'تیر',
							'مرداد',
							'شہریوار',
							'مہر',
							'ابان',
							'آزر',
							'ڈے',
							'بہمن',
							'اسفند'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'پیر',
						tue => 'منگل',
						wed => 'بدھ',
						thu => 'جمعرات',
						fri => 'جمعہ',
						sat => 'ہفتہ',
						sun => 'اتوار'
					},
					narrow => {
						mon => 'M',
						tue => 'T',
						wed => 'W',
						thu => 'T',
						fri => 'F',
						sat => 'S',
						sun => 'S'
					},
					short => {
						mon => 'پیر',
						tue => 'منگل',
						wed => 'بدھ',
						thu => 'جمعرات',
						fri => 'جمعہ',
						sat => 'ہفتہ',
						sun => 'اتوار'
					},
					wide => {
						mon => 'پیر',
						tue => 'منگل',
						wed => 'بدھ',
						thu => 'جمعرات',
						fri => 'جمعہ',
						sat => 'ہفتہ',
						sun => 'اتوار'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'پیر',
						tue => 'منگل',
						wed => 'بدھ',
						thu => 'جمعرات',
						fri => 'جمعہ',
						sat => 'ہفتہ',
						sun => 'اتوار'
					},
					narrow => {
						mon => 'M',
						tue => 'T',
						wed => 'W',
						thu => 'T',
						fri => 'F',
						sat => 'S',
						sun => 'S'
					},
					short => {
						mon => 'پیر',
						tue => 'منگل',
						wed => 'بدھ',
						thu => 'جمعرات',
						fri => 'جمعہ',
						sat => 'ہفتہ',
						sun => 'اتوار'
					},
					wide => {
						mon => 'پیر',
						tue => 'منگل',
						wed => 'بدھ',
						thu => 'جمعرات',
						fri => 'جمعہ',
						sat => 'ہفتہ',
						sun => 'اتوار'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'پہلی سہ ماہی',
						1 => 'دوسری سہ ماہی',
						2 => 'تیسری سہ ماہی',
						3 => 'چوتهی سہ ماہی'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => 'پہلی سہ ماہی',
						1 => 'دوسری سہ ماہی',
						2 => 'تیسری سہ ماہی',
						3 => 'چوتهی سہ ماہی'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'پہلی سہ ماہی',
						1 => 'دوسری سہ ماہی',
						2 => 'تیسری سہ ماہی',
						3 => 'چوتهی سہ ماہی'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => 'پہلی سہ ماہی',
						1 => 'دوسری سہ ماہی',
						2 => 'تیسری سہ ماہی',
						3 => 'چوتهی سہ ماہی'
					},
				},
			},
	} },
);

has 'day_period_data' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { sub {
		# Time in hhmm format
		my ($self, $type, $time, $day_period_type) = @_;
		$day_period_type //= 'default';
		SWITCH:
		for ($type) {
			if ($_ eq 'buddhist') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'coptic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'ethiopic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'generic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'gregorian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'hebrew') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'indian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'islamic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'persian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'roc') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
		}
	} },
);

around day_period_data => sub {
	my ($orig, $self) = @_;
	return $self->$orig;
};

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'afternoon1' => q{دوپہر},
					'afternoon2' => q{سہ پہر},
					'am' => q{AM},
					'evening1' => q{شام},
					'midnight' => q{آدھی رات},
					'morning1' => q{صبح},
					'night1' => q{رات},
					'pm' => q{PM},
				},
				'narrow' => {
					'afternoon1' => q{دوپہر},
					'afternoon2' => q{سہ پہر},
					'am' => q{a},
					'evening1' => q{شام},
					'midnight' => q{آدھی رات},
					'morning1' => q{صبح},
					'night1' => q{رات},
					'pm' => q{p},
				},
				'wide' => {
					'afternoon1' => q{دوپہر میں},
					'afternoon2' => q{سہ پہر},
					'am' => q{AM},
					'evening1' => q{شام میں},
					'midnight' => q{آدھی رات},
					'morning1' => q{صبح میں},
					'night1' => q{رات میں},
					'pm' => q{PM},
				},
			},
			'stand-alone' => {
				'abbreviated' => {
					'afternoon1' => q{دوپہر},
					'afternoon2' => q{سہ پہر},
					'am' => q{AM},
					'evening1' => q{شام},
					'midnight' => q{آدھی رات},
					'morning1' => q{صبح},
					'night1' => q{رات},
					'pm' => q{PM},
				},
				'narrow' => {
					'afternoon1' => q{دوپہر},
					'afternoon2' => q{سہ پہر},
					'am' => q{AM},
					'evening1' => q{شام},
					'midnight' => q{آدھی رات},
					'morning1' => q{صبح},
					'night1' => q{رات},
					'pm' => q{PM},
				},
				'wide' => {
					'afternoon1' => q{دوپہر},
					'afternoon2' => q{سہ پہر},
					'am' => q{AM},
					'evening1' => q{شام},
					'midnight' => q{آدھی رات},
					'morning1' => q{صبح},
					'night1' => q{رات},
					'pm' => q{PM},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
			abbreviated => {
				'0' => 'BE'
			},
			narrow => {
				'0' => 'BE'
			},
			wide => {
				'0' => 'BE'
			},
		},
		'coptic' => {
			abbreviated => {
				'0' => 'دور0',
				'1' => 'دور1'
			},
			narrow => {
				'0' => 'دور0',
				'1' => 'دور1'
			},
			wide => {
				'0' => 'دور0',
				'1' => 'دور1'
			},
		},
		'ethiopic' => {
			abbreviated => {
				'0' => 'دور0',
				'1' => 'دور1'
			},
			narrow => {
				'0' => 'دور0',
				'1' => 'دور1'
			},
			wide => {
				'0' => 'دور0',
				'1' => 'دور1'
			},
		},
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'قبل مسیح',
				'1' => 'عیسوی'
			},
			wide => {
				'0' => 'قبل مسیح',
				'1' => 'عیسوی'
			},
		},
		'hebrew' => {
			abbreviated => {
				'0' => 'AM'
			},
			narrow => {
				'0' => 'AM'
			},
			wide => {
				'0' => 'AM'
			},
		},
		'indian' => {
			abbreviated => {
				'0' => 'ساکا'
			},
			narrow => {
				'0' => 'ساکا'
			},
			wide => {
				'0' => 'ساکا'
			},
		},
		'islamic' => {
			abbreviated => {
				'0' => 'ہجری'
			},
			narrow => {
				'0' => 'ہجری'
			},
			wide => {
				'0' => 'ہجری'
			},
		},
		'persian' => {
			abbreviated => {
				'0' => 'AP'
			},
			narrow => {
				'0' => 'AP'
			},
			wide => {
				'0' => 'AP'
			},
		},
		'roc' => {
			abbreviated => {
				'0' => 'قبل از جمہوریہ چین',
				'1' => 'جمہوریہ چین'
			},
			narrow => {
				'0' => 'قبل از جمہوریہ چین',
				'1' => 'جمہوریہ چین'
			},
			wide => {
				'0' => 'قبل از جمہوریہ چین',
				'1' => 'جمہوریہ چین'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{EEEE، d MMMM، y G},
			'long' => q{d MMMM، y G},
			'medium' => q{d MMM، y G},
			'short' => q{d/M/y GGGGG},
		},
		'gregorian' => {
			'full' => q{EEEE، d MMMM، y},
			'long' => q{d MMMM، y},
			'medium' => q{d MMM، y},
			'short' => q{d/M/yy},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
		},
		'gregorian' => {
			'full' => q{h:mm:ss a zzzz},
			'long' => q{h:mm:ss a z},
			'medium' => q{h:mm:ss a},
			'short' => q{h:mm a},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Bh => q{h B},
			Bhm => q{h:mm B},
			Bhms => q{h:mm:ss B},
			E => q{ccc},
			EBhm => q{E h:mm B},
			EBhms => q{E h:mm:ss B},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{d E},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E، d MMM، y G},
			GyMMMd => q{d MMM، y G},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E، d/M},
			MMM => q{LLL},
			MMMEd => q{E، d MMM},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			Md => q{d/M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{y G},
			yyyy => q{y G},
			yyyyM => q{M/y G},
			yyyyMEd => q{E، d/M/y G},
			yyyyMMM => q{MMM y G},
			yyyyMMMEd => q{E، d MMM، y G},
			yyyyMMMM => q{MMMM y G},
			yyyyMMMd => q{d MMM، y G},
			yyyyMd => q{d/M/y G},
			yyyyQQQ => q{QQQ y G},
			yyyyQQQQ => q{QQQQ y G},
		},
		'gregorian' => {
			Bh => q{h B},
			Bhm => q{h:mm B},
			Bhms => q{h:mm:ss B},
			E => q{ccc},
			EBhm => q{E h:mm B},
			EBhms => q{E h:mm:ss B},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{d E},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E، d MMM، y G},
			GyMMMd => q{d MMM، y G},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			Hmsv => q{HH:mm:ss v},
			Hmv => q{HH:mm v},
			M => q{L},
			MEd => q{E، d/M},
			MMM => q{LLL},
			MMMEd => q{E، d MMM},
			MMMMW => q{MMMM کا ہفتہ W},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			Md => q{d/M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			hmsv => q{h:mm:ss a v},
			hmv => q{h:mm a v},
			ms => q{mm:ss},
			y => q{y},
			yM => q{M/y},
			yMEd => q{E، d/M/y},
			yMMM => q{MMM y},
			yMMMEd => q{E، d MMM، y},
			yMMMM => q{MMMM y},
			yMMMd => q{d MMM، y},
			yMd => q{d/M/y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ y},
			yw => q{Y کا w ہفتہ},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E، d/M – E، d/M},
				d => q{E، d/M – E، d/M},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{E، d MMM – E، d MMM},
				d => q{E، d MMM – E، d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y G},
			},
			yM => {
				M => q{M/y – M/y G},
				y => q{M/y – M/y G},
			},
			yMEd => {
				M => q{E، d/M/y – E، d/M/y G},
				d => q{E، d/M/y – E، d/M/y G},
				y => q{E، d/M/y – E، d/M/y G},
			},
			yMMM => {
				M => q{MMM–MMM y G},
				y => q{MMM y – MMM y G},
			},
			yMMMEd => {
				M => q{E، d MMM – E، d MMM، y G},
				d => q{E، d MMM – E، d MMM، y G},
				y => q{E، d MMM، y – E، d MMM، y G},
			},
			yMMMM => {
				M => q{MMMM–MMMM y G},
				y => q{MMMM y – MMMM y G},
			},
			yMMMd => {
				M => q{d MMM – d MMM، y G},
				d => q{d–d MMM، y G},
				y => q{d MMM، y – d MMM، y G},
			},
			yMd => {
				M => q{d/M/y – d/M/y G},
				d => q{d/M/y – d/M/y G},
				y => q{d/M/y – d/M/y G},
			},
		},
		'gregorian' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E، d/M – E، d/M},
				d => q{E، d/M – E، d/M},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{E، d MMM – E، d MMM},
				d => q{E، d MMM – E، d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y},
			},
			yM => {
				M => q{M/y – M/y},
				y => q{M/y – M/y},
			},
			yMEd => {
				M => q{E، d/M/y – E، d/M/y},
				d => q{E، d/M/y – E، d/M/y},
				y => q{E، d/M/y – E، d/M/y},
			},
			yMMM => {
				M => q{MMM–MMM y},
				y => q{MMM y – MMM y},
			},
			yMMMEd => {
				M => q{E، d MMM – E، d MMM، y},
				d => q{E، d MMM – E، d MMM، y},
				y => q{E، d MMM، y – E، d MMM، y},
			},
			yMMMM => {
				M => q{MMMM–MMMM y},
				y => q{MMMM y – MMMM y},
			},
			yMMMd => {
				M => q{d MMM – d MMM، y},
				d => q{d–d MMM y},
				y => q{d MMM، y – d MMM، y},
			},
			yMd => {
				M => q{d/M/y – d/M/y},
				d => q{d/M/y – d/M/y},
				y => q{d/M/y – d/M/y},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT {0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q({0} وقت),
		regionFormat => q({0} ڈے لائٹ ٹائم),
		regionFormat => q({0} اسٹینڈرڈ ٹائم),
		fallbackFormat => q({1} ({0})),
		'Afghanistan' => {
			long => {
				'standard' => q#افغانستان کا وقت#,
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#عابدجان#,
		},
		'Africa/Accra' => {
			exemplarCity => q#اکّرا#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#عدیس ابابا#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#الجیئرس#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#اسمارا#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#بماکو#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#بنگوئی#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#بنجول#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#بِساؤ#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#بلینٹائر#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#برازاویلے#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#بجمبرا#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#قاہرہ#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#کیسا بلانکا#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#سیوٹا#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#کونکری#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#ڈکار#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#دار السلام#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#جبوتی#,
		},
		'Africa/Douala' => {
			exemplarCity => q#ڈوآلا#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#العیون#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#فری ٹاؤن#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#گبرون#,
		},
		'Africa/Harare' => {
			exemplarCity => q#ہرارے#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#جوہانسبرگ#,
		},
		'Africa/Juba' => {
			exemplarCity => q#جوبا#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#کیمپالا#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#خرطوم#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#کگالی#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#کنشاسا#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#لاگوس#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#لبرے ویلے#,
		},
		'Africa/Lome' => {
			exemplarCity => q#لوم#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#لوانڈا#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#لوبمباشی#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#لیوساکا#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#ملابو#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#مپوٹو#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#مسیرو#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#مبابین#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#موگادیشو#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#مونروویا#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#نیروبی#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#اینجامینا#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#نیامی#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#نواکشوط#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#اؤگاڈؤگوو#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#پورٹو نووو#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#ساؤ ٹوم#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#ٹریپولی#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#تیونس#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#ونڈہوک#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#وسطی افریقہ ٹائم#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#مشرقی افریقہ ٹائم#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#جنوبی افریقہ سٹینڈرڈ ٹائم#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#مغربی افریقہ سمر ٹائم#,
				'generic' => q#مغربی افریقہ ٹائم#,
				'standard' => q#مغربی افریقہ سٹینڈرڈ ٹائم#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#الاسکا ڈے لائٹ ٹائم#,
				'generic' => q#الاسکا ٹائم#,
				'standard' => q#الاسکا اسٹینڈرڈ ٹائم#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#امیزون کا موسم گرما کا وقت#,
				'generic' => q#امیزون ٹائم#,
				'standard' => q#ایمیزون سٹینڈرڈ ٹائم#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#اداک#,
		},
		'America/Anchorage' => {
			exemplarCity => q#اینکریج#,
		},
		'America/Anguilla' => {
			exemplarCity => q#انگویلا#,
		},
		'America/Antigua' => {
			exemplarCity => q#انٹیگوا#,
		},
		'America/Araguaina' => {
			exemplarCity => q#اراگویانا#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#لا ریئوجا#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#ریو گالیگوس#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#سالٹا#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#سان جوآن#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#سان لوئس#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#ٹوکومین#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#اوشوآئیا#,
		},
		'America/Aruba' => {
			exemplarCity => q#اروبا#,
		},
		'America/Asuncion' => {
			exemplarCity => q#اسنسیئن#,
		},
		'America/Bahia' => {
			exemplarCity => q#باہیا#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#بہیا بندراز#,
		},
		'America/Barbados' => {
			exemplarCity => q#بارباڈوس#,
		},
		'America/Belem' => {
			exemplarCity => q#بیلیم#,
		},
		'America/Belize' => {
			exemplarCity => q#بیلائز#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#بلانک سبلون#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#بوآ وسٹا#,
		},
		'America/Bogota' => {
			exemplarCity => q#بگوٹا#,
		},
		'America/Boise' => {
			exemplarCity => q#بوائس#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#بیونس آئرس#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#کیمبرج کی کھاڑی#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#کیمپو گرینڈ#,
		},
		'America/Cancun' => {
			exemplarCity => q#کنکیون#,
		},
		'America/Caracas' => {
			exemplarCity => q#کراکاس#,
		},
		'America/Catamarca' => {
			exemplarCity => q#کیٹامارکا#,
		},
		'America/Cayenne' => {
			exemplarCity => q#کائین#,
		},
		'America/Cayman' => {
			exemplarCity => q#کیمین#,
		},
		'America/Chicago' => {
			exemplarCity => q#شکاگو#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#چیہوآہوآ#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#اٹیکوکن#,
		},
		'America/Cordoba' => {
			exemplarCity => q#کورڈوبا#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#کوسٹا ریکا#,
		},
		'America/Creston' => {
			exemplarCity => q#کریسٹون#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#کوئیابا#,
		},
		'America/Curacao' => {
			exemplarCity => q#کیوراکاؤ#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#ڈنمارک شاون#,
		},
		'America/Dawson' => {
			exemplarCity => q#ڈاؤسن#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#ڈاؤسن کریک#,
		},
		'America/Denver' => {
			exemplarCity => q#ڈینور#,
		},
		'America/Detroit' => {
			exemplarCity => q#ڈیٹرائٹ#,
		},
		'America/Dominica' => {
			exemplarCity => q#ڈومنیکا#,
		},
		'America/Edmonton' => {
			exemplarCity => q#ایڈمونٹن#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#ایرونیپ#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#ال سلواڈور#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#فورٹ نیلسن#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#فورٹالیزا#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#گلیس کی کھاڑی#,
		},
		'America/Godthab' => {
			exemplarCity => q#نوک#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#گوس کی کھاڑی#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#عظیم ترک#,
		},
		'America/Grenada' => {
			exemplarCity => q#غرناطہ#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#گواڈیلوپ#,
		},
		'America/Guatemala' => {
			exemplarCity => q#گواٹے مالا#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#گوآیاکوئل#,
		},
		'America/Guyana' => {
			exemplarCity => q#گیانا#,
		},
		'America/Halifax' => {
			exemplarCity => q#ہیلیفیکس#,
		},
		'America/Havana' => {
			exemplarCity => q#ہوانا#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#ہرموسیلو#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#کنوکس، انڈیانا#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#مرینگو، انڈیانا#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#پیٹرزبرگ، انڈیانا#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#ٹیل سٹی، انڈیانا#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#ویوے، انڈیانا#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#ونسینیز، انڈیانا#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#وینامیک، انڈیانا#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#انڈیاناپولس#,
		},
		'America/Inuvik' => {
			exemplarCity => q#انووِک#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#ایکالوئٹ#,
		},
		'America/Jamaica' => {
			exemplarCity => q#جمائیکا#,
		},
		'America/Jujuy' => {
			exemplarCity => q#جوجوئی#,
		},
		'America/Juneau' => {
			exemplarCity => q#جونیئو#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#مونٹیسیلو، کینٹوکی#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#کرالینڈیجک#,
		},
		'America/La_Paz' => {
			exemplarCity => q#لا پاز#,
		},
		'America/Lima' => {
			exemplarCity => q#لیما#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#لاس اینجلس#,
		},
		'America/Louisville' => {
			exemplarCity => q#لوئس ویلے#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#لوور پرنسس کوارٹر#,
		},
		'America/Maceio' => {
			exemplarCity => q#میسیئو#,
		},
		'America/Managua' => {
			exemplarCity => q#مناگوآ#,
		},
		'America/Manaus' => {
			exemplarCity => q#مناؤس#,
		},
		'America/Marigot' => {
			exemplarCity => q#میریگوٹ#,
		},
		'America/Martinique' => {
			exemplarCity => q#مارٹینک#,
		},
		'America/Matamoros' => {
			exemplarCity => q#میٹاموروس#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#میزٹلان#,
		},
		'America/Mendoza' => {
			exemplarCity => q#مینڈوزا#,
		},
		'America/Menominee' => {
			exemplarCity => q#مینومینی#,
		},
		'America/Merida' => {
			exemplarCity => q#میریڈا#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#میٹلا کاٹلا#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#میکسیکو سٹی#,
		},
		'America/Miquelon' => {
			exemplarCity => q#میکلیئون#,
		},
		'America/Moncton' => {
			exemplarCity => q#مونکٹن#,
		},
		'America/Monterrey' => {
			exemplarCity => q#مونٹیری#,
		},
		'America/Montevideo' => {
			exemplarCity => q#مونٹی ویڈیو#,
		},
		'America/Montserrat' => {
			exemplarCity => q#مونٹسیراٹ#,
		},
		'America/Nassau' => {
			exemplarCity => q#نساؤ#,
		},
		'America/New_York' => {
			exemplarCity => q#نیو یارک#,
		},
		'America/Nipigon' => {
			exemplarCity => q#نپیگون#,
		},
		'America/Nome' => {
			exemplarCity => q#نوم#,
		},
		'America/Noronha' => {
			exemplarCity => q#نورونہا#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#بیولاہ، شمالی ڈکوٹا#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#وسط، شمالی ڈکوٹا#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#نیو سلیم، شمالی ڈکوٹا#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#اوجیناگا#,
		},
		'America/Panama' => {
			exemplarCity => q#پنامہ#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#پینگنِرٹنگ#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#پراماریبو#,
		},
		'America/Phoenix' => {
			exemplarCity => q#فینکس#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#پورٹ او پرنس#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#پورٹ آف اسپین#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#پورٹو ویلہو#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#پیورٹو ریکو#,
		},
		'America/Punta_Arenas' => {
			exemplarCity => q#پنٹا یریناس#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#رینی ریور#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#رینکن انلیٹ#,
		},
		'America/Recife' => {
			exemplarCity => q#ریسائف#,
		},
		'America/Regina' => {
			exemplarCity => q#ریجینا#,
		},
		'America/Resolute' => {
			exemplarCity => q#ریزولیوٹ#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#ریئو برینکو#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#سانتا ایزابیل#,
		},
		'America/Santarem' => {
			exemplarCity => q#سنٹارین#,
		},
		'America/Santiago' => {
			exemplarCity => q#سنٹیاگو#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#سانتو ڈومنگو#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#ساؤ پالو#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#اسکورز بائی سنڈ#,
		},
		'America/Sitka' => {
			exemplarCity => q#سیٹکا#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#سینٹ برتھیلمی#,
		},
		'America/St_Johns' => {
			exemplarCity => q#سینٹ جانز#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#سینٹ کٹس#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#سینٹ لوسیا#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#سینٹ تھامس#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#سینٹ ونسنٹ#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#سوِفٹ کرنٹ#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#ٹیگوسیگالپے#,
		},
		'America/Thule' => {
			exemplarCity => q#تھولو#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#تھنڈر بے#,
		},
		'America/Tijuana' => {
			exemplarCity => q#تیجوآنا#,
		},
		'America/Toronto' => {
			exemplarCity => q#ٹورنٹو#,
		},
		'America/Tortola' => {
			exemplarCity => q#ٹورٹولا#,
		},
		'America/Vancouver' => {
			exemplarCity => q#وینکوور#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#وہائٹ ہارس#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#ونّیپیگ#,
		},
		'America/Yakutat' => {
			exemplarCity => q#یکوٹیٹ#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#ایلو نائف#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#سنٹرل ڈے لائٹ ٹائم#,
				'generic' => q#سنٹرل ٹائم#,
				'standard' => q#سنٹرل اسٹینڈرڈ ٹائم#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#ایسٹرن ڈے لائٹ ٹائم#,
				'generic' => q#ایسٹرن ٹائم#,
				'standard' => q#ایسٹرن اسٹینڈرڈ ٹائم#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#ماؤنٹین ڈے لائٹ ٹائم#,
				'generic' => q#ماؤنٹین ٹائم#,
				'standard' => q#ماؤنٹین اسٹینڈرڈ ٹائم#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#پیسفک ڈے لائٹ ٹائم#,
				'generic' => q#پیسفک ٹائم#,
				'standard' => q#پیسفک اسٹینڈرڈ ٹائم#,
			},
		},
		'Anadyr' => {
			long => {
				'daylight' => q#انیدر سمر ٹائم#,
				'generic' => q#انیدر ٹائم#,
				'standard' => q#انیدر اسٹینڈرڈ ٹائم#,
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#کیسی#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#ڈیوس#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#ڈومونٹ ڈی ارویلے#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#میکواری#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#ماؤسن#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#میک مرڈو#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#پلمیر#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#روتھیرا#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#سیووا#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#ٹرول#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#ووستوک#,
		},
		'Apia' => {
			long => {
				'daylight' => q#ایپیا ڈے لائٹ ٹائم#,
				'generic' => q#ایپیا ٹائم#,
				'standard' => q#ایپیا سٹینڈرڈ ٹائم#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#عرب ڈے لائٹ ٹائم#,
				'generic' => q#عرب کا وقت#,
				'standard' => q#عرب کا معیاری وقت#,
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#لانگ ایئر بین#,
		},
		'Argentina' => {
			long => {
				'daylight' => q#ارجنٹینا سمر ٹائم#,
				'generic' => q#ارجنٹینا ٹائم#,
				'standard' => q#ارجنٹینا سٹینڈرڈ ٹائم#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#مغربی ارجنٹینا کا موسم گرما کا وقت#,
				'generic' => q#مغربی ارجنٹینا کا وقت#,
				'standard' => q#مغربی ارجنٹینا کا معیاری وقت#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#آرمینیا کا موسم گرما کا وقت#,
				'generic' => q#آرمینیا کا وقت#,
				'standard' => q#آرمینیا کا معیاری وقت#,
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#عدن#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#الماٹی#,
		},
		'Asia/Amman' => {
			exemplarCity => q#امّان#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#انیدر#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#اکتاؤ#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#اکٹوب#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#اشغبت#,
		},
		'Asia/Atyrau' => {
			exemplarCity => q#آتیراؤ#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#بغداد#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#بحرین#,
		},
		'Asia/Baku' => {
			exemplarCity => q#باکو#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#بنکاک#,
		},
		'Asia/Barnaul' => {
			exemplarCity => q#برنال#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#بیروت#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#بشکیک#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#برونئی#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#کولکاتا#,
		},
		'Asia/Chita' => {
			exemplarCity => q#چیتا#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#چوئبالسان#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#کولمبو#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#دمشق#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#ڈھاکہ#,
		},
		'Asia/Dili' => {
			exemplarCity => q#ڈلی#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#دبئی#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#دوشانبے#,
		},
		'Asia/Famagusta' => {
			exemplarCity => q#فاماگوسٹا#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#غزہ#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#ہیبرون#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#ہانگ کانگ#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#ہووارڈ#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#ارکتسک#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#جکارتہ#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#جے پورہ#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#یروشلم#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#کابل#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#کیمچٹکا#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#کراچی#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#کاٹھمنڈو#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#خندیگا#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#کریسنویارسک#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#کوالا لمپور#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#کیوچنگ#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#کویت#,
		},
		'Asia/Macau' => {
			exemplarCity => q#مکاؤ#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#میگیدن#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#مکاسر#,
		},
		'Asia/Manila' => {
			exemplarCity => q#منیلا#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#مسقط#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#نکوسیا#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#نوووکیوزنیسک#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#نوووسِبِرسک#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#اومسک#,
		},
		'Asia/Oral' => {
			exemplarCity => q#اورال#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#پنوم پن#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#پونٹیانک#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#پیونگ یانگ#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#قطر#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#کیزیلورڈا#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#رنگون#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#ریاض#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#ہو چی منہ سٹی#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#سخالین#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#سمرقند#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#سیئول#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#شنگھائی#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#سنگاپور#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#سرہدنیکولیمسک#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#تائپے#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#تاشقند#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#طبلیسی#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#تہران#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#تھمپو#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#ٹوکیو#,
		},
		'Asia/Tomsk' => {
			exemplarCity => q#ٹامسک#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#اولان باتار#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#یورومکی#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#اوست-نیرا#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#وینٹیانا#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#ولادی ووستک#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#یکوتسک#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#یکاٹیرِنبرگ#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#یریوان#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#اٹلانٹک ڈے لائٹ ٹائم#,
				'generic' => q#اٹلانٹک ٹائم#,
				'standard' => q#اٹلانٹک اسٹینڈرڈ ٹائم#,
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#ازوریس#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#برمودا#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#کینری#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#کیپ ورڈی#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#فارو#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#مڈیئرا#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#ریکجاوک#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#جنوبی جارجیا#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#سینٹ ہیلینا#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#اسٹینلے#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#اڈیلائڈ#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#برسبین#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#بروکن ہِل#,
		},
		'Australia/Currie' => {
			exemplarCity => q#کیوری#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#ڈارون#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#ایوکلا#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#ہوبارٹ#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#لِنڈمین#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#لارڈ ہووے#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#ملبورن#,
		},
		'Australia/Perth' => {
			exemplarCity => q#پرتھ#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#سڈنی#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#آسٹریلین سنٹرل ڈے لائٹ ٹائم#,
				'generic' => q#سنٹرل آسٹریلیا ٹائم#,
				'standard' => q#آسٹریلین سنٹرل اسٹینڈرڈ ٹائم#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#آسٹریلین سنٹرل ویسٹرن ڈے لائٹ ٹائم#,
				'generic' => q#آسٹریلین سنٹرل ویسٹرن ٹائم#,
				'standard' => q#آسٹریلین سنٹرل ویسٹرن اسٹینڈرڈ ٹائم#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#آسٹریلین ایسٹرن ڈے لائٹ ٹائم#,
				'generic' => q#ایسٹرن آسٹریلیا ٹائم#,
				'standard' => q#آسٹریلین ایسٹرن اسٹینڈرڈ ٹائم#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#آسٹریلین ویسٹرن ڈے لائٹ ٹائم#,
				'generic' => q#ویسٹرن آسٹریلیا ٹائم#,
				'standard' => q#آسٹریلیا ویسٹرن اسٹینڈرڈ ٹائم#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#آذربائیجان کا موسم گرما کا وقت#,
				'generic' => q#آذربائیجان کا وقت#,
				'standard' => q#آذربائیجان کا معیاری وقت#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#ازوریس کا موسم گرما کا وقت#,
				'generic' => q#ازوریس کا وقت#,
				'standard' => q#ازوریس کا معیاری وقت#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#بنگلہ دیش کا موسم گرما کا وقت#,
				'generic' => q#بنگلہ دیش کا وقت#,
				'standard' => q#بنگلہ دیش کا معیاری وقت#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#بھوٹان کا وقت#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#بولیویا کا وقت#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#برازیلیا سمر ٹائم#,
				'generic' => q#برازیلیا ٹائم#,
				'standard' => q#برازیلیا اسٹینڈرڈ ٹائم#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#برونئی دارالسلام ٹائم#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#کیپ ورڈی سمر ٹائم#,
				'generic' => q#کیپ ورڈی ٹائم#,
				'standard' => q#کیپ ورڈی سٹینڈرڈ ٹائم#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#چامورو سٹینڈرڈ ٹائم#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#چیتھم ڈے لائٹ ٹائم#,
				'generic' => q#چیتھم ٹائم#,
				'standard' => q#چیتھم اسٹینڈرڈ ٹائم#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#چلی کا موسم گرما کا وقت#,
				'generic' => q#چلی کا وقت#,
				'standard' => q#چلی کا معیاری وقت#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#چینی ڈے لائٹ ٹائم#,
				'generic' => q#چین ٹائم#,
				'standard' => q#چین سٹینڈرڈ ٹائم#,
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q#کوائبلسان سمر ٹائم#,
				'generic' => q#کوئبلسان ٹائم#,
				'standard' => q#کوئبلسان سٹینڈرڈ ٹائم#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#کرسمس آئلینڈ ٹائم#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#کوکوس آئلینڈز ٹائم#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#کولمبیا کا موسم گرما کا وقت#,
				'generic' => q#کولمبیا ٹائم#,
				'standard' => q#کولمبیا کا معیاری وقت#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#کک آئلینڈز نصف سمر ٹائم#,
				'generic' => q#کک آئلینڈز ٹائم#,
				'standard' => q#کک آئلینڈز سٹینڈرڈ ٹائم#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#کیوبا ڈے لائٹ ٹائم#,
				'generic' => q#کیوبا ٹائم#,
				'standard' => q#کیوبا اسٹینڈرڈ ٹائم#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#ڈیوس ٹائم#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#ڈومونٹ-ڈی’ارویلے ٹائم#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#مشرقی تیمور ٹائم#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#ایسٹر آئلینڈ کا موسم گرما کا وقت#,
				'generic' => q#ایسٹر آئلینڈ کا وقت#,
				'standard' => q#ایسٹر آئلینڈ کا معیاری وقت#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#ایکواڈور کا وقت#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#کوآرڈینیٹڈ یونیورسل ٹائم#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#نامعلوم شہر#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#ایمسٹرڈم#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#انڈورا#,
		},
		'Europe/Astrakhan' => {
			exemplarCity => q#استراخان#,
		},
		'Europe/Athens' => {
			exemplarCity => q#ایتھنز#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#بلغراد#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#برلن#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#بریٹِسلاوا#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#برسلز#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#بخارسٹ#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#بڈاپسٹ#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#بزنجن#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#چیسیناؤ#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#کوپن ہیگن#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#ڈبلن#,
			long => {
				'daylight' => q#آئرش اسٹینڈرڈ ٹائم#,
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#جبل الطارق#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#گرنزی#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#ہیلسنکی#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#آئل آف مین#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#استنبول#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#جرسی#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#کالينينغراد#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#کیوو#,
		},
		'Europe/Kirov' => {
			exemplarCity => q#کیروف#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#لسبن#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#لیوبلیانا#,
		},
		'Europe/London' => {
			exemplarCity => q#لندن#,
			long => {
				'daylight' => q#برٹش سمر ٹائم#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#لگژمبرگ#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#میڈرڈ#,
		},
		'Europe/Malta' => {
			exemplarCity => q#مالٹا#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#میریہام#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#مِنسک#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#موناکو#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#ماسکو#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#اوسلو#,
		},
		'Europe/Paris' => {
			exemplarCity => q#پیرس#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#پوڈگورسیا#,
		},
		'Europe/Prague' => {
			exemplarCity => q#پراگ#,
		},
		'Europe/Riga' => {
			exemplarCity => q#ریگا#,
		},
		'Europe/Rome' => {
			exemplarCity => q#روم#,
		},
		'Europe/Samara' => {
			exemplarCity => q#سمارا#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#سان ماریانو#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#سراجیوو#,
		},
		'Europe/Saratov' => {
			exemplarCity => q#سیراٹو#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#سمفروپول#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#اسکوپجے#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#صوفیہ#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#اسٹاک ہوم#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#ٹالن#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#ٹیرانی#,
		},
		'Europe/Ulyanovsk' => {
			exemplarCity => q#الیانوسک#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#ازگوروڈ#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#ویڈوز#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#واٹیکن#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#ویانا#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#وِلنیئس#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#وولگوگراد#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#وارسا#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#زیگریب#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#زیپوروزائی#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#زیورخ#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#وسطی یورپ کا موسم گرما کا وقت#,
				'generic' => q#وسط یورپ کا وقت#,
				'standard' => q#وسطی یورپ کا معیاری وقت#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#مشرقی یورپ کا موسم گرما کا وقت#,
				'generic' => q#مشرقی یورپ کا وقت#,
				'standard' => q#مشرقی یورپ کا معیاری وقت#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#بعید مشرقی یورپی وقت#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#مغربی یورپ کا موسم گرما کا وقت#,
				'generic' => q#مغربی یورپ کا وقت#,
				'standard' => q#مغربی یورپ کا معیاری وقت#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#فاک لینڈ آئلینڈز کا موسم گرما کا وقت#,
				'generic' => q#فاک لینڈ آئلینڈز کا وقت#,
				'standard' => q#فاک لینڈ آئلینڈز کا معیاری وقت#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#فجی سمر ٹائم#,
				'generic' => q#فجی ٹائم#,
				'standard' => q#فجی سٹینڈرڈ ٹائم#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#فرینچ گیانا کا وقت#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#فرینچ جنوبی اور انٹارکٹک ٹائم#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#گرین وچ کا اصل وقت#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#گالاپاگوز کا وقت#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#گیمبیئر ٹائم#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#جارجیا کا موسم گرما کا وقت#,
				'generic' => q#جارجیا کا وقت#,
				'standard' => q#جارجیا کا معیاری وقت#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#جلبرٹ آئلینڈز ٹائم#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#مشرقی گرین لینڈ کا موسم گرما کا وقت#,
				'generic' => q#مشرقی گرین لینڈ ٹائم#,
				'standard' => q#مشرقی گرین لینڈ اسٹینڈرڈ ٹائم#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#مغربی گرین لینڈ کا موسم گرما کا وقت#,
				'generic' => q#مغربی گرین لینڈ ٹائم#,
				'standard' => q#مغربی گرین لینڈ اسٹینڈرڈ ٹائم#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#خلیج کا معیاری وقت#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#گیانا کا وقت#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#ہوائی الیوٹیئن ڈے لائٹ ٹائم#,
				'generic' => q#ہوائی الیوٹیئن ٹائم#,
				'standard' => q#ہوائی الیوٹیئن اسٹینڈرڈ ٹائم#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#ہانگ کانگ سمر ٹائم#,
				'generic' => q#ہانگ کانگ ٹائم#,
				'standard' => q#ہانگ کانگ سٹینڈرڈ ٹائم#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#ہووڈ سمر ٹائم#,
				'generic' => q#ہووڈ ٹائم#,
				'standard' => q#ہووڈ سٹینڈرڈ ٹائم#,
			},
		},
		'India' => {
			long => {
				'standard' => q#ہندوستان کا معیاری وقت#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#انٹاناناریوو#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#چاگوس#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#کرسمس#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#کوکوس#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#کومورو#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#کرگیولین#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#ماہی#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#مالدیپ#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#ماریشس#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#مایوٹ#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#ری یونین#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#بحر ہند ٹائم#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#ہند چین ٹائم#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#وسطی انڈونیشیا ٹائم#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#مشرقی انڈونیشیا ٹائم#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#مغربی انڈونیشیا ٹائم#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#ایران ڈے لائٹ ٹائم#,
				'generic' => q#ایران کا وقت#,
				'standard' => q#ایران کا معیاری وقت#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#ارکتسک سمر ٹائم#,
				'generic' => q#ارکتسک ٹائم#,
				'standard' => q#ارکتسک سٹینڈرڈ ٹائم#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#اسرائیل ڈے لائٹ ٹائم#,
				'generic' => q#اسرائیل کا وقت#,
				'standard' => q#اسرائیل کا معیاری وقت#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#جاپان ڈے لائٹ ٹائم#,
				'generic' => q#جاپان ٹائم#,
				'standard' => q#جاپان سٹینڈرڈ ٹائم#,
			},
		},
		'Kamchatka' => {
			long => {
				'daylight' => q#پیٹروپاؤلووسک-کیمچسکی سمر ٹائم#,
				'generic' => q#پیٹروپاؤلووسک-کیمچسکی ٹائم#,
				'standard' => q#پیٹروپاؤلووسک-کیمچسکی اسٹینڈرڈ ٹائم#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#مشرقی قزاخستان کا وقت#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#مغربی قزاخستان کا وقت#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#کوریا ڈے لائٹ ٹائم#,
				'generic' => q#کوریا ٹائم#,
				'standard' => q#کوریا سٹینڈرڈ ٹائم#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#کوسرے ٹائم#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#کریسنویارسک سمر ٹائم#,
				'generic' => q#کریسنویارسک ٹائم#,
				'standard' => q#کرسنویارسک سٹینڈرڈ ٹائم#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#کرغستان کا وقت#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#لائن آئلینڈز ٹائم#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#لارڈ ہووے ڈے لائٹ ٹائم#,
				'generic' => q#لارڈ ہووے ٹائم#,
				'standard' => q#لارڈ ہووے اسٹینڈرڈ ٹائم#,
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q#مکوآری آئلینڈ کا وقت#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#میگیدن سمر ٹائم#,
				'generic' => q#میگیدن ٹائم#,
				'standard' => q#مگادان اسٹینڈرڈ ٹائم#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#ملیشیا ٹائم#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#مالدیپ کا وقت#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#مارکیسس ٹائم#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#مارشل آئلینڈز ٹائم#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#ماریشس سمر ٹائم#,
				'generic' => q#ماریشس ٹائم#,
				'standard' => q#ماریشس سٹینڈرڈ ٹائم#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#ماؤسن ٹائم#,
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q#شمال مغربی میکسیکو ڈے لائٹ ٹائم#,
				'generic' => q#شمال مغربی میکسیکو ٹائم#,
				'standard' => q#شمال مغربی میکسیکو اسٹینڈرڈ ٹائم#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#میکسیکن پیسفک ڈے لائٹ ٹائم#,
				'generic' => q#میکسیکن پیسفک ٹائم#,
				'standard' => q#میکسیکن پیسفک اسٹینڈرڈ ٹائم#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#یولان بیتور سمر ٹائم#,
				'generic' => q#یولان بیتور ٹائم#,
				'standard' => q#یولان بیتور سٹینڈرڈ ٹائم#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#ماسکو سمر ٹائم#,
				'generic' => q#ماسکو ٹائم#,
				'standard' => q#ماسکو اسٹینڈرڈ ٹائم#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#میانمار ٹائم#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#ناؤرو ٹائم#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#نیپال کا وقت#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#نیو کیلیڈونیا سمر ٹائم#,
				'generic' => q#نیو کیلیڈونیا ٹائم#,
				'standard' => q#نیو کیلیڈونیا سٹینڈرڈ ٹائم#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#نیوزی لینڈ ڈے لائٹ ٹائم#,
				'generic' => q#نیوزی لینڈ کا وقت#,
				'standard' => q#نیوزی لینڈ کا معیاری وقت#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#نیو فاؤنڈ لینڈ ڈے لائٹ ٹائم#,
				'generic' => q#نیو فاؤنڈ لینڈ ٹائم#,
				'standard' => q#نیو فاؤنڈ لینڈ اسٹینڈرڈ ٹائم#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#نیئو ٹائم#,
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q#نارفوک آئلینڈ کا وقت#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#فرنانڈو ڈی نورونہا سمر ٹائم#,
				'generic' => q#فرنانڈو ڈی نورنہا کا وقت#,
				'standard' => q#فرنانڈو ڈی نورنہا کا معیاری وقت#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#نوووسیبرسک سمر ٹائم#,
				'generic' => q#نوووسیبرسک ٹائم#,
				'standard' => q#نوووسیبرسک سٹینڈرڈ ٹائم#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#اومسک سمر ٹائم#,
				'generic' => q#اومسک ٹائم#,
				'standard' => q#اومسک سٹینڈرڈ ٹائم#,
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#اپیا#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#آکلینڈ#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#بوگینولے#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#چیتھم#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#ایسٹر#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#ایفیٹ#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#اینڈربری#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#فکاؤفو#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#فجی#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#فیونافیوٹی#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#گیلاپیگوس#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#گامبیئر#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#گواڈل کینال#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#گوآم#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#ہونولولو#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#جانسٹن#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#کریتیماٹی#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#کوسرائی#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#کواجیلین#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#مجورو#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#مارکیساس#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#مڈوے#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#ناؤرو#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#نیئو#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#نورفوک#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#نؤمیا#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#پاگو پاگو#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#پلاؤ#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#پٹکائرن#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#پونپیئی#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#پورٹ موریسبی#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#راروٹونگا#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#سائپین#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#تاہیتی#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#ٹراوا#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#ٹونگاٹاپو#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#چیوک#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#ویک#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#ولّیس#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#پاکستان کا موسم گرما کا وقت#,
				'generic' => q#پاکستان کا وقت#,
				'standard' => q#پاکستان کا معیاری وقت#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#پلاؤ ٹائم#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#پاپوآ نیو گنی ٹائم#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#پیراگوئے کا موسم گرما کا وقت#,
				'generic' => q#پیراگوئے کا وقت#,
				'standard' => q#پیراگوئے کا معیاری وقت#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#پیرو کا موسم گرما کا وقت#,
				'generic' => q#پیرو کا وقت#,
				'standard' => q#پیرو کا معیاری وقت#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#فلپائن سمر ٹائم#,
				'generic' => q#فلپائن ٹائم#,
				'standard' => q#فلپائن سٹینڈرڈ ٹائم#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#فینکس آئلینڈز ٹائم#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#سینٹ پیئر اور مکلیئون ڈے لائٹ ٹائم#,
				'generic' => q#سینٹ پیئر اور مکلیئون ٹائم#,
				'standard' => q#سینٹ پیئر اور مکلیئون اسٹینڈرڈ ٹائم#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#پٹکائرن ٹائم#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#پوناپے ٹائم#,
			},
		},
		'Pyongyang' => {
			long => {
				'standard' => q#پیانگ یانگ وقت#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#ری یونین ٹائم#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#روتھیرا کا وقت#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#سخالین سمر ٹائم#,
				'generic' => q#سخالین ٹائم#,
				'standard' => q#سخالین سٹینڈرڈ ٹائم#,
			},
		},
		'Samara' => {
			long => {
				'daylight' => q#سمارا سمر ٹائم#,
				'generic' => q#سمارا ٹائم#,
				'standard' => q#سمارا اسٹینڈرڈ ٹائم#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#ساموآ ڈے لائٹ ٹائم#,
				'generic' => q#ساموآ ٹائم#,
				'standard' => q#ساموآ سٹینڈرڈ ٹائم#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#سیشلیز ٹائم#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#سنگاپور سٹینڈرڈ ٹائم#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#سولمن آئلینڈز ٹائم#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#جنوبی جارجیا ٹائم#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#سورینام کا وقت#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#سیووا ٹائم#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#تاہیتی ٹائم#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#تئی پیئی ڈے لائٹ ٹائم#,
				'generic' => q#تائی پیئی ٹائم#,
				'standard' => q#تائی پیئی اسٹینڈرڈ ٹائم#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#تاجکستان کا وقت#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#ٹوکیلاؤ ٹائم#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#ٹونگا سمر ٹائم#,
				'generic' => q#ٹونگا ٹائم#,
				'standard' => q#ٹونگا سٹینڈرڈ ٹائم#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#چوک ٹائم#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#ترکمانستان کا موسم گرما کا وقت#,
				'generic' => q#ترکمانستان کا وقت#,
				'standard' => q#ترکمانستان کا معیاری وقت#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#ٹوالو ٹائم#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#یوروگوئے کا موسم گرما کا وقت#,
				'generic' => q#یوروگوئے کا وقت#,
				'standard' => q#یوروگوئے کا معیاری وقت#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#ازبکستان کا موسم گرما کا وقت#,
				'generic' => q#ازبکستان کا وقت#,
				'standard' => q#ازبکستان کا معیاری وقت#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#وانوآٹو سمر ٹائم#,
				'generic' => q#وانوآٹو ٹائم#,
				'standard' => q#وانوآٹو سٹینڈرڈ ٹائم#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#وینزوئیلا کا وقت#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#ولادی ووستک سمر ٹائم#,
				'generic' => q#ولادی ووستک ٹائم#,
				'standard' => q#ولادی ووستک سٹینڈرڈ ٹائم#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#وولگوگراد سمر ٹائم#,
				'generic' => q#وولگوگراد ٹائم#,
				'standard' => q#وولگوگراد اسٹینڈرڈ ٹائم#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#ووسٹاک کا وقت#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#ویک آئلینڈ ٹائم#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#والیز اور فٹونا ٹائم#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#یکوتسک سمر ٹائم#,
				'generic' => q#یکوتسک ٹائم#,
				'standard' => q#یکوتسک اسٹینڈرڈ ٹائم#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#یکاٹیرِنبرگ سمر ٹائم#,
				'generic' => q#یکاٹیرِنبرگ ٹائم#,
				'standard' => q#یکاٹیرِنبرگ اسٹینڈرڈ ٹائم#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
