/* This structure is generated with convrtrs.pl */

#define TCONV_ICONV_MAX_CATEGORY 3
typedef struct tconv_iconv_alias2category {
  char *alias;                                 /* Normalized version */
  char *categoriesp[TCONV_ICONV_MAX_CATEGORY]; /* Categories */
} tconv_iconv_alias2category_t;
    
#define TCONV_ICONV_NB_ALIAS 1575
static tconv_iconv_alias2category_t alias2category[] = {
  { "utf8", { "UTF-8", NULL, NULL } },
  { "utf16", { "UTF-16", NULL, NULL } },
  { "utf16le", { "UTF-16LE", NULL, NULL } },
  { "utf16be", { "UTF-16BE", NULL, NULL } },
  { "utf32", { "UTF-32", NULL, NULL } },
  { "utf32le", { "UTF-32LE", NULL, NULL } },
  { "utf32be", { "UTF-32BE", NULL, NULL } },
  { "utf16,version=1", { "UTF-16,version=1", NULL, NULL } },
  { "utf16,version=2", { "UTF-16,version=2", NULL, NULL } },
  { "utf16be,version=1", { "UTF-16BE,version=1", NULL, NULL } },
  { "utf16bigendian", { "UTF-16BE", NULL, NULL } },
  { "utf16le,version=1", { "UTF-16LE,version=1", NULL, NULL } },
  { "utf16littleendian", { "UTF-16LE", NULL, NULL } },
  { "utf16oppositeendian", { "UTF16_OppositeEndian", NULL, NULL } },
  { "utf16platformendian", { "UTF16_PlatformEndian", NULL, NULL } },
  { "utf32bigendian", { "UTF-32BE", NULL, NULL } },
  { "utf32littleendian", { "UTF-32LE", NULL, NULL } },
  { "utf32oppositeendian", { "UTF32_OppositeEndian", NULL, NULL } },
  { "utf32platformendian", { "UTF32_PlatformEndian", NULL, NULL } },
  { "windows10000", { "macos-0_2-10.2", NULL, NULL } },
  { "windows10006", { "macos-6_2-10.4", NULL, NULL } },
  { "windows10007", { "macos-7_3-10.2", NULL, NULL } },
  { "windows10029", { "macos-29-10.2", NULL, NULL } },
  { "windows10081", { "macos-35-10.2", NULL, NULL } },
  { "windows1200", { "UTF-16LE", NULL, NULL } },
  { "windows1201", { "UTF-16BE", NULL, NULL } },
  { "windows1250", { "ibm-5346_P100-1998", "ibm-1250_P100-1995", NULL } },
  { "windows1251", { "ibm-5347_P100-1998", "ibm-1251_P100-1995", NULL } },
  { "windows1252", { "ibm-5348_P100-1997", "ibm-1252_P100-2000", NULL } },
  { "windows1253", { "ibm-5349_P100-1998", "ibm-1253_P100-1995", NULL } },
  { "windows1254", { "ibm-5350_P100-1998", "ibm-1254_P100-1995", NULL } },
  { "windows1255", { "ibm-9447_P100-2002", "ibm-5351_P100-1998", NULL } },
  { "windows1256", { "ibm-9448_X100-2005", "ibm-5352_P100-1998", NULL } },
  { "windows1257", { "ibm-9449_P100-2002", "ibm-5353_P100-1998", NULL } },
  { "windows1258", { "ibm-5354_P100-1998", "ibm-1258_P100-1997", NULL } },
  { "windows13612000", { "windows-1361-2000", NULL, NULL } },
  { "windows20127", { "US-ASCII", NULL, NULL } },
  { "windows20866", { "ibm-878_P100-1996", NULL, NULL } },
  { "windows20880", { "ibm-880_P100-1995", NULL, NULL } },
  { "windows20905", { "ibm-905_P100-1995", NULL, NULL } },
  { "windows21866", { "ibm-1168_P100-2002", NULL, NULL } },
  { "windows28592", { "ibm-912_P100-1995", NULL, NULL } },
  { "windows28593", { "ibm-913_P100-2000", NULL, NULL } },
  { "windows28594", { "ibm-914_P100-1995", NULL, NULL } },
  { "windows28595", { "ibm-915_P100-1995", NULL, NULL } },
  { "windows28596", { "ibm-1089_P100-1995", NULL, NULL } },
  { "windows28597", { "ibm-9005_X110-2007", NULL, NULL } },
  { "windows28598", { "ibm-5012_P100-1999", NULL, NULL } },
  { "windows28599", { "ibm-920_P100-1995", NULL, NULL } },
  { "windows28603", { "ibm-921_P100-1995", NULL, NULL } },
  { "windows28605", { "ibm-923_P100-1998", NULL, NULL } },
  { "windows31j", { "ibm-943_P15A-2003", NULL, NULL } },
  { "windows437", { "ibm-437_P100-1995", NULL, NULL } },
  { "windows51932", { "windows-51932-2006", NULL, NULL } },
  { "windows519322006", { "windows-51932-2006", NULL, NULL } },
  { "windows51949", { "ibm-970_P110_P110-2006_U2", NULL, NULL } },
  { "windows54936", { "gb18030", NULL, NULL } },
  { "windows57002", { "ISCII,version=0", NULL, NULL } },
  { "windows57003", { "ISCII,version=1", NULL, NULL } },
  { "windows57004", { "ISCII,version=5", NULL, NULL } },
  { "windows57005", { "ISCII,version=6", NULL, NULL } },
  { "windows57006", { "ISCII,version=1", NULL, NULL } },
  { "windows57007", { "ISCII,version=4", NULL, NULL } },
  { "windows57008", { "ISCII,version=7", NULL, NULL } },
  { "windows57009", { "ISCII,version=8", NULL, NULL } },
  { "windows57010", { "ISCII,version=3", NULL, NULL } },
  { "windows57011", { "ISCII,version=2", NULL, NULL } },
  { "windows65000", { "UTF-7", NULL, NULL } },
  { "windows65001", { "UTF-8", NULL, NULL } },
  { "windows720", { "ibm-720_P100-1997", NULL, NULL } },
  { "windows737", { "ibm-737_P100-1997", NULL, NULL } },
  { "windows775", { "ibm-775_P100-1996", NULL, NULL } },
  { "windows850", { "ibm-850_P100-1995", NULL, NULL } },
  { "windows852", { "ibm-852_P100-1995", NULL, NULL } },
  { "windows855", { "ibm-855_P100-1995", NULL, NULL } },
  { "windows857", { "ibm-857_P100-1995", NULL, NULL } },
  { "windows858", { "ibm-858_P100-1997", NULL, NULL } },
  { "windows861", { "ibm-861_P100-1995", NULL, NULL } },
  { "windows862", { "ibm-862_P100-1995", NULL, NULL } },
  { "windows8642000", { "windows-864-2000", NULL, NULL } },
  { "windows866", { "ibm-866_P100-1995", NULL, NULL } },
  { "windows869", { "ibm-869_P100-1995", NULL, NULL } },
  { "windows874", { "windows-874-2000", NULL, NULL } },
  { "windows8742000", { "windows-874-2000", NULL, NULL } },
  { "windows932", { "ibm-943_P15A-2003", NULL, NULL } },
  { "windows936", { "ibm-1386_P100-2001", "windows-936-2000", NULL } },
  { "windows9362000", { "windows-936-2000", NULL, NULL } },
  { "windows949", { "ibm-1363_P11B-1998", "windows-949-2000", NULL } },
  { "windows9492000", { "windows-949-2000", NULL, NULL } },
  { "windows950", { "ibm-1373_P100-2002", "windows-950-2000", NULL } },
  { "windows9502000", { "windows-950-2000", NULL, NULL } },
  { "cp00858", { "ibm-858_P100-1997", NULL, NULL } },
  { "cp00924", { "ibm-924_P100-1998", NULL, NULL } },
  { "cp01140", { "ibm-1140_P100-1997", NULL, NULL } },
  { "cp01141", { "ibm-1141_P100-1997", NULL, NULL } },
  { "cp01142", { "ibm-1142_P100-1997", NULL, NULL } },
  { "cp01143", { "ibm-1143_P100-1997", NULL, NULL } },
  { "cp01144", { "ibm-1144_P100-1997", NULL, NULL } },
  { "cp01145", { "ibm-1145_P100-1997", NULL, NULL } },
  { "cp01146", { "ibm-1146_P100-1997", NULL, NULL } },
  { "cp01147", { "ibm-1147_P100-1997", NULL, NULL } },
  { "cp01148", { "ibm-1148_P100-1997", NULL, NULL } },
  { "cp01149", { "ibm-1149_P100-1997", NULL, NULL } },
  { "cp037", { "ibm-37_P100-1995", NULL, NULL } },
  { "cp1006", { "ibm-1006_P100-1995", NULL, NULL } },
  { "cp1025", { "ibm-1025_P100-1995", NULL, NULL } },
  { "cp1026", { "ibm-1026_P100-1995", NULL, NULL } },
  { "cp1047", { "ibm-1047_P100-1995", NULL, NULL } },
  { "cp1089", { "ibm-1089_P100-1995", NULL, NULL } },
  { "cp1097", { "ibm-1097_P100-1995", NULL, NULL } },
  { "cp1098", { "ibm-1098_P100-1995", NULL, NULL } },
  { "cp1112", { "ibm-1112_P100-1995", NULL, NULL } },
  { "cp1122", { "ibm-1122_P100-1999", NULL, NULL } },
  { "cp1123", { "ibm-1123_P100-1995", NULL, NULL } },
  { "cp1124", { "ibm-1124_P100-1996", NULL, NULL } },
  { "cp1125", { "ibm-1125_P100-1997", NULL, NULL } },
  { "cp1131", { "ibm-1131_P100-1997", NULL, NULL } },
  { "cp1140", { "ibm-1140_P100-1997", NULL, NULL } },
  { "cp1141", { "ibm-1141_P100-1997", NULL, NULL } },
  { "cp1142", { "ibm-1142_P100-1997", NULL, NULL } },
  { "cp1143", { "ibm-1143_P100-1997", NULL, NULL } },
  { "cp1144", { "ibm-1144_P100-1997", NULL, NULL } },
  { "cp1145", { "ibm-1145_P100-1997", NULL, NULL } },
  { "cp1146", { "ibm-1146_P100-1997", NULL, NULL } },
  { "cp1147", { "ibm-1147_P100-1997", NULL, NULL } },
  { "cp1148", { "ibm-1148_P100-1997", NULL, NULL } },
  { "cp1149", { "ibm-1149_P100-1997", NULL, NULL } },
  { "cp1200", { "UTF-16BE", NULL, NULL } },
  { "cp1201", { "UTF-16BE", NULL, NULL } },
  { "cp1208", { "UTF-8", NULL, NULL } },
  { "cp1250", { "ibm-5346_P100-1998", NULL, NULL } },
  { "cp1251", { "ibm-5347_P100-1998", NULL, NULL } },
  { "cp1252", { "ibm-5348_P100-1997", NULL, NULL } },
  { "cp1253", { "ibm-5349_P100-1998", NULL, NULL } },
  { "cp1254", { "ibm-5350_P100-1998", NULL, NULL } },
  { "cp1255", { "ibm-9447_P100-2002", NULL, NULL } },
  { "cp1256", { "ibm-9448_X100-2005", NULL, NULL } },
  { "cp1257", { "ibm-9449_P100-2002", NULL, NULL } },
  { "cp1258", { "ibm-5354_P100-1998", NULL, NULL } },
  { "cp1363", { "ibm-1363_P11B-1998", NULL, NULL } },
  { "cp1381", { "ibm-1381_P110-1999", NULL, NULL } },
  { "cp1383", { "ibm-1383_P110-1999", NULL, NULL } },
  { "cp1386", { "ibm-1386_P100-2001", NULL, NULL } },
  { "cp154", { "glibc-PT154-2.3.3", NULL, NULL } },
  { "cp273", { "ibm-273_P100-1995", NULL, NULL } },
  { "cp274", { "ibm-274_P100-2000", NULL, NULL } },
  { "cp275", { "ibm-275_P100-1995", NULL, NULL } },
  { "cp277", { "ibm-277_P100-1995", NULL, NULL } },
  { "cp278", { "ibm-278_P100-1995", NULL, NULL } },
  { "cp280", { "ibm-280_P100-1995", NULL, NULL } },
  { "cp284", { "ibm-284_P100-1995", NULL, NULL } },
  { "cp285", { "ibm-285_P100-1995", NULL, NULL } },
  { "cp290", { "ibm-290_P100-1995", NULL, NULL } },
  { "cp297", { "ibm-297_P100-1995", NULL, NULL } },
  { "cp33722", { "ibm-33722_P120-1999", NULL, NULL } },
  { "cp367", { "US-ASCII", NULL, NULL } },
  { "cp37", { "ibm-37_P100-1995", NULL, NULL } },
  { "cp420", { "ibm-420_X120-1999", NULL, NULL } },
  { "cp424", { "ibm-424_P100-1995", NULL, NULL } },
  { "cp437", { "ibm-437_P100-1995", NULL, NULL } },
  { "cp500", { "ibm-500_P100-1995", NULL, NULL } },
  { "cp51932", { "windows-51932-2006", NULL, NULL } },
  { "cp737", { "ibm-737_P100-1997", NULL, NULL } },
  { "cp775", { "ibm-775_P100-1996", NULL, NULL } },
  { "cp803", { "ibm-803_P100-1999", NULL, NULL } },
  { "cp813", { "ibm-813_P100-1995", NULL, NULL } },
  { "cp819", { "ISO-8859-1", NULL, NULL } },
  { "cp838", { "ibm-838_P100-1995", NULL, NULL } },
  { "cp850", { "ibm-850_P100-1995", NULL, NULL } },
  { "cp851", { "ibm-851_P100-1995", NULL, NULL } },
  { "cp852", { "ibm-852_P100-1995", NULL, NULL } },
  { "cp855", { "ibm-855_P100-1995", NULL, NULL } },
  { "cp856", { "ibm-856_P100-1995", NULL, NULL } },
  { "cp857", { "ibm-857_P100-1995", NULL, NULL } },
  { "cp858", { "ibm-858_P100-1997", NULL, NULL } },
  { "cp860", { "ibm-860_P100-1995", NULL, NULL } },
  { "cp861", { "ibm-861_P100-1995", NULL, NULL } },
  { "cp862", { "ibm-862_P100-1995", NULL, NULL } },
  { "cp863", { "ibm-863_P100-1995", NULL, NULL } },
  { "cp864", { "ibm-864_X110-1999", NULL, NULL } },
  { "cp864s", { "windows-864-2000", NULL, NULL } },
  { "cp865", { "ibm-865_P100-1995", NULL, NULL } },
  { "cp866", { "ibm-866_P100-1995", NULL, NULL } },
  { "cp868", { "ibm-868_P100-1995", NULL, NULL } },
  { "cp869", { "ibm-869_P100-1995", NULL, NULL } },
  { "cp870", { "ibm-870_P100-1995", NULL, NULL } },
  { "cp871", { "ibm-871_P100-1995", NULL, NULL } },
  { "cp874", { "ibm-874_P100-1995", NULL, NULL } },
  { "cp875", { "ibm-875_P100-1995", NULL, NULL } },
  { "cp878", { "ibm-878_P100-1996", NULL, NULL } },
  { "cp880", { "ibm-880_P100-1995", NULL, NULL } },
  { "cp905", { "ibm-905_P100-1995", NULL, NULL } },
  { "cp912", { "ibm-912_P100-1995", NULL, NULL } },
  { "cp913", { "ibm-913_P100-2000", NULL, NULL } },
  { "cp914", { "ibm-914_P100-1995", NULL, NULL } },
  { "cp915", { "ibm-915_P100-1995", NULL, NULL } },
  { "cp916", { "ibm-916_P100-1995", NULL, NULL } },
  { "cp918", { "ibm-918_P100-1995", NULL, NULL } },
  { "cp920", { "ibm-920_P100-1995", NULL, NULL } },
  { "cp921", { "ibm-921_P100-1995", NULL, NULL } },
  { "cp922", { "ibm-922_P100-1999", NULL, NULL } },
  { "cp923", { "ibm-923_P100-1998", NULL, NULL } },
  { "cp930", { "ibm-930_P120-1999", NULL, NULL } },
  { "cp932", { "ibm-942_P12A-1999", "ibm-943_P15A-2003", NULL } },
  { "cp933", { "ibm-933_P110-1995", NULL, NULL } },
  { "cp935", { "ibm-935_P110-1999", NULL, NULL } },
  { "cp936", { "windows-936-2000", NULL, NULL } },
  { "cp937", { "ibm-937_P110-1999", NULL, NULL } },
  { "cp939", { "ibm-939_P120-1999", NULL, NULL } },
  { "cp943", { "ibm-943_P130-1999", NULL, NULL } },
  { "cp943c", { "ibm-943_P15A-2003", NULL, NULL } },
  { "cp949", { "ibm-949_P110-1999", NULL, NULL } },
  { "cp949c", { "ibm-949_P11A-1999", NULL, NULL } },
  { "cp950", { "ibm-950_P110-1999", NULL, NULL } },
  { "cp964", { "ibm-964_P110-1999", NULL, NULL } },
  { "cp970", { "ibm-970_P110_P110-2006_U2", NULL, NULL } },
  { "cpar", { "ibm-868_P100-1995", NULL, NULL } },
  { "cpgr", { "ibm-869_P100-1995", NULL, NULL } },
  { "cpibm284", { "ibm-284_P100-1995", NULL, NULL } },
  { "cpibm285", { "ibm-285_P100-1995", NULL, NULL } },
  { "cpibm297", { "ibm-297_P100-1995", NULL, NULL } },
  { "cpibm37", { "ibm-37_P100-1995", NULL, NULL } },
  { "cpis", { "ibm-861_P100-1995", NULL, NULL } },
  { "037", { "ibm-37_P100-1995", NULL, NULL } },
  { "1006", { "ibm-1006_P100-1995", NULL, NULL } },
  { "1025", { "ibm-1025_P100-1995", NULL, NULL } },
  { "1026", { "ibm-1026_P100-1995", NULL, NULL } },
  { "1047", { "ibm-1047_P100-1995", NULL, NULL } },
  { "1089", { "ibm-1089_P100-1995", NULL, NULL } },
  { "1097", { "ibm-1097_P100-1995", NULL, NULL } },
  { "1098", { "ibm-1098_P100-1995", NULL, NULL } },
  { "1112", { "ibm-1112_P100-1995", NULL, NULL } },
  { "1122", { "ibm-1122_P100-1999", NULL, NULL } },
  { "1123", { "ibm-1123_P100-1995", NULL, NULL } },
  { "1124", { "ibm-1124_P100-1996", NULL, NULL } },
  { "1381", { "ibm-1381_P110-1999", NULL, NULL } },
  { "1383", { "ibm-1383_P110-1999", NULL, NULL } },
  { "273", { "ibm-273_P100-1995", NULL, NULL } },
  { "277", { "ibm-277_P100-1995", NULL, NULL } },
  { "278", { "ibm-278_P100-1995", NULL, NULL } },
  { "280", { "ibm-280_P100-1995", NULL, NULL } },
  { "284", { "ibm-284_P100-1995", NULL, NULL } },
  { "285", { "ibm-285_P100-1995", NULL, NULL } },
  { "297", { "ibm-297_P100-1995", NULL, NULL } },
  { "33722", { "ibm-33722_P120-1999", NULL, NULL } },
  { "420", { "ibm-420_X120-1999", NULL, NULL } },
  { "424", { "ibm-424_P100-1995", NULL, NULL } },
  { "437", { "ibm-437_P100-1995", NULL, NULL } },
  { "500", { "ibm-500_P100-1995", NULL, NULL } },
  { "5601", { "ibm-970_P110_P110-2006_U2", "ibm-1363_P11B-1998", NULL } },
  { "646", { "US-ASCII", NULL, NULL } },
  { "737", { "ibm-737_P100-1997", NULL, NULL } },
  { "775", { "ibm-775_P100-1996", NULL, NULL } },
  { "813", { "ibm-813_P100-1995", NULL, NULL } },
  { "819", { "ISO-8859-1", NULL, NULL } },
  { "838", { "ibm-838_P100-1995", NULL, NULL } },
  { "850", { "ibm-850_P100-1995", NULL, NULL } },
  { "851", { "ibm-851_P100-1995", NULL, NULL } },
  { "852", { "ibm-852_P100-1995", NULL, NULL } },
  { "855", { "ibm-855_P100-1995", NULL, NULL } },
  { "856", { "ibm-856_P100-1995", NULL, NULL } },
  { "857", { "ibm-857_P100-1995", NULL, NULL } },
  { "860", { "ibm-860_P100-1995", NULL, NULL } },
  { "861", { "ibm-861_P100-1995", NULL, NULL } },
  { "862", { "ibm-862_P100-1995", NULL, NULL } },
  { "863", { "ibm-863_P100-1995", NULL, NULL } },
  { "865", { "ibm-865_P100-1995", NULL, NULL } },
  { "866", { "ibm-866_P100-1995", NULL, NULL } },
  { "868", { "ibm-868_P100-1995", NULL, NULL } },
  { "869", { "ibm-869_P100-1995", NULL, NULL } },
  { "871", { "ibm-871_P100-1995", NULL, NULL } },
  { "875", { "ibm-875_P100-1995", NULL, NULL } },
  { "88591", { "ISO-8859-1", NULL, NULL } },
  { "885913", { "ibm-921_P100-1995", NULL, NULL } },
  { "885915", { "ibm-923_P100-1998", NULL, NULL } },
  { "88592", { "ibm-912_P100-1995", NULL, NULL } },
  { "88593", { "ibm-913_P100-2000", NULL, NULL } },
  { "88594", { "ibm-914_P100-1995", NULL, NULL } },
  { "88595", { "ibm-915_P100-1995", NULL, NULL } },
  { "88596", { "ibm-1089_P100-1995", NULL, NULL } },
  { "88597", { "ibm-9005_X110-2007", NULL, NULL } },
  { "88598", { "ibm-5012_P100-1999", NULL, NULL } },
  { "88599", { "ibm-920_P100-1995", NULL, NULL } },
  { "912", { "ibm-912_P100-1995", NULL, NULL } },
  { "913", { "ibm-913_P100-2000", NULL, NULL } },
  { "914", { "ibm-914_P100-1995", NULL, NULL } },
  { "915", { "ibm-915_P100-1995", NULL, NULL } },
  { "916", { "ibm-916_P100-1995", NULL, NULL } },
  { "920", { "ibm-920_P100-1995", NULL, NULL } },
  { "921", { "ibm-921_P100-1995", NULL, NULL } },
  { "922", { "ibm-922_P100-1999", NULL, NULL } },
  { "923", { "ibm-923_P100-1998", NULL, NULL } },
  { "930", { "ibm-930_P120-1999", NULL, NULL } },
  { "933", { "ibm-933_P110-1995", NULL, NULL } },
  { "935", { "ibm-935_P110-1999", NULL, NULL } },
  { "937", { "ibm-937_P110-1999", NULL, NULL } },
  { "939", { "ibm-939_P120-1999", NULL, NULL } },
  { "943", { "ibm-943_P130-1999", NULL, NULL } },
  { "949", { "ibm-949_P110-1999", NULL, NULL } },
  { "950", { "ibm-950_P110-1999", NULL, NULL } },
  { "964", { "ibm-964_P110-1999", NULL, NULL } },
  { "970", { "ibm-970_P110_P110-2006_U2", NULL, NULL } },
  { "adobestandardencoding", { "ibm-1276_P100-1995", NULL, NULL } },
  { "aixibmudcjp4.3.6", { "aix-IBM_udcJP-4.3.6", NULL, NULL } },
  { "ansi1251", { "ibm-5347_P100-1998", NULL, NULL } },
  { "ansix3.41968", { "US-ASCII", NULL, NULL } },
  { "ansix3.41986", { "US-ASCII", NULL, NULL } },
  { "arabic", { "ibm-1089_P100-1995", NULL, NULL } },
  { "ascii", { "US-ASCII", NULL, NULL } },
  { "ascii7", { "US-ASCII", NULL, NULL } },
  { "asmo708", { "ibm-1089_P100-1995", NULL, NULL } },
  { "big5", { "windows-950-2000", NULL, NULL } },
  { "big5hk", { "ibm-1375_P100-2008", NULL, NULL } },
  { "big5hkscs", { "ibm-1375_P100-2008", "ibm-5471_P100-2006", NULL } },
  { "big5hkscs:unicode3.0", { "ibm-5471_P100-2006", NULL, NULL } },
  { "big5solaris", { "solaris-zh_TW_big5-2.7", NULL, NULL } },
  { "bocu1", { "BOCU-1", NULL, NULL } },
  { "bs4730", { "ibm-1013_P100-1995", NULL, NULL } },
  { "ca", { "ibm-1020_P100-2003", NULL, NULL } },
  { "ccsid00858", { "ibm-858_P100-1997", NULL, NULL } },
  { "ccsid00924", { "ibm-924_P100-1998", NULL, NULL } },
  { "ccsid01140", { "ibm-1140_P100-1997", NULL, NULL } },
  { "ccsid01141", { "ibm-1141_P100-1997", NULL, NULL } },
  { "ccsid01142", { "ibm-1142_P100-1997", NULL, NULL } },
  { "ccsid01143", { "ibm-1143_P100-1997", NULL, NULL } },
  { "ccsid01144", { "ibm-1144_P100-1997", NULL, NULL } },
  { "ccsid01145", { "ibm-1145_P100-1997", NULL, NULL } },
  { "ccsid01146", { "ibm-1146_P100-1997", NULL, NULL } },
  { "ccsid01147", { "ibm-1147_P100-1997", NULL, NULL } },
  { "ccsid01148", { "ibm-1148_P100-1997", NULL, NULL } },
  { "ccsid01149", { "ibm-1149_P100-1997", NULL, NULL } },
  { "cesu8", { "CESU-8", NULL, NULL } },
  { "chinese", { "ibm-5478_P100-1995", NULL, NULL } },
  { "cns11643", { "ibm-964_P110-1999", NULL, NULL } },
  { "compoundtext", { "x11-compound-text", NULL, NULL } },
  { "csa71", { "ibm-1020_P100-2003", NULL, NULL } },
  { "csadobestandardencoding", { "ibm-1276_P100-1995", NULL, NULL } },
  { "csascii", { "US-ASCII", NULL, NULL } },
  { "csaz243.419851", { "ibm-1020_P100-2003", NULL, NULL } },
  { "csbig5", { "windows-950-2000", NULL, NULL } },
  { "csbocu1", { "BOCU-1", NULL, NULL } },
  { "cscp51932", { "windows-51932-2006", NULL, NULL } },
  { "csdecmcs", { "ibm-1100_P100-2003", NULL, NULL } },
  { "csebcdicatdea", { "ibm-286_P100-2003", NULL, NULL } },
  { "cseuckr", { "ibm-970_P110_P110-2006_U2", NULL, NULL } },
  { "cseucpkdfmtjapanese", { "euc-jp-2007", NULL, NULL } },
  { "csgb2312", { "ibm-1383_P110-1999", NULL, NULL } },
  { "cshalfwidthkatakana", { "ibm-897_P100-1995", NULL, NULL } },
  { "cshproman8", { "ibm-1051_P100-1995", NULL, NULL } },
  { "csibm037", { "ibm-37_P100-1995", NULL, NULL } },
  { "csibm1026", { "ibm-1026_P100-1995", NULL, NULL } },
  { "csibm273", { "ibm-273_P100-1995", NULL, NULL } },
  { "csibm274", { "ibm-274_P100-2000", NULL, NULL } },
  { "csibm275", { "ibm-275_P100-1995", NULL, NULL } },
  { "csibm277", { "ibm-277_P100-1995", NULL, NULL } },
  { "csibm278", { "ibm-278_P100-1995", NULL, NULL } },
  { "csibm280", { "ibm-280_P100-1995", NULL, NULL } },
  { "csibm284", { "ibm-284_P100-1995", NULL, NULL } },
  { "csibm285", { "ibm-285_P100-1995", NULL, NULL } },
  { "csibm290", { "ibm-290_P100-1995", NULL, NULL } },
  { "csibm297", { "ibm-297_P100-1995", NULL, NULL } },
  { "csibm420", { "ibm-420_X120-1999", NULL, NULL } },
  { "csibm424", { "ibm-424_P100-1995", NULL, NULL } },
  { "csibm500", { "ibm-500_P100-1995", NULL, NULL } },
  { "csibm855", { "ibm-855_P100-1995", NULL, NULL } },
  { "csibm857", { "ibm-857_P100-1995", NULL, NULL } },
  { "csibm860", { "ibm-860_P100-1995", NULL, NULL } },
  { "csibm861", { "ibm-861_P100-1995", NULL, NULL } },
  { "csibm863", { "ibm-863_P100-1995", NULL, NULL } },
  { "csibm864", { "ibm-864_X110-1999", NULL, NULL } },
  { "csibm865", { "ibm-865_P100-1995", NULL, NULL } },
  { "csibm866", { "ibm-866_P100-1995", NULL, NULL } },
  { "csibm868", { "ibm-868_P100-1995", NULL, NULL } },
  { "csibm869", { "ibm-869_P100-1995", NULL, NULL } },
  { "csibm870", { "ibm-870_P100-1995", NULL, NULL } },
  { "csibm871", { "ibm-871_P100-1995", NULL, NULL } },
  { "csibm880", { "ibm-880_P100-1995", NULL, NULL } },
  { "csibm905", { "ibm-905_P100-1995", NULL, NULL } },
  { "csibm918", { "ibm-918_P100-1995", NULL, NULL } },
  { "csibmsymbols", { "ibm-259_P100-1995", NULL, NULL } },
  { "csibmthai", { "ibm-838_P100-1995", NULL, NULL } },
  { "csiso10swedish", { "ibm-1018_P100-1995", NULL, NULL } },
  { "csiso121canadian1", { "ibm-1020_P100-2003", NULL, NULL } },
  { "csiso15italian", { "ibm-1012_P100-1995", NULL, NULL } },
  { "csiso17spanish", { "ibm-1023_P100-2003", NULL, NULL } },
  { "csiso2022cn", { "ISO_2022,locale=zh,version=0", NULL, NULL } },
  { "csiso2022jp", { "ISO_2022,locale=ja,version=0", NULL, NULL } },
  { "csiso2022jp2", { "ISO_2022,locale=ja,version=2", NULL, NULL } },
  { "csiso2022kr", { "ISO_2022,locale=ko,version=0", NULL, NULL } },
  { "csiso21german", { "ibm-1011_P100-1995", NULL, NULL } },
  { "csiso25french", { "ibm-1104_P100-2003", NULL, NULL } },
  { "csiso4unitedkingdom", { "ibm-1013_P100-1995", NULL, NULL } },
  { "csiso58gb231280", { "ibm-5478_P100-1995", NULL, NULL } },
  { "csiso60danishnorwegian", { "ibm-1016_P100-1995", NULL, NULL } },
  { "csiso60norwegian1", { "ibm-1016_P100-1995", NULL, NULL } },
  { "csiso646danish", { "ibm-1107_P100-2003", NULL, NULL } },
  { "csiso69french", { "ibm-1010_P100-1995", NULL, NULL } },
  { "csiso84portuguese2", { "ibm-1015_P100-1995", NULL, NULL } },
  { "csiso85spanish2", { "ibm-1014_P100-1995", NULL, NULL } },
  { "csisolatin0", { "ibm-923_P100-1998", NULL, NULL } },
  { "csisolatin1", { "ISO-8859-1", NULL, NULL } },
  { "csisolatin2", { "ibm-912_P100-1995", NULL, NULL } },
  { "csisolatin3", { "ibm-913_P100-2000", NULL, NULL } },
  { "csisolatin4", { "ibm-914_P100-1995", NULL, NULL } },
  { "csisolatin5", { "ibm-920_P100-1995", NULL, NULL } },
  { "csisolatin6", { "iso-8859_10-1998", NULL, NULL } },
  { "csisolatin9", { "ibm-923_P100-1998", NULL, NULL } },
  { "csisolatinarabic", { "ibm-1089_P100-1995", NULL, NULL } },
  { "csisolatincyrillic", { "ibm-915_P100-1995", NULL, NULL } },
  { "csisolatingreek", { "ibm-9005_X110-2007", NULL, NULL } },
  { "csisolatinhebrew", { "ibm-5012_P100-1999", NULL, NULL } },
  { "csjisencoding", { "ISO_2022,locale=ja,version=1", NULL, NULL } },
  { "cskoi8r", { "ibm-878_P100-1996", NULL, NULL } },
  { "csksc56011987", { "ibm-1363_P11B-1998", "windows-949-2000", NULL } },
  { "cskz1048", { "ibm-1174_X100-2007", NULL, NULL } },
  { "csmacintosh", { "macos-0_2-10.2", NULL, NULL } },
  { "cspc775baltic", { "ibm-775_P100-1996", NULL, NULL } },
  { "cspc850multilingual", { "ibm-850_P100-1995", NULL, NULL } },
  { "cspc851", { "ibm-851_P100-1995", NULL, NULL } },
  { "cspc862latinhebrew", { "ibm-862_P100-1995", NULL, NULL } },
  { "cspc8codepage437", { "ibm-437_P100-1995", NULL, NULL } },
  { "cspcp852", { "ibm-852_P100-1995", NULL, NULL } },
  { "cspcp855", { "ibm-855_P100-1995", NULL, NULL } },
  { "csptcp154", { "glibc-PT154-2.3.3", NULL, NULL } },
  { "csshiftjis", { "ibm-943_P15A-2003", NULL, NULL } },
  { "csucs4", { "UTF-32", NULL, NULL } },
  { "csunicode", { "UTF-16", NULL, NULL } },
  { "cswindows31j", { "ibm-943_P15A-2003", NULL, NULL } },
  { "cyrillic", { "ibm-915_P100-1995", NULL, NULL } },
  { "cyrillicasian", { "glibc-PT154-2.3.3", NULL, NULL } },
  { "de", { "ibm-1011_P100-1995", NULL, NULL } },
  { "dec", { "ibm-1100_P100-2003", NULL, NULL } },
  { "decmcs", { "ibm-1100_P100-2003", NULL, NULL } },
  { "din66003", { "ibm-1011_P100-1995", NULL, NULL } },
  { "dk", { "ibm-1107_P100-2003", NULL, NULL } },
  { "dos720", { "ibm-720_P100-1997", NULL, NULL } },
  { "dos862", { "ibm-862_P100-1995", NULL, NULL } },
  { "ds2089", { "ibm-1107_P100-2003", NULL, NULL } },
  { "ebcdicar", { "ibm-16804_X110-1999", NULL, NULL } },
  { "ebcdicatdea", { "ibm-286_P100-2003", NULL, NULL } },
  { "ebcdicbe", { "ibm-274_P100-2000", NULL, NULL } },
  { "ebcdicbr", { "ibm-275_P100-1995", NULL, NULL } },
  { "ebcdiccpar1", { "ibm-420_X120-1999", NULL, NULL } },
  { "ebcdiccpar2", { "ibm-918_P100-1995", NULL, NULL } },
  { "ebcdiccpbe", { "ibm-500_P100-1995", NULL, NULL } },
  { "ebcdiccpca", { "ibm-37_P100-1995", NULL, NULL } },
  { "ebcdiccpch", { "ibm-500_P100-1995", NULL, NULL } },
  { "ebcdiccpdk", { "ibm-277_P100-1995", NULL, NULL } },
  { "ebcdiccpes", { "ibm-284_P100-1995", NULL, NULL } },
  { "ebcdiccpfi", { "ibm-278_P100-1995", NULL, NULL } },
  { "ebcdiccpfr", { "ibm-297_P100-1995", NULL, NULL } },
  { "ebcdiccpgb", { "ibm-285_P100-1995", NULL, NULL } },
  { "ebcdiccphe", { "ibm-424_P100-1995", NULL, NULL } },
  { "ebcdiccpis", { "ibm-871_P100-1995", NULL, NULL } },
  { "ebcdiccpit", { "ibm-280_P100-1995", NULL, NULL } },
  { "ebcdiccpnl", { "ibm-37_P100-1995", NULL, NULL } },
  { "ebcdiccpno", { "ibm-277_P100-1995", NULL, NULL } },
  { "ebcdiccproece", { "ibm-870_P100-1995", NULL, NULL } },
  { "ebcdiccpse", { "ibm-278_P100-1995", NULL, NULL } },
  { "ebcdiccptr", { "ibm-905_P100-1995", NULL, NULL } },
  { "ebcdiccpus", { "ibm-37_P100-1995", NULL, NULL } },
  { "ebcdiccpwt", { "ibm-37_P100-1995", NULL, NULL } },
  { "ebcdiccpyu", { "ibm-870_P100-1995", NULL, NULL } },
  { "ebcdiccyrillic", { "ibm-880_P100-1995", NULL, NULL } },
  { "ebcdicde", { "ibm-273_P100-1995", NULL, NULL } },
  { "ebcdicde273+euro", { "ibm-1141_P100-1997", NULL, NULL } },
  { "ebcdicdk", { "ibm-277_P100-1995", NULL, NULL } },
  { "ebcdicdk277+euro", { "ibm-1142_P100-1997", NULL, NULL } },
  { "ebcdices284+euro", { "ibm-1145_P100-1997", NULL, NULL } },
  { "ebcdicfi278+euro", { "ibm-1143_P100-1997", NULL, NULL } },
  { "ebcdicfr297+euro", { "ibm-1147_P100-1997", NULL, NULL } },
  { "ebcdicgb", { "ibm-285_P100-1995", NULL, NULL } },
  { "ebcdicgb285+euro", { "ibm-1146_P100-1997", NULL, NULL } },
  { "ebcdiche", { "ibm-12712_P100-1998", NULL, NULL } },
  { "ebcdicinternational500+euro", { "ibm-1148_P100-1997", NULL, NULL } },
  { "ebcdicis", { "ibm-871_P100-1995", NULL, NULL } },
  { "ebcdicis871+euro", { "ibm-1149_P100-1997", NULL, NULL } },
  { "ebcdicit280+euro", { "ibm-1144_P100-1997", NULL, NULL } },
  { "ebcdicjpkana", { "ibm-290_P100-1995", NULL, NULL } },
  { "ebcdiclatin9euro", { "ibm-924_P100-1998", NULL, NULL } },
  { "ebcdicno277+euro", { "ibm-1142_P100-1997", NULL, NULL } },
  { "ebcdicse278+euro", { "ibm-1143_P100-1997", NULL, NULL } },
  { "ebcdicsv", { "ibm-278_P100-1995", NULL, NULL } },
  { "ebcdicus37+euro", { "ibm-1140_P100-1997", NULL, NULL } },
  { "ebcdicxmlus", { "ebcdic-xml-us", NULL, NULL } },
  { "ecma114", { "ibm-1089_P100-1995", NULL, NULL } },
  { "ecma118", { "ibm-9005_X110-2007", NULL, NULL } },
  { "ecma128", { "ibm-920_P100-1995", NULL, NULL } },
  { "elot928", { "ibm-9005_X110-2007", NULL, NULL } },
  { "es", { "ibm-1023_P100-2003", NULL, NULL } },
  { "es2", { "ibm-1014_P100-1995", NULL, NULL } },
  { "euccn", { "ibm-1383_P110-1999", NULL, NULL } },
  { "eucjis", { "euc-jp-2007", NULL, NULL } },
  { "eucjp", { "euc-jp-2007", NULL, NULL } },
  { "eucjp2007", { "euc-jp-2007", NULL, NULL } },
  { "eucjplinux", { "java-euc_jp_linux-1.6_P", NULL, NULL } },
  { "eucjpopen", { "ibm-1350_P110-1997", NULL, NULL } },
  { "euckr", { "ibm-970_P110_P110-2006_U2", NULL, NULL } },
  { "eucth", { "ibm-874_P100-1995", NULL, NULL } },
  { "euctw", { "euc-tw-2014", NULL, NULL } },
  { "euctw2014", { "euc-tw-2014", NULL, NULL } },
  { "extendedunixcodepackedformatforjapanese", { "euc-jp-2007", NULL, NULL } },
  { "fi", { "ibm-1018_P100-1995", NULL, NULL } },
  { "fr", { "ibm-1010_P100-1995", NULL, NULL } },
  { "gb", { "ibm-1013_P100-1995", NULL, NULL } },
  { "gb18030", { "gb18030", NULL, NULL } },
  { "gb2312", { "ibm-1383_P110-1999", NULL, NULL } },
  { "gb2312.19800", { "ibm-5478_P100-1995", NULL, NULL } },
  { "gb23121980", { "ibm-5478_P100-1995", NULL, NULL } },
  { "gb231280", { "ibm-5478_P100-1995", NULL, NULL } },
  { "gbk", { "windows-936-2000", NULL, NULL } },
  { "glibcpt1542.3.3", { "glibc-PT154-2.3.3", NULL, NULL } },
  { "greek", { "ibm-9005_X110-2007", NULL, NULL } },
  { "greek8", { "ibm-9005_X110-2007", NULL, NULL } },
  { "gsm03.382009", { "gsm-03.38-2009", NULL, NULL } },
  { "gsm0338", { "gsm-03.38-2009", NULL, NULL } },
  { "hebrew", { "ibm-5012_P100-1999", NULL, NULL } },
  { "hebrew8", { "ibm-5012_P100-1999", NULL, NULL } },
  { "hkbig5", { "ibm-5471_P100-2006", NULL, NULL } },
  { "hkscsbig5", { "ibm-1375_P100-2008", NULL, NULL } },
  { "hp15cn", { "ibm-1383_P110-1999", NULL, NULL } },
  { "hproman8", { "ibm-1051_P100-1995", NULL, NULL } },
  { "hz", { "HZ", NULL, NULL } },
  { "hzgb2312", { "HZ", NULL, NULL } },
  { "ibm00858", { "ibm-858_P100-1997", NULL, NULL } },
  { "ibm00924", { "ibm-924_P100-1998", NULL, NULL } },
  { "ibm01140", { "ibm-1140_P100-1997", NULL, NULL } },
  { "ibm01141", { "ibm-1141_P100-1997", NULL, NULL } },
  { "ibm01142", { "ibm-1142_P100-1997", NULL, NULL } },
  { "ibm01143", { "ibm-1143_P100-1997", NULL, NULL } },
  { "ibm01144", { "ibm-1144_P100-1997", NULL, NULL } },
  { "ibm01145", { "ibm-1145_P100-1997", NULL, NULL } },
  { "ibm01146", { "ibm-1146_P100-1997", NULL, NULL } },
  { "ibm01147", { "ibm-1147_P100-1997", NULL, NULL } },
  { "ibm01148", { "ibm-1148_P100-1997", NULL, NULL } },
  { "ibm01149", { "ibm-1149_P100-1997", NULL, NULL } },
  { "ibm037", { "ibm-37_P100-1995", NULL, NULL } },
  { "ibm1004", { "ibm-1004_P100-1995", NULL, NULL } },
  { "ibm1004p1001995", { "ibm-1004_P100-1995", NULL, NULL } },
  { "ibm1006", { "ibm-1006_P100-1995", NULL, NULL } },
  { "ibm1006p1001995", { "ibm-1006_P100-1995", NULL, NULL } },
  { "ibm1008", { "ibm-1008_P100-1995", NULL, NULL } },
  { "ibm1008p1001995", { "ibm-1008_P100-1995", NULL, NULL } },
  { "ibm1009", { "ibm-1009_P100-1995", NULL, NULL } },
  { "ibm1009p1001995", { "ibm-1009_P100-1995", NULL, NULL } },
  { "ibm1010", { "ibm-1010_P100-1995", NULL, NULL } },
  { "ibm1010p1001995", { "ibm-1010_P100-1995", NULL, NULL } },
  { "ibm1011", { "ibm-1011_P100-1995", NULL, NULL } },
  { "ibm1011p1001995", { "ibm-1011_P100-1995", NULL, NULL } },
  { "ibm1012", { "ibm-1012_P100-1995", NULL, NULL } },
  { "ibm1012p1001995", { "ibm-1012_P100-1995", NULL, NULL } },
  { "ibm1013", { "ibm-1013_P100-1995", NULL, NULL } },
  { "ibm1013p1001995", { "ibm-1013_P100-1995", NULL, NULL } },
  { "ibm1014", { "ibm-1014_P100-1995", NULL, NULL } },
  { "ibm1014p1001995", { "ibm-1014_P100-1995", NULL, NULL } },
  { "ibm1015", { "ibm-1015_P100-1995", NULL, NULL } },
  { "ibm1015p1001995", { "ibm-1015_P100-1995", NULL, NULL } },
  { "ibm1016", { "ibm-1016_P100-1995", NULL, NULL } },
  { "ibm1016p1001995", { "ibm-1016_P100-1995", NULL, NULL } },
  { "ibm1017", { "ibm-1017_P100-1995", NULL, NULL } },
  { "ibm1017p1001995", { "ibm-1017_P100-1995", NULL, NULL } },
  { "ibm1018", { "ibm-1018_P100-1995", NULL, NULL } },
  { "ibm1018p1001995", { "ibm-1018_P100-1995", NULL, NULL } },
  { "ibm1019", { "ibm-1019_P100-1995", NULL, NULL } },
  { "ibm1019p1001995", { "ibm-1019_P100-1995", NULL, NULL } },
  { "ibm1020", { "ibm-1020_P100-2003", NULL, NULL } },
  { "ibm1020p1002003", { "ibm-1020_P100-2003", NULL, NULL } },
  { "ibm1021", { "ibm-1021_P100-2003", NULL, NULL } },
  { "ibm1021p1002003", { "ibm-1021_P100-2003", NULL, NULL } },
  { "ibm1023", { "ibm-1023_P100-2003", NULL, NULL } },
  { "ibm1023p1002003", { "ibm-1023_P100-2003", NULL, NULL } },
  { "ibm1025", { "ibm-1025_P100-1995", NULL, NULL } },
  { "ibm1025p1001995", { "ibm-1025_P100-1995", NULL, NULL } },
  { "ibm1026", { "ibm-1026_P100-1995", NULL, NULL } },
  { "ibm1026p1001995", { "ibm-1026_P100-1995", NULL, NULL } },
  { "ibm1027", { "ibm-1027_P100-1995", NULL, NULL } },
  { "ibm1027p1001995", { "ibm-1027_P100-1995", NULL, NULL } },
  { "ibm1041", { "ibm-1041_P100-1995", NULL, NULL } },
  { "ibm1041p1001995", { "ibm-1041_P100-1995", NULL, NULL } },
  { "ibm1043", { "ibm-1043_P100-1995", NULL, NULL } },
  { "ibm1043p1001995", { "ibm-1043_P100-1995", NULL, NULL } },
  { "ibm1046", { "ibm-1046_X110-1999", NULL, NULL } },
  { "ibm1046x1101999", { "ibm-1046_X110-1999", NULL, NULL } },
  { "ibm1047", { "ibm-1047_P100-1995", NULL, NULL } },
  { "ibm1047lf", { "ibm-1047_P100-1995,swaplfnl", NULL, NULL } },
  { "ibm1047p1001995", { "ibm-1047_P100-1995", NULL, NULL } },
  { "ibm1047p1001995,swaplfnl", { "ibm-1047_P100-1995,swaplfnl", NULL, NULL } },
  { "ibm1047s390", { "ibm-1047_P100-1995,swaplfnl", NULL, NULL } },
  { "ibm1051", { "ibm-1051_P100-1995", NULL, NULL } },
  { "ibm1051p1001995", { "ibm-1051_P100-1995", NULL, NULL } },
  { "ibm1088", { "ibm-1088_P100-1995", NULL, NULL } },
  { "ibm1088p1001995", { "ibm-1088_P100-1995", NULL, NULL } },
  { "ibm1089", { "ibm-1089_P100-1995", NULL, NULL } },
  { "ibm1089p1001995", { "ibm-1089_P100-1995", NULL, NULL } },
  { "ibm1097", { "ibm-1097_P100-1995", NULL, NULL } },
  { "ibm1097p1001995", { "ibm-1097_P100-1995", NULL, NULL } },
  { "ibm1098", { "ibm-1098_P100-1995", NULL, NULL } },
  { "ibm1098p1001995", { "ibm-1098_P100-1995", NULL, NULL } },
  { "ibm1100", { "ibm-1100_P100-2003", NULL, NULL } },
  { "ibm1100p1002003", { "ibm-1100_P100-2003", NULL, NULL } },
  { "ibm1101", { "ibm-1101_P100-2003", NULL, NULL } },
  { "ibm1101p1002003", { "ibm-1101_P100-2003", NULL, NULL } },
  { "ibm1102", { "ibm-1102_P100-2003", NULL, NULL } },
  { "ibm1102p1002003", { "ibm-1102_P100-2003", NULL, NULL } },
  { "ibm1103", { "ibm-1103_P100-2003", NULL, NULL } },
  { "ibm1103p1002003", { "ibm-1103_P100-2003", NULL, NULL } },
  { "ibm1104", { "ibm-1104_P100-2003", NULL, NULL } },
  { "ibm1104p1002003", { "ibm-1104_P100-2003", NULL, NULL } },
  { "ibm1105", { "ibm-1105_P100-2003", NULL, NULL } },
  { "ibm1105p1002003", { "ibm-1105_P100-2003", NULL, NULL } },
  { "ibm1106", { "ibm-1106_P100-2003", NULL, NULL } },
  { "ibm1106p1002003", { "ibm-1106_P100-2003", NULL, NULL } },
  { "ibm1107", { "ibm-1107_P100-2003", NULL, NULL } },
  { "ibm1107p1002003", { "ibm-1107_P100-2003", NULL, NULL } },
  { "ibm1112", { "ibm-1112_P100-1995", NULL, NULL } },
  { "ibm1112p1001995", { "ibm-1112_P100-1995", NULL, NULL } },
  { "ibm1114", { "ibm-1114_P100-2001", NULL, NULL } },
  { "ibm1114p1002001", { "ibm-1114_P100-2001", NULL, NULL } },
  { "ibm1115", { "ibm-1115_P100-1995", NULL, NULL } },
  { "ibm1115p1001995", { "ibm-1115_P100-1995", NULL, NULL } },
  { "ibm1122", { "ibm-1122_P100-1999", NULL, NULL } },
  { "ibm1122p1001999", { "ibm-1122_P100-1999", NULL, NULL } },
  { "ibm1123", { "ibm-1123_P100-1995", NULL, NULL } },
  { "ibm1123p1001995", { "ibm-1123_P100-1995", NULL, NULL } },
  { "ibm1124", { "ibm-1124_P100-1996", NULL, NULL } },
  { "ibm1124p1001996", { "ibm-1124_P100-1996", NULL, NULL } },
  { "ibm1125", { "ibm-1125_P100-1997", NULL, NULL } },
  { "ibm1125p1001997", { "ibm-1125_P100-1997", NULL, NULL } },
  { "ibm1127", { "ibm-1127_P100-2004", NULL, NULL } },
  { "ibm1127p1002004", { "ibm-1127_P100-2004", NULL, NULL } },
  { "ibm1129", { "ibm-1129_P100-1997", NULL, NULL } },
  { "ibm1129p1001997", { "ibm-1129_P100-1997", NULL, NULL } },
  { "ibm1130", { "ibm-1130_P100-1997", NULL, NULL } },
  { "ibm1130p1001997", { "ibm-1130_P100-1997", NULL, NULL } },
  { "ibm1131", { "ibm-1131_P100-1997", NULL, NULL } },
  { "ibm1131p1001997", { "ibm-1131_P100-1997", NULL, NULL } },
  { "ibm1132", { "ibm-1132_P100-1998", NULL, NULL } },
  { "ibm1132p1001998", { "ibm-1132_P100-1998", NULL, NULL } },
  { "ibm1133", { "ibm-1133_P100-1997", NULL, NULL } },
  { "ibm1133p1001997", { "ibm-1133_P100-1997", NULL, NULL } },
  { "ibm1137", { "ibm-1137_P100-1999", NULL, NULL } },
  { "ibm1137p1001999", { "ibm-1137_P100-1999", NULL, NULL } },
  { "ibm1140", { "ibm-1140_P100-1997", NULL, NULL } },
  { "ibm1140p1001997", { "ibm-1140_P100-1997", NULL, NULL } },
  { "ibm1140p1001997,swaplfnl", { "ibm-1140_P100-1997,swaplfnl", NULL, NULL } },
  { "ibm1140s390", { "ibm-1140_P100-1997,swaplfnl", NULL, NULL } },
  { "ibm1141", { "ibm-1141_P100-1997", NULL, NULL } },
  { "ibm1141lf", { "ibm-1141_P100-1997,swaplfnl", NULL, NULL } },
  { "ibm1141p1001997", { "ibm-1141_P100-1997", NULL, NULL } },
  { "ibm1141p1001997,swaplfnl", { "ibm-1141_P100-1997,swaplfnl", NULL, NULL } },
  { "ibm1141s390", { "ibm-1141_P100-1997,swaplfnl", NULL, NULL } },
  { "ibm1142", { "ibm-1142_P100-1997", NULL, NULL } },
  { "ibm1142p1001997", { "ibm-1142_P100-1997", NULL, NULL } },
  { "ibm1142p1001997,swaplfnl", { "ibm-1142_P100-1997,swaplfnl", NULL, NULL } },
  { "ibm1142s390", { "ibm-1142_P100-1997,swaplfnl", NULL, NULL } },
  { "ibm1143", { "ibm-1143_P100-1997", NULL, NULL } },
  { "ibm1143p1001997", { "ibm-1143_P100-1997", NULL, NULL } },
  { "ibm1143p1001997,swaplfnl", { "ibm-1143_P100-1997,swaplfnl", NULL, NULL } },
  { "ibm1143s390", { "ibm-1143_P100-1997,swaplfnl", NULL, NULL } },
  { "ibm1144", { "ibm-1144_P100-1997", NULL, NULL } },
  { "ibm1144p1001997", { "ibm-1144_P100-1997", NULL, NULL } },
  { "ibm1144p1001997,swaplfnl", { "ibm-1144_P100-1997,swaplfnl", NULL, NULL } },
  { "ibm1144s390", { "ibm-1144_P100-1997,swaplfnl", NULL, NULL } },
  { "ibm1145", { "ibm-1145_P100-1997", NULL, NULL } },
  { "ibm1145p1001997", { "ibm-1145_P100-1997", NULL, NULL } },
  { "ibm1145p1001997,swaplfnl", { "ibm-1145_P100-1997,swaplfnl", NULL, NULL } },
  { "ibm1145s390", { "ibm-1145_P100-1997,swaplfnl", NULL, NULL } },
  { "ibm1146", { "ibm-1146_P100-1997", NULL, NULL } },
  { "ibm1146p1001997", { "ibm-1146_P100-1997", NULL, NULL } },
  { "ibm1146p1001997,swaplfnl", { "ibm-1146_P100-1997,swaplfnl", NULL, NULL } },
  { "ibm1146s390", { "ibm-1146_P100-1997,swaplfnl", NULL, NULL } },
  { "ibm1147", { "ibm-1147_P100-1997", NULL, NULL } },
  { "ibm1147p1001997", { "ibm-1147_P100-1997", NULL, NULL } },
  { "ibm1147p1001997,swaplfnl", { "ibm-1147_P100-1997,swaplfnl", NULL, NULL } },
  { "ibm1147s390", { "ibm-1147_P100-1997,swaplfnl", NULL, NULL } },
  { "ibm1148", { "ibm-1148_P100-1997", NULL, NULL } },
  { "ibm1148p1001997", { "ibm-1148_P100-1997", NULL, NULL } },
  { "ibm1148p1001997,swaplfnl", { "ibm-1148_P100-1997,swaplfnl", NULL, NULL } },
  { "ibm1148s390", { "ibm-1148_P100-1997,swaplfnl", NULL, NULL } },
  { "ibm1149", { "ibm-1149_P100-1997", NULL, NULL } },
  { "ibm1149p1001997", { "ibm-1149_P100-1997", NULL, NULL } },
  { "ibm1149p1001997,swaplfnl", { "ibm-1149_P100-1997,swaplfnl", NULL, NULL } },
  { "ibm1149s390", { "ibm-1149_P100-1997,swaplfnl", NULL, NULL } },
  { "ibm1153", { "ibm-1153_P100-1999", NULL, NULL } },
  { "ibm1153p1001999", { "ibm-1153_P100-1999", NULL, NULL } },
  { "ibm1153p1001999,swaplfnl", { "ibm-1153_P100-1999,swaplfnl", NULL, NULL } },
  { "ibm1153s390", { "ibm-1153_P100-1999,swaplfnl", NULL, NULL } },
  { "ibm1154", { "ibm-1154_P100-1999", NULL, NULL } },
  { "ibm1154p1001999", { "ibm-1154_P100-1999", NULL, NULL } },
  { "ibm1155", { "ibm-1155_P100-1999", NULL, NULL } },
  { "ibm1155p1001999", { "ibm-1155_P100-1999", NULL, NULL } },
  { "ibm1156", { "ibm-1156_P100-1999", NULL, NULL } },
  { "ibm1156p1001999", { "ibm-1156_P100-1999", NULL, NULL } },
  { "ibm1157", { "ibm-1157_P100-1999", NULL, NULL } },
  { "ibm1157p1001999", { "ibm-1157_P100-1999", NULL, NULL } },
  { "ibm1158", { "ibm-1158_P100-1999", NULL, NULL } },
  { "ibm1158p1001999", { "ibm-1158_P100-1999", NULL, NULL } },
  { "ibm1160", { "ibm-1160_P100-1999", NULL, NULL } },
  { "ibm1160p1001999", { "ibm-1160_P100-1999", NULL, NULL } },
  { "ibm1161", { "ibm-1161_P100-1999", NULL, NULL } },
  { "ibm1161p1001999", { "ibm-1161_P100-1999", NULL, NULL } },
  { "ibm1162", { "ibm-1162_P100-1999", NULL, NULL } },
  { "ibm1162p1001999", { "ibm-1162_P100-1999", NULL, NULL } },
  { "ibm1163", { "ibm-1163_P100-1999", NULL, NULL } },
  { "ibm1163p1001999", { "ibm-1163_P100-1999", NULL, NULL } },
  { "ibm1164", { "ibm-1164_P100-1999", NULL, NULL } },
  { "ibm1164p1001999", { "ibm-1164_P100-1999", NULL, NULL } },
  { "ibm1165", { "ibm-1165_P101-2000", NULL, NULL } },
  { "ibm1165p1012000", { "ibm-1165_P101-2000", NULL, NULL } },
  { "ibm1166", { "ibm-1166_P100-2002", NULL, NULL } },
  { "ibm1166p1002002", { "ibm-1166_P100-2002", NULL, NULL } },
  { "ibm1167", { "ibm-1167_P100-2002", NULL, NULL } },
  { "ibm1167p1002002", { "ibm-1167_P100-2002", NULL, NULL } },
  { "ibm1168", { "ibm-1168_P100-2002", NULL, NULL } },
  { "ibm1168p1002002", { "ibm-1168_P100-2002", NULL, NULL } },
  { "ibm1174", { "ibm-1174_X100-2007", NULL, NULL } },
  { "ibm1174x1002007", { "ibm-1174_X100-2007", NULL, NULL } },
  { "ibm1200", { "UTF-16BE", NULL, NULL } },
  { "ibm1201", { "UTF-16BE", NULL, NULL } },
  { "ibm1202", { "UTF-16LE", NULL, NULL } },
  { "ibm1203", { "UTF-16LE", NULL, NULL } },
  { "ibm1204", { "UTF-16", NULL, NULL } },
  { "ibm1205", { "UTF-16", NULL, NULL } },
  { "ibm1208", { "UTF-8", NULL, NULL } },
  { "ibm1209", { "UTF-8", NULL, NULL } },
  { "ibm1212", { "SCSU", NULL, NULL } },
  { "ibm1213", { "SCSU", NULL, NULL } },
  { "ibm1214", { "BOCU-1", NULL, NULL } },
  { "ibm1215", { "BOCU-1", NULL, NULL } },
  { "ibm1232", { "UTF-32BE", NULL, NULL } },
  { "ibm1233", { "UTF-32BE", NULL, NULL } },
  { "ibm1234", { "UTF-32LE", NULL, NULL } },
  { "ibm1235", { "UTF-32LE", NULL, NULL } },
  { "ibm1236", { "UTF-32", NULL, NULL } },
  { "ibm1237", { "UTF-32", NULL, NULL } },
  { "ibm1250", { "ibm-1250_P100-1995", NULL, NULL } },
  { "ibm1250p1001995", { "ibm-1250_P100-1995", NULL, NULL } },
  { "ibm1251", { "ibm-1251_P100-1995", NULL, NULL } },
  { "ibm1251p1001995", { "ibm-1251_P100-1995", NULL, NULL } },
  { "ibm1252", { "ibm-1252_P100-2000", NULL, NULL } },
  { "ibm1252p1002000", { "ibm-1252_P100-2000", NULL, NULL } },
  { "ibm1253", { "ibm-1253_P100-1995", NULL, NULL } },
  { "ibm1253p1001995", { "ibm-1253_P100-1995", NULL, NULL } },
  { "ibm1254", { "ibm-1254_P100-1995", NULL, NULL } },
  { "ibm1254p1001995", { "ibm-1254_P100-1995", NULL, NULL } },
  { "ibm1255", { "ibm-1255_P100-1995", NULL, NULL } },
  { "ibm1255p1001995", { "ibm-1255_P100-1995", NULL, NULL } },
  { "ibm1256", { "ibm-1256_P110-1997", NULL, NULL } },
  { "ibm1256p1101997", { "ibm-1256_P110-1997", NULL, NULL } },
  { "ibm1257", { "ibm-1257_P100-1995", NULL, NULL } },
  { "ibm1257p1001995", { "ibm-1257_P100-1995", NULL, NULL } },
  { "ibm1258", { "ibm-1258_P100-1997", NULL, NULL } },
  { "ibm1258p1001997", { "ibm-1258_P100-1997", NULL, NULL } },
  { "ibm12712", { "ibm-12712_P100-1998", NULL, NULL } },
  { "ibm12712p1001998", { "ibm-12712_P100-1998", NULL, NULL } },
  { "ibm12712p1001998,swaplfnl", { "ibm-12712_P100-1998,swaplfnl", NULL, NULL } },
  { "ibm12712s390", { "ibm-12712_P100-1998,swaplfnl", NULL, NULL } },
  { "ibm1276", { "ibm-1276_P100-1995", NULL, NULL } },
  { "ibm1276p1001995", { "ibm-1276_P100-1995", NULL, NULL } },
  { "ibm1277", { "ibm-1277_P100-1995", NULL, NULL } },
  { "ibm1277p1001995", { "ibm-1277_P100-1995", NULL, NULL } },
  { "ibm13125", { "ibm-13125_P100-1997", NULL, NULL } },
  { "ibm13125p1001997", { "ibm-13125_P100-1997", NULL, NULL } },
  { "ibm13140", { "ibm-13140_P101-2000", NULL, NULL } },
  { "ibm13140p1012000", { "ibm-13140_P101-2000", NULL, NULL } },
  { "ibm13218", { "ibm-13218_P100-1996", NULL, NULL } },
  { "ibm13218p1001996", { "ibm-13218_P100-1996", NULL, NULL } },
  { "ibm13488", { "UTF-16BE", NULL, NULL } },
  { "ibm13489", { "UTF-16BE", NULL, NULL } },
  { "ibm13490", { "UTF-16LE", NULL, NULL } },
  { "ibm13491", { "UTF-16LE", NULL, NULL } },
  { "ibm13496", { "UTF-8", NULL, NULL } },
  { "ibm13497", { "UTF-8", NULL, NULL } },
  { "ibm1350", { "ibm-1350_P110-1997", NULL, NULL } },
  { "ibm1350p1101997", { "ibm-1350_P110-1997", NULL, NULL } },
  { "ibm1351", { "ibm-1351_P110-1997", NULL, NULL } },
  { "ibm1351p1101997", { "ibm-1351_P110-1997", NULL, NULL } },
  { "ibm1362", { "ibm-1362_P110-1999", NULL, NULL } },
  { "ibm1362p1101999", { "ibm-1362_P110-1999", NULL, NULL } },
  { "ibm1363", { "ibm-1363_P11B-1998", "ibm-1363_P110-1997", NULL } },
  { "ibm1363p1101997", { "ibm-1363_P110-1997", NULL, NULL } },
  { "ibm1363p11b1998", { "ibm-1363_P11B-1998", NULL, NULL } },
  { "ibm1363vasciivsubvpua", { "ibm-1363_P110-1997", NULL, NULL } },
  { "ibm1363vsubvpua", { "ibm-1363_P11B-1998", NULL, NULL } },
  { "ibm1364", { "ibm-1364_P110-2007", NULL, NULL } },
  { "ibm1364p1102007", { "ibm-1364_P110-2007", NULL, NULL } },
  { "ibm13676", { "ibm-13676_P102-2001", NULL, NULL } },
  { "ibm13676p1022001", { "ibm-13676_P102-2001", NULL, NULL } },
  { "ibm1370", { "ibm-1370_P100-1999", NULL, NULL } },
  { "ibm1370p1001999", { "ibm-1370_P100-1999", NULL, NULL } },
  { "ibm1371", { "ibm-1371_P100-1999", NULL, NULL } },
  { "ibm1371p1001999", { "ibm-1371_P100-1999", NULL, NULL } },
  { "ibm1373", { "ibm-1373_P100-2002", NULL, NULL } },
  { "ibm1373p1002002", { "ibm-1373_P100-2002", NULL, NULL } },
  { "ibm1375", { "ibm-1375_P100-2008", NULL, NULL } },
  { "ibm1375p1002008", { "ibm-1375_P100-2008", NULL, NULL } },
  { "ibm1380", { "ibm-1380_P100-1995", NULL, NULL } },
  { "ibm1380p1001995", { "ibm-1380_P100-1995", NULL, NULL } },
  { "ibm1381", { "ibm-1381_P110-1999", NULL, NULL } },
  { "ibm1381p1101999", { "ibm-1381_P110-1999", NULL, NULL } },
  { "ibm1382", { "ibm-1382_P100-1995", NULL, NULL } },
  { "ibm1382p1001995", { "ibm-1382_P100-1995", NULL, NULL } },
  { "ibm1383", { "ibm-1383_P110-1999", NULL, NULL } },
  { "ibm1383p1101999", { "ibm-1383_P110-1999", NULL, NULL } },
  { "ibm1383vpua", { "ibm-1383_P110-1999", NULL, NULL } },
  { "ibm1385", { "ibm-9577_P100-2001", NULL, NULL } },
  { "ibm1386", { "ibm-1386_P100-2001", NULL, NULL } },
  { "ibm1386p1002001", { "ibm-1386_P100-2001", NULL, NULL } },
  { "ibm1386vsubvpua", { "ibm-1386_P100-2001", NULL, NULL } },
  { "ibm1388", { "ibm-1388_P103-2001", NULL, NULL } },
  { "ibm1388p1032001", { "ibm-1388_P103-2001", NULL, NULL } },
  { "ibm1390", { "ibm-1390_P110-2003", NULL, NULL } },
  { "ibm1390p1102003", { "ibm-1390_P110-2003", NULL, NULL } },
  { "ibm1392", { "gb18030", NULL, NULL } },
  { "ibm1399", { "ibm-1399_P110-2003", NULL, NULL } },
  { "ibm1399p1102003", { "ibm-1399_P110-2003", NULL, NULL } },
  { "ibm16684", { "ibm-16684_P110-2003", NULL, NULL } },
  { "ibm16684p1102003", { "ibm-16684_P110-2003", NULL, NULL } },
  { "ibm16804", { "ibm-16804_X110-1999", NULL, NULL } },
  { "ibm16804s390", { "ibm-16804_X110-1999,swaplfnl", NULL, NULL } },
  { "ibm16804x1101999", { "ibm-16804_X110-1999", NULL, NULL } },
  { "ibm16804x1101999,swaplfnl", { "ibm-16804_X110-1999,swaplfnl", NULL, NULL } },
  { "ibm17221", { "ibm-17221_P100-2001", NULL, NULL } },
  { "ibm17221p1002001", { "ibm-17221_P100-2001", NULL, NULL } },
  { "ibm17248", { "ibm-17248_X110-1999", NULL, NULL } },
  { "ibm17248x1101999", { "ibm-17248_X110-1999", NULL, NULL } },
  { "ibm17584", { "UTF-16BE", NULL, NULL } },
  { "ibm17585", { "UTF-16BE", NULL, NULL } },
  { "ibm17586", { "UTF-16LE", NULL, NULL } },
  { "ibm17587", { "UTF-16LE", NULL, NULL } },
  { "ibm17592", { "UTF-8", NULL, NULL } },
  { "ibm17593", { "UTF-8", NULL, NULL } },
  { "ibm20780", { "ibm-16684_P110-2003", NULL, NULL } },
  { "ibm21344", { "ibm-21344_P101-2000", NULL, NULL } },
  { "ibm21344p1012000", { "ibm-21344_P101-2000", NULL, NULL } },
  { "ibm21427", { "ibm-21427_P100-1999", NULL, NULL } },
  { "ibm21427p1001999", { "ibm-21427_P100-1999", NULL, NULL } },
  { "ibm21680", { "UTF-16BE", NULL, NULL } },
  { "ibm21681", { "UTF-16BE", NULL, NULL } },
  { "ibm21682", { "UTF-16LE", NULL, NULL } },
  { "ibm21683", { "UTF-16LE", NULL, NULL } },
  { "ibm25546", { "ISO_2022,locale=ko,version=1", NULL, NULL } },
  { "ibm256", { "ibm-256_P100-1995", NULL, NULL } },
  { "ibm256p1001995", { "ibm-256_P100-1995", NULL, NULL } },
  { "ibm25776", { "UTF-16BE", NULL, NULL } },
  { "ibm25777", { "UTF-16BE", NULL, NULL } },
  { "ibm25778", { "UTF-16LE", NULL, NULL } },
  { "ibm25779", { "UTF-16LE", NULL, NULL } },
  { "ibm259", { "ibm-259_P100-1995", NULL, NULL } },
  { "ibm259p1001995", { "ibm-259_P100-1995", NULL, NULL } },
  { "ibm273", { "ibm-273_P100-1995", NULL, NULL } },
  { "ibm273p1001995", { "ibm-273_P100-1995", NULL, NULL } },
  { "ibm274", { "ibm-274_P100-2000", NULL, NULL } },
  { "ibm274p1002000", { "ibm-274_P100-2000", NULL, NULL } },
  { "ibm275", { "ibm-275_P100-1995", NULL, NULL } },
  { "ibm275p1001995", { "ibm-275_P100-1995", NULL, NULL } },
  { "ibm277", { "ibm-277_P100-1995", NULL, NULL } },
  { "ibm277p1001995", { "ibm-277_P100-1995", NULL, NULL } },
  { "ibm278", { "ibm-278_P100-1995", NULL, NULL } },
  { "ibm278p1001995", { "ibm-278_P100-1995", NULL, NULL } },
  { "ibm280", { "ibm-280_P100-1995", NULL, NULL } },
  { "ibm280p1001995", { "ibm-280_P100-1995", NULL, NULL } },
  { "ibm284", { "ibm-284_P100-1995", NULL, NULL } },
  { "ibm284p1001995", { "ibm-284_P100-1995", NULL, NULL } },
  { "ibm285", { "ibm-285_P100-1995", NULL, NULL } },
  { "ibm285p1001995", { "ibm-285_P100-1995", NULL, NULL } },
  { "ibm286", { "ibm-286_P100-2003", NULL, NULL } },
  { "ibm286p1002003", { "ibm-286_P100-2003", NULL, NULL } },
  { "ibm290", { "ibm-290_P100-1995", NULL, NULL } },
  { "ibm290p1001995", { "ibm-290_P100-1995", NULL, NULL } },
  { "ibm293", { "ibm-293_P100-1995", NULL, NULL } },
  { "ibm293p1001995", { "ibm-293_P100-1995", NULL, NULL } },
  { "ibm297", { "ibm-297_P100-1995", NULL, NULL } },
  { "ibm297p1001995", { "ibm-297_P100-1995", NULL, NULL } },
  { "ibm29872", { "UTF-16BE", NULL, NULL } },
  { "ibm29873", { "UTF-16BE", NULL, NULL } },
  { "ibm29874", { "UTF-16LE", NULL, NULL } },
  { "ibm29875", { "UTF-16LE", NULL, NULL } },
  { "ibm300", { "ibm-300_P120-2006", NULL, NULL } },
  { "ibm300p1202006", { "ibm-300_P120-2006", NULL, NULL } },
  { "ibm301", { "ibm-301_P110-1997", NULL, NULL } },
  { "ibm301p1101997", { "ibm-301_P110-1997", NULL, NULL } },
  { "ibm33058", { "ibm-33058_P100-2000", NULL, NULL } },
  { "ibm33058p1002000", { "ibm-33058_P100-2000", NULL, NULL } },
  { "ibm33722", { "ibm-33722_P12A_P12A-2009_U2", "ibm-33722_P120-1999", NULL } },
  { "ibm33722p1201999", { "ibm-33722_P120-1999", NULL, NULL } },
  { "ibm33722p12ap12a2009u2", { "ibm-33722_P12A_P12A-2009_U2", NULL, NULL } },
  { "ibm33722vasciivpua", { "ibm-33722_P120-1999", NULL, NULL } },
  { "ibm33722vpua", { "ibm-33722_P12A_P12A-2009_U2", NULL, NULL } },
  { "ibm367", { "US-ASCII", NULL, NULL } },
  { "ibm37", { "ibm-37_P100-1995", NULL, NULL } },
  { "ibm37p1001995", { "ibm-37_P100-1995", NULL, NULL } },
  { "ibm37p1001995,swaplfnl", { "ibm-37_P100-1995,swaplfnl", NULL, NULL } },
  { "ibm37s390", { "ibm-37_P100-1995,swaplfnl", NULL, NULL } },
  { "ibm420", { "ibm-420_X120-1999", NULL, NULL } },
  { "ibm420x1201999", { "ibm-420_X120-1999", NULL, NULL } },
  { "ibm424", { "ibm-424_P100-1995", NULL, NULL } },
  { "ibm424p1001995", { "ibm-424_P100-1995", NULL, NULL } },
  { "ibm425", { "ibm-425_P101-2000", NULL, NULL } },
  { "ibm425p1012000", { "ibm-425_P101-2000", NULL, NULL } },
  { "ibm437", { "ibm-437_P100-1995", NULL, NULL } },
  { "ibm437p1001995", { "ibm-437_P100-1995", NULL, NULL } },
  { "ibm4517", { "ibm-4517_P100-2005", NULL, NULL } },
  { "ibm4517p1002005", { "ibm-4517_P100-2005", NULL, NULL } },
  { "ibm4899", { "ibm-4899_P100-1998", NULL, NULL } },
  { "ibm4899p1001998", { "ibm-4899_P100-1998", NULL, NULL } },
  { "ibm4902", { "ISCII,version=0", NULL, NULL } },
  { "ibm4909", { "ibm-4909_P100-1999", NULL, NULL } },
  { "ibm4909p1001999", { "ibm-4909_P100-1999", NULL, NULL } },
  { "ibm4930", { "ibm-4930_P110-1999", NULL, NULL } },
  { "ibm4930p1101999", { "ibm-4930_P110-1999", NULL, NULL } },
  { "ibm4933", { "ibm-4933_P100-2002", NULL, NULL } },
  { "ibm4933p1002002", { "ibm-4933_P100-2002", NULL, NULL } },
  { "ibm4948", { "ibm-4948_P100-1995", NULL, NULL } },
  { "ibm4948p1001995", { "ibm-4948_P100-1995", NULL, NULL } },
  { "ibm4951", { "ibm-4951_P100-1995", NULL, NULL } },
  { "ibm4951p1001995", { "ibm-4951_P100-1995", NULL, NULL } },
  { "ibm4952", { "ibm-4952_P100-1995", NULL, NULL } },
  { "ibm4952p1001995", { "ibm-4952_P100-1995", NULL, NULL } },
  { "ibm4960", { "ibm-4960_P100-1995", NULL, NULL } },
  { "ibm4960p1001995", { "ibm-4960_P100-1995", NULL, NULL } },
  { "ibm4971", { "ibm-4971_P100-1999", NULL, NULL } },
  { "ibm4971p1001999", { "ibm-4971_P100-1999", NULL, NULL } },
  { "ibm500", { "ibm-500_P100-1995", NULL, NULL } },
  { "ibm500p1001995", { "ibm-500_P100-1995", NULL, NULL } },
  { "ibm5012", { "ibm-5012_P100-1999", NULL, NULL } },
  { "ibm5012p1001999", { "ibm-5012_P100-1999", NULL, NULL } },
  { "ibm5026", { "ibm-930_P120-1999", NULL, NULL } },
  { "ibm5035", { "ibm-939_P120-1999", NULL, NULL } },
  { "ibm5039", { "ibm-5039_P11A-1998", NULL, NULL } },
  { "ibm5039p11a1998", { "ibm-5039_P11A-1998", NULL, NULL } },
  { "ibm5048", { "ibm-5048_P100-1995", NULL, NULL } },
  { "ibm5048p1001995", { "ibm-5048_P100-1995", NULL, NULL } },
  { "ibm5049", { "ibm-5049_P100-1995", NULL, NULL } },
  { "ibm5049p1001995", { "ibm-5049_P100-1995", NULL, NULL } },
  { "ibm5050", { "ibm-33722_P12A_P12A-2009_U2", "ibm-33722_P120-1999", NULL } },
  { "ibm5054", { "ISO_2022,locale=ja,version=1", NULL, NULL } },
  { "ibm5067", { "ibm-5067_P100-1995", NULL, NULL } },
  { "ibm5067p1001995", { "ibm-5067_P100-1995", NULL, NULL } },
  { "ibm5104", { "ibm-5104_X110-1999", NULL, NULL } },
  { "ibm5104x1101999", { "ibm-5104_X110-1999", NULL, NULL } },
  { "ibm5123", { "ibm-5123_P100-1999", NULL, NULL } },
  { "ibm5123p1001999", { "ibm-5123_P100-1999", NULL, NULL } },
  { "ibm5233", { "ibm-5233_P100-2011", NULL, NULL } },
  { "ibm5233p1002011", { "ibm-5233_P100-2011", NULL, NULL } },
  { "ibm5304", { "UTF-8", NULL, NULL } },
  { "ibm5305", { "UTF-8", NULL, NULL } },
  { "ibm5346", { "ibm-5346_P100-1998", NULL, NULL } },
  { "ibm5346p1001998", { "ibm-5346_P100-1998", NULL, NULL } },
  { "ibm5347", { "ibm-5347_P100-1998", NULL, NULL } },
  { "ibm5347p1001998", { "ibm-5347_P100-1998", NULL, NULL } },
  { "ibm5348", { "ibm-5348_P100-1997", NULL, NULL } },
  { "ibm5348p1001997", { "ibm-5348_P100-1997", NULL, NULL } },
  { "ibm5349", { "ibm-5349_P100-1998", NULL, NULL } },
  { "ibm5349p1001998", { "ibm-5349_P100-1998", NULL, NULL } },
  { "ibm5350", { "ibm-5350_P100-1998", NULL, NULL } },
  { "ibm5350p1001998", { "ibm-5350_P100-1998", NULL, NULL } },
  { "ibm5351", { "ibm-5351_P100-1998", NULL, NULL } },
  { "ibm5351p1001998", { "ibm-5351_P100-1998", NULL, NULL } },
  { "ibm5352", { "ibm-5352_P100-1998", NULL, NULL } },
  { "ibm5352p1001998", { "ibm-5352_P100-1998", NULL, NULL } },
  { "ibm5353", { "ibm-5353_P100-1998", NULL, NULL } },
  { "ibm5353p1001998", { "ibm-5353_P100-1998", NULL, NULL } },
  { "ibm5354", { "ibm-5354_P100-1998", NULL, NULL } },
  { "ibm5354p1001998", { "ibm-5354_P100-1998", NULL, NULL } },
  { "ibm5471", { "ibm-5471_P100-2006", NULL, NULL } },
  { "ibm5471p1002006", { "ibm-5471_P100-2006", NULL, NULL } },
  { "ibm5478", { "ibm-5478_P100-1995", NULL, NULL } },
  { "ibm5478p1001995", { "ibm-5478_P100-1995", NULL, NULL } },
  { "ibm61955", { "UTF-16BE", NULL, NULL } },
  { "ibm61956", { "UTF-16BE", NULL, NULL } },
  { "ibm65025", { "LMBCS-1", NULL, NULL } },
  { "ibm720", { "ibm-720_P100-1997", NULL, NULL } },
  { "ibm720p1001997", { "ibm-720_P100-1997", NULL, NULL } },
  { "ibm737", { "ibm-737_P100-1997", NULL, NULL } },
  { "ibm737p1001997", { "ibm-737_P100-1997", NULL, NULL } },
  { "ibm775", { "ibm-775_P100-1996", NULL, NULL } },
  { "ibm775p1001996", { "ibm-775_P100-1996", NULL, NULL } },
  { "ibm803", { "ibm-803_P100-1999", NULL, NULL } },
  { "ibm803p1001999", { "ibm-803_P100-1999", NULL, NULL } },
  { "ibm806", { "ibm-806_P100-1998", NULL, NULL } },
  { "ibm806p1001998", { "ibm-806_P100-1998", NULL, NULL } },
  { "ibm808", { "ibm-808_P100-1999", NULL, NULL } },
  { "ibm808p1001999", { "ibm-808_P100-1999", NULL, NULL } },
  { "ibm813", { "ibm-813_P100-1995", NULL, NULL } },
  { "ibm813p1001995", { "ibm-813_P100-1995", NULL, NULL } },
  { "ibm819", { "ISO-8859-1", NULL, NULL } },
  { "ibm833", { "ibm-833_P100-1995", NULL, NULL } },
  { "ibm833p1001995", { "ibm-833_P100-1995", NULL, NULL } },
  { "ibm834", { "ibm-834_P100-1995", NULL, NULL } },
  { "ibm834p1001995", { "ibm-834_P100-1995", NULL, NULL } },
  { "ibm835", { "ibm-835_P100-1995", NULL, NULL } },
  { "ibm835p1001995", { "ibm-835_P100-1995", NULL, NULL } },
  { "ibm836", { "ibm-836_P100-1995", NULL, NULL } },
  { "ibm836p1001995", { "ibm-836_P100-1995", NULL, NULL } },
  { "ibm837", { "ibm-837_P100-2011", NULL, NULL } },
  { "ibm837p1002011", { "ibm-837_P100-2011", NULL, NULL } },
  { "ibm838", { "ibm-838_P100-1995", NULL, NULL } },
  { "ibm838p1001995", { "ibm-838_P100-1995", NULL, NULL } },
  { "ibm848", { "ibm-848_P100-1999", NULL, NULL } },
  { "ibm8482", { "ibm-8482_P100-1999", NULL, NULL } },
  { "ibm8482p1001999", { "ibm-8482_P100-1999", NULL, NULL } },
  { "ibm848p1001999", { "ibm-848_P100-1999", NULL, NULL } },
  { "ibm849", { "ibm-849_P100-1999", NULL, NULL } },
  { "ibm849p1001999", { "ibm-849_P100-1999", NULL, NULL } },
  { "ibm850", { "ibm-850_P100-1995", NULL, NULL } },
  { "ibm850p1001995", { "ibm-850_P100-1995", NULL, NULL } },
  { "ibm851", { "ibm-851_P100-1995", NULL, NULL } },
  { "ibm851p1001995", { "ibm-851_P100-1995", NULL, NULL } },
  { "ibm852", { "ibm-852_P100-1995", NULL, NULL } },
  { "ibm852p1001995", { "ibm-852_P100-1995", NULL, NULL } },
  { "ibm855", { "ibm-855_P100-1995", NULL, NULL } },
  { "ibm855p1001995", { "ibm-855_P100-1995", NULL, NULL } },
  { "ibm856", { "ibm-856_P100-1995", NULL, NULL } },
  { "ibm856p1001995", { "ibm-856_P100-1995", NULL, NULL } },
  { "ibm857", { "ibm-857_P100-1995", NULL, NULL } },
  { "ibm857p1001995", { "ibm-857_P100-1995", NULL, NULL } },
  { "ibm858", { "ibm-858_P100-1997", NULL, NULL } },
  { "ibm858p1001997", { "ibm-858_P100-1997", NULL, NULL } },
  { "ibm859", { "ibm-859_P100-1999", NULL, NULL } },
  { "ibm859p1001999", { "ibm-859_P100-1999", NULL, NULL } },
  { "ibm860", { "ibm-860_P100-1995", NULL, NULL } },
  { "ibm860p1001995", { "ibm-860_P100-1995", NULL, NULL } },
  { "ibm861", { "ibm-861_P100-1995", NULL, NULL } },
  { "ibm8612", { "ibm-8612_P100-1995", NULL, NULL } },
  { "ibm8612p1001995", { "ibm-8612_P100-1995", NULL, NULL } },
  { "ibm861p1001995", { "ibm-861_P100-1995", NULL, NULL } },
  { "ibm862", { "ibm-862_P100-1995", NULL, NULL } },
  { "ibm862p1001995", { "ibm-862_P100-1995", NULL, NULL } },
  { "ibm863", { "ibm-863_P100-1995", NULL, NULL } },
  { "ibm863p1001995", { "ibm-863_P100-1995", NULL, NULL } },
  { "ibm864", { "ibm-864_X110-1999", NULL, NULL } },
  { "ibm864s", { "windows-864-2000", NULL, NULL } },
  { "ibm864x1101999", { "ibm-864_X110-1999", NULL, NULL } },
  { "ibm865", { "ibm-865_P100-1995", NULL, NULL } },
  { "ibm865p1001995", { "ibm-865_P100-1995", NULL, NULL } },
  { "ibm866", { "ibm-866_P100-1995", NULL, NULL } },
  { "ibm866p1001995", { "ibm-866_P100-1995", NULL, NULL } },
  { "ibm867", { "ibm-867_P100-1998", NULL, NULL } },
  { "ibm867p1001998", { "ibm-867_P100-1998", NULL, NULL } },
  { "ibm868", { "ibm-868_P100-1995", NULL, NULL } },
  { "ibm868p1001995", { "ibm-868_P100-1995", NULL, NULL } },
  { "ibm869", { "ibm-869_P100-1995", NULL, NULL } },
  { "ibm869p1001995", { "ibm-869_P100-1995", NULL, NULL } },
  { "ibm870", { "ibm-870_P100-1995", NULL, NULL } },
  { "ibm870p1001995", { "ibm-870_P100-1995", NULL, NULL } },
  { "ibm871", { "ibm-871_P100-1995", NULL, NULL } },
  { "ibm871p1001995", { "ibm-871_P100-1995", NULL, NULL } },
  { "ibm872", { "ibm-872_P100-1999", NULL, NULL } },
  { "ibm872p1001999", { "ibm-872_P100-1999", NULL, NULL } },
  { "ibm874", { "ibm-874_P100-1995", NULL, NULL } },
  { "ibm874p1001995", { "ibm-874_P100-1995", NULL, NULL } },
  { "ibm875", { "ibm-875_P100-1995", NULL, NULL } },
  { "ibm875p1001995", { "ibm-875_P100-1995", NULL, NULL } },
  { "ibm878", { "ibm-878_P100-1996", NULL, NULL } },
  { "ibm878p1001996", { "ibm-878_P100-1996", NULL, NULL } },
  { "ibm880", { "ibm-880_P100-1995", NULL, NULL } },
  { "ibm880p1001995", { "ibm-880_P100-1995", NULL, NULL } },
  { "ibm896", { "ibm-896_P100-1995", NULL, NULL } },
  { "ibm896p1001995", { "ibm-896_P100-1995", NULL, NULL } },
  { "ibm897", { "ibm-897_P100-1995", NULL, NULL } },
  { "ibm897p1001995", { "ibm-897_P100-1995", NULL, NULL } },
  { "ibm9005", { "ibm-9005_X110-2007", NULL, NULL } },
  { "ibm9005x1102007", { "ibm-9005_X110-2007", NULL, NULL } },
  { "ibm901", { "ibm-901_P100-1999", NULL, NULL } },
  { "ibm901p1001999", { "ibm-901_P100-1999", NULL, NULL } },
  { "ibm902", { "ibm-902_P100-1999", NULL, NULL } },
  { "ibm9027", { "ibm-9027_P100-1999", NULL, NULL } },
  { "ibm9027p1001999", { "ibm-9027_P100-1999", NULL, NULL } },
  { "ibm902p1001999", { "ibm-902_P100-1999", NULL, NULL } },
  { "ibm9030", { "ibm-838_P100-1995", NULL, NULL } },
  { "ibm9048", { "ibm-9048_P100-1998", NULL, NULL } },
  { "ibm9048p1001998", { "ibm-9048_P100-1998", NULL, NULL } },
  { "ibm905", { "ibm-905_P100-1995", NULL, NULL } },
  { "ibm9056", { "ibm-9056_P100-1995", NULL, NULL } },
  { "ibm9056p1001995", { "ibm-9056_P100-1995", NULL, NULL } },
  { "ibm905p1001995", { "ibm-905_P100-1995", NULL, NULL } },
  { "ibm9061", { "ibm-9061_P100-1999", NULL, NULL } },
  { "ibm9061p1001999", { "ibm-9061_P100-1999", NULL, NULL } },
  { "ibm9066", { "ibm-874_P100-1995", NULL, NULL } },
  { "ibm9067", { "ibm-9067_X100-2005", NULL, NULL } },
  { "ibm9067x1002005", { "ibm-9067_X100-2005", NULL, NULL } },
  { "ibm912", { "ibm-912_P100-1995", NULL, NULL } },
  { "ibm912p1001995", { "ibm-912_P100-1995", NULL, NULL } },
  { "ibm913", { "ibm-913_P100-2000", NULL, NULL } },
  { "ibm913p1002000", { "ibm-913_P100-2000", NULL, NULL } },
  { "ibm914", { "ibm-914_P100-1995", NULL, NULL } },
  { "ibm9145", { "ibm-9145_P110-1997", NULL, NULL } },
  { "ibm9145p1101997", { "ibm-9145_P110-1997", NULL, NULL } },
  { "ibm914p1001995", { "ibm-914_P100-1995", NULL, NULL } },
  { "ibm915", { "ibm-915_P100-1995", NULL, NULL } },
  { "ibm915p1001995", { "ibm-915_P100-1995", NULL, NULL } },
  { "ibm916", { "ibm-916_P100-1995", NULL, NULL } },
  { "ibm916p1001995", { "ibm-916_P100-1995", NULL, NULL } },
  { "ibm918", { "ibm-918_P100-1995", NULL, NULL } },
  { "ibm918p1001995", { "ibm-918_P100-1995", NULL, NULL } },
  { "ibm920", { "ibm-920_P100-1995", NULL, NULL } },
  { "ibm920p1001995", { "ibm-920_P100-1995", NULL, NULL } },
  { "ibm921", { "ibm-921_P100-1995", NULL, NULL } },
  { "ibm921p1001995", { "ibm-921_P100-1995", NULL, NULL } },
  { "ibm922", { "ibm-922_P100-1999", NULL, NULL } },
  { "ibm922p1001999", { "ibm-922_P100-1999", NULL, NULL } },
  { "ibm923", { "ibm-923_P100-1998", NULL, NULL } },
  { "ibm9238", { "ibm-9238_X110-1999", NULL, NULL } },
  { "ibm9238x1101999", { "ibm-9238_X110-1999", NULL, NULL } },
  { "ibm923p1001998", { "ibm-923_P100-1998", NULL, NULL } },
  { "ibm924", { "ibm-924_P100-1998", NULL, NULL } },
  { "ibm924lf", { "ibm-924_P100-1998,swaplfnl", NULL, NULL } },
  { "ibm924p1001998", { "ibm-924_P100-1998", NULL, NULL } },
  { "ibm924p1001998,swaplfnl", { "ibm-924_P100-1998,swaplfnl", NULL, NULL } },
  { "ibm924s390", { "ibm-924_P100-1998,swaplfnl", NULL, NULL } },
  { "ibm926", { "ibm-926_P100-2000", NULL, NULL } },
  { "ibm926p1002000", { "ibm-926_P100-2000", NULL, NULL } },
  { "ibm927", { "ibm-927_P100-1995", NULL, NULL } },
  { "ibm927p1001995", { "ibm-927_P100-1995", NULL, NULL } },
  { "ibm928", { "ibm-928_P100-1995", NULL, NULL } },
  { "ibm928p1001995", { "ibm-928_P100-1995", NULL, NULL } },
  { "ibm930", { "ibm-930_P120-1999", NULL, NULL } },
  { "ibm930p1201999", { "ibm-930_P120-1999", NULL, NULL } },
  { "ibm931", { "ibm-939_P120-1999", NULL, NULL } },
  { "ibm932", { "ibm-942_P12A-1999", NULL, NULL } },
  { "ibm932vsubvpua", { "ibm-942_P12A-1999", NULL, NULL } },
  { "ibm933", { "ibm-933_P110-1995", NULL, NULL } },
  { "ibm933p1101995", { "ibm-933_P110-1995", NULL, NULL } },
  { "ibm935", { "ibm-935_P110-1999", NULL, NULL } },
  { "ibm935p1101999", { "ibm-935_P110-1999", NULL, NULL } },
  { "ibm937", { "ibm-937_P110-1999", NULL, NULL } },
  { "ibm937p1101999", { "ibm-937_P110-1999", NULL, NULL } },
  { "ibm939", { "ibm-939_P120-1999", NULL, NULL } },
  { "ibm939p1201999", { "ibm-939_P120-1999", NULL, NULL } },
  { "ibm9400", { "CESU-8", NULL, NULL } },
  { "ibm941", { "ibm-941_P13A-2001", NULL, NULL } },
  { "ibm941p13a2001", { "ibm-941_P13A-2001", NULL, NULL } },
  { "ibm942", { "ibm-942_P12A-1999", NULL, NULL } },
  { "ibm9424", { "UTF-32BE", NULL, NULL } },
  { "ibm942p12a1999", { "ibm-942_P12A-1999", NULL, NULL } },
  { "ibm942vsubvpua", { "ibm-942_P12A-1999", NULL, NULL } },
  { "ibm943", { "ibm-943_P15A-2003", "ibm-943_P130-1999", NULL } },
  { "ibm943c", { "ibm-943_P15A-2003", NULL, NULL } },
  { "ibm943p1301999", { "ibm-943_P130-1999", NULL, NULL } },
  { "ibm943p15a2003", { "ibm-943_P15A-2003", NULL, NULL } },
  { "ibm943vasciivsubvpua", { "ibm-943_P130-1999", NULL, NULL } },
  { "ibm943vsubvpua", { "ibm-943_P15A-2003", NULL, NULL } },
  { "ibm944", { "ibm-944_P100-1995", NULL, NULL } },
  { "ibm9447", { "ibm-9447_P100-2002", NULL, NULL } },
  { "ibm9447p1002002", { "ibm-9447_P100-2002", NULL, NULL } },
  { "ibm9448", { "ibm-9448_X100-2005", NULL, NULL } },
  { "ibm9448x1002005", { "ibm-9448_X100-2005", NULL, NULL } },
  { "ibm9449", { "ibm-9449_P100-2002", NULL, NULL } },
  { "ibm9449p1002002", { "ibm-9449_P100-2002", NULL, NULL } },
  { "ibm944p1001995", { "ibm-944_P100-1995", NULL, NULL } },
  { "ibm946", { "ibm-946_P100-1995", NULL, NULL } },
  { "ibm946p1001995", { "ibm-946_P100-1995", NULL, NULL } },
  { "ibm947", { "ibm-947_P100-1995", NULL, NULL } },
  { "ibm947p1001995", { "ibm-947_P100-1995", NULL, NULL } },
  { "ibm948", { "ibm-948_P110-1999", NULL, NULL } },
  { "ibm948p1101999", { "ibm-948_P110-1999", NULL, NULL } },
  { "ibm949", { "ibm-949_P110-1999", "ibm-949_P11A-1999", NULL } },
  { "ibm949c", { "ibm-949_P11A-1999", NULL, NULL } },
  { "ibm949p1101999", { "ibm-949_P110-1999", NULL, NULL } },
  { "ibm949p11a1999", { "ibm-949_P11A-1999", NULL, NULL } },
  { "ibm949vasciivsubvpua", { "ibm-949_P110-1999", NULL, NULL } },
  { "ibm949vsubvpua", { "ibm-949_P11A-1999", NULL, NULL } },
  { "ibm950", { "ibm-950_P110-1999", NULL, NULL } },
  { "ibm950p1101999", { "ibm-950_P110-1999", NULL, NULL } },
  { "ibm951", { "ibm-951_P100-1995", NULL, NULL } },
  { "ibm951p1001995", { "ibm-951_P100-1995", NULL, NULL } },
  { "ibm952", { "ibm-952_P110-1997", NULL, NULL } },
  { "ibm952p1101997", { "ibm-952_P110-1997", NULL, NULL } },
  { "ibm953", { "ibm-953_P100-2000", NULL, NULL } },
  { "ibm953p1002000", { "ibm-953_P100-2000", NULL, NULL } },
  { "ibm954", { "ibm-954_P101-2007", NULL, NULL } },
  { "ibm954p1012007", { "ibm-954_P101-2007", NULL, NULL } },
  { "ibm955", { "ibm-955_P110-1997", NULL, NULL } },
  { "ibm955p1101997", { "ibm-955_P110-1997", NULL, NULL } },
  { "ibm9577", { "ibm-9577_P100-2001", NULL, NULL } },
  { "ibm9577p1002001", { "ibm-9577_P100-2001", NULL, NULL } },
  { "ibm9580", { "ibm-1388_P103-2001", NULL, NULL } },
  { "ibm964", { "ibm-964_P110-1999", NULL, NULL } },
  { "ibm964p1101999", { "ibm-964_P110-1999", NULL, NULL } },
  { "ibm964vpua", { "ibm-964_P110-1999", NULL, NULL } },
  { "ibm970", { "ibm-970_P110_P110-2006_U2", NULL, NULL } },
  { "ibm970p110p1102006u2", { "ibm-970_P110_P110-2006_U2", NULL, NULL } },
  { "ibm970vpua", { "ibm-970_P110_P110-2006_U2", NULL, NULL } },
  { "ibm971", { "ibm-971_P100-1995", NULL, NULL } },
  { "ibm971p1001995", { "ibm-971_P100-1995", NULL, NULL } },
  { "ibm971vpua", { "ibm-971_P100-1995", NULL, NULL } },
  { "ibmeuccn", { "ibm-1383_P110-1999", NULL, NULL } },
  { "ibmeucjp", { "ibm-33722_P12A_P12A-2009_U2", NULL, NULL } },
  { "ibmeuckr", { "ibm-970_P110_P110-2006_U2", NULL, NULL } },
  { "ibmeuctw", { "ibm-964_P110-1999", NULL, NULL } },
  { "ibmsymbols", { "ibm-259_P100-1995", NULL, NULL } },
  { "ibmthai", { "ibm-838_P100-1995", NULL, NULL } },
  { "imapmailboxname", { "IMAP-mailbox-name", NULL, NULL } },
  { "iscii,version=0", { "ISCII,version=0", NULL, NULL } },
  { "iscii,version=1", { "ISCII,version=1", NULL, NULL } },
  { "iscii,version=2", { "ISCII,version=2", NULL, NULL } },
  { "iscii,version=3", { "ISCII,version=3", NULL, NULL } },
  { "iscii,version=4", { "ISCII,version=4", NULL, NULL } },
  { "iscii,version=5", { "ISCII,version=5", NULL, NULL } },
  { "iscii,version=6", { "ISCII,version=6", NULL, NULL } },
  { "iscii,version=7", { "ISCII,version=7", NULL, NULL } },
  { "iscii,version=8", { "ISCII,version=8", NULL, NULL } },
  { "isciibng", { "ISCII,version=1", NULL, NULL } },
  { "isciidev", { "ISCII,version=0", NULL, NULL } },
  { "isciiguj", { "ISCII,version=3", NULL, NULL } },
  { "isciigur", { "ISCII,version=2", NULL, NULL } },
  { "isciiknd", { "ISCII,version=7", NULL, NULL } },
  { "isciimlm", { "ISCII,version=8", NULL, NULL } },
  { "isciiori", { "ISCII,version=4", NULL, NULL } },
  { "isciitlg", { "ISCII,version=6", NULL, NULL } },
  { "isciitml", { "ISCII,version=5", NULL, NULL } },
  { "iso10646ucs2", { "UTF-16", NULL, NULL } },
  { "iso10646ucs4", { "UTF-32", NULL, NULL } },
  { "iso2022,locale=ja,version=0", { "ISO_2022,locale=ja,version=0", NULL, NULL } },
  { "iso2022,locale=ja,version=1", { "ISO_2022,locale=ja,version=1", NULL, NULL } },
  { "iso2022,locale=ja,version=2", { "ISO_2022,locale=ja,version=2", NULL, NULL } },
  { "iso2022,locale=ja,version=3", { "ISO_2022,locale=ja,version=3", NULL, NULL } },
  { "iso2022,locale=ja,version=4", { "ISO_2022,locale=ja,version=4", NULL, NULL } },
  { "iso2022,locale=ko,version=0", { "ISO_2022,locale=ko,version=0", NULL, NULL } },
  { "iso2022,locale=ko,version=1", { "ISO_2022,locale=ko,version=1", NULL, NULL } },
  { "iso2022,locale=zh,version=0", { "ISO_2022,locale=zh,version=0", NULL, NULL } },
  { "iso2022,locale=zh,version=1", { "ISO_2022,locale=zh,version=1", NULL, NULL } },
  { "iso2022,locale=zh,version=2", { "ISO_2022,locale=zh,version=2", NULL, NULL } },
  { "iso2022cn", { "ISO_2022,locale=zh,version=0", NULL, NULL } },
  { "iso2022cncns", { "ISO_2022,locale=zh,version=2", NULL, NULL } },
  { "iso2022cnext", { "ISO_2022,locale=zh,version=1", NULL, NULL } },
  { "iso2022jp", { "ISO_2022,locale=ja,version=0", NULL, NULL } },
  { "iso2022jp1", { "ISO_2022,locale=ja,version=1", NULL, NULL } },
  { "iso2022jp2", { "ISO_2022,locale=ja,version=2", NULL, NULL } },
  { "iso2022kr", { "ISO_2022,locale=ko,version=0", NULL, NULL } },
  { "iso646.irv:1983", { "US-ASCII", NULL, NULL } },
  { "iso646.irv:1991", { "US-ASCII", NULL, NULL } },
  { "iso646ca", { "ibm-1020_P100-2003", NULL, NULL } },
  { "iso646de", { "ibm-1011_P100-1995", NULL, NULL } },
  { "iso646dk", { "ibm-1107_P100-2003", NULL, NULL } },
  { "iso646es", { "ibm-1023_P100-2003", NULL, NULL } },
  { "iso646es2", { "ibm-1014_P100-1995", NULL, NULL } },
  { "iso646fi", { "ibm-1018_P100-1995", NULL, NULL } },
  { "iso646fr", { "ibm-1010_P100-1995", NULL, NULL } },
  { "iso646fr1", { "ibm-1104_P100-2003", NULL, NULL } },
  { "iso646gb", { "ibm-1013_P100-1995", NULL, NULL } },
  { "iso646it", { "ibm-1012_P100-1995", NULL, NULL } },
  { "iso646no", { "ibm-1016_P100-1995", NULL, NULL } },
  { "iso646pt2", { "ibm-1015_P100-1995", NULL, NULL } },
  { "iso646se", { "ibm-1018_P100-1995", NULL, NULL } },
  { "iso646us", { "US-ASCII", NULL, NULL } },
  { "iso88591", { "ISO-8859-1", NULL, NULL } },
  { "iso885910", { "iso-8859_10-1998", NULL, NULL } },
  { "iso8859101998", { "iso-8859_10-1998", NULL, NULL } },
  { "iso885910:1992", { "iso-8859_10-1998", NULL, NULL } },
  { "iso885911", { "iso-8859_11-2001", NULL, NULL } },
  { "iso8859112001", { "iso-8859_11-2001", NULL, NULL } },
  { "iso885913", { "ibm-921_P100-1995", NULL, NULL } },
  { "iso885914", { "iso-8859_14-1998", NULL, NULL } },
  { "iso8859141998", { "iso-8859_14-1998", NULL, NULL } },
  { "iso885914:1998", { "iso-8859_14-1998", NULL, NULL } },
  { "iso885915", { "ibm-923_P100-1998", NULL, NULL } },
  { "iso885915fdis", { "ibm-923_P100-1998", NULL, NULL } },
  { "iso885916", { "iso-8859_16-2001", NULL, NULL } },
  { "iso8859162001", { "iso-8859_16-2001", NULL, NULL } },
  { "iso885916:2001", { "iso-8859_16-2001", NULL, NULL } },
  { "iso88591:1987", { "ISO-8859-1", NULL, NULL } },
  { "iso88592", { "ibm-912_P100-1995", NULL, NULL } },
  { "iso88592:1987", { "ibm-912_P100-1995", NULL, NULL } },
  { "iso88593", { "ibm-913_P100-2000", NULL, NULL } },
  { "iso88593:1988", { "ibm-913_P100-2000", NULL, NULL } },
  { "iso88594", { "ibm-914_P100-1995", NULL, NULL } },
  { "iso88594:1988", { "ibm-914_P100-1995", NULL, NULL } },
  { "iso88595", { "ibm-915_P100-1995", NULL, NULL } },
  { "iso88595:1988", { "ibm-915_P100-1995", NULL, NULL } },
  { "iso88596", { "ibm-1089_P100-1995", NULL, NULL } },
  { "iso88596:1987", { "ibm-1089_P100-1995", NULL, NULL } },
  { "iso88596e", { "ibm-1089_P100-1995", NULL, NULL } },
  { "iso88596i", { "ibm-1089_P100-1995", NULL, NULL } },
  { "iso88597", { "ibm-9005_X110-2007", NULL, NULL } },
  { "iso88597:1987", { "ibm-9005_X110-2007", NULL, NULL } },
  { "iso88598", { "ibm-5012_P100-1999", NULL, NULL } },
  { "iso88598:1988", { "ibm-5012_P100-1999", NULL, NULL } },
  { "iso88598e", { "ibm-5012_P100-1999", NULL, NULL } },
  { "iso88598i", { "ibm-5012_P100-1999", NULL, NULL } },
  { "iso88599", { "ibm-920_P100-1995", NULL, NULL } },
  { "iso88599:1989", { "ibm-920_P100-1995", NULL, NULL } },
  { "isoceltic", { "iso-8859_14-1998", NULL, NULL } },
  { "isoir10", { "ibm-1018_P100-1995", NULL, NULL } },
  { "isoir100", { "ISO-8859-1", NULL, NULL } },
  { "isoir101", { "ibm-912_P100-1995", NULL, NULL } },
  { "isoir109", { "ibm-913_P100-2000", NULL, NULL } },
  { "isoir110", { "ibm-914_P100-1995", NULL, NULL } },
  { "isoir121", { "ibm-1020_P100-2003", NULL, NULL } },
  { "isoir126", { "ibm-9005_X110-2007", NULL, NULL } },
  { "isoir127", { "ibm-1089_P100-1995", NULL, NULL } },
  { "isoir138", { "ibm-5012_P100-1999", NULL, NULL } },
  { "isoir144", { "ibm-915_P100-1995", NULL, NULL } },
  { "isoir148", { "ibm-920_P100-1995", NULL, NULL } },
  { "isoir149", { "ibm-1363_P11B-1998", "windows-949-2000", NULL } },
  { "isoir15", { "ibm-1012_P100-1995", NULL, NULL } },
  { "isoir157", { "iso-8859_10-1998", NULL, NULL } },
  { "isoir17", { "ibm-1023_P100-2003", NULL, NULL } },
  { "isoir199", { "iso-8859_14-1998", NULL, NULL } },
  { "isoir21", { "ibm-1011_P100-1995", NULL, NULL } },
  { "isoir226", { "iso-8859_16-2001", NULL, NULL } },
  { "isoir25", { "ibm-1104_P100-2003", NULL, NULL } },
  { "isoir4", { "ibm-1013_P100-1995", NULL, NULL } },
  { "isoir58", { "ibm-5478_P100-1995", NULL, NULL } },
  { "isoir6", { "US-ASCII", NULL, NULL } },
  { "isoir60", { "ibm-1016_P100-1995", NULL, NULL } },
  { "isoir69", { "ibm-1010_P100-1995", NULL, NULL } },
  { "isoir84", { "ibm-1015_P100-1995", NULL, NULL } },
  { "isoir85", { "ibm-1014_P100-1995", NULL, NULL } },
  { "it", { "ibm-1012_P100-1995", NULL, NULL } },
  { "javacp1390a1.6p", { "java-Cp1390A-1.6_P", NULL, NULL } },
  { "javacp1399a1.6p", { "java-Cp1399A-1.6_P", NULL, NULL } },
  { "javacp420s1.6p", { "java-Cp420s-1.6_P", NULL, NULL } },
  { "javaeucjplinux1.6p", { "java-euc_jp_linux-1.6_P", NULL, NULL } },
  { "javasjis02131.6p", { "java-sjis_0213-1.6_P", NULL, NULL } },
  { "jis", { "ISO_2022,locale=ja,version=1", NULL, NULL } },
  { "jis7", { "ISO_2022,locale=ja,version=3", NULL, NULL } },
  { "jis8", { "ISO_2022,locale=ja,version=4", NULL, NULL } },
  { "jisencoding", { "ISO_2022,locale=ja,version=1", NULL, NULL } },
  { "jisx0201", { "ibm-897_P100-1995", NULL, NULL } },
  { "jisx02121990", { "ibm-953_P100-2000", NULL, NULL } },
  { "johab", { "windows-1361-2000", NULL, NULL } },
  { "koi8", { "ibm-878_P100-1996", NULL, NULL } },
  { "koi8r", { "ibm-878_P100-1996", NULL, NULL } },
  { "koi8ru", { "ibm-1167_P100-2002", NULL, NULL } },
  { "koi8u", { "ibm-1168_P100-2002", NULL, NULL } },
  { "korean", { "ibm-1363_P11B-1998", "windows-949-2000", NULL } },
  { "ksc", { "ibm-1363_P11B-1998", NULL, NULL } },
  { "ksc5601", { "ibm-970_P110_P110-2006_U2", "ibm-1363_P11B-1998", "windows-949-2000" } },
  { "ksc56011987", { "ibm-970_P110_P110-2006_U2", "ibm-1363_P11B-1998", "windows-949-2000" } },
  { "ksc56011989", { "ibm-1363_P11B-1998", "windows-949-2000", NULL } },
  { "ksc56011992", { "windows-1361-2000", NULL, NULL } },
  { "kz1048", { "ibm-1174_X100-2007", NULL, NULL } },
  { "l1", { "ISO-8859-1", NULL, NULL } },
  { "l10", { "iso-8859_16-2001", NULL, NULL } },
  { "l2", { "ibm-912_P100-1995", NULL, NULL } },
  { "l3", { "ibm-913_P100-2000", NULL, NULL } },
  { "l4", { "ibm-914_P100-1995", NULL, NULL } },
  { "l5", { "ibm-920_P100-1995", NULL, NULL } },
  { "l6", { "iso-8859_10-1998", NULL, NULL } },
  { "l8", { "iso-8859_14-1998", NULL, NULL } },
  { "l9", { "ibm-923_P100-1998", NULL, NULL } },
  { "latin0", { "ibm-923_P100-1998", NULL, NULL } },
  { "latin1", { "ISO-8859-1", NULL, NULL } },
  { "latin10", { "iso-8859_16-2001", NULL, NULL } },
  { "latin2", { "ibm-912_P100-1995", NULL, NULL } },
  { "latin3", { "ibm-913_P100-2000", NULL, NULL } },
  { "latin4", { "ibm-914_P100-1995", NULL, NULL } },
  { "latin5", { "ibm-920_P100-1995", NULL, NULL } },
  { "latin6", { "iso-8859_10-1998", NULL, NULL } },
  { "latin8", { "iso-8859_14-1998", NULL, NULL } },
  { "latin9", { "ibm-923_P100-1998", NULL, NULL } },
  { "lmbcs", { "LMBCS-1", NULL, NULL } },
  { "lmbcs1", { "LMBCS-1", NULL, NULL } },
  { "mac", { "macos-0_2-10.2", NULL, NULL } },
  { "macarabic", { "macos-518-10.2", NULL, NULL } },
  { "macce", { "macos-29-10.2", NULL, NULL } },
  { "maccentraleurope", { "macos-29-10.2", NULL, NULL } },
  { "maccroatian", { "macos-36_2-10.2", NULL, NULL } },
  { "maccy", { "macos-7_3-10.2", NULL, NULL } },
  { "maccyrillic", { "macos-7_3-10.2", NULL, NULL } },
  { "macdingbat", { "macos-34-10.2", NULL, NULL } },
  { "macgr", { "macos-6_2-10.4", NULL, NULL } },
  { "machebrew", { "macos-1285-10.2", NULL, NULL } },
  { "maciceland", { "macos-37_5-10.2", NULL, NULL } },
  { "macintosh", { "macos-0_2-10.2", NULL, NULL } },
  { "macos0210.2", { "macos-0_2-10.2", NULL, NULL } },
  { "macos128510.2", { "macos-1285-10.2", NULL, NULL } },
  { "macos2110.5", { "macos-21-10.5", NULL, NULL } },
  { "macos2910.2", { "macos-29-10.2", NULL, NULL } },
  { "macos3310.5", { "macos-33-10.5", NULL, NULL } },
  { "macos3410.2", { "macos-34-10.2", NULL, NULL } },
  { "macos3510.2", { "macos-35-10.2", NULL, NULL } },
  { "macos36210.2", { "macos-36_2-10.2", NULL, NULL } },
  { "macos37510.2", { "macos-37_5-10.2", NULL, NULL } },
  { "macos38210.2", { "macos-38_2-10.2", NULL, NULL } },
  { "macos51810.2", { "macos-518-10.2", NULL, NULL } },
  { "macos6210.4", { "macos-6_2-10.4", NULL, NULL } },
  { "macos7310.2", { "macos-7_3-10.2", NULL, NULL } },
  { "macroman", { "macos-0_2-10.2", NULL, NULL } },
  { "macromania", { "macos-38_2-10.2", NULL, NULL } },
  { "macsymbol", { "macos-33-10.5", NULL, NULL } },
  { "macthai", { "macos-21-10.5", NULL, NULL } },
  { "mactr", { "macos-35-10.2", NULL, NULL } },
  { "ms1361", { "windows-1361-2000", NULL, NULL } },
  { "ms874", { "windows-874-2000", NULL, NULL } },
  { "ms932", { "ibm-943_P15A-2003", NULL, NULL } },
  { "ms936", { "windows-936-2000", NULL, NULL } },
  { "ms949", { "windows-949-2000", NULL, NULL } },
  { "ms950", { "windows-950-2000", NULL, NULL } },
  { "ms950hkscs", { "ibm-5471_P100-2006", NULL, NULL } },
  { "mskanji", { "ibm-943_P15A-2003", NULL, NULL } },
  { "nfz62010", { "ibm-1010_P100-1995", NULL, NULL } },
  { "nfz620101973", { "ibm-1104_P100-2003", NULL, NULL } },
  { "no", { "ibm-1016_P100-1995", NULL, NULL } },
  { "ns45511", { "ibm-1016_P100-1995", NULL, NULL } },
  { "pck", { "ibm-943_P15A-2003", NULL, NULL } },
  { "pcmultilingual850+euro", { "ibm-858_P100-1997", NULL, NULL } },
  { "pt154", { "glibc-PT154-2.3.3", NULL, NULL } },
  { "pt2", { "ibm-1015_P100-1995", NULL, NULL } },
  { "ptcp154", { "glibc-PT154-2.3.3", NULL, NULL } },
  { "r8", { "ibm-1051_P100-1995", NULL, NULL } },
  { "rk1048", { "ibm-1174_X100-2007", NULL, NULL } },
  { "roman8", { "ibm-1051_P100-1995", NULL, NULL } },
  { "scsu", { "SCSU", NULL, NULL } },
  { "se", { "ibm-1018_P100-1995", NULL, NULL } },
  { "sen850200b", { "ibm-1018_P100-1995", NULL, NULL } },
  { "shiftjis", { "ibm-943_P15A-2003", "ibm-943_P130-1999", NULL } },
  { "shiftjis78", { "ibm-942_P12A-1999", NULL, NULL } },
  { "sjis", { "ibm-943_P15A-2003", NULL, NULL } },
  { "sjis78", { "ibm-942_P12A-1999", NULL, NULL } },
  { "solariszhtwbig52.7", { "solaris-zh_TW_big5-2.7", NULL, NULL } },
  { "strk10482002", { "ibm-1174_X100-2007", NULL, NULL } },
  { "suneugreek", { "ibm-9005_X110-2007", NULL, NULL } },
  { "thai8", { "iso-8859_11-2001", NULL, NULL } },
  { "tis620", { "windows-874-2000", "ibm-874_P100-1995", NULL } },
  { "tis620.2533", { "ibm-874_P100-1995", NULL, NULL } },
  { "turkish", { "ibm-920_P100-1995", NULL, NULL } },
  { "turkish8", { "ibm-920_P100-1995", NULL, NULL } },
  { "ucs2", { "UTF-16", NULL, NULL } },
  { "ucs4", { "UTF-32", NULL, NULL } },
  { "ujis", { "euc-jp-2007", NULL, NULL } },
  { "uk", { "ibm-1013_P100-1995", NULL, NULL } },
  { "unicode", { "UTF-16", NULL, NULL } },
  { "unicode11utf7", { "UTF-7", NULL, NULL } },
  { "unicode11utf8", { "UTF-8", NULL, NULL } },
  { "unicode20utf7", { "UTF-7", NULL, NULL } },
  { "unicode20utf8", { "UTF-8", NULL, NULL } },
  { "unicodebig", { "UTF-16BE,version=1", NULL, NULL } },
  { "unicodebigunmarked", { "UTF-16BE", NULL, NULL } },
  { "unicodelittle", { "UTF-16LE,version=1", NULL, NULL } },
  { "unicodelittleunmarked", { "UTF-16LE", NULL, NULL } },
  { "us", { "US-ASCII", NULL, NULL } },
  { "usascii", { "US-ASCII", NULL, NULL } },
  { "utf7", { "UTF-7", NULL, NULL } },
  { "x0201", { "ibm-897_P100-1995", NULL, NULL } },
  { "x11compoundtext", { "x11-compound-text", NULL, NULL } },
  { "xbig5", { "windows-950-2000", NULL, NULL } },
  { "xbig5solaris", { "solaris-zh_TW_big5-2.7", NULL, NULL } },
  { "xcompoundtext", { "x11-compound-text", NULL, NULL } },
  { "xeucjp", { "euc-jp-2007", NULL, NULL } },
  { "xeucjplinux", { "java-euc_jp_linux-1.6_P", NULL, NULL } },
  { "xeucjpopen", { "ibm-1350_P110-1997", NULL, NULL } },
  { "xibm1006", { "ibm-1006_P100-1995", NULL, NULL } },
  { "xibm1025", { "ibm-1025_P100-1995", NULL, NULL } },
  { "xibm1027", { "ibm-1027_P100-1995", NULL, NULL } },
  { "xibm1041", { "ibm-1041_P100-1995", NULL, NULL } },
  { "xibm1043", { "ibm-1043_P100-1995", NULL, NULL } },
  { "xibm1046", { "ibm-1046_X110-1999", NULL, NULL } },
  { "xibm1046s", { "ibm-1046_X110-1999", NULL, NULL } },
  { "xibm1088", { "ibm-1088_P100-1995", NULL, NULL } },
  { "xibm1097", { "ibm-1097_P100-1995", NULL, NULL } },
  { "xibm1098", { "ibm-1098_P100-1995", NULL, NULL } },
  { "xibm1112", { "ibm-1112_P100-1995", NULL, NULL } },
  { "xibm1114", { "ibm-1114_P100-2001", NULL, NULL } },
  { "xibm1115", { "ibm-1115_P100-1995", NULL, NULL } },
  { "xibm1122", { "ibm-1122_P100-1999", NULL, NULL } },
  { "xibm1123", { "ibm-1123_P100-1995", NULL, NULL } },
  { "xibm1124", { "ibm-1124_P100-1996", NULL, NULL } },
  { "xibm1153", { "ibm-1153_P100-1999", NULL, NULL } },
  { "xibm1351", { "ibm-1351_P110-1997", NULL, NULL } },
  { "xibm1362", { "ibm-1362_P110-1999", NULL, NULL } },
  { "xibm1363", { "ibm-1363_P110-1997", NULL, NULL } },
  { "xibm1363c", { "ibm-1363_P11B-1998", NULL, NULL } },
  { "xibm1364", { "ibm-1364_P110-2007", NULL, NULL } },
  { "xibm1370", { "ibm-1370_P100-1999", NULL, NULL } },
  { "xibm1371", { "ibm-1371_P100-1999", NULL, NULL } },
  { "xibm1380", { "ibm-1380_P100-1995", NULL, NULL } },
  { "xibm1381", { "ibm-1381_P110-1999", NULL, NULL } },
  { "xibm1382", { "ibm-1382_P100-1995", NULL, NULL } },
  { "xibm1385", { "ibm-9577_P100-2001", NULL, NULL } },
  { "xibm1388", { "ibm-1388_P103-2001", NULL, NULL } },
  { "xibm1390", { "ibm-1390_P110-2003", NULL, NULL } },
  { "xibm1390a", { "java-Cp1390A-1.6_P", NULL, NULL } },
  { "xibm1399", { "ibm-1399_P110-2003", NULL, NULL } },
  { "xibm1399a", { "java-Cp1399A-1.6_P", NULL, NULL } },
  { "xibm300", { "ibm-300_P120-2006", NULL, NULL } },
  { "xibm301", { "ibm-301_P110-1997", NULL, NULL } },
  { "xibm33722", { "ibm-33722_P120-1999", NULL, NULL } },
  { "xibm33722a", { "ibm-33722_P120-1999", NULL, NULL } },
  { "xibm33722c", { "ibm-33722_P120-1999", NULL, NULL } },
  { "xibm420s", { "java-Cp420s-1.6_P", NULL, NULL } },
  { "xibm720", { "ibm-720_P100-1997", NULL, NULL } },
  { "xibm737", { "ibm-737_P100-1997", NULL, NULL } },
  { "xibm808", { "ibm-808_P100-1999", NULL, NULL } },
  { "xibm833", { "ibm-833_P100-1995", NULL, NULL } },
  { "xibm834", { "ibm-834_P100-1995", NULL, NULL } },
  { "xibm835", { "ibm-835_P100-1995", NULL, NULL } },
  { "xibm836", { "ibm-836_P100-1995", NULL, NULL } },
  { "xibm837", { "ibm-837_P100-2011", NULL, NULL } },
  { "xibm856", { "ibm-856_P100-1995", NULL, NULL } },
  { "xibm859", { "ibm-859_P100-1999", NULL, NULL } },
  { "xibm864s", { "windows-864-2000", NULL, NULL } },
  { "xibm867", { "ibm-867_P100-1998", NULL, NULL } },
  { "xibm874", { "ibm-874_P100-1995", NULL, NULL } },
  { "xibm875", { "ibm-875_P100-1995", NULL, NULL } },
  { "xibm897", { "ibm-897_P100-1995", NULL, NULL } },
  { "xibm921", { "ibm-921_P100-1995", NULL, NULL } },
  { "xibm922", { "ibm-922_P100-1999", NULL, NULL } },
  { "xibm927", { "ibm-927_P100-1995", NULL, NULL } },
  { "xibm930", { "ibm-930_P120-1999", NULL, NULL } },
  { "xibm930a", { "ibm-930_P120-1999", NULL, NULL } },
  { "xibm933", { "ibm-933_P110-1995", NULL, NULL } },
  { "xibm935", { "ibm-935_P110-1999", NULL, NULL } },
  { "xibm937", { "ibm-937_P110-1999", NULL, NULL } },
  { "xibm939", { "ibm-939_P120-1999", NULL, NULL } },
  { "xibm939a", { "ibm-939_P120-1999", NULL, NULL } },
  { "xibm942", { "ibm-942_P12A-1999", NULL, NULL } },
  { "xibm942c", { "ibm-942_P12A-1999", NULL, NULL } },
  { "xibm943", { "ibm-943_P130-1999", NULL, NULL } },
  { "xibm947", { "ibm-947_P100-1995", NULL, NULL } },
  { "xibm948", { "ibm-948_P110-1999", NULL, NULL } },
  { "xibm949", { "ibm-949_P110-1999", NULL, NULL } },
  { "xibm949c", { "ibm-949_P11A-1999", NULL, NULL } },
  { "xibm950", { "ibm-950_P110-1999", NULL, NULL } },
  { "xibm951", { "ibm-951_P100-1995", NULL, NULL } },
  { "xibm954", { "ibm-954_P101-2007", NULL, NULL } },
  { "xibm954c", { "ibm-954_P101-2007", NULL, NULL } },
  { "xibm964", { "ibm-964_P110-1999", NULL, NULL } },
  { "xibm970", { "ibm-970_P110_P110-2006_U2", NULL, NULL } },
  { "xibm971", { "ibm-971_P100-1995", NULL, NULL } },
  { "xibmudcjp", { "aix-IBM_udcJP-4.3.6", NULL, NULL } },
  { "xiscii91", { "ISCII,version=0", NULL, NULL } },
  { "xisciias", { "ISCII,version=1", NULL, NULL } },
  { "xisciibe", { "ISCII,version=1", NULL, NULL } },
  { "xisciide", { "ISCII,version=0", NULL, NULL } },
  { "xisciigu", { "ISCII,version=3", NULL, NULL } },
  { "xisciika", { "ISCII,version=7", NULL, NULL } },
  { "xisciima", { "ISCII,version=8", NULL, NULL } },
  { "xisciior", { "ISCII,version=4", NULL, NULL } },
  { "xisciipa", { "ISCII,version=2", NULL, NULL } },
  { "xisciita", { "ISCII,version=5", NULL, NULL } },
  { "xisciite", { "ISCII,version=6", NULL, NULL } },
  { "xiso2022cncns", { "ISO_2022,locale=zh,version=2", NULL, NULL } },
  { "xiso2022cngb", { "ISO_2022,locale=zh,version=0", NULL, NULL } },
  { "xiso885911", { "iso-8859_11-2001", NULL, NULL } },
  { "xiso88596s", { "ibm-1089_P100-1995", NULL, NULL } },
  { "xjis0208", { "ibm-952_P110-1997", NULL, NULL } },
  { "xjisautodetect", { "ibm-943_P15A-2003", NULL, NULL } },
  { "xjohab", { "windows-1361-2000", NULL, NULL } },
  { "xkoi8ru", { "ibm-1167_P100-2002", NULL, NULL } },
  { "xksc5601", { "windows-949-2000", NULL, NULL } },
  { "xmacarabic", { "macos-518-10.2", NULL, NULL } },
  { "xmacce", { "macos-29-10.2", NULL, NULL } },
  { "xmaccentraleurope", { "macos-29-10.2", NULL, NULL } },
  { "xmaccentraleurroman", { "macos-29-10.2", NULL, NULL } },
  { "xmaccroatian", { "macos-36_2-10.2", NULL, NULL } },
  { "xmaccyrillic", { "macos-7_3-10.2", NULL, NULL } },
  { "xmacdingbat", { "macos-34-10.2", NULL, NULL } },
  { "xmacgreek", { "macos-6_2-10.4", NULL, NULL } },
  { "xmachebrew", { "macos-1285-10.2", NULL, NULL } },
  { "xmaciceland", { "macos-37_5-10.2", NULL, NULL } },
  { "xmacroman", { "macos-0_2-10.2", NULL, NULL } },
  { "xmacromania", { "macos-38_2-10.2", NULL, NULL } },
  { "xmacsymbol", { "macos-33-10.5", NULL, NULL } },
  { "xmacthai", { "macos-21-10.5", NULL, NULL } },
  { "xmacturkish", { "macos-35-10.2", NULL, NULL } },
  { "xmacukraine", { "macos-7_3-10.2", NULL, NULL } },
  { "xms9320213", { "ibm-943_P15A-2003", NULL, NULL } },
  { "xms950hkscs", { "ibm-5471_P100-2006", NULL, NULL } },
  { "xmscp932", { "ibm-943_P15A-2003", NULL, NULL } },
  { "xroman8", { "ibm-1051_P100-1995", NULL, NULL } },
  { "xsjis", { "ibm-943_P15A-2003", NULL, NULL } },
  { "xsjis0213", { "java-sjis_0213-1.6_P", NULL, NULL } },
  { "xutf16be", { "UTF-16BE", NULL, NULL } },
  { "xutf16le", { "UTF-16LE", NULL, NULL } },
  { "xutf16lebom", { "UTF-16LE,version=1", NULL, NULL } },
  { "xutf8j", { "UTF-8", NULL, NULL } },
  { "xwindows1256s", { "ibm-9448_X100-2005", NULL, NULL } },
  { "xwindows50220", { "ISO_2022,locale=ja,version=0", NULL, NULL } },
  { "xwindows50221", { "ISO_2022,locale=ja,version=1", NULL, NULL } },
  { "xwindows874", { "windows-874-2000", NULL, NULL } },
  { "xwindows950", { "windows-950-2000", NULL, NULL } },
  { "xwindowsiso2022jp", { "ISO_2022,locale=ja,version=0", NULL, NULL } }
};
