use lib 't', 'lib';
use strict;
use warnings;
use Test::More tests => 22;
use IO::All;
use IO_All_Test;

is(io('././t/file_spec.t')->canonpath, 't/file_spec.t');
is(io('././t/bogus')->canonpath, 't/bogus');
is(join(';', io->catdir(qw(t mydir))->all), 't/mydir/dir1;t/mydir/dir2;t/mydir/file1;t/mydir/file2;t/mydir/file3');
test_file_contents(io->catfile(qw(t mystuff))->scalar, 't/mystuff');
test_file_contents(io->join(qw(t mystuff))->scalar, 't/mystuff');
is(ref(io->devnull), 'IO::All');
ok(io->devnull->print('IO::All'));
ok(IO::All->devnull->print('IO::All'));
ok(io->rootdir->is_dir);
ok(io->tmpdir->is_dir);
ok(io->updir->is_dir);
like(io->case_tolerant, qr/^[01]$/);
ok(io('/foo/bar')->is_absolute);
ok(not io('foo/bar')->is_absolute);
is(scalar(@{[io->path]}), scalar(@{[split ':', $ENV{PATH}]}));
my ($v, $d, $f) = io('foo/bar')->splitpath;
is($d, 'foo/');
is($f, 'bar');
my @dirs = io('foo/bar/baz')->splitdir;
is(scalar(@dirs), 3);
is(join('+', @dirs), 'foo+bar+baz');
test_file_contents(io->catpath(undef, qw(t mystuff))->scalar, 't/mystuff');
is(io('/foo/bar/baz')->abs2rel('/foo'), 'bar/baz');
is(io('foo/bar/baz')->rel2abs('/moo'), '/moo/foo/bar/baz');
