#!/usr/bin/perl
# 	$rcs = ' $Id: eText.t,v 1.2 1995/09/16 00:17:44 ilya Exp ilya $ ';
require 5.000;
#use English;
use Tk;

print "1..1\n";

use Tk::eText;

# $top = MainWindow->new;
# $top->title('Widget Demonstration');
# #Tk::Widget::EnterWidgetCmd($top,"text",Tk::eText::Cmd());

# $text = $top->eText(-relief => 'raised', -borderwidth => 1);
# @a = %$text;
# print "$text\n@a\n", ;
# $text->pack(-side => 'bottom', -expand => 'yes', -fill => 'both');
# $text->insert('insert',"Here is some text");
# @conf = $text->block('configure','Std');
# $text->insert('insert',"@conf");

# MainLoop;

require 'dumpvar.pl';
eval 'use ExtUtils::Peek' if $ENV{ETEXT_DB}; warn $@ if $@;

$dumpvar::compactDump=160;
$prefix = $ENV{kprefix} || "Control-Meta-";

$initialized || do {
  $top = MainWindow->new;
  #Tk::Widget::EnterWidgetMethod("Text","block");
  
  my $s = $top->Scrollbar(-orient => 'vertical');
  $s->pack(-side => 'right', -fill => 'y');
  $text = $top->eText(-relief => 'raised', -borderwidth => 1,
		      -yscrollcommand =>  ['set', $s]);
  $s->configure(-command => ['yview', $text]);
  $text->insert('insert', "abcd\nefg");

  #print $text->get("0.0","end"), "\n";
  $text->block('configure', 'Std');
  $text->block('insert', 'Std', "1.2", "2.2");
  $text->block('split',  "1.4", 1);
  #print $text->get("0.0","end"), "\n";
  $initialized++;
};

$top->title('Extended Text Demonstration');
#@a = %$text;
#print "$text\n@a\n", ;
$text->pack(-side => 'bottom', -expand => 'yes', -fill => 'both');
$text->debug("yes");
#require ExtUtils::Dump;

#@conf = $text->block('configure', 'Std');
#$text->insert('insert',"Here is some text");
#$text->insert('insert',"@conf");
#dumpvar("main","conf");

$| = 1;

$text->configure (-insertbackground => "Gray", -insertborderwidth => 2,
  -insertwidth => 6, -height => 25, -width => 35, -font => "10x20");

$text->block('configure', 'Std', "-layoutcmd" => \&recursiveLayout,
	     '-layoutdepth' => -1, 
	     '-layoutwidths' => [[1,12]]);

$text->block('configure', 'Fraction', "-layoutcmd" => \&layoutFraction,
	     '-layoutdepth' => 1, 
	     '-layoutwidths' => [2]);

$text->block('configure', 'SuperSub', "-layoutcmd" => \&layoutSuperSub,
	     '-layoutdepth' => 1, 
	     '-layoutwidths' => [2]);

$text->block('configure', 'Radical', "-layoutcmd" => \&layoutRadical,
	     '-layoutdepth' => 1, 
	     '-layoutwidths' => [1]);

$text->block('configure', 'Equation', "-layoutcmd" => \&layoutEquation,
	     '-layoutdepth' => 1, 
	     '-layoutwidths' => [2]);

$text->block('configure', 'Tab', "-layoutcmd" => [\&layoutTab, 5, 35],
	     -empty => 'on');
#$text->block('configure', 'Tab', "-layoutcmd" => sub {layoutTab(5, 35, @_)},
#	     -empty => 'on');

#@conf = $text->block('configure', 'std');
#@conf = $text->block('configure', 'Std');
#dumpvar("main","conf");

$text->bind( "<${prefix}n>",sub {do "t/eText.t"; die $@ if $@; $text->break});
$text->bind( "<${prefix}q>",sub {print "ok 1\n"; exit});
$text->bind( "<${prefix}i>", ['insertBlock','Std']);
$text->bind( "<${prefix}f>", ['insertBlock','Fraction']);
$text->bind( "<${prefix}d>", ['insertBlock','Radical']);
$text->bind( "<${prefix}t>", ['insertBlock','Tab']);
$text->bind( "<${prefix}c>", ['insertBlock','SuperSub']);
$text->bind( "<${prefix}e>", ['insertBlock','Equation']);
$text->bind( "<${prefix}p>",
	    sub {dumpVar ($text->block('configure','Std')); $text->break});
$text->bind("<Control-Return>",
	    sub {$text->block('split','insert',1); $text->break});
$text->bind("<${prefix}Return>",
	    sub {$text->block('split','insert',2); $text->break});
$text->bind("<${prefix}BackSpace>",
	    sub {$text->block('trim','insert'); $text->break});

$text->bindtags([$text, ref $text,$text->toplevel,'all']);

$text->bind( "<F1>", ['blockInsert', 'insert', "x",
		      (bless ['Std',"abc","ef","g"], Tk::Text::Block),
		      "y"]);

$text->bind( "<F2>", ['blockInsert', 'insert', "x",
		      (bless ['Std', "abc",
			      ["e", (bless ['Std',"pqr","st"],
				     Tk::Text::Block), "f"],
			      "g"],
		       Tk::Text::Block),
		      "y"]);

$text->bind( "<F3>", ['blockInsert', 'insert',
		      (bless ['Radical',
			      ["a+b", (bless ['SuperSub',"2","in"],
				       Tk::Text::Block)]],
		       Tk::Text::Block)]);

$text->bind("<F4>", 
	    ['blockInsert', 'insert', "\n",
	     (bless
	      ['Equation', "(3.1a)",
	       [(bless 
		 ['Radical', 
		  ["1+",
		   (bless
		    ['Radical', 
		     ["1+", 
		      (bless
		       ['Radical', 
			["1+", 
			 (bless
			  ['Radical',"1+..."], 
			  Tk::Text::Block)]],
		       Tk::Text::Block)]],
		    Tk::Text::Block)]],
		 Tk::Text::Block), "=",
		(bless 
		 ['Fraction', 1,
		  ["1+",
		   (bless
		    ['Fraction', 1,
		     ["1+", 
		      (bless
		       ['Fraction', 1,
			["1+", 
			 (bless
			  ['Fraction', 1, "1+..."], 
			  Tk::Text::Block)]],
		       Tk::Text::Block)]],
		    Tk::Text::Block)]],
		 Tk::Text::Block)]],
	      Tk::Text::Block)]);

$text->bind( "<F5>", ['blockInsert', 'insert', "x",
		      (bless ['Tab'], Tk::Text::Block), "xx",
		      (bless ['Tab'], Tk::Text::Block), "xxx",
		      (bless ['Tab'], Tk::Text::Block), "xxxx",
		      (bless ['Tab'], Tk::Text::Block), "|"]);

$text->bind( "<F10>", ['blockInsert', 'insert',
		      (bless ['Std'], Tk::Text::Block)]);

$text->tag('configure', 'red', -foreground => 'red');
$text->tag('configure', 'blue', -background => 'lightblue', 
	   -border => 2, -relief => 'raised');
$text->tag('configure', 'small', -font => "6x10");
$text->tag('configure', 'black', -background => 'black');
eval {
  $text->tag('configure', 'symbol', -font => '-*-symbol-*-*-*-*-20-*-*-*-*-*-*-*');
};
eval {
  $text->tag('configure', 'symbol', -font => '-*-symbol-*-*-*-*-18-*-*-*-*-*-*-*');
} if $@;

$text->tag('configure', 'backgr1', -background => 'blue',
	   -border => 2, -relief => 'raised');
$text->tag('configure', 'backgr2', -background => 'gray90',
	   -border => 2, -relief => 'raised');


$text->block('deletelines');

$text->insert('1.0', "\n", [qw(black)]);
$blackLine = $text->block('addline', '1.0');
$text->delete('1.0', '1.0+1c');

#$text->insert('1.0', "v\n", [qw(blue red)]);
#$fractionLine =  $text->block('addline', '1.0');
#$text->delete('1.0', '1.0+2c');

$text->insert('1.0', "\326\n", [qw(symbol)]);
$radicalCheck = $text->block('addline', '1.0');
$text->delete('1.0', '1.0+2c');

$text->insert('1.0', "\n", [qw(backgr1)]);
$backgrId1 = $text->block('addline', '1.0');
$text->delete('1.0', '1.0+1c');

$text->insert('1.0', "\n", [qw(backgr2)]);
$backgrId2 = $text->block('addline', '1.0');
$text->delete('1.0', '1.0+1c');

$treeline = 2;
$treelineLen = 6;
#$layout = \&stdTree;

$fractionWidth = 2;
$fractionWidthHalf = $fractionWidth+1/2;
$stdAscent = 15;
$stdAscentHalf = int($stdAscent/2);
$stdDescent = 5;

#dumpValue($text->bind);

sub myLoop {
  if (defined &DB::DB) {
    while (1) {			# MainWindow->Count
      Tk::DoOneEvent(0);
    }
  } else {
    MainLoop;
  }
}

$inmainloop++ || myLoop;	# To allow reloading

sub dumpVar {local %dumpvar::address; dumpvar::unwrap(shift,0);}

# sub stdLayout {			# Example Layout: makes almost the same as
# 				# the standard one, only puts middle at the
# 				# average baseline
#   #dumpVar \@_;
#   shift; shift;			# Name of the block and x-coordinate
#   my ($y, $w, $ww, $h, $b, $trow, @out) = (0) x 5;
#   foreach $row (@_) {
#     # Starts with multiplicity and y-coordinate
#     if ($w < $row->[2]) {$w = $row->[2]} # Width
#     if ($ww < $row->[3]) {$ww = $row->[3]} # Width of background
#     $h += $row->[4];
#     $b += $row->[5];
#   }
#   $b = ($h + $b/@_)/2;		# So that the middle is average baseline high
#   @out = ([-1, 0, $y, $w, $ww, $h, $b]);
#   foreach $row (@_) {
#     $trow = [ @{$row}[0..5] ]; $trow->[3] = $ww;
#     splice(@$trow, 1, 0, 0);	# Insert 0 after the first element - x coord
#     push(@out, $trow);
#   }
#   #print "X";
#   #dumpVar \@out;
#   return @out;
# }

# sub treeLayout {		# Example Layout: makes almost the same as
# 				# the standard one, only puts middle at the
# 				# average baseline
#   # dumpVar \@_;
#   shift; shift;			# Name of the block and x-coordinate
#   my ($y, $w, $ww, $h, $b, $trow, @out) = (0) x 5;
#   foreach $row (@_) {
#     # Starts with multiplicity and y-coordinate
#     if ($w < $row->[2]) {$w = $row->[2]} # Width
#     if ($ww < $row->[3]) {$ww = $row->[3]} # Width of background
#     $h += $row->[4];
#     $b += $row->[5];
#   }
#   $b = ($h + $b/@_)/2;		# So that the middle is average baseline high
#   @out = ([-1, 0, $y, $w, $ww, $h, $b]);
#   foreach $row (@_) {
#     $trow = [ @{$row}[0..5] ]; $trow->[3] = $ww;
#     splice(@$trow, 1, 0, 0);	# Insert 0 after the first element - x coord
#     push(@out, $trow);
#   }
#   print STDOUT "X";
#   #dumpVar \@out;
#   return @out;
# }

# The following layout procedure takes a name of layered layout
# procedure and makes it into usual one

#sub wrapLayout {
#  my ($block,$inner,$addlines) = &$layout;
#  ($block, @$inner, @$addlines); # Just collect arrays together
#}

# Below &$layout returns a reference to a list the first element of
# which contains a layout data for what is inside. It uses only the
# first component of arguments to make layout, all the rest is preserved
# in other components of the return. If it takes 3 arguments, the first
# component of return is the total size, the second gives layout of
# internal blocks, the third of additional blocks, and 3 others are just
# copies of what it got.

sub descendTree {
  my ($dx, $dy, $res, $add, @tree) = @_;
  #dumpValue (\@_);
  for (@$add) {
    $_->[1] += $dx;
    $_->[2] += $dy;
    push( @addlines, $_ );
  }
  my $i = 0;
  my $head;
  for (@tree) {
    if (@$_ > 1) {		# Arrays of length 1 or >=4
      $head = shift(@$_);
      descendTree($dx + $res->[$i]->[1], $dy + $res->[$i]->[2], @$_);
    } else {
      #$_->[0]->[1] += $dy + $res->[$i]->[2]; # y-coordinate
      #splice(@ {$_->[0]}, 6, 3);
      #splice(@ {$_->[0]}, 1, 0, $dx + $res->[$i]->[1]); # x-coordinate
      #push(@lines,$_->[0]);
      $res->[$i]->[1] += $dx; # x-coordinate
      $res->[$i]->[2] += $dy; # y-coordinate
      push(@lines,$res->[$i]);
    }
    $i++;
  }
}

sub stdTree {			# Example Layout: makes almost the same as
				# the standard one, only puts middle at the
				# average baseline
  shift; shift;			# Name of the block and x-coordinate
  #print "Tree:\n";
  #dumpValue ( \@_ );
  my ($y, $w, $ww, $h, $b, $trow, @out, $row, $uppermin, $lowermid) = (0) x 5;
  $y = $_[0][0][1];		# In first row: second elt of layout info
  foreach (@_) {
    $row = $_->[0];		# the layout for inside
    warn "Error: \$_ = `$_', \$row = `$row'\n" unless defined ref $row;
    # Starts with multiplicity and y-coordinate
    if ($w < $row->[2]) {$w = $row->[2]} # Width
    if ($ww < $row->[3]) {$ww = $row->[3]} # Width of background
    $h += $row->[4];
    $b += $row->[5];
  }
  $uppermid = $_[0]->[0];
  $uppermid = $uppermid->[4]/2; # 1/3 of accent high looks pretty reasonable
  $lowermid = $_[$#_]->[0];
  $lowermid = $h - $lowermid->[4]/2; # + $lowermid->[5]*2/3;
  $b = $b/@_/3 + ($uppermid + $lowermid)/2;
  # So that the middle is average baseline high
  my @block = (-1, $y, $w + $treelineLen, $ww + $treelineLen, $h, $b);
  @out = ();
  my @addl = ();
  my $nrow;
  foreach (@_) {
    $nrow = $_->[0];
    $trow = [ @{$nrow}[0..5] ]; $trow->[3] = $ww;
    $trow->[1] -= $y;		# Make relative.
    splice(@$trow, 1, 0, $treelineLen); # Insert $tl after the first element - x coord
    push(@out, $trow);
    push(@addl,[$blackLine,0,$trow->[2]+$trow->[5]/2,
		$treelineLen,$treelineLen,$treeline,0]);
  }
  push(@addl,
       [$blackLine,0,$uppermid,$treeline,$treeline,$lowermid-$uppermid,0]);
  #print "X";
  #dumpVar \@out;
  return [\@block,\@out,\@addl,@_];
}

sub digester {
  my ($data, $x) = (shift, shift);
  # Prepares information for handling to stdTree
  #print "Before:\n";
  #dumpValue ( \@_ );
  for (@_) {
    if (ref $_->[0]) {		# Inner block
      $_ = &digester( $data, $x, @$_);
    } else {
      $_=[$_];
    }
  }
  #print "After:\n";
  #dumpValue ( \@_ );
  stdTree $data, $x, @_;
}

sub recursiveLayout {
  my $tree = &digester;
  #dumpValue ($tree);
  local @addlines;		# the kids will extend it
  local @lines;			# the kids will extend it
  my $block = shift(@$tree);
  splice @$block, 1, 0, 0;	# Add x coordinate to the block
  descendTree 0, 0, @$tree;	# dx, dy, tree; Will extend arrays
  #print "block";
  #dumpValue ($block);
  #print "lines";
  #dumpValue (\@lines);
  #print "add";
  #dumpValue (\@addlines);
  ($block, @lines, @addlines);
}


sub layoutFraction {		#block x super sub
  my ($data,$x,$super,$sub) = @_;
  #dumpValue( \@_ );
  my $w = $super->[2];
  $w = $sub->[2] if $w < $sub->[2];
  $w += 4;
  my $shift1 = ($w - $super->[2])/2;
  my $shift2 = ($w - $sub->[2])/2;
  my $b = $stdAscentHalf + $super->[4] + $fractionWidthHalf;
  my $h = $super->[4] + $fractionWidth + $sub->[4];
  $h = $b if $h < $b;
  my @out = (
	     [-1, 0, 0, $w, $w, $h, $b],
	     [$super->[0], $shift1, $super->[1], $super->[2],
	      $super->[2], $super->[4], $super->[5]],
	     [$sub->[0], $shift2, $sub->[1] + $fractionWidth, $sub->[2],
	      $sub->[2], $sub->[4], $sub->[5]],
	     [$blackLine, 1, $super->[4], $w - 2, $w - 2, 2, 1],
	    );
  #dumpValue( \@out );
  return @out;
}

sub layoutSuperSub {		#block x super sub
  my ($data,$x,$super,$sub) = @_;
  #dumpValue( \@_ );
  my $w = $super->[2];
  $w = $sub->[2] if $w < $sub->[2];
  my $ww = $super->[3];
  $ww = $sub->[3] if $ww < $sub->[3];
  my $b = $stdAscentHalf + $super->[4];
  my $d = 0;
  my $y1 = 0;
  if (defined $sub) {
    # There is a subscript
    $d = $stdDescent + $sub->[4] - $sub->[5];
    if ($d < $sub->[4] - $stdAscentHalf ) {
      $d = $sub->[4] - $stdAscentHalf;
      $y1 = $super->[4];
    } else {
      $y1 = $b + $stdAscentHalf - $sub->[5];
    }
  }
  $#$super = $#$sub = 5;
  splice @$super, 1, 0, 0;
  splice @$sub, 1, 0, 0;
  $super->[4] = $sub->[4] = $ww;
  $sub->[2] = $y1;
  my @out = (
	     [-1, 0, 0, $w, $ww, $b + $d, $b],
	     $super,
	     $sub,
	    );
  #dumpValue( \@out );
  return @out;
}

sub layoutRadical {		# block x row
  my ($block, $x, $row) = (shift, shift, shift);
  my $h = $row->[4];
  my $vlx = 9;
  my $hlw = 2;
  my $vlw = 1;
  my $addxoff = 1;
  my $rcYoff = 1;
  my $xoff = $vlx + $hlw + $addxoff;
  my $checkH = 20;
  my $checkB = 15;
  my $addHeight = 3;
  $addHeight = $checkB - $h + $addHeight - 1 if $h < $checkB;
  my $vlH = 0;
  my $vrow = [];
  if ($h > $checkB) {
    $vlH = $h - $checkB;
    $vrow = [$blackLine, $vlx, 0, $vlw, $vlw, $vlH, 0];
  }
  my $b = $row->[5] + $addHeight;
  my $h = $h + $addHeight;
  my $wtot = $row->[2] + $xoff;
  my $hll = $row->[2] + $vlw + $addxoff;
  $row->[1] = $xoff;
  splice @$row, 2, 0, $addHeight;
  $#$row = 6;
  my $hrow = [$blackLine, $vlx, 0, $hll, $hll, $hlw, $hlw];
  my $totblock = [-1, 0, 0, $wtot, $wtot, $h, $b];
  my $check = [$radicalCheck, 0, $vlH + $rcYoff, 0, 0, $checkH, $checkB];
  if ( @$vrow ) {
    return ($totblock, $row, $hrow, $vrow, $check);
  } else {
    return ($totblock, $row, $hrow, $check);
  }
}

$eqWidth = 300;
$eqGap = 15;

sub layoutEquation {		# block x row
  my ($block, $x, $ind, $eq) = @_;
  my $eqw = $eqWidth;		# block->[0]->winfo ('width');
  $eqw = $block->[1]->winfo('width') - 10; # XXXX Borders? otherwise
                                           # cannot get cursor into
                                           # the beginning of line

  #dumpValue($block);
  #dumpValue($eq);
  #print $eqw,"\n";
  $#$ind = 5;
  $#$eq = 5;
  #defined $ind->[2] or warn 1;defined $eq->[2] or warn 2;
  my $tw =  $ind->[2] + $eq->[2] + $eqGap;
  $eqw = $tw if $eqw < $tw;
  my $gap = $ind->[2] + $eqGap + int(($eqw-$tw)/2);
  my $h = $ind->[4];
  $h = $eq->[4] if $h < $eq->[4];
  my $y0 = 0;
  $y0 =  int(($h - $ind->[4])/2)
      if $h > $ind->[4];
  my $y1 = 0;
  my $b = $eq->[5] + $y1;
  splice @$ind, 1, 1, 0, $y0;
  splice @$eq, 1, 1, $gap, $y1;
  my @out = (
	     [-1, 0, 0, $eqw, $eqw, $h, $b],
	     $ind,
	     $eq,
	    );
  #dumpValue( \@out );
  return @out;
}

sub layoutTab {			# min mult block x
  my ($min,$mult,$block,$x) = @_;
  my $w = $min + $mult - ($x + $min - 1) % $mult - 1;
  my $totblock = [$backgrId2, 0, 0, $w, $w, 5, 3];
  return ($totblock, $totblock);
}


sub Tk::eText::insertBlock {
  my ($widget, $name) = (shift,shift);
  my @sel = $widget->tag('nextrange','sel','0.0');
  if (@sel) {
    $widget->block( 'insert', $name, $sel[0], $sel[1]);
  } else {
    $widget->block( 'insert', $name, 'insert' );
    $widget->SetCursor('insert-1c');
  }
  $widget->break;
}

# Takes widget, position, and a list reference. The elements of the
# list may be:
# 
# a) strings to insert;
# 
# b) blessed references to blocks
# 
# A block object is a list: name, array of arrays of contents

$biMark = 0;

sub Tk::eText::blockInsert {
  my ($widget, $pos) = (shift,shift);
  my $mark = "bim" . $biMark++;
  $widget->mark('set',$mark, $pos);
  foreach $elt (@_) {
    if (!defined ref $elt) {	# String to insert
      $widget->insert($mark, $elt);
    } elsif (ref $elt eq 'Tk::Text::Block') {
      my $cnt = 1;
      $widget->block('insert',$elt->[0],$mark);
      my @what;
      while ($cnt <= $#$elt) {
	if (defined ref $elt->[$cnt]) {
	  @what = @{$elt->[$cnt]};
	} else {
	  @what = $elt->[$cnt];
	}
	$widget->blockInsert("$mark -1 c", @what);
	$widget->insert("$mark -1 c", "\n") if $cnt++ < $#$elt;
      }
    } else {
      warn "Unknown data type `" . ref $elt . "' given to blockInsert";
    }
  }
  $biMark--;
  return;
}

sub listdepth {
  my $d = 0;
  my $din = 0;
  foreach (@_) {
    next unless ref $_ eq 'ARRAY';
    $din = listdepth $_;
    $d = $din if $d < $din;
  }
  return $d;
}

sub Tk::eText::insertBlockWith {
  my ($widget, $name) = (shift,shift);
  $widget->block( 'insert', $name, 'insert' );
  $widget->SetCursor('insert-1c');
  my $d = &listdepth;
}

