#!/usr/bin/perl -w -I "~holger/perl"
use strict;
use warnings;
use LWP::Simple;

printf "%s\n",   "*" x 80;
printf "*%s*\n", " " x 78;
printf "* Specification *\n";
printf "*%s*\n", " " x 78;
printf "%s\n",   "*" x 80;

my @files = ();
my %nodes = ();
my %sai   = ();

sub download {

	#return if -e 'X3DPublicSpecifications.zip';
	system "wget http://www.web3d.org/x3d/specifications/X3DPublicSpecifications.zip";
}

sub unzip {
	system "unzip -o X3DPublicSpecifications.zip";
}

sub copy {
	system "cp -r X3DPublicSpecifications/* ./";
}

sub getFileList {

	@files = grep { chomp; -f } map {
		my $dir = $_;
		map { "$dir/$_" } `ls -C1 $dir`
	  } 'ISO-IEC-19775-X3DAbstractSpecification/Part01',
	  'ISO-IEC-19775-X3DAbstractSpecification/Part01/components',
	  'ISO-IEC-19775-X3DAbstractSpecification/Part02',;

	#printf "%s\n", join "\n", @files;

	return @files;
}

sub getNodeList {

	my $index = join '', `cat ISO-IEC-19775-X3DAbstractSpecification/Part01/nodeIndex.html`;
	$index =~ s/[\n\r]//sg;

	#printf "%s\n", join "\n", $index;

	while ( $index =~ m|\G.*?<p\s+class="IndexEntry">(\s*<i>)?\s*(.+?)(\s*</i>)?\s*</p>|gcso ) {
		my $link = $2;
		if ($link =~ m|>\s*(.*?)\s*<|) {
			my $key  = $1;
			$link =~ s|\s*$key|$key|sg;
			$link =~ s|components/|file:///home/holger/Desktop/holger/perl/X3D/specifications/ISO-IEC-19775-X3DAbstractSpecification/Part01/components/|o;
			$nodes{$key} = $link;
		}
	}

	#printf "%s\n", join "\n", sort values %nodes;

	return %nodes;

}

sub link_nodes {
	my %nodes = getNodeList;
	foreach my $filename (getFileList) {
		#printf "%s\n", $filename;
		
		my $file = join "", `cat $filename`;

		foreach my $nodeTypeName ( keys %nodes ) {
			if ($file =~ s/([\s\t\n>\[\(])$nodeTypeName(?=(?![\w]))/$1$nodes{$nodeTypeName}/sg) {
				#printf "  %s\n", $nodeTypeName;
			}
		}
		
		open FILE, ">$filename";
		print FILE $file;
		close FILE;
	}
}

sub getSAIList {

	my $index = join '', `cat ISO-IEC-19775-X3DAbstractSpecification/Part02/dataRef.html`;
	$index =~ s/[\n\r]//sg;
	$index =~ s|\Q</a><a href="#SAIBrowserEvent">Browser</a><a href=\E".*?\Q">|Browser|sg;

	#printf "%s\n", join "\n", $index;

	while ( $index =~ m|\G.*?<li>(.*?)</li>|gcso ) {
		my $link = $1;
		$link =~ s/\d+\.\d+\.\d+(.\d+)?\s*//sgo || next;
		$link =~ /SAI|NULL/ || next;
		if ($link =~ /\>(.*?)\</sgo) {
			my $key = $1;
			$link =~ s|#|file:///home/holger/Desktop/holger/perl/X3D/specifications/ISO-IEC-19775-X3DAbstractSpecification/Part02/dataRef.html#|;
			$sai{$key} = $link;
		}
	}

	printf "%s\n", join "\n", sort values %sai;

	return %sai;

}

sub link_sai {
	my %sai = getSAIList;
	foreach my $filename (getFileList) {
		#printf "%s\n", $filename;
		
		my $file = join "", `cat $filename`;

		foreach my $key ( keys %sai ) {
			if ($file =~ s/([\s\t\n>\[\(])$key(?=(?![\w]))/$1$sai{$key}/sg) {
				#printf "  %s\n", $nodeTypeName;
			}
		}
		
		open FILE, ">$filename";
		print FILE $file;
		close FILE;
	}
}

sub main {

	#download;
	#unzip;
	copy;
	link_nodes;
	link_sai;
}

&main;

1;
__END__
ISO-IEC-19775-X3DAbstractSpecification/Part01
ISO-IEC-19775-X3DAbstractSpecification/Part01/components
ISO-IEC-19775-X3DAbstractSpecification/Part02
