package SFScalar;
use strict;
use warnings;
no strict 'refs';

use rlib "../";

use Hash::NoRef;
use Scalar::Util;
use X3DGenerator;
use X3DError;

sub new {
	my $self = shift;
	my $class = ref($self) || $self;

	my $this = bless {}, $class;
	$this->setValue(@_);

	return $this;
}

sub getId { Scalar::Util::refaddr(shift) }

sub clone {
	my $this   = shift;
	my $scalar = $this->new( $this->getValue );
	return $scalar;
}

sub copy {
	my $this   = shift;
	my $scalar = $this->new( $this->getValue );
	return $scalar;
}

sub setValue {
	my $this = shift;
	$this->{value} = shift;
}

sub getValue { $_[0]->{value} }

sub getReferenceCount {
	my $this = shift;
	return Hash::NoRef::SvREFCNT( $this->{value} );
}

sub toString {
	return $_[0]->getValue;
}

sub DESTROY { 0 }

1;
__END__
