package X3DTiedArray;
use strict;
use warnings;
no strict 'refs';

use rlib "../";

use X3DError;

# subs fr $this->{value}
sub TIEARRAY {
	my ( $class, $array ) = @_;
	bless $array, $class;
}

sub FETCHSIZE {
	my $array = shift;
	$#$array;
}

sub STORESIZE {
	my $array = shift;
	my $size  = shift;
	my $this  = $array->[0];

	$size++;

	my $SField = ${ ref($this) . "::SField" };

	for ( my $i = @$array ; @$array < $size ; ++$i ) {
		$array->[$i] = $SField->new;
	}
}

#
sub STORE {
	my $array = shift;
	my $index = shift;
	my $value = shift;
	my $this  = $array->[0];

	my $SField = ${ ref($this) . "::SField" };

	$value = ref $value ? $value->copy : $SField->new($value);

	$array->[ $index + 1 ] = $value;
}

#
sub FETCH { $_[0]->[ $_[1] + 1 ]->copy } #sub FETCH { ${ $_[0] }->[ $_[1] ]->copy }!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

#
sub CLEAR {
	my $array = shift;
	my $this  = shift @$array;
	@$array = ($this);
}

#
sub SHIFT { $_[0]->SPLICE( 0, 1 ) }

sub PUSH {
	my $array = shift;
	$array->SPLICE( $#$array, 0, @_ )
}

sub POP { $_[0]->SPLICE( 0, -1 ) }

#
sub UNSHIFT {
	my $array = shift;
	$array->SPLICE( 0, 0, @_ )
}

sub EXTEND { $_[0]->STORESIZE( $_[1] ) }
sub EXISTS { exists $_[0]->[ $_[1] + 1 ] }
sub DELETE { delete $_[0]->[ $_[1] + 1 ] }

sub SPLICE {
	my $array = shift;
	my $this  = $array->[0];

	my $size = $array->FETCHSIZE;

	my $offset = @_ ? shift: 0;
	$offset += $size if $offset < 0;

	my $length = @_ ? shift: $size - $offset;

	my @values = map { ref $_ ? $_->copy : $_ } @_;

	@values = splice( @$array, $length >= 0 ? $offset + 1 : $offset, $length, @values );

	return @values;
}

sub DESTROY {    #X3DError::Debug ref $_[0];
	my $this = shift;
	$this->CLEAR;
	@$this = ();
	0;
}

1;

package MFScalar;
use strict;
use warnings;

use rlib "../";

use Scalar::Util;
use X3DGenerator;
use X3DError;
use X3DArray;

use SFScalar;
our $SField = new SFScalar;

#use List::Util qw(first max maxstr min minstr reduce shuffle sum);

use overload
  "=" => \&copy,
"<=>" => sub { &X3DArray::ncmp( $_[0]->{value}, $_[1]->isa("MFScalar") ? $_[1]->{value} : $_[1] ) },
  "=="   => sub { !( $_[0] <=> $_[1] ) },
  "!="   => sub { ( $_[0] <=> $_[1] ) && 1 },
  "bool" => sub { $_[0]->length },
  "0+"   => sub { $_[0]->length },
  '""'   => sub { $_[0]->toString },
  '@{}'  => sub { $_[0]->{value} },
  ;

sub new {
	my $self = shift;
	my $class = ref($self) || $self;

	my $this = bless {}, $class;
	$this->_create(@_);

	return $this;
}

sub _create {
	my $this = shift;

	my $value = @_ == 1 && ref( $_[0] ) eq 'ARRAY' ? shift: [@_];

	unshift @$value, $this;
	#X3DError::Debug ref $value->[0];

	tie my @array, "X3DTiedArray", $value;
	$this->{value} = \@array;

	#X3DError::Debug scalar @array;
}

sub getId { Scalar::Util::refaddr(shift) }

sub copy {
	$_[0]->new( $_[0]->getValue );
}

sub getValue { map { $_->copy } @{ $_[0] } }

sub get1Value { $_[0]->[ $_[1] ]->copy }

sub setValue {
	my $this = shift;
	@$this = @_;
	return;
}

sub set1Value { $_[0]->[ $_[1] ] = $_[2] }

sub getIndex { X3DArray::index @_ }

sub length {
	my $this = shift;
	$#$this = $_[0] - 1 if @_;
	return scalar @$this;
}

sub toString {
	my $this = shift;

	return "[${X3DGenerator::TSPACE}]" unless @$this;

	my $string = '';
	if ($#$this) {
		$string .= "[${X3DGenerator::TSPACE}";
		$string .= join ",${X3DGenerator::TSPACE}", @$this;
		$string .= "${X3DGenerator::TSPACE}]";
	}
	else {
		$string .= $this->[0];
	}

	return $string;
}

1;
__END__
