use strict;
use warnings;

use Test::More;

use Katsubushi::Converter;

# 1441340545 = 2015-09-04T13:22:25

subtest "id_to_epoch" => sub {
    my $epoch = Katsubushi::Converter::id_to_epoch(89213456844517376);
    is $epoch, 1441340545;
};

subtest "id_to_epoch_msec" => sub {
    my $epoch_msec = Katsubushi::Converter::id_to_epoch_msec(89213456844517376);
    is $epoch_msec, 1441340545617;
};

subtest "epoch_to_id" => sub {
    my $id = Katsubushi::Converter::epoch_to_id(1441340545);
    is $id, 89213454254080000;
};

subtest "epoch_msec_to_id" => sub {
    my $id = Katsubushi::Converter::epoch_msec_to_id(1441340545617);
    is $id, 89213456841965568;
};

done_testing;
