package App::Manoc::ControllerRole::ResultSet;
#ABSTRACT:  Role for controllers accessing resultset

use Moose::Role;

our $VERSION = '2.99.4'; ##TRIAL VERSION

use MooseX::MethodAttributes::Role;
use namespace::autoclean;


has 'class' => ( is => 'ro', isa => 'Str', writer => '_set_class' );


sub setup : Chained('/') : CaptureArgs(0) : PathPart('specify.in.subclass.config') { }


sub base : Chained('setup') : PathPart('') : CaptureArgs(0) {
    my ( $self, $c ) = @_;

    $c->stash( resultset => $self->get_resultset($c) );
}


sub get_resultset {
    my ( $self, $c ) = @_;

    return $c->model( $c->stash->{class} || $self->class );
}

1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::ControllerRole::ResultSet - Role for controllers accessing resultset

=head1 VERSION

version 2.99.4

=head1 DESCRIPTION

This is a base role for all Manoc controllers which manage a resultset.

=head1 ACTIONS

=head2 setup

=head2 base

Add a resultset to the stash. Chained to setup.

=head1 METHODS

=head2 get_resultset

It returns a resultset of the controller's class.  Used by base.

=head1 NAME

App::Manoc::ControllerRole::ResultSet -

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
