#!/usr/bin/perl

sub ip_sort {
    my ($list,$column,$reverse,$unique) = @_;
    $column  = 1 if ! $column ;
    $reverse = 0 if ! $reverse; 
    $unique  = 0 if ! $unique ;

    return 0 if $column  !~ /^\d+$/;
    return 0 if $reverse !~ /^0|1$/;
    return 0 if $unique  !~ /^0|1$/;
     
    my @list;
    my %unique;
    my %x12;
    my $i=0;
    my $ip;

    $column--;
    foreach(split /\n/,$list) {
       if ( ! $unique || ! $unique{$_} ) {
          push @list,$_;
          $unique{$_} = 1;
          $ip = (split /\s+/)[$column];
          $x12{$i} = sprintf "%03d%03d%03d%03d" , split /\./ , $ip;
          $i++ } }

    foreach ( sort { if ( $reverse ) { $x12{$b} <=> $x12{$a} } else { $x12{$a} <=> $x12{$b} } } keys %x12 ) {
       print "$list[$_]\n" } }

###################################################################

( $f , $c , $r , $u ) = @ARGV ;
$l = `cat $f` ;

use Net::Kalk;

print Net::Kalk::sort($l,$c,$r,$u) ;
