package PDF::Reuse::Util;
use PDF::Reuse;
require    Exporter;
our @ISA     = qw(Exporter);
our @EXPORT  = qw(hyperLink blackText);


use strict;

our %font_widths = ( 
    'Courier'             => 600,
    'Courier-Bold'        => 600,
    'Courier-BoldOblique' => 600,
    'Courier-Oblique'     => 600,
    'Times-Roman'         => 
     [000,   000,   000,   000,   000,   000,   000,   000,  
      000,   000,   000,   000,   000,   000,   000,   000,  
      000,   000,   000,   000,   000,   000,   000,   000,  
      000,   000,   000,   000,   000,   000,   000,   000,  
      250,   333,   408,   500,   500,   833,   778,   180, 
      333,   333,   500,   564,   250,   333,   250,   278,  
      500,   500,   500,   500,   500,   500,   500,   500,  
      500,   500,   278,   278,   564,   564,   564,   444,  
      921,   722,   667,   667,   722,   611,   556,   722,  
      722,   333,   389,   722,   611,   889,   722,   722,  
      556,   722,   667,   556,   611,   722,   722,   944,  
      722,   722,   611,   333,   278,   333,   469,   500,  
      333,   444,   500,   444,   500,   444,   333,   500,  
      500,   278,   278,   500,   278,   778,   500,   500,  
      500,   500,   333,   389,   278,   500,   500,   722,  
      500,   500,   444,   480,   200,   480,   541,   350,   
      500,   350,   333,   500,   443,   1000,   500,   500, 
      333,   1000,   555,   333,  889,   350,   611,  350,   
      350,   333,   333,   443,   443,   350,   500,   1000, 
      333,   980,   388,   333,   722,   350,   444,   721,  
      250,   333,   500,   500,   500,   500,   200,   500, 
      333,   760,   276,   500,   564,   333,   760,   333, 
      400,   564,   300,   300,   333,   510,   453,   250, 
      333,   300,   310,   500,   750,   750,   750,   444, 
      722,   722,   722,   722,   722,   722,   889,   667, 
      611,   611,   611,   611,   333,   333,   333,   333,  
      722,   722,   722,   722,   722,   722,   722,   564,  
      722,   722,   722,   722,   722,   722,   556,   500,  
      444,   444,   444,   444,   444,   444,   667,   444,  
      444,   444,   444,   444,   278,   278,   278,   278,  
      500,   500,   500,   500,   500,   500,   500,   564,  
      500,   500,   500,   500,   500,   500,   500,   500],
     'Times-Bold' => 
     [000,   000,   000,   000,   000,   000,   000,   000,  
      000,   000,   000,   000,   000,   000,   000,   000,  
      000,   000,   000,   000,   000,   000,   000,   000,  
      000,   000,   000,   000,   000,   000,   000,   000,  
      250,   333,   555,   500,   500,  1000,   833,   278,   
      333,   333,   500,   570,   250,   333,   250,   278,  
      500,   500,   500,   500,   500,   500,   500,   500,  
      500,   500,   333,   333,   570,   570,   570,   500,  
      930,   722,   667,   722,   722,   667,   611,   778,  
      778,   389,   500,   778,   667,   944,   722,   778,  
      611,   778,   722,   556,   667,   722,   722,  1000,  
      722,   722,   667,   333,   278,   333,   581,   500,  
      333,   500,   556,   444,   556,   444,   333,   500,  
      556,   278,   333,   556,   278,   833,   556,   500,  
      556,   556,   444,   389,   333,   556,   500,   722,  
      500,   500,   444,   394,   220,   394,   520,   350,  
      500,   350,   333,   500,   500,   1000,   500,   500,
      333,   1000,   556,   333,  1000,   350,   667,  350, 
      350,   333,   333,   500,   500,   350,   500,   1000,
      333,   1000,   389,   333,   723,   350,   444,   722,  
      250,   333,   500,   500,   500,   500,   220,   500, 
      333,   747,   300,   500,   570,   333,   747,   333, 
      400,   570,   300,   300,   333,   601,   540,   250, 
      333,   300,   330,   500,   750,   750,   750,   500, 
      722,   722,   722,   722,   722,   722,  1000,   722,  
      667,   667,   667,   667,   389,   389,   389,   389,  
      722,   722,   778,   778,   778,   778,   778,   570,  
      778,   722,   722,   722,   722,   722,   611,   556,  
      500,   500,   500,   500,   500,   500,   722,   444,  
      444,   444,   444,   444,   278,   278,   278,   278,  
      500,   556,   500,   500,   500,   500,   500,   570,  
      500,   556,   556,   556,   556,   500,   556,   500],
     'Times-Italic' =>
     [000,   000,   000,   000,   000,   000,   000,   000,  
      000,   000,   000,   000,   000,   000,   000,   000,  
      000,   000,   000,   000,   000,   000,   000,   000,  
      000,   000,   000,   000,   000,   000,   000,   000,  
      250,   333,   420,   500,   500,   833,   778,   214, #39 
      333,   333,   500,   675,   250,   333,   250,   278, #47
      500,   500,   500,   500,   500,   500,   500,   500, #55
      500,   500,   333,   333,   675,   675,   675,   500, #63
      920,   611,   611,   667,   722,   611,   611,   722, #71
      722,   333,   444,   667,   556,   833,   667,   722, #79
      611,   722,   611,   500,   556,   722,   611,   833, #87
      611,   556,   556,   389,   278,   389,   422,   500, #95
      333,   500,   500,   444,   500,   444,   278,   500, #103 
      500,   278,   278,   444,   278,   722,   500,   500, #111
      500,   500,   389,   389,   278,   500,   444,   667, #119
      444,   444,   389,   400,   275,   400,   541,   350,  # 127 
      500,   350,   333,   500,   556,   889,   500,   500,  # 135
      333,   1000,   500,   333,  944,   350,   556,  350,   # 143
      350,   333,   333,   556,   556,   350,   500,   890,  # 151
      333,   980,   389,   333,   668,   350,   390,   557, # 159  
      250,   389,   500,   500,   500,   500,   275,   500, # 167 
      333,   760,   276,   500,   675,   333,   760,   333, # 175 
      400,   675,   300,   300,   333,   514,   523,   250, # 183 
      333,   300,   310,   500,   750,   750,   750,   500, # 191 
      611,   611,   611,   611,   611,   611,   889,   667,  
      611,   611,   611,   611,   333,   333,   333,   333,  
      722,   667,   722,   722,   722,   722,   722,   675,  
      722,   722,   722,   722,   722,   556,   611,   500,  
      500,   500,   500,   500,   500,   500,   667,   444,  
      444,   444,   444,   444,   278,   278,   278,   278,  
      500,   500,   500,   500,   500,   500,   500,   675,  
      500,   500,   500,   500,   500,   444,   500,   444],

    'Times-BoldItalic' =>
     [000,   000,   000,   000,   000,   000,   000,   000,  
      000,   000,   000,   000,   000,   000,   000,   000,  
      000,   000,   000,   000,   000,   000,   000,   000,  
      000,   000,   000,   000,   000,   000,   000,   000,  
      250,   389,   555,   500,   500,   833,   778,   278,  
      333,   333,   500,   570,   250,   333,   250,   278,  
      500,   500,   500,   500,   500,   500,   500,   500,  
      500,   500,   333,   333,   570,   570,   570,   500,  
      832,   667,   667,   667,   722,   667,   667,   722,  
      778,   389,   500,   667,   611,   889,   722,   722,  
      611,   722,   667,   556,   611,   722,   667,   889,  
      667,   611,   611,   333,   278,   333,   570,   500,  
      333,   500,   500,   444,   500,   444,   333,   500,  
      556,   278,   278,   500,   278,   778,   556,   500,  
      500,   500,   389,   389,   278,   556,   444,   667,  
      500,   444,   389,   348,   220,   348,   570,   350,  # 127 
      500,   350,   333,   500,   502,   1000,   500,   500,  # 135
      333,   1000,   555,   333,  944,   350,   610,  350,   # 143
      350,   333,   333,   500,   500,   350,   500,   1000,  # 151
      333,   1000,   389,   333,   721,   350,   390,   610,  # 159   
      250,   389,   500,   500,   500,   500,   220,   500,  #167
      333,   747,   266,   500,   606,   333,   747,   333,  #175
      400,   570,   300,   300,   333,   532,   500,   250,  #183
      333,   300,   300,   500,   750,   750,   750,   500,  
      667,   667,   667,   667,   667,   667,   944,   667,  
      667,   667,   667,   667,   389,   389,   389,   389,  
      722,   722,   722,   722,   722,   722,   722,   570,  
      722,   722,   722,   722,   722,   611,   611,   500,  
      500,   500,   500,   500,   500,   500,   722,   444,  
      444,   444,   444,   444,   278,   278,   278,   278,  
      500,   556,   500,   500,   500,   500,   500,   570,  
      500,   556,   556,   556,   556,   444,   500,   444],   

    'Helvetica' =>
     [000,   000,   000,   000,   000,   000,   000,   000,  
      000,   000,   000,   000,   000,   000,   000,   000,  
      000,   000,   000,   000,   000,   000,   000,   000,  
      000,   000,   000,   000,   000,   000,   000,   000,  
      278,   278,   355,   556,   556,   889,   667,   192,  
      333,   333,   389,   584,   278,   333,   278,   278,  
      556,   556,   556,   556,   556,   556,   556,   556,  
      556,   556,   278,   278,   584,   584,   584,   556,  
     1015,   667,   667,   722,   722,   667,   611,   778,  
      722,   278,   500,   667,   556,   833,   722,   778,  
      667,   778,   722,   667,   611,   722,   667,   944,  
      667,   667,   611,   278,   278,   278,   469,   557,  
      334,   556,   556,   500,   556,   556,   278,   556,  
      556,   222,   222,   500,   222,   833,   556,   556,  
      556,   556,   333,   500,   278,   556,   500,   722,  
      500,   500,   500,   334,   260,   334,   584,   350,  # 127 
      556,   350,   222,   556,   333,   1000,   556,   556,  # 135
      333,   1000,   667,   333,   1000,   351,   611,  350,   # 143
      350,   223,   222,   333,   333,   351,   557,   1000,  # 151
      333,   1000,   500,   333,   945,   350,   500,   667, # 159 
      278,   333,   556,   556,   556,   556,   260,   556,  # 167
      333,   737,   370,   556,   584,   333,   737,   333,  # 175
      400,   584,   333,   333,   333,   578,   537,   278,  # 183
      333,   333,   365,   556,   835,   835,   835,   611,  # 191
      667,   667,   667,   667,   667,   667,  1000,   722,  
      667,   667,   667,   667,   278,   278,   278,   278,  
      722,   722,   778,   778,   778,   778,   778,   584,  
      778,   722,   722,   722,   722,   667,   667,   611,  
      556,   556,   556,   556,   556,   556,   889,   500,  
      556,   556,   556,   556,   278,   278,   278,   278,  
      556,   556,   556,   556,   556,   556,   556,   584,  
      611,   556,   556,   556,   556,   500,   556,   500],

    'Helvetica-Bold' =>
     [000,   000,   000,   000,   000,   000,   000,   000,  
      000,   000,   000,   000,   000,   000,   000,   000,  
      000,   000,   000,   000,   000,   000,   000,   000,  
      000,   000,   000,   000,   000,   000,   000,   000,  #31 
      278,   333,   474,   556,   556,   889,   722,   238,  #39
      333,   333,   389,   584,   278,   333,   278,   278,  #47
      556,   556,   556,   556,   556,   556,   556,   556,  #55
      556,   556,   333,   333,   584,   584,   584,   611,  #63
      975,   722,   722,   722,   722,   667,   611,   778,  #71
      722,   278,   556,   722,   611,   833,   722,   778,  #79
      667,   778,   722,   667,   611,   722,   667,   944,  #87
      667,   667,   611,   333,   278,   333,   584,   556,  #95
      333,   556,   611,   556,   611,   556,   333,   611,  #103
      611,   278,   278,   556,   278,   889,   611,   611,  #111
      611,   611,   389,   556,   333,   611,   556,   778,  #119
      556,   556,   500,   389,   280,   389,   584,   350,  # 127 
      556,   350,   278,   556,   500,   1000,   556,   556,  # 135
      333,   1000,   667,   333,   1000,   350,   611,  350,   # 143
      350,   278,   278,   500,   500,   350,   556,   1000,  # 151
      333,   1000,   556,   333,   944,   350,   500,   667, # 159
      278,   333,   556,   556,   556,   556,   280,   556,  #167
      333,   737,   370,   556,   584,   333,   737,   333,  
      400,   584,   333,   333,   333,   611,   556,   278,  
      333,   333,   365,   556,   834,   834,   834,   611,  
      722,   722,   722,   722,   722,   722,  1000,   722,  
      667,   667,   667,   667,   278,   278,   278,   278,  
      722,   722,   778,   778,   778,   778,   778,   584,  
      778,   722,   722,   722,   722,   667,   667,   611,  
      556,   556,   556,   556,   556,   556,   889,   556,  
      556,   556,   556,   556,   278,   278,   278,   278,  
      611,   611,   611,   611,   611,   611,   611,   584,  
      611,   611,   611,   611,   611,   556,   611,   556],

    'Helvetica-Oblique' =>
     [000,   000,   000,   000,   000,   000,   000,   000,  
      000,   000,   000,   000,   000,   000,   000,   000,  
      000,   000,   000,   000,   000,   000,   000,   000,  
      000,   000,   000,   000,   000,   000,   000,   000,  
      278,   278,   355,   556,   556,   889,   667,   191,  
      333,   333,   389,   584,   278,   333,   278,   278,  
      556,   556,   556,   556,   556,   556,   556,   556,  
      556,   556,   278,   278,   584,   584,   584,   556,  
     1015,   667,   667,   722,   722,   667,   611,   778,  
      722,   278,   500,   667,   556,   833,   722,   778,  
      667,   778,   722,   667,   611,   722,   667,   944,  
      667,   667,   611,   278,   278,   278,   469,   556,  
      333,   556,   556,   500,   556,   556,   278,   556,  
      556,   222,   222,   500,   222,   833,   556,   556,  
      556,   556,   333,   500,   278,   556,   500,   722,  
      500,   500,   500,   334,   260,   334,   584,   350,  # 127 
      556,   350,   222,   556,   333,   1000,   556,   556,  # 135
      333,   1000,   667,   333,   1000,   351,   611,  350,   # 143
      350,   223,   222,   333,   333,   351,   557,   1000,  # 151
      333,   1000,   500,   333,   945,   350,   500,   667, # 159 
      278,   333,   556,   556,   556,   556,   260,   556,  # 167
      333,   737,   370,   556,   584,   333,   737,   333,  # 175
      400,   584,   333,   333,   333,   578,   537,   278,  # 183
      333,   333,   365,   556,   834,   834,   834,   611,  # 191
      667,   667,   667,   667,   667,   667,  1000,   722,  
      667,   667,   667,   667,   278,   278,   278,   278,  
      722,   722,   778,   778,   778,   778,   778,   584,  
      778,   722,   722,   722,   722,   667,   667,   611,  
      556,   556,   556,   556,   556,   556,   889,   500,  
      556,   556,   556,   556,   278,   278,   278,   278,  
      556,   556,   556,   556,   556,   556,   556,   584,  
      611,   556,   556,   556,   556,   500,   556,   500],

    'Helvetica-BoldOblique' =>
     [000,   000,   000,   000,   000,   000,   000,   000,  
      000,   000,   000,   000,   000,   000,   000,   000,  
      000,   000,   000,   000,   000,   000,   000,   000,  
      000,   000,   000,   000,   000,   000,   000,   000,  
      278,   333,   474,   556,   556,   889,   722,   238, #39  
      333,   333,   389,   584,   278,   333,   278,   278, #47 
      556,   556,   556,   556,   556,   556,   556,   556, #55 
      556,   556,   333,   333,   584,   584,   584,   611, #63
      975,   722,   722,   722,   722,   667,   611,   778, #71 
      722,   278,   556,   722,   611,   833,   722,   778, #79 
      667,   778,   722,   667,   611,   722,   667,   944, #87
      667,   667,   611,   333,   278,   333,   584,   556, #95
      333,   556,   611,   556,   611,   556,   333,   611, #103
      611,   278,   278,   556,   278,   889,   611,   611, #111
      611,   611,   389,   556,   333,   611,   556,   778, #119
      556,   556,   500,   389,   280,   389,   584,   350,  # 127 
      556,   350,   278,   556,   500,   1000,   556,   556,  # 135
      333,   1000,   667,   333,   1000,   350,   611,  350,   # 143
      350,   278,   278,   500,   500,   350,   556,   1000,  # 151
      333,   1000,   556,   333,   944,   350,   500,   667, # 159
      278,   333,   556,   556,   556,   556,   280,   556,  
      333,   737,   370,   556,   584,   333,   737,   333,  
      400,   584,   333,   333,   333,   611,   556,   278,  
      333,   333,   365,   556,   834,   834,   834,   611,  
      722,   722,   722,   722,   722,   722,  1000,   722,  
      667,   667,   667,   667,   278,   278,   278,   278,  
      722,   722,   778,   778,   778,   778,   778,   584,  
      778,   722,   722,   722,   722,   667,   667,   611,  
      556,   556,   556,   556,   556,   556,   889,   556,  
      556,   556,   556,   556,   278,   278,   278,   278,  
      611,   611,   611,   611,   611,   611,   611,   584,  
      611,   611,   611,   611,   611,   556,   611,   556]
     );
1;

sub hyperLink
{   my $x    = shift;
    my $y    = shift;
    my $text = shift || ' ';
    my $URI  = shift;
    my $fontSize = shift;
    my $s    = shift || 'URI';

    my ($actualSize, $fontSizeBeforetheChange, $height, $x2, $y2);
    if ((! defined $x) || (! defined $y) || (! defined $URI))
    {  return undef;
    }
    my ($internalName, $externalName, $oldInternalName, $oldExternalname) =
         PDF::Reuse::prFont('HO');
    if (! defined $fontSize) 
    {  ($actualSize, $fontSizeBeforetheChange) = PDF::Reuse::prFontSize();
       $fontSize = $fontSizeBeforetheChange;
       PDF::Reuse::prFontSize($fontSize) if ($actualSize != $fontSizeBeforetheChange);
    }
    else
    {  ($actualSize, $fontSizeBeforetheChange) = PDF::Reuse::prFontSize($fontSize);
    }
    $height = $fontSize + 2.5;
    my $width = PDF::Reuse::prStrWidth($text);
    $y2 = $y - 2;
    $x2 = $x + $width;
    PDF::Reuse::prAdd("q\n 0.3 0.3 1 RG 0.3 0.3 1 rg\n$x $y2 m\n$x2 $y2 l\n B*\n");
    $y2 -= 1;
    PDF::Reuse::prText($x, $y, $text);
    PDF::Reuse::prLink( { x => $x,
                          y => $y2,
                          width => $width,
                          height => $height,
                          URI => $URI,
                          s => $s} );

    PDF::Reuse::prAdd("0 0 0 RG 0 0 0 rg\nQ\n");
    PDF::Reuse::prFont($oldExternalname) 
                 if ($oldExternalname ne $externalName);
    PDF::Reuse::prFontSize($fontSizeBeforetheChange)
                 if ($fontSizeBeforetheChange != $fontSize);
    return $x2;
}

sub blackText
{   PDF::Reuse::prAdd("0 0 0 rg\n0 g\nf\n");
    1;
}

