# $Id: 31_encode_all_bytes.t 40 2007-09-21 15:31:44Z cfaerber $

use bytes;
use strict;

use Test::More;
use Net::IDN::Encode;

use Test::More;

if($] < 5.007) {
  plan skip_all => 'perl 5.6.x does not support utf8 flag';
} else {
  plan tests => 21;
}

is(Net::IDN::Encode::_to_ascii('faerber'),'faerber');
is(Net::IDN::Encode::_to_ascii('xn--frber-gra'),'xn--frber-gra');
is(Net::IDN::Encode::_to_ascii('frber'),'xn--frber-gra');

is(Net::IDN::Encode::_to_unicode('faerber'),'faerber');
is(Net::IDN::Encode::_to_unicode('xn--frber-gra'),'frber');
is(Net::IDN::Encode::_to_unicode('xn--frber-gra'),'frber');

is(domain_to_ascii('faerber.muc.de'),'faerber.muc.de');
is(domain_to_ascii('xn--frber-gra.muc.de'),'xn--frber-gra.muc.de');
is(domain_to_ascii('frber.muc.de'),'xn--frber-gra.muc.de');

is(domain_to_unicode('faerber.muc.de'),'faerber.muc.de');
is(domain_to_unicode('xn--frber-gra.muc.de'),'frber.muc.de');
is(domain_to_unicode('xn--frber-gra.muc.de'),'frber.muc.de');

is(email_to_ascii('claus@faerber.muc.de'),'claus@faerber.muc.de');
is(email_to_ascii('claus@xn--frber-gra.muc.de'),'claus@xn--frber-gra.muc.de');
is(email_to_ascii('claus@frber.muc.de'),'claus@xn--frber-gra.muc.de');
is(email_to_ascii(''), undef);
is(email_to_ascii('test'), 'test');

is(email_to_unicode('claus@faerber.muc.de'),'claus@faerber.muc.de');
is(email_to_unicode('claus@xn--frber-gra.muc.de'),'claus@frber.muc.de');
is(email_to_unicode(''),undef);
is(email_to_unicode('test'),'test');
