package Net::Connector::Radware::Loadbalance;

use 5.016;
use strict;
use warnings;

sub _spawn_command {
  my ($self, $args) = @_;
  $args //= '-o PreferredAuthentications=password';
  # 初始化变量
  my $command;

  # 绑定已有变量
  my $user = $self->username;
  my $host = $self->host;
  my $port = $self->port;
  my $proto = $self->proto;

  # 判断是否定义非标端口
  if ($self->hasPort) {
    # 根据不同协议生成脚本，telnet 协议兼容性可能有问题
    if ($proto =~ /telnet/i) {
      $command = $proto . " $args" . " -l $user $host $port";
    }
    elsif ($proto =~ /ssh/i) {
      $command = $proto . " $args" . " -l $user $host -p $port";
    }
  }
  else {
    $command = $proto . " $args" . " -l $user $host";
  }

  # 返回计算结果
  return $command;
}


1;