use strict;
use warnings;
use 5.022;
use feature qw /postderef signatures/;

package Vote::Count::Method::IRV;
$Vote::Count::Method::IRV::VERSION = '0.001'; # TRIAL
use namespace::autoclean;
use Moose;
extends 'Vote::Count';
# Brings the main Vote::Count Object in along with
# Topcount and other methods.
# with 'Vote::Count';
# with 'Vote::Count::Matrix';

no warnings 'experimental';
use List::Util qw( min max );

# use Vote::Count::RankCount;
# use Try::Tiny;
use Text::Table::Tiny 'generate_markdown_table';
use Data::Printer;
use Data::Dumper;

# use YAML::XS;

sub RunIRV ( $self, $active = undef ) {
  unless ( defined $active ) {
    $active = $self->BallotSet->{'choices'};
  }
  my $winner     = undef;
  my $roundctr   = 0;
  my $maxround   = scalar( keys %{$active} );
  my $resulthash = {};
  $self->logt( "Instant Runoff Voting",
    'Choices: ', join( ', ', ( sort keys %{$active} ) ) );
IRVLOOP:
  until ( defined $winner ) {
    $roundctr++;
    die "IRVLOOP infinite stopped at $roundctr" if $roundctr > $maxround;
    my $round = $self->TopCount($active);
    $self->logv( '---', "IRV Round $roundctr", $round->RankTable() );
    my $majority = $self->TopCountMajority( $round, $active );
    if ( $majority->{'winner'} ) {
      $winner = $majority->{'winner'};
      my $rows = [
        [ 'Winner',                    $winner ],
        [ 'Votes in Final Round',      $majority->{'votes'} ],
        [ 'Votes Needed for Majority', $majority->{'thresshold'} ],
        [ 'Winning Votes',             $majority->{'winvotes'} ],
      ];
      $resulthash = {
        winner     => $winner,
        votes      => $majority->{'votes'},
        winvotes   => $majority->{'winvotes'},
        thresshold => $majority->{'thresshold'},
        tie => 0,
      };
      $self->logt(
        '---',
        generate_markdown_table(
          rows       => $rows,
          header_row => 0
        )
      );
    }
    else {
      my @bottom = sort $round->ArrayBottom()->@*;
      if ( scalar(@bottom) == scalar( keys %{$active} ) ) {
        # if there is a tie at the end, the finalists should
        # be both top and bottom and the active set.
        $self->logt( "Tied: " . join( ', ', @bottom ) );
        return { tie => 1, tied => \@bottom, winner => 0  };
      }
      $self->logv( "Eliminating: " . join( ', ', @bottom ) );
      for my $b (@bottom) {
        delete $active->{$b};
      }
    }
  }
  return $resulthash;
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Vote::Count::Method::IRV

=head1 VERSION

version 0.001

=head1 AUTHOR

John Karr <brainbuz@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2019 by John Karr.

This is free software, licensed under:

  The GNU General Public License, Version 3, June 2007

=cut
