package Acme::MetaSyntactic::punctuation;
use strict;
use Acme::MetaSyntactic::List;
our @ISA = qw( Acme::MetaSyntactic::List );
our $VERSION = '1.000';
__PACKAGE__->init();
1;

=head1 NAME

Acme::MetaSyntactic::punctuation - The punctuation theme

=head1 DESCRIPTION

Names of various punctuation marks.

This list is based on a browsing session starting from:
L<http://en.wikipedia.org/wiki/Punctuation>.

=head1 CONTRIBUTOR

Philippe "BooK" Bruhat.

Introduced in Acme-MetaSyntactic version 0.29, published on July 4, 2005.

Updated by Abigail in version 0.91, publish on September 11, 2006.

Received its own version number for Acme-MetaSyntactic-Themes version 1.000,
published on May 7, 2012.

=head1 SEE ALSO

L<Acme::MetaSyntactic>, L<Acme::MetaSyntactic::List>.

=cut

__DATA__
# names
apostrophe prime
brackets
parentheses round_brackets parens fingernails
square_brackets
curly_brackets braces
angle_brackets chevrons fishhooks
corner_brackets
comma
dash emdash endash
ellipsis suspension_points
exclamation_mark inverted_exclamation_mark
full_stop period
hyphen
interrobang
question_mark inverted_question_mark
quotation_marks single_quotes double_quotes backquotes
angle_quotes single_angle_quotes double_angle_quotes
quotation_dash
guillemets
semicolon
slash solidus
space
interpunct
colon
ampersand
asteriks
asterism
at
backslash
bullet
caret
currency
dagger
degree
number_sign octothorpe
percent_sign permille_sign
pilcrow paragraph_mark
section_mark
tilde
underscore
umlaut deaeresis
pipe vertical_bar broken_bar
