package P2P::Transmission::Torrent;

=head1 NAME

P2P::Transmission::Torrent - Transmission Torrent object

=head1 DESCRIPTION

C<P2P::Transmission::Torrent> object

=cut

use Carp;
use strict;

our $VERSION = '0.05';

###
### AUTOGENERATED METHODS
###

use constant TORRENT_SET => qw{
    files_wanted
    files_unwanted
    peer_limit
    priority_high
    priority_low
    priority_normal
    speed_limit_down
    speed_limit_down_enabled
    speed_limit_up
    speed_limit_up_enabled
};

use constant TORRENT_GET => qw{
    activity_date
    added_date
    announce_response
    announce_url
    comment
    corrupt_ever
    creator
    date_created
    desired_available
    done_date
    downloaded_ever
    download_limit_mode
    download_limit
    error
    error_string
    eta
    files
    hash_string
    have_unchecked
    have_valid
    id
    is_private
    last_announce_time
    last_scrape_time
    leechers
    left_until_done
    manual_announce_time
    max_connected_peers
    name
    next_announce_time
    next_scrape_time
    peers
    peers_connected
    peers_from
    peers_getting_from_us
    peers_known
    peers_sending_to_us
    piece_count
    piece_size
    priorities
    rate_download
    rate_upload
    recheck_progress
    scrape_response
    scrape_url
    seeders
    size_when_done
    start_date
    status
    swarm_speed
    times_completed
    trackers
    total_size
    uploaded_ever
    upload_limit_mode
    upload_limit
    upload_ratio
    wanted
    webseeds
    webseeds_sending_to_us
};

###
### PUBLIC METHODS
###

sub new {
    my ($class, $parent, $id) = @_;
    return bless({parent => $parent, id => $id}, $class);
}

sub remove {
    my ($self) = shift;
    $self->{parent}->remove($self);
}

sub delete {
    my ($self) = shift;
    $self->{parent}->delete($self);
}

sub start {
    my ($self) = shift;
    $self->{parent}->start($self);
}

sub stop {
    my ($self) = shift;
    $self->{parent}->stop($self);
}

sub verify {
    my ($self) = shift;
    $self->{parent}->verify($self);
}

sub DESTROY { }

###
### METHOD GENERATOR
###

INIT {
    no strict 'refs';
    
    # generate TORRENT_SET accessors
    foreach my $method (TORRENT_SET) {
        *{$method} = sub {
            my ($self, $value) = @_;
            my $this = [ $self->{id} ];
            my $that = $self->{parent};
            
            # inconsistent API fix:
            $method =~ tr/_/-/;
            
            if ($value) {
                $that->_rpc('torrent-set', ids => $this , $method => $value);
            }

            return;
        }
    }
    
    # generate TORRENT_GET accessors
    foreach my $method (TORRENT_GET) {
        *{$method} = sub {
            my ($self) = @_;
            my $this = [ $self->{id} ];
            my $that = $self->{parent};
            
            # inconsistent API fix:
            $method =~ s/url/URL/g;
            $method =~ s/_(\w)/\u$1/g;
            
            # now we have to fetch and unwrap the response
            my $r = $that->_rpc('torrent-get', ids => $this, fields => [ $method ]);
            return $r->{torrents}[0]->{$method};
        }
    }
};

1;

__END__

=head1 SEE ALSO

L<P2P::Transmission>

=head1 AUTHOR

Brandon Gilmore, E<lt>brandon@mg2.orgE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2007 Brandon Gilmore

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.8 or,
at your option, any later version of Perl 5 you may have available.

=cut
